/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.ActiveContour.Ovuscule;

import Catalano.Core.DoublePoint;
import Catalano.Core.IntPoint;
import Catalano.Imaging.ActiveContour.Ovuscule.IOvusculeSnake2D;
import Catalano.Imaging.ActiveContour.Ovuscule.OvusculeSnake2DNode;
import Catalano.Imaging.ActiveContour.Ovuscule.OvusculeSnake2DScale;
import Catalano.Imaging.FastBitmap;

public class Ovuscule
implements IOvusculeSnake2D {
    private FastBitmap fastBitmap = null;
    private double area;
    private double RamanujanPerimeter;
    private double a11;
    private double a12;
    private double a22;
    private double a33;
    private double a3;
    private double c1;
    private double c2;
    private double p1;
    private double p2;
    private double pq1;
    private double pq2;
    private double pq;
    private double q1;
    private double q2;
    private double qr1;
    private double qr2;
    private double qr;
    private double r1;
    private double r2;
    private double rp1;
    private double rp2;
    private double rp;
    private double s1;
    private double s2;
    private double u1;
    private double u2;
    private double v1;
    private double v2;
    private double y1;
    private double y2;
    private OvusculeSnake2DNode[] node = new OvusculeSnake2DNode[3];
    private int height;
    private int width;
    private static final double AREA_FACTOR = 1.2091995761561452;
    private static final double HALF_SQRT2 = 0.7071067811865476;
    private static final double REGULARIZATION_WEIGHT = 100.0;
    private static final double SQRT_TINY = Math.sqrt(Float.intBitsToFloat(0x33FFFFFF));
    private static final double SQRT2 = 1.4142135623730951;
    private static final double SQRT3 = 1.7320508075688772;
    private static final double THIRD_SQRT2 = 0.47140452079103173;

    public Ovuscule(FastBitmap fastBitmap, DoublePoint p, DoublePoint q, DoublePoint r) {
        this(fastBitmap, p.x, p.y, q.x, q.y, r.x, r.y);
    }

    public Ovuscule(FastBitmap fastBitmap, IntPoint p, IntPoint q, IntPoint r) {
        this(fastBitmap, p.x, p.y, q.x, q.y, r.x, r.y);
    }

    public Ovuscule(FastBitmap fastBitmap, double p1, double p2, double q1, double q2, double r1, double r2) {
        this.fastBitmap = fastBitmap;
        this.height = fastBitmap.getHeight();
        this.width = fastBitmap.getWidth();
        this.node[0] = new OvusculeSnake2DNode(p2, p1);
        this.node[1] = new OvusculeSnake2DNode(q2, q1);
        this.node[2] = new OvusculeSnake2DNode(r2, r1);
        this.setNodes(this.node);
    }

    @Override
    public double energy() {
        double weightedArea = this.contrast();
        double regularization = this.regularization();
        return weightedArea + regularization;
    }

    @Override
    public DoublePoint[] getEnergyGradient() {
        DoublePoint[] gc = this.contrastGradient(this.node[0], this.node[1]);
        DoublePoint[] gr = this.regularizationGradient(this.node[0], this.node[1]);
        return this.plus(gc, gr);
    }

    @Override
    public OvusculeSnake2DNode[] getNodes() {
        return this.node;
    }

    @Override
    public OvusculeSnake2DScale[] getScales() {
        int K = (int)Math.ceil(1.0 + this.RamanujanPerimeter / 2.0);
        if (K > 2 * (this.width + this.height)) {
            return null;
        }
        int[] s0x1 = new int[K];
        int[] s0x2 = new int[K];
        int[] s1x1 = new int[K];
        int[] s1x2 = new int[K];
        for (int k = 0; k < K; ++k) {
            double theta = Math.PI * 2 * (double)k / (double)K;
            s0x1[k] = (int)Math.round(this.y1 + this.c1 * Math.cos(theta) + this.s1 * Math.sin(theta));
            s0x2[k] = (int)Math.round(this.y2 + this.c2 * Math.cos(theta) + this.s2 * Math.sin(theta));
            s1x1[k] = (int)Math.round(this.y1 + 0.7071067811865476 * (this.c1 * Math.cos(theta) + this.s1 * Math.sin(theta)));
            s1x2[k] = (int)Math.round(this.y2 + 0.7071067811865476 * (this.c2 * Math.cos(theta) + this.s2 * Math.sin(theta)));
        }
        OvusculeSnake2DScale[] skin = new OvusculeSnake2DScale[]{new OvusculeSnake2DScale(null, null, true, false), new OvusculeSnake2DScale(null, null, true, false)};
        skin[0].npoints = K;
        skin[0].xpoints = s0x1;
        skin[0].ypoints = s0x2;
        skin[1].npoints = K;
        skin[1].xpoints = s1x1;
        skin[1].ypoints = s1x2;
        return skin;
    }

    @Override
    public void setNodes(OvusculeSnake2DNode[] node) {
        this.p1 = node[0].x;
        this.p2 = node[0].y;
        this.q1 = node[1].x;
        this.q2 = node[1].y;
        this.r1 = node[2].x;
        this.r2 = node[2].y;
        this.node[0].x = this.p1;
        this.node[0].y = this.p2;
        this.node[1].x = this.q1;
        this.node[1].y = this.q2;
        this.node[2].x = this.r1;
        this.node[2].y = this.r2;
        this.pq1 = this.p1 - this.q1;
        this.pq2 = this.p2 - this.q2;
        this.qr1 = this.q1 - this.r1;
        this.qr2 = this.q2 - this.r2;
        this.rp1 = this.r1 - this.p1;
        this.rp2 = this.r2 - this.p2;
        this.pq = this.p1 * this.q2 - this.p2 * this.q1;
        this.qr = this.q1 * this.r2 - this.q2 * this.r1;
        this.rp = this.r1 * this.p2 - this.r2 * this.p1;
        this.y1 = (this.p1 + this.q1 + this.r1) / 3.0;
        this.y2 = (this.p2 + this.q2 + this.r2) / 3.0;
        this.a11 = 3.0 * (this.p2 * this.pq2 + this.q2 * this.qr2 + this.r2 * this.rp2);
        this.a12 = 3.0 * (this.p1 * (this.q2 - 2.0 * this.p2) + this.p2 * this.q1 + this.q1 * (this.r2 - 2.0 * this.q2) + this.q2 * this.r1 + this.r1 * (this.p2 - 2.0 * this.r2) + this.r2 * this.p1);
        this.a22 = 3.0 * (this.p1 * this.pq1 + this.q1 * this.qr1 + this.r1 * this.rp1);
        this.a33 = this.pq + this.qr + this.rp;
        this.a3 = Math.abs(this.a33);
        this.c1 = (this.pq1 - this.rp1) / 3.0;
        this.c2 = (this.pq2 - this.rp2) / 3.0;
        this.s1 = this.qr1 / 1.7320508075688772;
        this.s2 = this.qr2 / 1.7320508075688772;
        double halfWidth = Math.sqrt(Math.abs(this.c1 * this.c1 + this.s1 * this.s1));
        double halfHeight = Math.sqrt(Math.abs(this.c2 * this.c2 + this.s2 * this.s2));
        this.u1 = this.y1 - halfWidth;
        this.u2 = this.y2 - halfHeight;
        this.v1 = this.y1 + halfWidth;
        this.v2 = this.y2 + halfHeight;
        double a = (this.a11 + this.a22) / 3.0;
        double b = Math.sqrt(Math.abs(a * a - 3.0 * this.a33 * this.a33));
        double semiMinor = 0.47140452079103173 * Math.sqrt(Math.abs(a - b));
        double semiMajor = 0.47140452079103173 * Math.sqrt(Math.abs(a + b));
        this.area = 1.2091995761561452 * this.a3;
        double excentricity = (semiMajor - semiMinor) / (semiMajor + semiMinor);
        excentricity *= excentricity;
        this.RamanujanPerimeter = Math.PI * (semiMajor + semiMinor) * (1.0 + 3.0 * excentricity / (10.0 + Math.sqrt(Math.abs(4.0 - 3.0 * excentricity))));
    }

    private double contrast() {
        if (this.area < 1.0) {
            return 1.0 / SQRT_TINY;
        }
        double c = 0.0;
        int xmin = Math.max((int)Math.floor(this.u1), 0);
        int xmax = Math.min((int)Math.ceil(this.v1), this.width - 1);
        int ymin = Math.max((int)Math.floor(this.u2), 0);
        int ymax = Math.min((int)Math.ceil(this.v2), this.height - 1);
        if (this.u1 < (double)xmin || (double)xmax < this.v1 || this.u2 < (double)ymin || (double)ymax < this.v2) {
            return 1.0 / SQRT_TINY;
        }
        if (xmax <= xmin || ymax <= ymin) {
            return 1.0 / SQRT_TINY;
        }
        for (int y = ymin; y <= ymax; ++y) {
            double dy = this.y2 - (double)y;
            double dy2 = dy * dy;
            for (int x = xmin; x <= xmax; ++x) {
                double dx = this.y1 - (double)x;
                double dx2 = dx * dx;
                double d = Math.sqrt(dx2 + dy2);
                double z = this.a11 * dx2 + this.a12 * dx * dy + this.a22 * dy2;
                if (z < SQRT_TINY) {
                    c -= (double)this.fastBitmap.getGray(y, x);
                    continue;
                }
                double d0 = (1.0 - (z = this.a3 / Math.sqrt(z)) / 1.4142135623730951) * d;
                if (d0 < -0.7071067811865476) {
                    c -= (double)this.fastBitmap.getGray(y, x);
                    continue;
                }
                if (d0 < 0.7071067811865476) {
                    c += 1.4142135623730951 * d0 * (double)this.fastBitmap.getGray(y, x);
                    continue;
                }
                d0 = (1.0 - z) * d;
                if (d0 < -1.0) {
                    c += (double)this.fastBitmap.getGray(y, x);
                    continue;
                }
                if (!(d0 < 1.0)) continue;
                c += (1.0 - d0) * (double)this.fastBitmap.getGray(y, x) / 2.0;
            }
        }
        return c / this.area;
    }

    private DoublePoint[] contrastGradient(OvusculeSnake2DNode p, OvusculeSnake2DNode q) {
        if (this.area < 1.0) {
            return null;
        }
        int xmin = Math.max((int)Math.floor(this.u1), 0);
        int xmax = Math.min((int)Math.ceil(this.v1), this.width - 1);
        int ymin = Math.max((int)Math.floor(this.u2), 0);
        int ymax = Math.min((int)Math.ceil(this.v2), this.height - 1);
        if (this.u1 < (double)xmin || (double)xmax < this.v1 || this.u2 < (double)ymin || (double)ymax < this.v2) {
            return null;
        }
        if (xmax <= xmin || ymax <= ymin) {
            return null;
        }
        DoublePoint[] gradient = new DoublePoint[]{new DoublePoint(0.0, 0.0), new DoublePoint(0.0, 0.0), new DoublePoint(0.0, 0.0)};
        double[] z12 = new double[]{this.pq1 - this.qr1, this.pq2 - this.qr2, this.qr1 - this.rp1, this.qr2 - this.rp2, this.rp1 - this.pq1, this.rp2 - this.pq2};
        for (int y = ymin; y <= ymax; ++y) {
            double dy = this.y2 - (double)y;
            double dy2 = dy * dy;
            for (int x = xmin; x <= xmax; ++x) {
                double h2;
                double h1;
                double h0;
                double gy;
                double gx;
                double g1;
                double g0;
                double g;
                double dx = this.y1 - (double)x;
                double dx2 = dx * dx;
                double d = Math.sqrt(dx2 + dy2);
                if (d < SQRT_TINY) continue;
                double f = this.fastBitmap.getGray(y, x);
                double z = this.a11 * dx2 + this.a12 * dx * dy + this.a22 * dy2;
                if (z < SQRT_TINY) {
                    gradient[0].x += f * this.qr2;
                    gradient[0].y -= f * this.qr1;
                    gradient[1].x += f * this.rp2;
                    gradient[1].y -= f * this.rp1;
                    gradient[2].x += f * this.pq2;
                    gradient[2].y -= f * this.pq1;
                    continue;
                }
                double d0 = (1.0 - (z = this.a3 / Math.sqrt(z)) / 1.4142135623730951) * d;
                if (d0 < -0.7071067811865476) {
                    gradient[0].x += f * this.qr2;
                    gradient[0].y -= f * this.qr1;
                    gradient[1].x += f * this.rp2;
                    gradient[1].y -= f * this.rp1;
                    gradient[2].x += f * this.pq2;
                    gradient[2].y -= f * this.pq1;
                    continue;
                }
                if (d0 < 0.7071067811865476) {
                    g = 1.4142135623730951 * d;
                    g0 = z * z * z * d / (6.0 * this.a33);
                    g1 = this.a33 * (1.4142135623730951 - z) / (3.0 * g0 * d);
                    gx = (2.0 * this.a11 + g1) * dx + this.a12 * dy;
                    gy = (2.0 * this.a22 + g1) * dy + this.a12 * dx;
                    h0 = 9.0 * (z12[5] * dx - z12[4] * dy);
                    h1 = 9.0 * (z12[1] * dx - z12[0] * dy);
                    h2 = 9.0 * (z12[3] * dx - z12[2] * dy);
                    gradient[0].x -= f * (g * this.qr2 - g0 * (dy * h0 + gx));
                    gradient[0].y += f * (g * this.qr1 - g0 * (dx * h0 - gy));
                    gradient[1].x -= f * (g * this.rp2 - g0 * (dy * h1 + gx));
                    gradient[1].y += f * (g * this.rp1 - g0 * (dx * h1 - gy));
                    gradient[2].x -= f * (g * this.pq2 - g0 * (dy * h2 + gx));
                    gradient[2].y += f * (g * this.pq1 - g0 * (dx * h2 - gy));
                    continue;
                }
                d0 = (1.0 - z) * d;
                if (d0 < -1.0) {
                    gradient[0].x -= f * this.qr2;
                    gradient[0].y += f * this.qr1;
                    gradient[1].x -= f * this.rp2;
                    gradient[1].y += f * this.rp1;
                    gradient[2].x -= f * this.pq2;
                    gradient[2].y += f * this.pq1;
                    continue;
                }
                if (!(d0 < 1.0)) continue;
                g = (d - 1.0) / 2.0;
                g0 = z * z * z * d / (12.0 * this.a33);
                g1 = this.a33 * (1.0 - z) / (6.0 * g0 * d);
                gx = (2.0 * this.a11 + g1) * dx + this.a12 * dy;
                gy = (2.0 * this.a22 + g1) * dy + this.a12 * dx;
                h0 = 9.0 * (z12[5] * dx - z12[4] * dy);
                h1 = 9.0 * (z12[1] * dx - z12[0] * dy);
                h2 = 9.0 * (z12[3] * dx - z12[2] * dy);
                gradient[0].x += f * (g * this.qr2 - g0 * (dy * h0 + gx));
                gradient[0].y -= f * (g * this.qr1 - g0 * (dx * h0 - gy));
                gradient[1].x += f * (g * this.rp2 - g0 * (dy * h1 + gx));
                gradient[1].y -= f * (g * this.rp1 - g0 * (dx * h1 - gy));
                gradient[2].x += f * (g * this.pq2 - g0 * (dy * h2 + gx));
                gradient[2].y -= f * (g * this.pq1 - g0 * (dx * h2 - gy));
            }
        }
        double A = this.a33 * this.area;
        gradient[0].x /= A;
        gradient[0].y /= A;
        gradient[1].x /= A;
        gradient[1].y /= A;
        gradient[2].x /= A;
        gradient[2].y /= A;
        return gradient;
    }

    private DoublePoint[] plus(DoublePoint[] gc, DoublePoint[] gr) {
        if (null == gc || null == gr) {
            return null;
        }
        int K = gc.length;
        if (K != gr.length) {
            return null;
        }
        DoublePoint[] g = new DoublePoint[K];
        for (int k = 0; k < K; ++k) {
            g[k] = new DoublePoint(gc[k].x + gr[k].x, gc[k].y + gr[k].y);
        }
        return g;
    }

    private double regularization() {
        double regularization = Math.min(Math.min(this.pq2 * this.pq2, this.qr2 * this.qr2), this.rp2 * this.rp2);
        return 100.0 * regularization / this.area;
    }

    private DoublePoint[] regularizationGradient(OvusculeSnake2DNode p, OvusculeSnake2DNode q) {
        DoublePoint[] gradient = new DoublePoint[]{new DoublePoint(0.0, 0.0), new DoublePoint(0.0, 0.0), new DoublePoint(0.0, 0.0)};
        double ppqq2 = this.pq2 * this.pq2;
        double qqrr2 = this.qr2 * this.qr2;
        double rrpp2 = this.rp2 * this.rp2;
        double A = 0.0;
        if (ppqq2 <= qqrr2 && ppqq2 <= rrpp2) {
            gradient[0].x = -this.pq2 * this.qr2;
            gradient[0].y = 2.0 * this.a33 + this.pq2 * this.qr1;
            gradient[1].x = -this.rp2 * this.pq2;
            gradient[1].y = -2.0 * this.a33 + this.rp1 * this.pq2;
            gradient[2].x = -ppqq2;
            gradient[2].y = this.pq1 * this.pq2;
            A = 100.0 * this.pq2 / (this.a33 * this.area);
        } else if (qqrr2 <= rrpp2 && qqrr2 <= ppqq2) {
            gradient[0].x = -qqrr2;
            gradient[0].y = this.qr1 * this.qr2;
            gradient[1].x = -this.qr2 * this.rp2;
            gradient[1].y = 2.0 * this.a33 + this.qr2 * this.rp1;
            gradient[2].x = -this.pq2 * this.qr2;
            gradient[2].y = -2.0 * this.a33 + this.pq1 * this.qr2;
            A = 100.0 * this.qr2 / (this.a33 * this.area);
        } else if (rrpp2 <= ppqq2 && rrpp2 <= qqrr2) {
            gradient[0].x = -this.qr2 * this.rp2;
            gradient[0].y = -2.0 * this.a33 + this.qr1 * this.rp2;
            gradient[1].x = -rrpp2;
            gradient[1].y = this.rp1 * this.rp2;
            gradient[2].x = -this.rp2 * this.pq2;
            gradient[2].y = 2.0 * this.a33 + this.rp2 * this.pq1;
            A = 100.0 * this.rp2 / (this.a33 * this.area);
        }
        gradient[0].x *= A;
        gradient[0].y *= A;
        gradient[1].x *= A;
        gradient[1].y *= A;
        gradient[2].x *= A;
        gradient[2].y *= A;
        return gradient;
    }
}

