/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Graph.Pathfinding.AStar;

import Catalano.Core.IntPoint;
import Catalano.Core.Structs.BinaryHeap;
import Catalano.Graph.Pathfinding.AStar.ANode;
import Catalano.Graph.Pathfinding.AStar.NodeMap;
import Catalano.Graph.Pathfinding.ISearch;
import java.util.ArrayList;

public class AStar
implements ISearch {
    private int width;
    private int height;
    private Neighbor neighbor;
    private Heuristic heuristic;
    private NodeMap nodeMap;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Neighbor getNeighbor() {
        return this.neighbor;
    }

    public void setNeighbor(Neighbor neighbor) {
        this.neighbor = neighbor;
    }

    public Heuristic getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
    }

    public void addBlock(int x, int y) {
        this.nodeMap.nodes[x][y].setCost(0.0);
    }

    public void removeBlock(int x, int y) {
        this.nodeMap.nodes[x][y].setCost(1.0);
    }

    public boolean isBlocked(int x, int y) {
        return this.nodeMap.nodes[x][y].getCost() == 0.0;
    }

    public double getCost(int x, int y) {
        return this.nodeMap.nodes[x][y].getCost();
    }

    public void setCost(int x, int y, double cost) {
        this.nodeMap.nodes[x][y].setCost(cost);
    }

    public NodeMap getNodeMap() {
        return this.nodeMap;
    }

    public double getTotalCost(ArrayList<IntPoint> path) {
        double sum = 0.0;
        for (IntPoint p : path) {
            sum += this.nodeMap.getNode(p.x, p.y).getCost();
        }
        return sum;
    }

    public AStar(int width, int height) {
        this(width, height, 1.0, Neighbor.Eight, Heuristic.Euclidean);
    }

    public AStar(int width, int height, double initialCost) {
        this(width, height, initialCost, Neighbor.Eight, Heuristic.Euclidean);
    }

    public AStar(double[][] costMap) {
        this(costMap, Neighbor.Eight, Heuristic.Euclidean);
    }

    public AStar(double[][] costMap, Neighbor neighbor, Heuristic heuristic) {
        this.width = costMap[0].length;
        this.height = costMap.length;
        this.neighbor = neighbor;
        this.heuristic = heuristic;
        this.nodeMap = new NodeMap(costMap, neighbor, heuristic);
    }

    public AStar(int width, int height, double initialCost, Neighbor neighbor, Heuristic heuristic) {
        this.width = width;
        this.height = height;
        this.neighbor = neighbor;
        this.heuristic = heuristic;
        this.nodeMap = new NodeMap(width, height, initialCost, neighbor, heuristic);
    }

    private boolean AStar(NodeMap Map2, int StartX, int StartY, int EndX, int EndY) {
        return this.AStar(Map2, Map2.nodes[StartX][StartY], Map2.nodes[EndX][EndY]);
    }

    private boolean AStar(NodeMap Map2, ANode Start, ANode End) {
        try {
            if (Start != null && End != null) {
                if (Start.getMapParent() == Map2 && End.getMapParent() == Map2) {
                    boolean PathFound = true;
                    BinaryHeap<ANode> OpenList = new BinaryHeap<ANode>();
                    BinaryHeap<ANode> ClosedList = new BinaryHeap<ANode>();
                    OpenList.add(Start);
                    Start.setOnOpenList(true);
                    while (!End.isOnClosedList()) {
                        if (OpenList.size() > 0) {
                            ANode[] Surrounding;
                            ANode Current = (ANode)OpenList.remove();
                            ClosedList.add(Current);
                            Current.setOnClosedList(true);
                            for (ANode Next : Surrounding = Current.getSurroundingNodes()) {
                                if (!(Next.getCost() > 0.0) || Next.isOnClosedList()) continue;
                                if (!Next.isOnOpenList()) {
                                    Next.setParent(Current);
                                    Next.setG(Current.getG() + Next.getCost());
                                    Next.setH(Next.ComputeHeuristic(End));
                                    OpenList.add(Next);
                                    Next.setOnOpenList(true);
                                    continue;
                                }
                                if (!(Current.getG() > Next.getG() + Current.getCost())) continue;
                                Current.setParent(Next);
                                Current.setG(Next.getG() + Current.getCost());
                                OpenList.remove(Current);
                                OpenList.add(Current);
                            }
                            continue;
                        }
                        PathFound = false;
                        break;
                    }
                    return PathFound;
                }
                throw new IllegalArgumentException("Start or End Node does not belong to the NodeMap passed into the function.");
            }
            throw new IllegalArgumentException("Start or End Node were not initialised, ensure they are initialised and belong to a NodeMap.");
        }
        catch (IllegalArgumentException Ex) {
            throw new IllegalArgumentException(Ex.getMessage());
        }
    }

    @Override
    public ArrayList<IntPoint> FindPath(IntPoint start, IntPoint end) {
        return this.FindPath(start.x, start.y, end.x, end.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<IntPoint> FindPath(int startX, int startY, int endX, int endY) {
        ArrayList<IntPoint> path = new ArrayList<IntPoint>();
        NodeMap copy = this.nodeMap.clone();
        boolean result = this.AStar(copy, startX, startY, endX, endY);
        if (result) {
            ANode cur = copy.getNode(endX, endY);
            ANode end = copy.getNode(startX, startY);
            try {
                while (cur.getParent() != end) {
                    path.add(new IntPoint(cur.getParent().getX(), cur.getParent().getY()));
                    cur = cur.getParent();
                }
            }
            finally {
                return path;
            }
        }
        return path;
    }

    public static enum Heuristic {
        Manhattan,
        Chebyshev,
        Euclidean,
        SquaredEuclidean;

    }

    public static enum Neighbor {
        Four,
        Eight;

    }
}

