/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Graph.Network;

import Catalano.Graph.AdjacencyMatrix;

public class PageRank {
    private double epsilon = 0.001;
    private double factor = 0.85;
    private int it = 0;

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        if (epsilon == 0.0) {
            throw new IllegalArgumentException("The epsilon value must be different of zero.");
        }
        this.epsilon = epsilon;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = Math.min(1.0, Math.max(0.0, factor));
    }

    public int getNumberOfIterations() {
        return this.it;
    }

    public PageRank() {
    }

    public PageRank(double factor) {
        this.setFactor(factor);
    }

    public double[] Compute(AdjacencyMatrix matrix) {
        double[] w = new double[matrix.getData().length];
        double t = 1 / w.length;
        for (int i = 0; i < w.length; ++i) {
            w[i] = t;
        }
        return this.Compute(matrix, w);
    }

    public double[] Compute(AdjacencyMatrix matrix, double[] weights) {
        if (matrix.getData().length != weights.length) {
            throw new IllegalArgumentException("The matrix lenght must be the same lenght of the weights.");
        }
        double[][] m = matrix.getData();
        double[] ranks = new double[m.length];
        double[] outs = new double[m.length];
        for (int i = 0; i < m.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < m[0].length; ++j) {
                if (m[i][j] == 0.0) continue;
                sum += 1.0;
            }
            outs[i] = sum;
        }
        ranks = weights;
        double part1 = (1.0 - this.factor) / (double)m.length;
        double maxDiff = Double.MAX_VALUE;
        double[] oldRanks = (double[])ranks.clone();
        while (maxDiff > this.epsilon) {
            for (int j = 0; j < m[0].length; ++j) {
                double part2 = 0.0;
                for (int i = 0; i < m.length; ++i) {
                    if (m[i][j] == 0.0) continue;
                    part2 += ranks[i] / outs[i];
                }
                ranks[j] = part1 + this.factor * part2;
            }
            maxDiff = this.Convergency(oldRanks, ranks);
            ++this.it;
        }
        return ranks;
    }

    private double Convergency(double[] oldRanks, double[] ranks) {
        double maxDiff = Double.MAX_VALUE;
        for (int i = 0; i < ranks.length; ++i) {
            maxDiff = Math.min(maxDiff, oldRanks[i] - ranks[i]);
        }
        return maxDiff;
    }
}

