/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Fuzzy;

import Catalano.Fuzzy.FuzzyOutput;
import Catalano.Fuzzy.IDefuzzifier;
import Catalano.Fuzzy.INorm;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CentroidDefuzzifier
implements IDefuzzifier {
    private int intervals;

    public CentroidDefuzzifier(int intervals) {
        this.intervals = intervals;
    }

    @Override
    public float Defuzzify(FuzzyOutput fuzzyOutput, INorm normOperator) {
        float weightSum = 0.0f;
        float membershipSum = 0.0f;
        float start = fuzzyOutput.getOutputVariable().getStart();
        float end = fuzzyOutput.getOutputVariable().getEnd();
        float increment = (end - start) / (float)this.intervals;
        for (float x = start; x < end; x += increment) {
            for (FuzzyOutput.OutputConstraint oc : fuzzyOutput.getOutputList()) {
                float membership = fuzzyOutput.getOutputVariable().GetLabelMembership(oc.getLabel(), x);
                float constrainedMembership = normOperator.Evaluate(membership, oc.getFiringStrength());
                weightSum += x * constrainedMembership;
                membershipSum += constrainedMembership;
            }
        }
        if (membershipSum == 0.0f) {
            try {
                throw new Exception("The numerical output in unavaliable. All memberships are zero.");
            }
            catch (Exception ex) {
                Logger.getLogger(CentroidDefuzzifier.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return weightSum / membershipSum;
    }
}

