/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.ArraysUtil;
import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RealCodedSimulatedAnnealing
extends BaseEvolutionaryOptimization {
    private int maxSub;
    private double t0;
    private double alpha;
    private int move;
    private double mu;
    private double sigma;

    public int getMaxSubIterations() {
        return this.maxSub;
    }

    public void setMaxSubIterations(int maxSub) {
        this.maxSub = maxSub;
    }

    public double getInitialTemperature() {
        return this.t0;
    }

    public void setInitialTemperature(double t0) {
        this.t0 = t0;
    }

    public double getTemperatureReduction() {
        return this.alpha;
    }

    public void setTemperatureReduction(double alpha) {
        this.alpha = alpha;
    }

    public int getNumberOfNeighbors() {
        return this.move;
    }

    public void setNumberOfNeighbors(int move) {
        this.move = move;
    }

    public double getMutationRate() {
        return this.mu;
    }

    public void setMutationRate(double mu) {
        this.mu = mu;
    }

    public double getMutationRange() {
        return this.sigma;
    }

    public void setMutationRange(double sigma) {
        this.sigma = sigma;
    }

    public RealCodedSimulatedAnnealing() {
        this(10, 1000);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations) {
        this(population, iterations, 20);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations, int maxSub) {
        this(population, iterations, maxSub, 0.1);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations, int maxSub, double t0) {
        this(population, iterations, maxSub, t0, 0.99);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations, int maxSub, double t0, double alpha) {
        this(population, iterations, maxSub, t0, alpha, 5);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations, int maxSub, double t0, double alpha, int move) {
        this(population, iterations, maxSub, t0, alpha, move, 0.5);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations, int maxSub, double t0, double alpha, int move, double mu) {
        this(population, iterations, maxSub, t0, alpha, move, mu, 0.1);
    }

    public RealCodedSimulatedAnnealing(int population, int iterations, int maxSub, double t0, double alpha, int move, double mu, double sigma) {
        this.populationSize = population;
        this.generations = iterations;
        this.maxSub = maxSub;
        this.t0 = t0;
        this.alpha = alpha;
        this.move = move;
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        Random rand = new Random();
        double[][] pop = new double[this.populationSize][boundConstraint.size()];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(boundConstraint);
        }
        double[] fitness = new double[pop.length];
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = function.Compute(pop[i]);
        }
        double t = this.t0;
        for (int i = 0; i < this.generations; ++i) {
            double[][] newPop = new double[pop.length * this.move][pop[0].length];
            double[] newFitness = new double[newPop.length];
            double[] sigmaRange = new double[boundConstraint.size()];
            for (int m = 0; m < sigmaRange.length; ++m) {
                DoubleRange range = boundConstraint.get(m);
                sigmaRange[m] = this.sigma * (range.getMax() - range.getMin());
            }
            for (int j = 0; j < this.maxSub; ++j) {
                int index = 0;
                for (int k = 0; k < pop.length; ++k) {
                    for (int l = 0; l < this.move; ++l) {
                        newPop[index] = this.Mutate(pop[k], this.mu, sigmaRange, boundConstraint, rand);
                        newFitness[index] = function.Compute(newPop[index]);
                        ++index;
                        ++this.nEvals;
                    }
                }
                int[] order = ArraysUtil.Argsort(newFitness, true);
                for (int p = 0; p < pop.length; ++p) {
                    if (newFitness[order[p]] <= fitness[p]) {
                        pop[p] = Arrays.copyOf(newPop[order[p]], newPop[0].length);
                        fitness[p] = newFitness[order[p]];
                    } else {
                        double delta = (newFitness[order[p]] - fitness[p]) / fitness[p];
                        double pr = Math.exp(-delta / t);
                        if (rand.nextDouble() <= pr) {
                            pop[p] = Arrays.copyOf(newPop[order[p]], newPop[0].length);
                            fitness[p] = newFitness[order[p]];
                        }
                    }
                    if (!(fitness[p] <= this.minError)) continue;
                    this.minError = fitness[p];
                    this.best = Arrays.copyOf(pop[p], pop[p].length);
                }
            }
            t *= this.alpha;
            this.sigma *= 0.98;
            if (this.listener == null) continue;
            this.listener.onIteration(i + 1, this.minError);
        }
    }

    private double[] Mutate(double[] solution, double mu, double[] sigmaRange, List<DoubleRange> boundConstraint, Random rand) {
        double[] v = Matrix.UniformRandom(0.0, 1.0, solution.length);
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] <= mu)) continue;
            lst.add(i);
        }
        v = Arrays.copyOf(solution, solution.length);
        for (Integer i : lst) {
            v[i.intValue()] = solution[i] + sigmaRange[i] * rand.nextGaussian();
            v[i.intValue()] = Tools.Clamp(v[i], boundConstraint.get(i));
        }
        return v;
    }

    @Override
    public double getError() {
        return this.minError;
    }
}

