/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class JayaOptimization
extends BaseEvolutionaryOptimization {
    public JayaOptimization() {
        this(100, 1000);
    }

    public JayaOptimization(int population, int iterations) {
        this.populationSize = population;
        this.generations = iterations;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        Random rand = new Random();
        double[][] pop = new double[this.populationSize][boundConstraint.size()];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(boundConstraint);
        }
        double[] fitness = new double[pop.length];
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = function.Compute(pop[i]);
            if (!(fitness[i] < this.minError)) continue;
            this.minError = fitness[i];
            this.best = Arrays.copyOf(pop[i], pop[0].length);
        }
        for (int it = 0; it < this.generations; ++it) {
            double[] worst = pop[Matrix.MaxIndex(fitness)];
            for (int i = 0; i < pop.length; ++i) {
                double[] newSolution = new double[pop[0].length];
                for (int j = 0; j < pop[0].length; ++j) {
                    newSolution[j] = pop[i][j] + rand.nextDouble() * (this.best[j] - Math.abs(pop[i][j])) - rand.nextDouble() * (worst[j] - Math.abs(pop[i][j]));
                    newSolution[j] = Tools.Clamp(newSolution[j], boundConstraint.get(j));
                }
                double f = function.Compute(newSolution);
                ++this.nEvals;
                if (f < fitness[i]) {
                    pop[i] = newSolution;
                    fitness[i] = f;
                }
                if (!(f < this.minError)) continue;
                this.minError = f;
                this.best = Arrays.copyOf(newSolution, pop[0].length);
            }
            if (this.listener == null) continue;
            this.listener.onIteration(it + 1, this.minError);
        }
    }

    @Override
    public double getError() {
        return this.minError;
    }
}

