/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import java.util.List;
import java.util.Random;

public class GreyWolfOptimizer
extends BaseEvolutionaryOptimization {
    private double[] alpha;
    private double[] beta;
    private double[] delta;
    private double alphaScore;
    private double betaScore;
    private double deltaScore;

    public GreyWolfOptimizer() {
        this(25, 1000);
    }

    public GreyWolfOptimizer(int population, int generations) {
        this.populationSize = population;
        this.generations = generations;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        Random rand = new Random();
        int iter = 0;
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        this.alpha = new double[boundConstraint.size()];
        this.beta = new double[boundConstraint.size()];
        this.delta = new double[boundConstraint.size()];
        this.deltaScore = Double.MAX_VALUE;
        this.betaScore = Double.MAX_VALUE;
        this.alphaScore = Double.MAX_VALUE;
        double[][] pop = this.InitializePopulation(this.populationSize, boundConstraint);
        for (int g = 0; g < this.generations; ++g) {
            for (int i = 0; i < pop.length; ++i) {
                double fitness = function.Compute(pop[i]);
                ++this.nEvals;
                if (fitness < this.alphaScore) {
                    this.alphaScore = fitness;
                    this.alpha = pop[i];
                }
                if (fitness > this.alphaScore && fitness < this.betaScore) {
                    this.betaScore = fitness;
                    this.beta = pop[i];
                }
                if (fitness > this.alphaScore && fitness > this.betaScore && fitness < this.deltaScore) {
                    this.deltaScore = fitness;
                    this.delta = pop[i];
                }
                if (!(fitness < this.minError)) continue;
                this.minError = fitness;
                this.best = pop[i];
            }
            double a = 2.0 - (double)iter * (2.0 / (double)this.generations);
            for (int i = 0; i < pop.length; ++i) {
                for (int j = 0; j < pop[0].length; ++j) {
                    DoubleRange bounds;
                    double c3;
                    double d_delta;
                    double a3;
                    double x3;
                    double c2;
                    double d_beta;
                    double a2;
                    double x2;
                    double c1;
                    double d_alpha;
                    double a1 = 2.0 * a * rand.nextDouble() - a;
                    double x1 = this.alpha[j] - a1 * (d_alpha = Math.abs((c1 = 2.0 * rand.nextDouble()) * this.alpha[j] - pop[i][j]));
                    double val = (x1 + (x2 = this.beta[j] - (a2 = 2.0 * a * rand.nextDouble() - a) * (d_beta = Math.abs((c2 = 2.0 * rand.nextDouble()) * this.beta[j] - pop[i][j]))) + (x3 = this.delta[j] - (a3 = 2.0 * a * rand.nextDouble() - a) * (d_delta = Math.abs((c3 = 2.0 * rand.nextDouble()) * this.delta[j] - pop[i][j])))) / 3.0;
                    if (val > (bounds = boundConstraint.get(j)).getMax()) {
                        val = bounds.getMax();
                    }
                    if (val < bounds.getMin()) {
                        val = bounds.getMin();
                    }
                    pop[i][j] = val;
                }
            }
            ++iter;
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }

    private double[][] InitializePopulation(int population, List<DoubleRange> boundConstraint) {
        double[][] pop = new double[population][boundConstraint.size()];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(boundConstraint);
        }
        return pop;
    }
}

