/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.Individual;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class BiogeographyBasedOptimization
extends BaseEvolutionaryOptimization {
    private float keepRate;
    private double alpha = 0.9;
    private float pMutation = 0.1f;
    private double sigma = 0.02;

    public float getKeepRate() {
        return this.keepRate;
    }

    public void setKeepRate(float keepRate) {
        this.keepRate = Math.max(0.0f, Math.min(1.0f, keepRate));
    }

    public float getProbabilityMutation() {
        return this.pMutation;
    }

    public void setProbabilityMutation(float pMutation) {
        this.pMutation = pMutation;
    }

    public BiogeographyBasedOptimization() {
        this(50, 1000, 0.2f);
    }

    public BiogeographyBasedOptimization(int populationSize, int generations) {
        this(populationSize, generations, 0.2f);
    }

    public BiogeographyBasedOptimization(int populationSize, int generations, float keepRate) {
        this.populationSize = populationSize;
        this.generations = generations;
        this.keepRate = keepRate;
    }

    public BiogeographyBasedOptimization(int populationSize, int generations, float keepRate, float pMutation) {
        this.populationSize = populationSize;
        this.generations = generations;
        this.keepRate = keepRate;
        this.pMutation = pMutation;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> bounds) {
        Random rand = new Random();
        this.nEvals = 0L;
        this.minError = Double.MAX_VALUE;
        List<Individual> population = Individual.CreatePopulation(this.populationSize, bounds, function);
        this.nEvals += (long)this.populationSize;
        Collections.sort(population);
        this.best = Arrays.copyOf(population.get(0).getLocation(), bounds.size());
        this.minError = population.get(0).getFitness();
        int nKeep = (int)((float)this.populationSize * this.keepRate);
        int nNews = this.populationSize - nKeep;
        double[] mu = Matrix.Linspace(1.0, 0.0, this.populationSize);
        double[] sigmas = new double[bounds.size()];
        for (int i = 0; i < sigmas.length; ++i) {
            DoubleRange range = bounds.get(i);
            sigmas[i] = this.sigma * (range.getMax() - range.getMin());
        }
        for (int g = 0; g < this.generations; ++g) {
            int i;
            ArrayList<Individual> newpop = new ArrayList<Individual>(this.populationSize);
            for (i = 0; i < this.populationSize; ++i) {
                newpop.add(population.get(i).getClone());
            }
            for (i = 0; i < this.populationSize; ++i) {
                double[] newIndividual = ((Individual)newpop.get(i)).getLocation();
                for (int j = 0; j < bounds.size(); ++j) {
                    if (rand.nextDouble() <= 1.0 - mu[i]) {
                        double[] ep = Arrays.copyOf(mu, mu.length);
                        ep[i] = 0.0;
                        double sum = Tools.Sum(ep);
                        int k = 0;
                        while (k < ep.length) {
                            int n = k++;
                            ep[n] = ep[n] / sum;
                        }
                        int index = this.RouletteWheelSelection(ep, rand);
                        newIndividual[j] = population.get(i).getLocation(j) + this.alpha * (population.get(index).getLocation(j) - population.get(i).getLocation(j));
                    }
                    if (!(rand.nextFloat() <= this.pMutation)) continue;
                    newIndividual[j] = newIndividual[j] + sigmas[j] * rand.nextGaussian();
                }
                Catalano.Math.Tools.Clamp(newIndividual, bounds);
                double f = function.Compute(newIndividual);
                ((Individual)newpop.get(i)).setFitness(f);
                ++this.nEvals;
            }
            Collections.sort(newpop);
            population = population.subList(0, nKeep);
            population.addAll(newpop.subList(0, nNews));
            Collections.sort(population);
            this.best = Arrays.copyOf(population.get(0).getLocation(), bounds.size());
            this.minError = population.get(0).getFitness();
            this.listener.onIteration(g + 1, this.minError);
        }
    }

    private int RouletteWheelSelection(double[] values, Random rand) {
        double r = rand.nextDouble();
        double cumsum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (!((cumsum += values[i]) >= r)) continue;
            return i;
        }
        return values.length - 1;
    }
}

