/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Selection;

import Catalano.Core.ArraysUtil;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Selection.ISelection;
import Catalano.Math.Matrix;
import java.util.List;

public class TournamentSelection
implements ISelection {
    private int k;

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = Math.max(k, 2);
    }

    public TournamentSelection() {
        this(5);
    }

    public TournamentSelection(int k) {
        this.k = Math.max(k, 2);
    }

    @Override
    public int[] Compute(List<IChromosome> chromosomes) {
        int[] index = Matrix.Indices(0, chromosomes.size());
        ArraysUtil.Shuffle(index);
        int[] selected = new int[this.k];
        double[] fit = new double[this.k];
        for (int i = 0; i < this.k; ++i) {
            selected[i] = index[i];
            fit[i] = chromosomes.get(index[i]).getFitness();
        }
        int[] order = ArraysUtil.Argsort(fit, false);
        return new int[]{selected[order[0]], selected[order[1]]};
    }
}

