/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Selection;

import Catalano.Core.ArraysUtil;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Selection.ISelection;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RouletteWheelSelection
implements ISelection {
    private long seed;

    public RouletteWheelSelection() {
    }

    public RouletteWheelSelection(long seed) {
        this.seed = seed;
    }

    @Override
    public int[] Compute(List<IChromosome> chromosomes) {
        int i;
        int[] index = new int[2];
        double[] fitness = new double[chromosomes.size()];
        double max = 0.0;
        for (i = 0; i < fitness.length; ++i) {
            fitness[i] = chromosomes.get(i).getFitness();
            max = Math.max(max, fitness[i]);
        }
        i = 0;
        while (i < fitness.length) {
            int n = i++;
            fitness[n] = fitness[n] / max;
        }
        int[] oriIndex = ArraysUtil.Argsort(fitness, true);
        Arrays.sort(fitness);
        Random r = new Random();
        if (this.seed != 0L) {
            r.setSeed(this.seed);
        }
        for (int i2 = 0; i2 < index.length; ++i2) {
            double v = r.nextDouble();
            for (int j = 0; j < fitness.length; ++j) {
                if (!(v >= fitness[j])) continue;
                index[i2] = oriIndex[j];
            }
        }
        return index;
    }
}

