/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Selection;

import Catalano.Core.ArraysUtil;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Selection.ISelection;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RankSelection
implements ISelection {
    private long seed;

    @Override
    public int[] Compute(List<IChromosome> chromosomes) {
        int[] index = new int[2];
        double[] fitness = new double[chromosomes.size()];
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = chromosomes.get(i).getFitness();
        }
        int[] indexes = ArraysUtil.Argsort(fitness, true);
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = (double)indexes[i] / (double)indexes.length;
        }
        Arrays.sort(fitness);
        Random r = new Random();
        if (this.seed != 0L) {
            r.setSeed(this.seed);
        }
        for (int i = 0; i < index.length; ++i) {
            double v = r.nextDouble();
            for (int j = 0; j < fitness.length; ++j) {
                if (!(v >= fitness[j])) continue;
                index[i] = indexes[j];
            }
        }
        return index;
    }
}

