/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import Catalano.Evolutionary.Genetic.IFitness;
import Catalano.Evolutionary.Genetic.Mutation.IMutation;
import Catalano.Evolutionary.Genetic.Reinsertion.ElistismReinsertion;
import Catalano.Evolutionary.Genetic.Reinsertion.IReinsertion;
import Catalano.Evolutionary.Genetic.Selection.ISelection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class Population {
    private int population;
    private float crossoverRate;
    private IFitness function;
    private List<IChromosome> list;
    private ISelection selection;
    private ICrossover crossover;
    private IMutation mutation;
    private IReinsertion reinsertion;
    private IChromosome best;
    private double minError;
    private long nEvals;

    public int getPopulationSize() {
        return this.population;
    }

    public float getCrossoverRate() {
        return this.crossoverRate;
    }

    public void setCrossoverRate(float crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    public IChromosome getBest() {
        return this.best;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void setCrossover(ICrossover crossover) {
        this.crossover = crossover;
    }

    public void setMutation(IMutation mutation) {
        this.mutation = mutation;
    }

    public long getNumberOfEvaluations() {
        return this.nEvals;
    }

    public Population(IChromosome base, int population, IFitness function, float crossoverRate) {
        this.population = population;
        this.crossoverRate = crossoverRate;
        this.function = function;
        this.Generate(base);
    }

    public void setOperators(ISelection selection, ICrossover crossover, IMutation mutation) {
        this.selection = selection;
        this.crossover = crossover;
        this.mutation = mutation;
        this.reinsertion = new ElistismReinsertion();
    }

    public void setOperators(ISelection selection, ICrossover crossover, IMutation mutation, IReinsertion reinsertion) {
        this.selection = selection;
        this.crossover = crossover;
        this.mutation = mutation;
        this.reinsertion = reinsertion;
    }

    private void Generate(IChromosome chromossome) {
        this.list = new ArrayList<IChromosome>(this.population);
        chromossome.Evaluate(this.function);
        this.minError = chromossome.getFitness();
        this.best = chromossome.Clone();
        this.list.add(chromossome);
        for (int i = 1; i < this.population; ++i) {
            IChromosome c = chromossome.CreateNew();
            c.Evaluate(this.function);
            this.list.add(c);
            if (!(c.getFitness() < this.minError)) continue;
            this.minError = c.getFitness();
            this.best = c.Clone();
        }
    }

    public void RunEpoch() {
        Random rand = new Random();
        ArrayList<IChromosome> newPop = new ArrayList<IChromosome>();
        for (int i = 1; i < this.population; i += 2) {
            if (rand.nextFloat() < this.crossoverRate) {
                int[] index = this.selection.Compute(this.list);
                List<IChromosome> elem = this.crossover.Compute(this.list.get(index[0]), this.list.get(index[1]));
                newPop.addAll(elem);
                continue;
            }
            newPop.add(this.list.get(i - 1).Clone());
            newPop.add(this.list.get(i).Clone());
        }
        int size = newPop.size();
        for (int i = 0; i < size; ++i) {
            IChromosome c = (IChromosome)this.mutation.Compute(newPop.get(i));
            c.Evaluate(this.function);
            newPop.set(i, c);
            ++this.nEvals;
        }
        this.list = this.reinsertion.Compute(this, this.list, newPop);
        IChromosome bTemp = this.FindBestChromossome(this.list);
        if (bTemp.getFitness() > this.minError) {
            this.minError = bTemp.getFitness();
            this.best = bTemp.Clone();
        }
    }

    private IChromosome FindBestChromossome(List<IChromosome> list) {
        IChromosome b = null;
        double f = -1.7976931348623157E308;
        for (IChromosome c : list) {
            if (!(c.getFitness() > f)) continue;
            f = c.getFitness();
            b = c.Clone();
        }
        return b;
    }

    private void Sort(List<IChromosome> list) {
        list.sort(new Comparator<IChromosome>(){

            @Override
            public int compare(IChromosome o1, IChromosome o2) {
                return Double.compare(o2.getFitness(), o1.getFitness());
            }
        });
    }
}

