/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.PermutationChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import Catalano.Math.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiPointCrossover
implements ICrossover<IChromosome> {
    private int n;

    public int getNumberOfPoints() {
        return this.n;
    }

    public void setNumberOfPoints(int n) {
        this.n = Math.max(1, n);
    }

    public MultiPointCrossover() {
        this(3);
    }

    public MultiPointCrossover(int n) {
        this.n = n;
    }

    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        if (chromosome1 instanceof PermutationChromosome) {
            throw new IllegalArgumentException("Permutation Chromosome is not supported.");
        }
        int length = chromosome1.getLength();
        int[] indexes = Matrix.RandomPermutation(length);
        int[] cuts = Arrays.copyOf(indexes, this.n);
        Arrays.sort(cuts, 0, cuts.length);
        IChromosome c1 = chromosome1.Clone();
        IChromosome c2 = chromosome2.Clone();
        int start = 0;
        for (int c = 0; c < this.n; ++c) {
            int i;
            if (c % 2 == 0) {
                for (i = start; i < cuts[c]; ++i) {
                    c1.setGene(i, chromosome1.getGene(i));
                    c2.setGene(i, chromosome2.getGene(i));
                }
            } else {
                for (i = start; i < cuts[c]; ++i) {
                    c1.setGene(i, chromosome2.getGene(i));
                    c2.setGene(i, chromosome1.getGene(i));
                }
            }
            start = cuts[c];
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }
}

