/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.DoubleChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.FloatChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import Catalano.Math.Random.Random;
import java.util.ArrayList;
import java.util.List;

public class FlatCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        if (chromosome1 instanceof FloatChromosome) {
            return this.Compute((FloatChromosome)chromosome1, (FloatChromosome)chromosome2);
        }
        if (chromosome1 instanceof DoubleChromosome) {
            return this.Compute((DoubleChromosome)chromosome1, (DoubleChromosome)chromosome2);
        }
        throw new IllegalArgumentException("Flat crossover only works with Double/Float chromosomes.");
    }

    @Override
    private List<IChromosome> Compute(DoubleChromosome chromosome1, DoubleChromosome chromosome2) {
        Random rand = new Random();
        DoubleChromosome c1 = (DoubleChromosome)chromosome1.Clone();
        DoubleChromosome c2 = (DoubleChromosome)chromosome2.Clone();
        int length = c1.getLength();
        for (int i = 0; i < length; ++i) {
            double min = Math.min((Double)c1.getGene(i), (Double)c2.getGene(i));
            double max = Math.max((Double)c1.getGene(i), (Double)c2.getGene(i));
            c1.setGene(i, (Object)rand.nextDouble(min, max));
            c2.setGene(i, (Object)rand.nextDouble(min, max));
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }

    @Override
    private List<IChromosome> Compute(FloatChromosome chromosome1, FloatChromosome chromosome2) {
        Random rand = new Random();
        FloatChromosome c1 = (FloatChromosome)chromosome1.Clone();
        FloatChromosome c2 = (FloatChromosome)chromosome2.Clone();
        int length = c1.getLength();
        for (int i = 0; i < length; ++i) {
            float min = Math.min(((Float)c1.getGene(i)).floatValue(), ((Float)c2.getGene(i)).floatValue());
            float max = Math.max(((Float)c1.getGene(i)).floatValue(), ((Float)c2.getGene(i)).floatValue());
            c1.setGene(i, Float.valueOf((float)rand.nextDouble(min, max)));
            c2.setGene(i, Float.valueOf((float)rand.nextDouble(min, max)));
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }
}

