/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Core.Structs;

import java.util.ArrayList;
import java.util.List;

public class BinaryHeap<E extends Comparable<E>> {
    private int count = 0;
    List<E> heap = new ArrayList();

    public int count() {
        return this.count;
    }

    public int size() {
        return this.heap.size();
    }

    public BinaryHeap() {
    }

    public BinaryHeap(E[] keys) {
        for (E key : keys) {
            this.heap.add(key);
        }
        for (int k = this.heap.size() / 2 - 1; k >= 0; --k) {
            this.downHeap(k, (Comparable)this.heap.get(k));
        }
    }

    public void add(E node) {
        this.heap.add(null);
        int k = this.heap.size() - 1;
        this.upHeap(k, node);
        ++this.count;
    }

    public E remove() {
        Comparable removedNode = (Comparable)this.heap.get(0);
        Comparable lastNode = (Comparable)this.heap.remove(this.heap.size() - 1);
        this.downHeap(0, lastNode);
        --this.count;
        return (E)removedNode;
    }

    public void remove(E item) {
        this.heap.remove(item);
    }

    public E min() {
        return (E)((Comparable)this.heap.get(0));
    }

    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    private void upHeap(int k, E node) {
        int parent;
        Comparable p;
        while (k > 0 && node.compareTo((Comparable)(p = (Comparable)this.heap.get(parent = (k - 1) / 2))) < 0) {
            this.heap.set(k, p);
            k = parent;
        }
        this.heap.set(k, node);
    }

    private void downHeap(int k, E node) {
        if (this.heap.isEmpty()) {
            return;
        }
        while (k < this.heap.size() / 2) {
            int child = 2 * k + 1;
            if (child < this.heap.size() - 1 && ((Comparable)this.heap.get(child)).compareTo(this.heap.get(child + 1)) > 0) {
                ++child;
            }
            if (node.compareTo(this.heap.get(child)) < 0) break;
            this.heap.set(k, this.heap.get(child));
            k = child;
        }
        this.heap.set(k, node);
    }
}

