/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Core;

import Catalano.Core.DoubleRange;
import Catalano.Core.IntRange;
import java.io.Serializable;

public class FloatRange
implements Serializable {
    float min;
    float max;

    public FloatRange() {
    }

    public FloatRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float length() {
        return this.max - this.min;
    }

    public boolean isInside(float x) {
        return x >= this.min && x <= this.max;
    }

    public boolean IsOverlapping(FloatRange range) {
        return this.isInside(range.min) || this.isInside(range.max) || range.isInside(this.min) || range.isInside(this.max);
    }

    public IntRange toIntRange() {
        return new IntRange((int)this.min, (int)this.max);
    }

    public DoubleRange toDoubleRange() {
        return new DoubleRange(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(FloatRange.class)) {
            FloatRange range = (FloatRange)obj;
            return this.min == range.getMin() && this.max == range.getMax();
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + Float.floatToIntBits(this.min);
        hash += 19 * hash + Float.floatToIntBits(this.max);
        return hash;
    }

    public String toString() {
        return "Minimum: " + this.min + " Maximum: " + this.max;
    }
}

