/*
 * Decompiled with CFR 0.152.
 */
package test;

import org.jzy3d.analysis.AbstractAnalysis;
import org.jzy3d.analysis.AnalysisLauncher;
import org.jzy3d.analysis.IAnalysis;
import org.jzy3d.chart.factories.AWTChartComponentFactory;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalGrid;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.rendering.canvas.Quality;

public class SurfaceDemo
extends AbstractAnalysis {
    public static void main(String[] args) throws Exception {
        AnalysisLauncher.open((IAnalysis)new SurfaceDemo());
    }

    public void init() {
        Mapper mapper = new Mapper(){

            public double f(double x, double y) {
                return x * Math.sin(x * y);
            }
        };
        Range range = new Range(-3.0f, 3.0f);
        int steps = 80;
        Shape surface = Builder.buildOrthonormal((OrthonormalGrid)new OrthonormalGrid(range, steps, range, steps), (Mapper)mapper);
        surface.setColorMapper(new ColorMapper((IColorMap)new ColorMapRainbow(), (double)surface.getBounds().getZmin(), (double)surface.getBounds().getZmax(), new Color(1.0f, 1.0f, 1.0f, 0.5f)));
        surface.setFaceDisplayed(true);
        surface.setWireframeDisplayed(false);
        this.chart = AWTChartComponentFactory.chart((Quality)Quality.Advanced, (String)this.getCanvasType());
        this.chart.getScene().getGraph().add((AbstractDrawable)surface);
    }
}

