/*
 * Decompiled with CFR 0.152.
 */
package jyplot.XYErrorBar;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import jyplot.XYErrorBar.XYErrorBarRenderer;
import jyplot.XYErrorBar.XYErrorBarSeries;
import jyplot.XYErrorBar.XYErrorBarSeriesCollection;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;

public class ErrorBarDemo {
    public ErrorBarDemo() {
        XYDataset dataset = this.createDataset();
        ChartPanel chartPanel = this.createChartPanel(dataset);
        JFrame frame = new JFrame("Error Bar Demo");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(chartPanel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.pack();
        frame.setLocation((screenSize.width - frame.getWidth()) / 2, (screenSize.height - frame.getHeight()) / 2);
        frame.show();
    }

    public static void main(String[] args) {
        new ErrorBarDemo();
    }

    private ChartPanel createChartPanel(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createScatterPlot("Error Bar Demo", "x", "y", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYErrorBarRenderer r = new XYErrorBarRenderer();
        chart.getXYPlot().setRenderer(r);
        r.addChangeListener(chart.getXYPlot());
        ChartPanel chartPanel = new ChartPanel(chart, false, false, false, false, false);
        chartPanel.setMouseZoomable(true, false);
        return chartPanel;
    }

    private XYDataset createDataset() {
        XYErrorBarSeriesCollection dataset = new XYErrorBarSeriesCollection();
        XYErrorBarSeries series = new XYErrorBarSeries("Series 1");
        for (int i = 0; i < 10; ++i) {
            series.add(i, i, i - 2, i + 2);
        }
        dataset.addSeries(series);
        return dataset;
    }
}

