/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhplot.FPR;
import jplot3dp.JColor;
import jplot3dp.ModelView;
import jplot3dp.Utils;

class OptionsDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Frame parentFrame;
    private ModelView modelView;
    private ModelView.FunctionsList functions;
    private boolean dirty = false;
    private JComboBox comboFunction;
    private JLabel lblFunctions;
    private JToggleButton tglIsCurve;
    private JCheckBox chkVisible;
    private JButton btnAdd;
    private JButton btnDelete;
    private JSpinner spinUSteps;
    private JSpinner spinVSteps;
    private JSpinner spinPenWidth;
    private Container paneUSteps;
    private Container paneVSteps;
    private Container panePenWidth;
    private Container paneSurfaceColor;
    private JTextArea textFuncDef;
    private JCheckBox chkFillSurface;
    private JColor curveColor;
    private JColor surfaceColor;
    private JSlider sldAlpha;
    private JLabel lblArea;
    private JComponent containerFunc;
    private JTabbedPane jtpMain;
    private ModelView.ModelFunction lastFunction;
    private JButton btnGoLeft;
    private JButton btnGoRight;
    private JPanel jpanVStepsFill;
    private JCheckBox chkAbsoluteWidth;
    private JTextField jtfTitle;
    private JColor bgColor;
    private JCheckBox chkFog;
    private JSpinner spinFogStart;
    private JSpinner spinFogEnd;
    private JSpinner spinBoxWidth;
    private JSpinner spinBoxHeight;
    private JSpinner spinFOV;
    private JCheckBox[] axisShown = new JCheckBox[3];
    private JSpinner[] spnAxesMin = new JSpinner[3];
    private JSpinner[] spnAxesMax = new JSpinner[3];
    private JColor axesColor;
    private JSpinner spnAxesIncr;
    private JSpinner spnAxesTicks;
    private JSpinner spnAxesWidth;

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    private void updateLblFunctions() {
        this.lblFunctions.setText("Number of function(s): " + this.functions.size());
    }

    private void updateBorderFunction() {
        TitledBorder titledborder = (TitledBorder)this.containerFunc.getBorder();
        titledborder.setTitle("\"" + this.lastFunction.name + "\" properties");
        this.containerFunc.repaint();
    }

    private void updateLblArea() {
        double d = this.lastFunction.getArea();
        d = (double)((int)(d * 10000.0 + 0.5)) / 10000.0;
        if (this.lastFunction.isCurve) {
            this.lblArea.setText("Aproximate length : " + d);
        } else {
            this.lblArea.setText("Aproximate surface area : " + d);
        }
    }

    private Container createFunctionTools() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.fill = 2;
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.insets = new Insets(0, 2, 0, 0);
        this.btnGoLeft = new JButton(Utils.loadIcon("goleft.gif"));
        jpanel.add((Component)this.btnGoLeft, gridbagconstraints);
        Utils.makeHot(this.btnGoLeft);
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.insets = new Insets(0, 0, 0, 0);
        this.comboFunction = new JComboBox();
        jpanel.add(this.comboFunction, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.insets = new Insets(0, 0, 2, 0);
        this.btnGoRight = new JButton(Utils.loadIcon("goright.gif"));
        jpanel.add((Component)this.btnGoRight, gridbagconstraints);
        Utils.makeHot(this.btnGoRight);
        class _cls1OnLeftRight
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent actionevent) {
                int i = actionevent.getSource().equals(OptionsDialog.this.btnGoLeft) ? OptionsDialog.this.comboFunction.getSelectedIndex() - 1 : OptionsDialog.this.comboFunction.getSelectedIndex() + 1;
                OptionsDialog.this.comboFunction.setSelectedIndex(i %= OptionsDialog.this.comboFunction.getItemCount());
            }

            _cls1OnLeftRight() {
            }
        }
        this.btnGoLeft.addActionListener(new _cls1OnLeftRight());
        this.btnGoRight.addActionListener(new _cls1OnLeftRight());
        this.comboFunction.setEditable(true);
        this.comboFunction.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                if (itemevent.getStateChange() == 1) {
                    Object obj = ((JComboBox)itemevent.getSource()).getSelectedItem();
                    if (obj instanceof ModelView.ModelFunction) {
                        OptionsDialog.this.lastFunction = (ModelView.ModelFunction)((JComboBox)itemevent.getSource()).getSelectedItem();
                        OptionsDialog.this.getFunctionFields();
                    }
                } else {
                    OptionsDialog.this.setFunctionFields(OptionsDialog.this.lastFunction);
                }
            }
        });
        this.comboFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                if (OptionsDialog.this.lastFunction != null) {
                    ((OptionsDialog)OptionsDialog.this).lastFunction.name = OptionsDialog.this.comboFunction.getSelectedItem().toString();
                    OptionsDialog.this.updateBorderFunction();
                }
            }
        });
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.fill = 0;
        gridbagconstraints.insets = new Insets(0, 2, 0, 0);
        this.chkVisible = new JCheckBox();
        jpanel.add((Component)this.chkVisible, gridbagconstraints);
        this.chkVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                OptionsDialog.this.setFunctionFields();
            }
        });
        gridbagconstraints.insets = new Insets(0, 0, 0, 5);
        JLabel jlabel = new JLabel(Utils.loadIcon("eye.gif"));
        jpanel.add((Component)jlabel, gridbagconstraints);
        jlabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseevent) {
                OptionsDialog.this.chkVisible.setSelected(!OptionsDialog.this.chkVisible.isSelected());
                OptionsDialog.this.setFunctionFields();
            }
        });
        gridbagconstraints.insets = new Insets(0, 2, 0, 2);
        this.btnAdd = new JButton("Add");
        jpanel.add((Component)this.btnAdd, gridbagconstraints);
        this.btnDelete = new JButton("Delete");
        jpanel.add((Component)this.btnDelete, gridbagconstraints);
        gridbagconstraints.weightx = 2.0;
        gridbagconstraints.anchor = 22;
        gridbagconstraints.insets = new Insets(0, 5, 0, 5);
        this.lblFunctions = new JLabel();
        jpanel.add((Component)this.lblFunctions, gridbagconstraints);
        this.updateLblFunctions();
        ActionListener actionlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                if (actionevent.getSource() == OptionsDialog.this.btnAdd) {
                    ModelView.ModelFunction modelfunction = OptionsDialog.this.functions.addFunction();
                    modelfunction.parseFunction();
                    OptionsDialog.this.comboFunction.addItem(modelfunction);
                    OptionsDialog.this.comboFunction.setSelectedIndex(OptionsDialog.this.comboFunction.getItemCount() - 1);
                } else if (OptionsDialog.this.comboFunction.getItemCount() > 1) {
                    int i = OptionsDialog.this.comboFunction.getSelectedIndex();
                    OptionsDialog.this.comboFunction.removeItemAt(i);
                    OptionsDialog.this.functions.removeFunction(i);
                }
                OptionsDialog.this.updateLblFunctions();
                OptionsDialog.this.modelView.repaint();
            }
        };
        this.btnAdd.addActionListener(actionlistener);
        this.btnDelete.addActionListener(actionlistener);
        jpanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        return jpanel;
    }

    public void addFunction(FPR fun) {
        ModelView.ModelFunction modelfunction = this.functions.addFunction();
        modelfunction.expression = fun.getName();
        modelfunction.gridDivsU = fun.getDivU();
        modelfunction.gridDivsV = fun.getDivV();
        modelfunction.curveColor = fun.getLineColor();
        modelfunction.curveWidth = fun.getPenWidth();
        modelfunction.surfaceColor = fun.getFillColor();
        modelfunction.fillSurface = fun.isFilled();
        modelfunction.parseFunction();
        this.comboFunction.addItem(modelfunction);
        this.comboFunction.setSelectedIndex(this.comboFunction.getItemCount() - 1);
        this.updateLblFunctions();
    }

    private Container createFunctionControls() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = -1;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 0;
        this.tglIsCurve = new JToggleButton("Function is a curve", false);
        jpanel.add((Component)this.tglIsCurve, gridbagconstraints);
        this.tglIsCurve.setSelected(true);
        this.tglIsCurve.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                boolean flag = OptionsDialog.this.tglIsCurve.isSelected();
                OptionsDialog.this.chkFillSurface.setVisible(!flag);
                ((JLabel)OptionsDialog.this.paneUSteps.getComponent(0)).setText(flag ? "t steps:" : "u steps:");
                OptionsDialog.this.paneVSteps.setVisible(!flag);
                OptionsDialog.this.jpanVStepsFill.setVisible(flag);
                OptionsDialog.this.panePenWidth.setVisible(flag);
                OptionsDialog.this.chkAbsoluteWidth.setVisible(flag);
                OptionsDialog.this.paneSurfaceColor.setVisible(!flag);
                if (((OptionsDialog)OptionsDialog.this).lastFunction.isCurve != flag) {
                    OptionsDialog.this.lblArea.setText("");
                } else {
                    OptionsDialog.this.updateLblArea();
                }
            }
        });
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridwidth = 1;
        this.spinUSteps = new JSpinner(new SpinnerNumberModel(30, 1, 5000, 1));
        this.paneUSteps = Utils.labeledComponent("u steps:", this.spinUSteps, true);
        jpanel.add((Component)this.paneUSteps, gridbagconstraints);
        gridbagconstraints.gridx = 1;
        this.jpanVStepsFill = new JPanel();
        jpanel.add((Component)this.jpanVStepsFill, gridbagconstraints);
        this.spinVSteps = new JSpinner(new SpinnerNumberModel(30, 1, 5000, 1));
        this.paneVSteps = Utils.labeledComponent("v steps:", this.spinVSteps, true);
        jpanel.add((Component)this.paneVSteps, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        this.spinPenWidth = new JSpinner(new SpinnerNumberModel(2, 0, 1000, 1));
        this.panePenWidth = Utils.labeledComponent("Pen Width: ", this.spinPenWidth, true);
        jpanel.add((Component)this.panePenWidth, gridbagconstraints);
        gridbagconstraints.gridx = 1;
        this.chkAbsoluteWidth = new JCheckBox("Absolute Width");
        jpanel.add((Component)this.chkAbsoluteWidth, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = -1;
        gridbagconstraints.gridwidth = 0;
        this.chkFillSurface = new JCheckBox("Fill Surface");
        jpanel.add((Component)this.chkFillSurface, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.gridy = -1;
        gridbagconstraints.gridwidth = 1;
        this.curveColor = new JColor(50, 20);
        jpanel.add((Component)Utils.labeledComponent("Curve color:", this.curveColor, true), gridbagconstraints);
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = -1;
        this.surfaceColor = new JColor(50, 20);
        this.paneSurfaceColor = Utils.labeledComponent("Surface color:", this.surfaceColor, true);
        jpanel.add((Component)this.paneSurfaceColor, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridwidth = 0;
        this.sldAlpha = new JSlider(0, 255);
        jpanel.add((Component)Utils.labeledComponent("Transparency:", this.sldAlpha, true), gridbagconstraints);
        this.sldAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                int i = 255 - OptionsDialog.this.sldAlpha.getValue();
                OptionsDialog.this.curveColor.setColor(Utils.changeAlpha(OptionsDialog.this.curveColor.getColor(), i));
                OptionsDialog.this.surfaceColor.setColor(Utils.changeAlpha(OptionsDialog.this.surfaceColor.getColor(), i));
            }
        });
        this.lblArea = new JLabel("Area");
        jpanel.add((Component)this.lblArea, gridbagconstraints);
        this.lblArea.setHorizontalAlignment(0);
        jpanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return jpanel;
    }

    private Container createFunctionEditor() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.weightx = 2.0;
        gridbagconstraints.weighty = 1.0;
        gridbagconstraints.fill = 1;
        this.textFuncDef = new JTextArea();
        Container container = Utils.labeledComponent("Function definition:", new JScrollPane(this.textFuncDef), false);
        jpanel.add((Component)container, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.anchor = 19;
        container = this.createFunctionControls();
        jpanel.add((Component)container, gridbagconstraints);
        jpanel.setBorder(BorderFactory.createTitledBorder("Function Properties"));
        this.containerFunc = jpanel;
        return this.containerFunc;
    }

    private Container createFunctionsPane() {
        Box box = new Box(1);
        box.add(Box.createVerticalStrut(2));
        box.add(this.createFunctionTools());
        box.add(this.createFunctionEditor());
        return box;
    }

    private void getFunctionFields() {
        ModelView.ModelFunction modelfunction = this.lastFunction;
        if (modelfunction == null) {
            return;
        }
        this.updateBorderFunction();
        this.tglIsCurve.setSelected(modelfunction.isCurve);
        this.chkVisible.setSelected(modelfunction.visible);
        this.spinUSteps.setValue(new Integer(modelfunction.gridDivsU - 1));
        this.spinVSteps.setValue(new Integer(modelfunction.gridDivsV - 1));
        this.spinPenWidth.setValue(new Integer(modelfunction.curveWidth));
        this.chkAbsoluteWidth.setSelected(modelfunction.absoluteWidth);
        this.chkFillSurface.setSelected(modelfunction.fillSurface);
        this.curveColor.setColor(modelfunction.curveColor);
        this.surfaceColor.setColor(modelfunction.surfaceColor);
        this.sldAlpha.setValue(255 - modelfunction.surfaceColor.getAlpha());
        this.textFuncDef.setText(modelfunction.expression);
        this.updateLblArea();
    }

    public void setFillColor(Color c) {
        ModelView.ModelFunction modelfunction = this.lastFunction;
        modelfunction.surfaceColor = c;
    }

    public void setLineColor(Color c) {
        ModelView.ModelFunction modelfunction = this.lastFunction;
        modelfunction.curveColor = c;
    }

    private void setFunctionFields() {
        this.setFunctionFields(this.lastFunction);
    }

    private void setFunctionFields(ModelView.ModelFunction modelfunction) {
        int i;
        if (modelfunction == null) {
            return;
        }
        boolean flag = false;
        boolean flag1 = false;
        if (this.tglIsCurve.isSelected() != modelfunction.isCurve) {
            modelfunction.isCurve = this.tglIsCurve.isSelected();
            flag = true;
        }
        if (modelfunction.visible != this.chkVisible.isSelected()) {
            modelfunction.visible = this.chkVisible.isSelected();
            flag1 = true;
        }
        if (modelfunction.gridDivsU != (i = (Integer)this.spinUSteps.getValue() + 1)) {
            modelfunction.gridDivsU = i;
            flag = true;
        }
        if (modelfunction.gridDivsV != (i = (Integer)this.spinVSteps.getValue() + 1)) {
            modelfunction.gridDivsV = i;
            flag = true;
        }
        if (modelfunction.curveWidth != (i = ((Integer)this.spinPenWidth.getValue()).intValue())) {
            modelfunction.curveWidth = i;
            flag1 = true;
        }
        if (modelfunction.absoluteWidth != this.chkAbsoluteWidth.isSelected()) {
            modelfunction.absoluteWidth = this.chkAbsoluteWidth.isSelected();
            flag1 = true;
        }
        if (modelfunction.fillSurface != this.chkFillSurface.isSelected()) {
            modelfunction.fillSurface = this.chkFillSurface.isSelected();
            flag1 = true;
        }
        if (!modelfunction.curveColor.equals(this.curveColor.getColor())) {
            modelfunction.curveColor = this.curveColor.getColor();
            flag1 = true;
        }
        if (!modelfunction.surfaceColor.equals(this.surfaceColor.getColor())) {
            modelfunction.surfaceColor = this.surfaceColor.getColor();
            flag1 = true;
        }
        if (!modelfunction.expression.equals(this.textFuncDef.getText())) {
            modelfunction.expression = this.textFuncDef.getText();
            flag = true;
        }
        if (flag) {
            modelfunction.parseFunction();
            this.updateLblArea();
            flag1 = true;
        }
        if (flag1) {
            this.modelView.repaint();
            this.dirty = true;
        }
    }

    private Container createGlobalControls() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.gridy = 0;
        this.jtfTitle = new JTextField();
        jpanel.add((Component)Utils.labeledComponent("Title to display:", this.jtfTitle, true), gridbagconstraints);
        JPanel jpanel1 = new JPanel(new FlowLayout());
        this.bgColor = new JColor(50, 20);
        jpanel1.add((Component)Utils.labeledComponent("Background color:", this.bgColor, true), gridbagconstraints);
        this.chkFog = new JCheckBox("Fog");
        jpanel1.add((Component)this.chkFog, gridbagconstraints);
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)jpanel1, gridbagconstraints);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 1;
        this.spinFogStart = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
        jpanel.add((Component)Utils.labeledComponent("Fog start:", this.spinFogStart, true), gridbagconstraints);
        this.spinFogEnd = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
        jpanel.add((Component)Utils.labeledComponent("Fog end:", this.spinFogEnd, true), gridbagconstraints);
        gridbagconstraints.gridy = 3;
        this.spinBoxWidth = new JSpinner(new SpinnerNumberModel(10, 0, 2000, 1));
        jpanel.add((Component)Utils.labeledComponent("Box width:", this.spinBoxWidth, true), gridbagconstraints);
        this.spinBoxHeight = new JSpinner(new SpinnerNumberModel(10, 0, 2000, 1));
        jpanel.add((Component)Utils.labeledComponent("Box height:", this.spinBoxHeight, true), gridbagconstraints);
        this.spinBoxWidth.setEnabled(Utils.applet == null);
        this.spinBoxHeight.setEnabled(Utils.applet == null);
        this.modelView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentevent) {
                OptionsDialog.this.spinBoxWidth.setValue(new Integer(OptionsDialog.this.modelView.getWidth()));
                OptionsDialog.this.spinBoxHeight.setValue(new Integer(OptionsDialog.this.modelView.getHeight()));
            }
        });
        gridbagconstraints.gridy = 4;
        gridbagconstraints.gridwidth = 0;
        jpanel1 = new JPanel(new FlowLayout());
        jpanel1.add(new JPanel());
        this.spinFOV = new JSpinner(new SpinnerNumberModel(90.0, 10.0, 170.0, 1.0));
        jpanel1.add(Utils.labeledComponent("Field of Vision:", this.spinFOV, true));
        jpanel1.add(new JPanel());
        jpanel.add((Component)jpanel1, gridbagconstraints);
        jpanel.setBorder(BorderFactory.createTitledBorder("Global Settings"));
        return jpanel;
    }

    private Container createGlobalPane() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.add(this.createGlobalControls());
        return jpanel;
    }

    public double getFov() {
        return (Double)this.spinFOV.getValue();
    }

    public void setFov(double d) {
        this.modelView.getFov();
        this.spinFOV.setValue(new Double(d));
    }

    public void getGlobalFields() {
        this.jtfTitle.setText(this.modelView.title);
        this.bgColor.setColor(this.modelView.bgColor);
        this.chkFog.setSelected(this.modelView.fogEnabled);
        this.spinFogStart.setValue(new Double(this.modelView.fogStart));
        this.spinFogEnd.setValue(new Double(this.modelView.fogEnd));
        this.spinFOV.setValue(new Double(this.modelView.getFov()));
    }

    private void setGlobalFields() {
        double d;
        boolean flag = false;
        if (!this.modelView.title.equals(this.jtfTitle.getText())) {
            this.modelView.title = this.jtfTitle.getText();
            flag = true;
        }
        if (!this.modelView.bgColor.equals(this.bgColor.getColor())) {
            this.modelView.bgColor = this.bgColor.getColor();
            flag = true;
        }
        if (this.modelView.fogEnabled != this.chkFog.isSelected()) {
            this.modelView.fogEnabled = this.chkFog.isSelected();
            flag = true;
        }
        if (this.modelView.fogStart != (d = ((Double)this.spinFogStart.getValue()).doubleValue())) {
            this.modelView.fogStart = d;
            flag = true;
        }
        if (this.modelView.fogEnd != (d = ((Double)this.spinFogEnd.getValue()).doubleValue())) {
            this.modelView.fogEnd = d;
            flag = true;
        }
        d = (Double)this.spinFOV.getValue();
        if (this.modelView.getFov() != d) {
            this.modelView.setFov(d);
            flag = true;
        }
        Dimension dimension = this.modelView.getSize();
        int i = (Integer)this.spinBoxWidth.getValue();
        int j = (Integer)this.spinBoxHeight.getValue();
        if (dimension.height != j || dimension.width != i) {
            Dimension dimension1 = this.parentFrame.getSize();
            this.parentFrame.setSize(dimension1.width - dimension.width + i, dimension1.height - dimension.height + j);
            this.parentFrame.validate();
        }
        if (flag) {
            this.modelView.repaint();
            this.dirty = true;
        }
    }

    private Container createAxisExtents() {
        Box box = new Box(1);
        String[] as = new String[]{"X", "Z", "Y"};
        for (int i = 0; i < 3; ++i) {
            int j = i != 0 ? 3 - i : 0;
            Box box1 = new Box(0);
            box1.add(new JLabel(as[j]));
            this.axisShown[j] = new JCheckBox();
            box1.add(this.axisShown[j]);
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMin[j] = new JSpinner(new SpinnerNumberModel(0.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Min:", this.spnAxesMin[j], true));
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMax[j] = new JSpinner(new SpinnerNumberModel(1.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Max:", this.spnAxesMax[j], true));
            box1.setAlignmentX(1.0f);
            box.add(box1);
        }
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        return box;
    }

    private Container createAxisControls() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        this.axesColor = new JColor(50, 20);
        jpanel.add((Component)Utils.labeledComponent("Axis color:", this.axesColor, true), gridbagconstraints);
        this.spnAxesWidth = new JSpinner(new SpinnerNumberModel(2, 1, 3, 1));
        jpanel.add((Component)Utils.labeledComponent("Line width:", this.spnAxesWidth, true), gridbagconstraints);
        gridbagconstraints.gridy = 1;
        this.spnAxesIncr = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 500.0, 0.01));
        jpanel.add((Component)Utils.labeledComponent("Step density:", this.spnAxesIncr, true), gridbagconstraints);
        this.spnAxesTicks = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 5000.0, 0.05));
        jpanel.add((Component)Utils.labeledComponent("Tick density:", this.spnAxesTicks, true), gridbagconstraints);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)this.createAxisExtents(), gridbagconstraints);
        jpanel.setBorder(BorderFactory.createTitledBorder("Axis Settings"));
        return jpanel;
    }

    private Container createAxisPane() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.add(this.createAxisControls());
        return jpanel;
    }

    private void getAxisFields() {
        ModelView.AxesDefinition axesdefinition = this.modelView.axesDefinition;
        for (int i = 0; i < 3; ++i) {
            this.axisShown[i].setSelected(axesdefinition.shown[i]);
            this.spnAxesMin[i].setValue(new Double(axesdefinition.min[i]));
            this.spnAxesMax[i].setValue(new Double(axesdefinition.max[i]));
        }
        this.axesColor.setColor(axesdefinition.color);
        this.spnAxesIncr.setValue(new Double(axesdefinition.incr));
        this.spnAxesTicks.setValue(new Double(axesdefinition.tickDensity));
        this.spnAxesWidth.setValue(new Integer(axesdefinition.width));
    }

    private void setAxisFields() {
        int i;
        double d1;
        boolean flag = false;
        ModelView.AxesDefinition axesdefinition = this.modelView.axesDefinition;
        for (int j = 0; j < 3; ++j) {
            double d2;
            double d = (Double)this.spnAxesMin[j].getValue();
            if (axesdefinition.min[j] != d) {
                axesdefinition.min[j] = d;
                flag = true;
            }
            if (axesdefinition.max[j] != (d2 = ((Double)this.spnAxesMax[j].getValue()).doubleValue())) {
                axesdefinition.max[j] = d2;
                flag = true;
            }
            if (d2 <= d) {
                this.axisShown[j].setSelected(false);
            }
            if (this.axisShown[j].isSelected() == axesdefinition.shown[j]) continue;
            axesdefinition.shown[j] = this.axisShown[j].isSelected();
            flag = true;
        }
        if (!axesdefinition.color.equals(this.axesColor.getColor())) {
            axesdefinition.color = this.axesColor.getColor();
            flag = true;
        }
        if (axesdefinition.incr != (d1 = ((Double)this.spnAxesIncr.getValue()).doubleValue())) {
            axesdefinition.incr = d1;
            flag = true;
        }
        if (axesdefinition.tickDensity != (d1 = ((Double)this.spnAxesTicks.getValue()).doubleValue())) {
            axesdefinition.tickDensity = d1;
            flag = true;
        }
        if (axesdefinition.width != (i = ((Integer)this.spnAxesWidth.getValue()).intValue())) {
            axesdefinition.width = i;
            flag = true;
        }
        if (flag && this.modelView.bShowAxes) {
            this.modelView.repaint();
            this.dirty = true;
        }
    }

    private Container createDialogButtons() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.anchor = 22;
        gridbagconstraints.fill = 2;
        gridbagconstraints.weightx = 5.0;
        jpanel.add((Component)new JPanel(), gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.insets = new Insets(0, 2, 0, 2);
        JButton jbutton = new JButton("Redraw");
        jpanel.add((Component)jbutton, gridbagconstraints);
        jbutton.setMnemonic('R');
        JButton jbutton1 = new JButton("Close");
        jpanel.add((Component)jbutton1, gridbagconstraints);
        jbutton1.setMnemonic('C');
        jbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                if (OptionsDialog.this.jtpMain.getSelectedIndex() == 0) {
                    OptionsDialog.this.setGlobalFields();
                } else if (OptionsDialog.this.jtpMain.getSelectedIndex() == 1) {
                    OptionsDialog.this.setFunctionFields();
                    OptionsDialog.this.textFuncDef.requestFocus();
                } else {
                    OptionsDialog.this.setAxisFields();
                }
            }
        });
        jbutton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                if (OptionsDialog.this.jtpMain.getSelectedIndex() == 0) {
                    OptionsDialog.this.setGlobalFields();
                } else if (OptionsDialog.this.jtpMain.getSelectedIndex() == 1) {
                    OptionsDialog.this.setFunctionFields();
                } else {
                    OptionsDialog.this.setAxisFields();
                }
                OptionsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jbutton1);
        jpanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, jbutton1.getHeight()));
        return jpanel;
    }

    public void reLoadAll() {
        this.lastFunction = null;
        this.comboFunction.removeAllItems();
        for (int i = 0; i < this.functions.size(); ++i) {
            this.comboFunction.addItem(this.functions.getFunction(i));
        }
        this.lastFunction = this.functions.getFunction(0);
        this.getFunctionFields();
        this.getGlobalFields();
        this.getAxisFields();
    }

    public OptionsDialog(Frame frame, ModelView modelview) {
        super("Functions Editor");
        this.parentFrame = frame;
        this.modelView = modelview;
        this.functions = modelview.functions;
        this.jtpMain = new JTabbedPane();
        this.jtpMain.add("Global", this.createGlobalPane());
        this.jtpMain.add("Functions", this.createFunctionsPane());
        this.jtpMain.add("Axes", this.createAxisPane());
        this.jtpMain.setSelectedIndex(1);
        this.jtpMain.addChangeListener(new ChangeListener(){
            int nLastIndex = 1;

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                if (this.nLastIndex == 0) {
                    OptionsDialog.this.setGlobalFields();
                } else if (this.nLastIndex == 1) {
                    OptionsDialog.this.setFunctionFields();
                } else {
                    OptionsDialog.this.setAxisFields();
                }
                this.nLastIndex = OptionsDialog.this.jtpMain.getSelectedIndex();
            }
        });
        Box box = new Box(1);
        box.add(this.jtpMain);
        box.add(Box.createVerticalStrut(3));
        box.add(this.createDialogButtons());
        this.getContentPane().add(box);
        this.setSize(500, 300);
        this.setLocationRelativeTo(null);
        this.reLoadAll();
    }
}

