/*
 * Decompiled with CFR 0.152.
 */
package jplot3d.draw;

import java.awt.Graphics;
import jplot3d.JSurface;

public class DrawContour {
    public static final void run(JSurface sf) {
        float zx;
        float zi;
        boolean printing = sf.printing;
        boolean plotfunc1 = sf.plotfunc1;
        boolean plotfunc2 = sf.plotfunc2;
        sf.accumulator.clearAccumulator();
        try {
            zi = sf.model.getZMin();
            zx = sf.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("plotContour:Error in ranges");
            return;
        }
        sf.zmin = zi;
        sf.zmax = zx;
        sf.computePlotArea();
        int plot_density = sf.model.getDispDivisions();
        int multiple_factor = sf.calc_divisions / plot_density;
        Thread.yield();
        sf.contour_stepz = (zx - zi) / (float)(sf.contour_lines + 1);
        if (!printing) {
            sf.graphics.setColor(sf.getSurfaceColor().getBackgroundColor());
            sf.graphics.fillRect(0, 0, sf.getBounds().width, sf.getBounds().height);
        }
        if (plotfunc1 || plotfunc2) {
            int index = 0;
            int func = 0;
            if (!plotfunc1) {
                func = 1;
            }
            sf.curve = func + 1;
            int delta = (sf.calc_divisions + 1) * multiple_factor;
            for (int i = 0; i < sf.calc_divisions; i += multiple_factor) {
                index = i * (sf.calc_divisions + 1);
                for (int j = 0; j < sf.calc_divisions; j += multiple_factor) {
                    sf.contour_vertex[0] = sf.vertex[func][index];
                    sf.contour_vertex[1] = sf.vertex[func][index + multiple_factor];
                    sf.contour_vertex[2] = sf.vertex[func][index + delta + multiple_factor];
                    sf.contour_vertex[3] = sf.vertex[func][index + delta];
                    sf.createContour();
                    index += multiple_factor;
                }
            }
        }
        sf.graphics.setColor(sf.getSurfaceColor().getLineColor());
        sf.accumulator.drawAll((Graphics)sf.graphics);
        sf.drawBoundingRect();
    }
}

