/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import hep.aida.ref.histogram.Histogram2D;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import jhplot.F2D;
import jhplot.H2D;
import jhplot.JHPlot;
import jhplot.P2D;
import jhplot.P3D;
import jplot3d.ColorModelSet;
import jplot3d.JPoint;
import jplot3d.NumUtil;
import jplot3d.Projector;
import jplot3d.SurfaceColor;
import jplot3d.SurfaceModel;
import jplot3d.SurfaceVertex;

public class SurfaceModelCanvas
implements SurfaceModel {
    public final String X_MIN_PROPERTY = "XMin";
    public final String Y_MIN_PROPERTY = "YMin";
    public final String Z_MIN_PROPERTY = "ZMin";
    public final String X_MAX_PROPERTY = "XMax";
    public final String Y_MAX_PROPERTY = "YMax";
    public final String Z_MAX_PROPERTY = "ZMax";
    public final String EXPECT_DELAY_PROPERTY = "ExpectDelay";
    public final String BOXED_PROPERTY = "Boxed";
    public final String MESH_PROPERTY = "Mesh";
    public final String SCALE_BOX_PROPERTY = "ScaleBox";
    public final String DISPLAY_Z_PROPERTY = "DisplayZ";
    public final String DISPLAY_GRIDS_PROPERTY = "DisplayGrids";
    public final String PLOT_FUNCTION_1_PROPERTY = "PlotFunction1";
    public final String PLOT_FUNCTION_2_PROPERTY = "PlotFunction2";
    public final String DATA_AVAILABLE_PROPERTY = "DataAvailable";
    public final String DISPLAY_X_Y_PROPERTY = "DisplayXY";
    public final String CALC_DIVISIONS_PROPERTY = "CalcDivisions";
    public final String CONTOUR_LINES_PROPERTY = "ContourLines";
    public final String DISP_DIVISIONS_PROPERTY = "DispDivisions";
    public final String SURFACE_VERTEX_PROPERTY = "SurfaceVertex";
    public final String AUTO_SCALE_Z_PROPERTY = "AutoScaleZ";
    public final String PLOT_TYPE_PROPERTY = "PlotType";
    public final String PLOT_COLOR_PROPERTY = "PlotColor";
    public final String COLOR_MODEL_PROPERTY = "ColorModel";
    private float p_distance = 70.0f;
    private float p_scaling = 15.0f;
    private float p_rotation = 125.0f;
    private float p_elevation = 10.0f;
    private boolean m_isP2D = false;
    private boolean m_isP3D = false;
    private boolean isempty = false;
    private JPoint[] jpoint;
    private PlotterImpl plotter;
    private boolean ish2f2 = false;
    private boolean m_AutoXY;
    private float m_LabelOffsetX;
    private float m_LabelOffsetY;
    private float m_LabelOffsetZ;
    private Color m_AxesFontColor;
    private Color m_FontColorLabel;
    private float m_PenWidth;
    private String m_Xlabel;
    private String m_Ylabel;
    private String m_Zlabel;
    private Font m_LabelFont;
    private Font m_AxisFont;
    private Color m_LabelColor;
    private Font m_TicFont;
    private float m_TicOffset;
    private float m_FrameScale = 1.0f;
    private float init_scaling = 10.0f;
    protected PropertyChangeSupport property;
    private final int INIT_CALC_DIV = 20;
    private final int INIT_DISP_DIV = 20;
    protected boolean autoScaleZ = true;
    protected SurfaceModel.PlotType plotType = SurfaceModel.PlotType.SURFACE;
    protected SurfaceModel.PlotColor plotColor;
    protected SurfaceVertex[][] vertex;
    Projector projector;
    protected int calcDivisions = 20;
    protected int contourLines;
    protected int dispDivisions = 20;
    protected float xMin;
    protected float yMin;
    protected float zMin;
    protected float xMax;
    protected float yMax;
    protected float z1Max;
    protected float z1Min;
    protected float z2Max;
    protected float z2Min;
    protected float zMax;
    public ColorModelSet colorModel;
    protected boolean expectDelay = false;
    protected boolean boxed;
    protected boolean mesh;
    protected boolean scaleBox;
    protected boolean displayXY;
    protected boolean displayZ;
    protected boolean displayGrids;
    protected boolean hasFunction1;
    protected boolean plotFunction1 = this.hasFunction1 = true;
    protected boolean hasFunction2;
    protected boolean plotFunction2 = this.hasFunction2 = true;
    protected boolean dataAvailable;
    EventListenerList listenerList = new EventListenerList();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.property.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.property.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.property.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.property.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public boolean isAutoScaleZ() {
        return this.autoScaleZ;
    }

    public void setAutoScaleZ(boolean v) {
        boolean o = this.autoScaleZ;
        this.autoScaleZ = v;
        this.autoScale();
        this.property.firePropertyChange("AutoScaleZ", o, v);
    }

    public void toggleAutoScaleZ() {
        this.setAutoScaleZ(!this.isAutoScaleZ());
    }

    public void autoScale() {
        if (!this.autoScaleZ) {
            return;
        }
        if (this.plotFunction1 && this.plotFunction2) {
            this.setZMin(Math.min(this.z1Min, this.z2Min));
            this.setZMax(Math.max(this.z1Max, this.z2Max));
        } else {
            if (this.plotFunction1) {
                this.setZMin(this.z1Min);
                this.setZMax(this.z1Max);
            }
            if (this.plotFunction2) {
                this.setZMin(this.z2Min);
                this.setZMax(this.z2Max);
            }
        }
    }

    @Override
    public SurfaceModel.PlotType getPlotType() {
        return this.plotType;
    }

    public void setPlotType(SurfaceModel.PlotType v) {
        SurfaceModel.PlotType o = this.plotType;
        this.plotType = v;
        if (this.colorModel != null) {
            this.colorModel.setPlotType(this.plotType);
        }
        this.property.firePropertyChange("PlotType", (Object)o, (Object)v);
        this.fireAllType(o, v);
    }

    @Override
    public SurfaceModel.PlotColor getPlotColor() {
        return this.plotColor;
    }

    public void setPlotColor(SurfaceModel.PlotColor v) {
        SurfaceModel.PlotColor o = this.plotColor;
        this.plotColor = v;
        if (this.colorModel != null) {
            this.colorModel.setPlotColor(this.plotColor);
        }
        this.property.firePropertyChange("PlotColor", (Object)o, (Object)v);
        this.fireAllMode(o, v);
    }

    private void fireAllMode(SurfaceModel.PlotColor oldValue, SurfaceModel.PlotColor newValue) {
        for (SurfaceModel.PlotColor c : SurfaceModel.PlotColor.values()) {
            this.property.firePropertyChange(c.getPropertyName(), oldValue == c, newValue == c);
        }
    }

    private void fireAllType(SurfaceModel.PlotType oldValue, SurfaceModel.PlotType newValue) {
        for (SurfaceModel.PlotType c : SurfaceModel.PlotType.values()) {
            this.property.firePropertyChange(c.getPropertyName(), oldValue == c, newValue == c);
        }
    }

    private void fireAllFunction(boolean oldHas1, boolean oldHas2) {
        this.property.firePropertyChange("FirstFunctionOnly", !oldHas2 && oldHas1, !this.plotFunction2 && this.plotFunction1);
        this.property.firePropertyChange("SecondFunctionOnly", !oldHas1 && oldHas2, !this.plotFunction1 && this.plotFunction2);
        this.property.firePropertyChange("BothFunction", oldHas1 && oldHas2, this.plotFunction1 && this.plotFunction2);
        this.autoScale();
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isHiddenMode() {
        return this.plotColor == SurfaceModel.PlotColor.OPAQUE;
    }

    public void setHiddenMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.OPAQUE : SurfaceModel.PlotColor.SPECTRUM);
    }

    public boolean isSpectrumMode() {
        return this.plotColor == SurfaceModel.PlotColor.SPECTRUM;
    }

    public void setSpectrumMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.SPECTRUM : SurfaceModel.PlotColor.GRAYSCALE);
    }

    public boolean isGrayScaleMode() {
        return this.plotColor == SurfaceModel.PlotColor.GRAYSCALE;
    }

    public void setGrayScaleMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.GRAYSCALE : SurfaceModel.PlotColor.SPECTRUM);
    }

    public boolean isDualShadeMode() {
        return this.plotColor == SurfaceModel.PlotColor.DUALSHADE;
    }

    public void setDualShadeMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.DUALSHADE : SurfaceModel.PlotColor.SPECTRUM);
    }

    public boolean isFogMode() {
        return this.plotColor == SurfaceModel.PlotColor.FOG;
    }

    public void setFogMode(boolean val) {
        this.setPlotColor(val ? SurfaceModel.PlotColor.FOG : SurfaceModel.PlotColor.SPECTRUM);
    }

    public boolean isWireframeType() {
        return this.plotType == SurfaceModel.PlotType.WIREFRAME;
    }

    public void setWireframeType(boolean val) {
        if (val) {
            this.setPlotType(SurfaceModel.PlotType.WIREFRAME);
        } else {
            this.setPlotType(SurfaceModel.PlotType.SURFACE);
        }
    }

    public boolean isSurfaceType() {
        return this.plotType == SurfaceModel.PlotType.SURFACE;
    }

    public void setSurfaceType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.SURFACE : SurfaceModel.PlotType.WIREFRAME);
    }

    public boolean isContourType() {
        return this.plotType == SurfaceModel.PlotType.CONTOUR;
    }

    public void setContourType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.CONTOUR : SurfaceModel.PlotType.SURFACE);
    }

    public boolean isDensityType() {
        return this.plotType == SurfaceModel.PlotType.DENSITY;
    }

    public void setDensityType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.DENSITY : SurfaceModel.PlotType.SURFACE);
    }

    public boolean isBarsType() {
        return this.plotType == SurfaceModel.PlotType.BARS;
    }

    public void setBarsType(boolean val) {
        this.setPlotType(val ? SurfaceModel.PlotType.BARS : SurfaceModel.PlotType.SURFACE);
    }

    public boolean isFirstFunctionOnly() {
        return this.plotFunction1 && !this.plotFunction2;
    }

    public void setFirstFunctionOnly(boolean val) {
        this.setPlotFunction12(val, !val);
    }

    public boolean isSecondFunctionOnly() {
        return !this.plotFunction1 && this.plotFunction2;
    }

    public void setSecondFunctionOnly(boolean val) {
        this.setPlotFunction12(!val, val);
    }

    public boolean isBothFunction() {
        return this.plotFunction1 && this.plotFunction2;
    }

    public void setBothFunction(boolean val) {
        this.setPlotFunction12(val, val);
    }

    @Override
    public SurfaceVertex[][] getSurfaceVertex() {
        return this.vertex;
    }

    public void setSurfaceVertex(SurfaceVertex[][] v) {
        SurfaceVertex[][] o = this.vertex;
        this.vertex = v;
        this.property.firePropertyChange("SurfaceVertex", o, v);
    }

    @Override
    public Projector getProjector() {
        if (this.projector == null) {
            this.projector = new Projector();
            this.projector.setDistance(this.p_distance);
            this.projector.set2DScaling(this.p_scaling);
            this.projector.setRotationAngle(this.p_rotation);
            this.projector.setElevationAngle(this.p_elevation);
        }
        return this.projector;
    }

    public void setDistance(float d) {
        this.p_distance = d;
        if (this.projector != null) {
            this.projector.setDistance(d);
        }
    }

    public void set2DScaling(float d) {
        this.p_scaling = d;
        if (this.projector != null) {
            this.projector.set2DScaling(d);
        }
    }

    public void setRotationAngle(float d) {
        this.p_rotation = d;
        if (this.projector != null) {
            this.projector.setRotationAngle(d);
        }
    }

    public void setElevationAngle(float d) {
        this.p_elevation = d;
        if (this.projector != null) {
            this.projector.setElevationAngle(d);
        }
    }

    public float getDistance() {
        if (this.projector == null) {
            return this.p_distance;
        }
        return this.projector.getDistance();
    }

    public float get2DScaling() {
        if (this.projector == null) {
            return this.p_scaling;
        }
        return this.projector.get2DScaling();
    }

    public float getRotationAngle() {
        if (this.projector == null) {
            return this.p_rotation;
        }
        return this.projector.getRotationAngle();
    }

    public float getElevationAngle() {
        if (this.projector == null) {
            return this.p_elevation;
        }
        return this.projector.getElevationAngle();
    }

    @Override
    public int getCalcDivisions() {
        return this.calcDivisions;
    }

    public void setCalcDivisions(int v) {
        int o = this.calcDivisions;
        this.calcDivisions = v;
        this.property.firePropertyChange("CalcDivisions", o, v);
    }

    @Override
    public int getContourLines() {
        return this.contourLines;
    }

    public void setContourLines(int v) {
        int o = this.contourLines;
        this.contourLines = v;
        this.property.firePropertyChange("ContourLines", o, v);
    }

    public void setDispDivisions(int v) {
        int o = this.dispDivisions;
        this.dispDivisions = v;
        this.property.firePropertyChange("DispDivisions", o, v);
    }

    @Override
    public int getDispDivisions() {
        if (this.dispDivisions > this.calcDivisions) {
            this.dispDivisions = this.calcDivisions;
        }
        while (this.calcDivisions % this.dispDivisions != 0) {
            ++this.dispDivisions;
        }
        return this.dispDivisions;
    }

    @Override
    public float getXMin() {
        return this.xMin;
    }

    public void setXMin(float v) {
        float o = this.xMin;
        this.xMin = v;
        this.property.firePropertyChange("XMin", new Float(o), new Float(v));
    }

    @Override
    public float getYMin() {
        return this.yMin;
    }

    public void setYMin(float v) {
        float o = this.yMin;
        this.yMin = v;
        this.property.firePropertyChange("YMin", new Float(o), new Float(v));
    }

    @Override
    public float getZMin() {
        return this.zMin;
    }

    public void setZMin(float v) {
        if (v >= this.zMax) {
            return;
        }
        float o = this.zMin;
        this.zMin = v;
        this.property.firePropertyChange("ZMin", new Float(o), new Float(v));
    }

    @Override
    public float getXMax() {
        return this.xMax;
    }

    public void setXMax(float v) {
        float o = this.xMax;
        this.xMax = v;
        this.property.firePropertyChange("XMax", new Float(o), new Float(v));
    }

    @Override
    public float getYMax() {
        return this.yMax;
    }

    public void setYMax(float v) {
        float o = this.yMax;
        this.yMax = v;
        this.property.firePropertyChange("YMax", new Float(o), new Float(v));
    }

    @Override
    public float getZMax() {
        return this.zMax;
    }

    public void setZMax(float v) {
        if (v <= this.zMin) {
            return;
        }
        float o = this.zMax;
        this.zMax = v;
        this.property.firePropertyChange("ZMax", new Float(o), new Float(v));
    }

    public SurfaceModelCanvas() {
        this.property = new SwingPropertyChangeSupport(this);
        this.setColorModel(new ColorModelSet());
    }

    @Override
    public SurfaceColor getColorModel() {
        return this.colorModel;
    }

    protected void setColorModel(ColorModelSet v) {
        ColorModelSet o = this.colorModel;
        this.colorModel = v;
        if (this.colorModel != null) {
            this.colorModel.setPlotColor(this.plotColor);
        }
        if (this.colorModel != null) {
            this.colorModel.setPlotType(this.plotType);
        }
        this.property.firePropertyChange("ColorModel", o, v);
    }

    public void setMessage(String text) {
    }

    public void rotationStarts() {
    }

    public void rotationStops() {
    }

    public void exportCSV(File file) throws IOException {
        float yx;
        float xx;
        float yi;
        float xi;
        if (file == null) {
            return;
        }
        FileWriter w = new FileWriter(file);
        boolean f1 = true;
        boolean f2 = true;
        Object pixels = null;
        boolean imgwidth = false;
        boolean imgheight = false;
        try {
            xi = this.getXMin();
            yi = this.getYMin();
            xx = this.getXMax();
            yx = this.getYMax();
            if (xi >= xx || yi >= yx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.setMessage("Error in ranges");
            return;
        }
        this.calcDivisions = this.getCalcDivisions();
        float stepx = (xx - xi) / (float)this.calcDivisions;
        float stepy = (yx - yi) / (float)this.calcDivisions;
        int total = (this.calcDivisions + 1) * (this.calcDivisions + 1);
        if (this.vertex == null) {
            return;
        }
        float max = Float.NaN;
        float min = Float.NaN;
        int i = 0;
        int j = 0;
        int k = 0;
        float x = xi;
        float y = yi;
        float xfactor = 20.0f / (xx - xi);
        float yfactor = 20.0f / (yx - yi);
        w.write("X\\Y->Z;");
        while (j <= this.calcDivisions) {
            w.write(Float.toString(y));
            if (j != this.calcDivisions) {
                w.write(59);
            }
            ++j;
            y += stepy;
            ++k;
        }
        w.write("\n");
        i = 0;
        j = 0;
        k = 0;
        x = xi;
        y = yi;
        while (i <= this.calcDivisions) {
            w.write(Float.toString(x));
            w.write(59);
            while (j <= this.calcDivisions) {
                w.write(Float.toString(this.vertex[0][k].z));
                if (j != this.calcDivisions) {
                    w.write(59);
                }
                ++j;
                y += stepy;
                ++k;
            }
            w.write(10);
            j = 0;
            y = yi;
            ++i;
            x += stepx;
        }
        w.flush();
        w.close();
    }

    public Plotter newPlotter(int calcDivisions) {
        this.setCalcDivisions(calcDivisions);
        this.plotter = new PlotterImpl();
        return this.plotter;
    }

    @Override
    public PlotterImpl getPlotter() {
        return this.plotter;
    }

    @Override
    public JPoint[] getJPoints() {
        return this.jpoint;
    }

    public synchronized double floor(double d, int digits) {
        if (d == 0.0) {
            return d;
        }
        long og = (long)Math.ceil(Math.log(Math.abs(d)) / Math.log(10.0));
        double factor = Math.pow(10.0, (long)digits - og);
        double res = Math.floor(d * factor) / factor;
        return res;
    }

    public synchronized double ceil(double d, int digits) {
        if (d == 0.0) {
            return d;
        }
        long og = (long)Math.ceil(Math.log(Math.abs(d)) / Math.log(10.0));
        double factor = Math.pow(10.0, (long)digits - og);
        double res = Math.ceil(d * factor) / factor;
        return res;
    }

    @Override
    public boolean isExpectDelay() {
        return this.expectDelay;
    }

    public void setExpectDelay(boolean v) {
        boolean o = this.expectDelay;
        this.expectDelay = v;
        this.property.firePropertyChange("ExpectDelay", o, v);
    }

    public void toggleExpectDelay() {
        this.setExpectDelay(!this.isExpectDelay());
    }

    @Override
    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean v) {
        boolean o = this.boxed;
        this.boxed = v;
        this.property.firePropertyChange("Boxed", o, v);
    }

    public void toggleBoxed() {
        this.setBoxed(!this.isBoxed());
    }

    @Override
    public boolean isMesh() {
        return this.mesh;
    }

    public void setMesh(boolean v) {
        boolean o = this.mesh;
        this.mesh = v;
        this.property.firePropertyChange("Mesh", o, v);
    }

    public void toggleMesh() {
        this.setMesh(!this.isMesh());
    }

    @Override
    public boolean isScaleBox() {
        return this.scaleBox;
    }

    public void setScaleBox(boolean v) {
        boolean o = this.scaleBox;
        this.scaleBox = v;
        this.property.firePropertyChange("ScaleBox", o, v);
    }

    public void toggleScaleBox() {
        this.setScaleBox(!this.isScaleBox());
    }

    @Override
    public boolean isDisplayXY() {
        return this.displayXY;
    }

    public void setDisplayXY(boolean v) {
        boolean o = this.displayXY;
        this.displayXY = v;
        this.property.firePropertyChange("DisplayXY", o, v);
    }

    public boolean getDisplayXY() {
        return this.displayXY;
    }

    public boolean getDisplayZ() {
        return this.displayZ;
    }

    public void toggleDisplayXY() {
        this.setDisplayXY(!this.isDisplayXY());
    }

    @Override
    public boolean isDisplayZ() {
        return this.displayZ;
    }

    public void setDisplayZ(boolean v) {
        boolean o = this.displayZ;
        this.displayZ = v;
        this.property.firePropertyChange("DisplayZ", o, v);
    }

    public void toggleDisplayZ() {
        this.setDisplayZ(!this.isDisplayZ());
    }

    @Override
    public boolean isDisplayGrids() {
        return this.displayGrids;
    }

    public void setDisplayGrids(boolean v) {
        boolean o = this.displayGrids;
        this.displayGrids = v;
        this.property.firePropertyChange("DisplayGrids", o, v);
    }

    public void toggleDisplayGrids() {
        this.setDisplayGrids(!this.isDisplayGrids());
    }

    @Override
    public boolean isPlotFunction1() {
        return this.plotFunction1;
    }

    public void setPlotFunction1(boolean v) {
        boolean o = this.plotFunction1;
        this.plotFunction1 = this.hasFunction1 && v;
        this.property.firePropertyChange("PlotFunction1", o, v);
        this.fireAllFunction(o, this.plotFunction2);
    }

    public void setPlotFunction12(boolean p1, boolean p2) {
        boolean o1 = this.plotFunction1;
        boolean o2 = this.plotFunction2;
        this.plotFunction1 = this.hasFunction1 && p1;
        this.property.firePropertyChange("PlotFunction1", o1, p1);
        this.plotFunction2 = this.hasFunction2 && p2;
        this.property.firePropertyChange("PlotFunction2", o2, p2);
        this.fireAllFunction(o1, o2);
    }

    public void togglePlotFunction1() {
        this.setPlotFunction1(!this.isPlotFunction1());
    }

    public void togglePlotFunction2() {
        this.setPlotFunction2(!this.isPlotFunction2());
    }

    @Override
    public boolean isPlotFunction2() {
        return this.plotFunction2;
    }

    public void setPlotFunction2(boolean v) {
        boolean o = this.plotFunction2;
        this.plotFunction2 = this.hasFunction2 && v;
        this.property.firePropertyChange("PlotFunction2", o, v);
        this.fireAllFunction(this.plotFunction1, o);
    }

    @Override
    public boolean isP2D() {
        return this.m_isP2D;
    }

    @Override
    public boolean isP3D() {
        return this.m_isP3D;
    }

    private SurfaceVertex[][] allocateMemory(boolean f1, boolean f2, int total) {
        SurfaceVertex[][] vertex = null;
        try {
            vertex = new SurfaceVertex[2][total];
            if (!f1) {
                vertex[0] = null;
            }
            if (!f2) {
                vertex[1] = null;
            }
        }
        catch (OutOfMemoryError e) {
            this.setMessage("Not enough memory");
        }
        catch (Exception e) {
            this.setMessage("Error: " + e.toString());
        }
        return vertex;
    }

    @Override
    public boolean isDataAvailable() {
        return this.dataAvailable;
    }

    private void setDataAvailable(boolean v) {
        boolean o = this.dataAvailable;
        this.dataAvailable = v;
        this.property.firePropertyChange("DataAvailable", o, v);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    @Override
    public void addChangeListener(ChangeListener ol) {
        this.listenerList.add(ChangeListener.class, ol);
    }

    @Override
    public void removeChangeListener(ChangeListener ol) {
        this.listenerList.remove(ChangeListener.class, ol);
    }

    @Override
    public boolean isH2F2() {
        return this.ish2f2;
    }

    @Override
    public void setLabelOffsetX(float a) {
        this.m_LabelOffsetX = a;
    }

    @Override
    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    @Override
    public void setLabelOffsetZ(float a) {
        this.m_LabelOffsetZ = a;
    }

    @Override
    public void setLabelOffsetY(float a) {
        this.m_LabelOffsetY = a;
    }

    @Override
    public void setTicOffset(float a) {
        this.m_TicOffset = a;
    }

    @Override
    public float getTicOffset() {
        return this.m_TicOffset;
    }

    @Override
    public void setAxesFontColor(Color fontColorAxes) {
        this.m_AxesFontColor = fontColorAxes;
    }

    @Override
    public Color getAxesFontColor() {
        return this.m_AxesFontColor;
    }

    @Override
    public void setFontColorLabel(Color fontColorLabel) {
        this.m_FontColorLabel = fontColorLabel;
    }

    @Override
    public Color getFontColorLabel() {
        return this.m_FontColorLabel;
    }

    @Override
    public double getLabelOffsetX() {
        return this.m_LabelOffsetX;
    }

    @Override
    public double getLabelOffsetY() {
        return this.m_LabelOffsetY;
    }

    @Override
    public double getLabelOffsetZ() {
        return this.m_LabelOffsetZ;
    }

    @Override
    public void setPenWidth(float w) {
        this.m_PenWidth = w;
    }

    @Override
    public float getPenWidth() {
        return this.m_PenWidth;
    }

    @Override
    public void setXlabel(String a) {
        this.m_Xlabel = a;
    }

    @Override
    public void setYlabel(String a) {
        this.m_Ylabel = a;
    }

    @Override
    public void setZlabel(String a) {
        this.m_Zlabel = a;
    }

    @Override
    public void setLabelFont(Font a) {
        this.m_LabelFont = a;
    }

    @Override
    public void setAxisFont(Font fontAxis) {
        this.m_AxisFont = fontAxis;
    }

    @Override
    public Font getAxisFont() {
        return this.m_AxisFont;
    }

    @Override
    public void setLabelColor(Color a) {
        this.m_LabelColor = a;
    }

    @Override
    public void setTicFont(Font a) {
        this.m_TicFont = a;
    }

    @Override
    public Font getTicFont() {
        return this.m_TicFont;
    }

    @Override
    public Color getLabelColor() {
        return this.m_LabelColor;
    }

    @Override
    public float getFrameScale() {
        return this.m_FrameScale;
    }

    @Override
    public void setFrameScale(float a) {
        this.m_FrameScale = a;
    }

    @Override
    public String getXlabel() {
        return this.m_Xlabel;
    }

    @Override
    public String getYlabel() {
        return this.m_Ylabel;
    }

    @Override
    public String getZlabel() {
        return this.m_Zlabel;
    }

    @Override
    public void setInitScaling(float scaling) {
        this.init_scaling = scaling;
    }

    @Override
    public float getInitScaling() {
        return this.init_scaling;
    }

    public void setAutoScaleXY(boolean b) {
        this.m_AutoXY = b;
    }

    public boolean getAutoScaleXY() {
        return this.m_AutoXY;
    }

    static /* synthetic */ JPoint[] access$702(SurfaceModelCanvas x0, JPoint[] x1) {
        x0.jpoint = x1;
        return x1;
    }

    public class PlotterImpl
    implements Plotter {
        float stepx;
        float stepy;
        float xi;
        float xx;
        float yi;
        float yx;
        float v;
        float x;
        float y;
        float min1;
        float max1;
        float min2;
        float max2;
        boolean f1;
        boolean f2;
        int i;
        int j;
        int k;
        int total;
        private float[][] pointsX;
        private float[][] pointsY;
        private float[][] pointsZ;
        int[] pixels = null;
        int imgwidth = 0;
        int imgheight = 0;
        float xfactor;
        float yfactor;
        float zfactor;
        int calcDivisions;

        @Override
        public float getFactorX() {
            return this.xfactor;
        }

        @Override
        public float getFactorY() {
            return this.yfactor;
        }

        @Override
        public float getFactorZ() {
            return this.zfactor;
        }

        @Override
        public float getStepX() {
            return this.stepx;
        }

        @Override
        public float getStepY() {
            return this.stepy;
        }

        @Override
        public float[][] getPointsX() {
            return this.pointsX;
        }

        @Override
        public float[][] getPointsY() {
            return this.pointsY;
        }

        @Override
        public float[][] getPointsZ() {
            return this.pointsZ;
        }

        @Override
        public void setH2DF2D(ArrayList<H2D> hu, ArrayList<F2D> fu) {
            this.max2 = Float.NaN;
            this.min2 = Float.NaN;
            this.max1 = Float.NaN;
            this.min1 = Float.NaN;
            this.f1 = false;
            this.f2 = false;
            SurfaceModelCanvas.this.m_isP2D = false;
            SurfaceModelCanvas.this.m_isP3D = false;
            SurfaceModelCanvas.this.ish2f2 = true;
            SurfaceModelCanvas.this.setDataAvailable(false);
            SurfaceModelCanvas.this.setBarsType(false);
            this.f1 = false;
            this.f2 = false;
            Histogram2D h1 = null;
            F2D h2 = null;
            if (hu.size() > 0) {
                this.f1 = true;
                h1 = hu.get(0).get();
            }
            if (fu.size() > 0 && hu.size() > 0) {
                this.f2 = true;
                this.f1 = true;
                h1 = hu.get(0).get();
                h2 = fu.get(0);
            }
            if (SurfaceModelCanvas.this.isBarsType()) {
                this.f2 = false;
            }
            SurfaceModelCanvas.this.hasFunction1 = this.f1;
            SurfaceModelCanvas.this.hasFunction2 = this.f2;
            int calc_divisionsX = 1;
            int calc_divisionsY = 1;
            SurfaceModelCanvas.this.getProjector();
            if (this.f1) {
                int BinX = h1.xAxis().bins();
                int BinY = h1.yAxis().bins();
                double hight = h1.maxBinHeight();
                this.min1 = 0.0f;
                this.max1 = (float)NumUtil.roundUp(hight * 1.2);
                this.xi = (float)h1.xAxis().lowerEdge();
                this.yi = (float)h1.yAxis().lowerEdge();
                this.xx = (float)h1.xAxis().upperEdge();
                this.yx = (float)h1.yAxis().upperEdge();
                if (this.xi >= this.xx || this.yi >= this.yx) {
                    throw new NumberFormatException();
                }
                if (BinX != BinY && !SurfaceModelCanvas.this.isBarsType()) {
                    if (BinX > BinY) {
                        BinX = BinY;
                    }
                    if (BinX < BinY) {
                        BinY = BinX;
                    }
                    System.out.println("You cannot use different bins in the surface mode.\n Consider the bar mode. At this moment, \n the number of bins were set to the smallest number of bins");
                }
                SurfaceModelCanvas.this.setCalcDivisions(BinX);
                this.calcDivisions = SurfaceModelCanvas.this.getCalcDivisions();
                calc_divisionsX = BinX;
                calc_divisionsY = BinY;
                this.total = (calc_divisionsX + 1) * (calc_divisionsY + 1);
                SurfaceModelCanvas.this.vertex = SurfaceModelCanvas.this.allocateMemory(this.f1, this.f2, this.total);
                SurfaceModelCanvas.this.setSurfaceVertex(SurfaceModelCanvas.this.vertex);
                if (SurfaceModelCanvas.this.vertex == null) {
                    return;
                }
            }
            this.calcDivisions = SurfaceModelCanvas.this.getCalcDivisions();
            this.stepx = (this.xx - this.xi) / (float)calc_divisionsX;
            this.stepy = (this.yx - this.yi) / (float)calc_divisionsY;
            this.i = 0;
            this.j = 0;
            this.k = 0;
            this.x = this.xi;
            this.y = this.yi;
            this.xfactor = 20.0f / (this.xx - this.xi);
            this.yfactor = 20.0f / (this.yx - this.yi);
            this.zfactor = 20.0f / (this.max1 - this.min1);
            this.pointsX = null;
            this.pointsY = null;
            this.pointsZ = null;
            if (SurfaceModelCanvas.this.isBarsType()) {
                this.pointsX = new float[calc_divisionsX][calc_divisionsY];
                this.pointsY = new float[calc_divisionsX][calc_divisionsY];
                this.pointsZ = new float[calc_divisionsX][calc_divisionsY];
                while (this.i < calc_divisionsX) {
                    while (this.j < calc_divisionsY) {
                        if (this.f1) {
                            this.v = (float)h1.binHeight(this.i, this.j);
                            this.pointsX[this.i][this.j] = (this.x - this.xi) * this.xfactor - 10.0f;
                            this.pointsY[this.i][this.j] = (this.y - this.yi) * this.yfactor - 10.0f;
                            this.pointsZ[this.i][this.j] = this.v;
                        }
                        ++this.j;
                        this.y += this.stepy;
                        ++this.k;
                        if (this.k % 100 != 0) continue;
                        JHPlot.showMessage("Calculating : " + this.k * 100 / this.total + "% completed");
                    }
                    this.j = 0;
                    this.y = this.yi;
                    ++this.i;
                    this.x += this.stepx;
                }
            } else {
                this.i = 0;
                this.k = 0;
                this.j = 0;
                this.x = this.xi;
                this.y = this.yi;
                while (this.i <= calc_divisionsX) {
                    while (this.j <= calc_divisionsY) {
                        if (this.f1) {
                            this.v = (float)h1.binHeight(this.i, this.j);
                            if (Float.isInfinite(this.v)) {
                                this.v = Float.NaN;
                            }
                            if (!Float.isNaN(this.v)) {
                                if (Float.isNaN(this.max1) || this.v > this.max1) {
                                    this.max1 = this.v;
                                } else if (Float.isNaN(this.min1) || this.v < this.min1) {
                                    this.min1 = this.v;
                                }
                            }
                            SurfaceModelCanvas.this.vertex[0][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                        }
                        ++this.j;
                        this.y += this.stepy;
                        ++this.k;
                        if (this.k % 100 != 0 && this.k != this.total) continue;
                        JHPlot.showMessage("Calculating : " + this.k * 100 / this.total + "% completed");
                    }
                    this.j = 0;
                    this.y = this.yi;
                    ++this.i;
                    this.x += this.stepx;
                }
            }
            this.calcDivisions = calc_divisionsX;
            this.stepx = (this.xx - this.xi) / (float)calc_divisionsX;
            this.stepy = (this.yx - this.yi) / (float)calc_divisionsY;
            this.xfactor = 20.0f / (this.xx - this.xi);
            this.yfactor = 20.0f / (this.yx - this.yi);
            this.i = 0;
            this.j = 0;
            this.k = 0;
            this.x = this.xi;
            this.y = this.yi;
            while (this.i <= this.calcDivisions) {
                while (this.j <= this.calcDivisions) {
                    if (SurfaceModelCanvas.this.isBarsType()) {
                        this.v = (float)h2.eval(this.x, this.y);
                        if (Float.isInfinite(this.v)) {
                            this.v = Float.NaN;
                        }
                        if (!Float.isNaN(this.v)) {
                            if (Float.isNaN(this.max1) || this.v > this.max1) {
                                this.max1 = this.v;
                            } else if (Float.isNaN(this.min1) || this.v < this.min1) {
                                this.min1 = this.v;
                            }
                        }
                        SurfaceModelCanvas.this.vertex[0][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                    }
                    if (!SurfaceModelCanvas.this.isBarsType()) {
                        this.v = (float)h2.eval(this.x, this.y);
                        if (Float.isInfinite(this.v)) {
                            this.v = Float.NaN;
                        }
                        if (!Float.isNaN(this.v)) {
                            if (Float.isNaN(this.max2) || this.v > this.max2) {
                                this.max2 = this.v;
                            } else if (Float.isNaN(this.min2) || this.v < this.min2) {
                                this.min2 = this.v;
                            }
                        }
                        SurfaceModelCanvas.this.vertex[1][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                    }
                    ++this.j;
                    this.y += this.stepy;
                    ++this.k;
                    if (this.k % 100 != 0 && this.k != this.total) continue;
                    JHPlot.showMessage("Calculating : " + this.k * 100 / this.total + "% completed");
                }
                this.j = 0;
                this.y = this.yi;
                ++this.i;
                this.x += this.stepx;
            }
            if ((double)this.min1 < 0.2 && (double)this.min1 > -0.2) {
                DecimalFormat dfb = new DecimalFormat("#.#E00");
                String s1 = dfb.format((double)this.min1 * 0.9);
                if (this.min1 < 0.0f) {
                    s1 = dfb.format((double)this.min1 * 1.1);
                }
                this.min1 = (float)Double.valueOf(s1.trim()).doubleValue();
            } else {
                if (this.min1 > 0.0f) {
                    this.min1 = (float)NumUtil.roundUp(this.min1);
                }
                if (this.min1 < 0.0f) {
                    this.min1 = -1.0f * (float)NumUtil.roundUp(-1.0 * (double)this.min1);
                }
            }
            this.max1 = (float)NumUtil.roundUp((double)this.max1 * 1.2);
            SurfaceModelCanvas.this.setXMin(this.xi);
            SurfaceModelCanvas.this.setXMax(this.xx);
            SurfaceModelCanvas.this.setYMin(this.yi);
            SurfaceModelCanvas.this.setYMax(this.yx);
            SurfaceModelCanvas.this.setZMin(this.min1);
            SurfaceModelCanvas.this.setZMax(this.max1);
            SurfaceModelCanvas.this.setDataAvailable(true);
            SurfaceModelCanvas.this.autoScale();
            SurfaceModelCanvas.this.fireStateChanged();
        }

        @Override
        public void setF2D(ArrayList<F2D> fu) {
            this.max2 = Float.NaN;
            this.min2 = Float.NaN;
            this.max1 = Float.NaN;
            this.min1 = Float.NaN;
            this.calcDivisions = SurfaceModelCanvas.this.getCalcDivisions();
            SurfaceModelCanvas.this.setDataAvailable(false);
            this.total = (this.calcDivisions + 1) * (this.calcDivisions + 1);
            this.f1 = false;
            this.f2 = false;
            F2D fu1 = null;
            F2D fu2 = null;
            if (fu.size() == 1) {
                this.f1 = true;
                fu1 = fu.get(0);
            }
            if (fu.size() == 2) {
                this.f2 = true;
                this.f1 = true;
                fu1 = fu.get(0);
                fu2 = fu.get(1);
            }
            SurfaceModelCanvas.this.hasFunction1 = this.f1;
            SurfaceModelCanvas.this.hasFunction2 = this.f2;
            if (SurfaceModelCanvas.this.m_AutoXY) {
                SurfaceModelCanvas.this.setXMin((float)fu1.getMinX());
                SurfaceModelCanvas.this.setXMax((float)fu1.getMaxX());
                SurfaceModelCanvas.this.setYMin((float)fu1.getMinY());
                SurfaceModelCanvas.this.setYMax((float)fu1.getMaxY());
            }
            SurfaceModelCanvas.this.vertex = SurfaceModelCanvas.this.allocateMemory(this.f1, this.f2, this.total);
            SurfaceModelCanvas.this.setSurfaceVertex(SurfaceModelCanvas.this.vertex);
            SurfaceModelCanvas.this.getProjector();
            try {
                this.xi = SurfaceModelCanvas.this.getXMin();
                this.yi = SurfaceModelCanvas.this.getYMin();
                this.xx = SurfaceModelCanvas.this.getXMax();
                this.yx = SurfaceModelCanvas.this.getYMax();
                if (this.xi >= this.xx || this.yi >= this.yx) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                SurfaceModelCanvas.this.setMessage("Error in ranges");
                return;
            }
            this.stepx = (this.xx - this.xi) / (float)this.calcDivisions;
            this.stepy = (this.yx - this.yi) / (float)this.calcDivisions;
            this.xfactor = 20.0f / (this.xx - this.xi);
            this.yfactor = 20.0f / (this.yx - this.yi);
            this.i = 0;
            this.j = 0;
            this.k = 0;
            this.x = this.xi;
            this.y = this.yi;
            while (this.i <= this.calcDivisions) {
                while (this.j <= this.calcDivisions) {
                    if (this.f1) {
                        this.v = (float)fu1.eval(this.x, this.y);
                        if (Float.isInfinite(this.v)) {
                            this.v = Float.NaN;
                        }
                        if (!Float.isNaN(this.v)) {
                            if (Float.isNaN(this.max1) || this.v > this.max1) {
                                this.max1 = this.v;
                            } else if (Float.isNaN(this.min1) || this.v < this.min1) {
                                this.min1 = this.v;
                            }
                        }
                        SurfaceModelCanvas.this.vertex[0][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                    }
                    if (this.f2) {
                        this.v = (float)fu2.eval(this.x, this.y);
                        if (Float.isInfinite(this.v)) {
                            this.v = Float.NaN;
                        }
                        if (!Float.isNaN(this.v)) {
                            if (Float.isNaN(this.max2) || this.v > this.max2) {
                                this.max2 = this.v;
                            } else if (Float.isNaN(this.min2) || this.v < this.min2) {
                                this.min2 = this.v;
                            }
                        }
                        SurfaceModelCanvas.this.vertex[1][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                    }
                    ++this.j;
                    this.y += this.stepy;
                    ++this.k;
                    if (this.k % 100 != 0 && this.k != this.total) continue;
                    JHPlot.showMessage("Calculating : " + this.k * 100 / this.total + "% completed");
                }
                this.j = 0;
                this.y = this.yi;
                ++this.i;
                this.x += this.stepx;
            }
            SurfaceModelCanvas.this.setXMin(this.xi);
            SurfaceModelCanvas.this.setXMax(this.xx);
            SurfaceModelCanvas.this.setYMin(this.yi);
            SurfaceModelCanvas.this.setYMax(this.yx);
            SurfaceModelCanvas.this.z1Min = (float)SurfaceModelCanvas.this.floor(this.min1, 2);
            SurfaceModelCanvas.this.z1Max = (float)SurfaceModelCanvas.this.ceil(this.max1, 2);
            SurfaceModelCanvas.this.z2Min = (float)SurfaceModelCanvas.this.floor(this.min2, 2);
            SurfaceModelCanvas.this.z2Max = (float)SurfaceModelCanvas.this.ceil(this.max2, 2);
            SurfaceModelCanvas.this.setDataAvailable(true);
            SurfaceModelCanvas.this.autoScale();
            SurfaceModelCanvas.this.fireStateChanged();
        }

        @Override
        public void setEmpty() {
            SurfaceModelCanvas.this.isempty = true;
            this.calcDivisions = 100;
            this.total = (this.calcDivisions + 1) * (this.calcDivisions + 1);
            this.f1 = true;
            this.f2 = false;
            SurfaceModelCanvas.this.vertex = SurfaceModelCanvas.this.allocateMemory(this.f1, this.f2, this.total);
            SurfaceModelCanvas.this.setSurfaceVertex(SurfaceModelCanvas.this.vertex);
            SurfaceModelCanvas.this.getProjector();
            try {
                this.xi = SurfaceModelCanvas.this.getXMin();
                this.yi = SurfaceModelCanvas.this.getYMin();
                this.xx = SurfaceModelCanvas.this.getXMax();
                this.yx = SurfaceModelCanvas.this.getYMax();
                if (this.xi >= this.xx || this.yi >= this.yx) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                SurfaceModelCanvas.this.setMessage("Error in ranges");
                return;
            }
            SurfaceModelCanvas.this.setXMin(this.xi);
            SurfaceModelCanvas.this.setXMax(this.xx);
            SurfaceModelCanvas.this.setYMin(this.yi);
            SurfaceModelCanvas.this.setYMax(this.yx);
            SurfaceModelCanvas.this.setDataAvailable(true);
            SurfaceModelCanvas.this.fireStateChanged();
        }

        @Override
        public int getWidth() {
            return this.calcDivisions + 1;
        }

        @Override
        public int getHeight() {
            return this.calcDivisions + 1;
        }

        @Override
        public void setH2D(ArrayList<H2D> hu) {
            this.max2 = Float.NaN;
            this.min2 = Float.NaN;
            this.max1 = Float.NaN;
            this.min1 = Float.NaN;
            this.f1 = false;
            this.f2 = false;
            SurfaceModelCanvas.this.setDataAvailable(false);
            SurfaceModelCanvas.this.m_isP2D = false;
            SurfaceModelCanvas.this.m_isP3D = false;
            Histogram2D h1 = null;
            Histogram2D h2 = null;
            if (hu.size() == 1) {
                this.f1 = true;
                h1 = hu.get(0).get();
            }
            if (hu.size() == 2) {
                this.f2 = true;
                this.f1 = true;
                SurfaceModelCanvas.this.setBarsType(false);
                h1 = hu.get(0).get();
                h2 = hu.get(1).get();
            }
            SurfaceModelCanvas.this.hasFunction1 = this.f1;
            SurfaceModelCanvas.this.hasFunction2 = this.f2;
            int calc_divisionsX = 1;
            int calc_divisionsY = 1;
            SurfaceModelCanvas.this.getProjector();
            float Mi = SurfaceModelCanvas.this.getZMin();
            float Ma = SurfaceModelCanvas.this.getZMax();
            if (this.f1) {
                int BinX = h1.xAxis().bins();
                int BinY = h1.yAxis().bins();
                double hight = h1.maxBinHeight();
                this.min1 = 0.0f;
                this.max1 = (float)NumUtil.roundUp(hight * 1.2);
                this.xi = (float)h1.xAxis().lowerEdge();
                this.yi = (float)h1.yAxis().lowerEdge();
                this.xx = (float)h1.xAxis().upperEdge();
                this.yx = (float)h1.yAxis().upperEdge();
                if (this.xi >= this.xx || this.yi >= this.yx) {
                    throw new NumberFormatException();
                }
                if (BinX != BinY && !SurfaceModelCanvas.this.isBarsType()) {
                    if (BinX > BinY) {
                        BinX = BinY;
                    }
                    if (BinX < BinY) {
                        BinY = BinX;
                    }
                    System.out.println("You cannot use different bins in the surface mode.\n Consider the bar mode. At this moment, \n the number of bins were set to the smallest number of bins");
                }
                SurfaceModelCanvas.this.setCalcDivisions(BinX);
                this.calcDivisions = SurfaceModelCanvas.this.getCalcDivisions();
                calc_divisionsX = BinX;
                calc_divisionsY = BinY;
                this.total = (calc_divisionsX + 1) * (calc_divisionsY + 1);
                if (!SurfaceModelCanvas.this.isBarsType()) {
                    SurfaceModelCanvas.this.vertex = SurfaceModelCanvas.this.allocateMemory(this.f1, this.f2, this.total);
                    SurfaceModelCanvas.this.setSurfaceVertex(SurfaceModelCanvas.this.vertex);
                    if (SurfaceModelCanvas.this.vertex == null) {
                        return;
                    }
                }
            }
            this.calcDivisions = SurfaceModelCanvas.this.getCalcDivisions();
            this.stepx = (this.xx - this.xi) / (float)calc_divisionsX;
            this.stepy = (this.yx - this.yi) / (float)calc_divisionsY;
            if (this.f2) {
                double hight = h2.maxBinHeight();
                this.min2 = 0.0f;
                this.max2 = (float)NumUtil.roundUp(hight * 1.2);
                calc_divisionsX = this.calcDivisions = SurfaceModelCanvas.this.getCalcDivisions();
                calc_divisionsY = this.calcDivisions;
                SurfaceModelCanvas.this.setDataAvailable(false);
                this.stepx = (this.xx - this.xi) / (float)calc_divisionsX;
                this.stepy = (this.yx - this.yi) / (float)calc_divisionsY;
                this.total = (this.calcDivisions + 1) * (this.calcDivisions + 1);
                if (!SurfaceModelCanvas.this.isBarsType()) {
                    SurfaceModelCanvas.this.vertex = SurfaceModelCanvas.this.allocateMemory(this.f1, this.f2, this.total);
                    SurfaceModelCanvas.this.setSurfaceVertex(SurfaceModelCanvas.this.vertex);
                    if (SurfaceModelCanvas.this.vertex == null) {
                        return;
                    }
                }
            }
            this.i = 0;
            this.j = 0;
            this.k = 0;
            this.x = this.xi;
            this.y = this.yi;
            if (!SurfaceModelCanvas.this.autoScaleZ && !SurfaceModelCanvas.this.isBarsType()) {
                this.max1 = Ma;
                this.min1 = Mi;
                this.max2 = Ma;
                this.min2 = Mi;
            }
            this.xfactor = 20.0f / (this.xx - this.xi);
            this.yfactor = 20.0f / (this.yx - this.yi);
            this.zfactor = 20.0f / (this.max1 - this.min1);
            this.pointsX = null;
            this.pointsY = null;
            this.pointsZ = null;
            if (SurfaceModelCanvas.this.isBarsType()) {
                this.pointsX = new float[calc_divisionsX][calc_divisionsY];
                this.pointsY = new float[calc_divisionsX][calc_divisionsY];
                this.pointsZ = new float[calc_divisionsX][calc_divisionsY];
                while (this.i < calc_divisionsX) {
                    while (this.j < calc_divisionsY) {
                        if (this.f1) {
                            this.v = (float)h1.binHeight(this.i, this.j);
                            this.pointsX[this.i][this.j] = (this.x - this.xi) * this.xfactor - 10.0f;
                            this.pointsY[this.i][this.j] = (this.y - this.yi) * this.yfactor - 10.0f;
                            this.pointsZ[this.i][this.j] = this.v;
                        }
                        ++this.j;
                        this.y += this.stepy;
                        ++this.k;
                        if (this.k % 100 != 0) continue;
                        JHPlot.showMessage("Calculating : " + this.k * 100 / this.total + "% completed");
                    }
                    this.j = 0;
                    this.y = this.yi;
                    ++this.i;
                    this.x += this.stepx;
                }
            } else {
                this.i = 0;
                this.k = 0;
                this.j = 0;
                this.x = this.xi;
                this.y = this.yi;
                while (this.i <= calc_divisionsX) {
                    while (this.j <= calc_divisionsY) {
                        if (this.f1) {
                            this.v = (float)h1.binHeight(this.i, this.j);
                            if (Float.isInfinite(this.v)) {
                                this.v = Float.NaN;
                            }
                            if (!Float.isNaN(this.v)) {
                                if (Float.isNaN(this.max1) || this.v > this.max1) {
                                    this.max1 = this.v;
                                } else if (Float.isNaN(this.min1) || this.v < this.min1) {
                                    this.min1 = this.v;
                                }
                            }
                            SurfaceModelCanvas.this.vertex[0][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                        }
                        if (this.f2) {
                            this.v = (float)h2.binHeight(this.i, this.j);
                            if (Float.isInfinite(this.v)) {
                                this.v = Float.NaN;
                            }
                            if (!Float.isNaN(this.v)) {
                                if (Float.isNaN(this.max2) || this.v > this.max2) {
                                    this.max2 = this.v;
                                } else if (Float.isNaN(this.min2) || this.v < this.min2) {
                                    this.min2 = this.v;
                                }
                            }
                            SurfaceModelCanvas.this.vertex[1][this.k] = new SurfaceVertex((this.x - this.xi) * this.xfactor - 10.0f, (this.y - this.yi) * this.yfactor - 10.0f, this.v);
                        }
                        ++this.j;
                        this.y += this.stepy;
                        ++this.k;
                        if (this.k % 100 != 0 && this.k != this.total) continue;
                        JHPlot.showMessage("Calculating : " + this.k * 100 / this.total + "% completed");
                    }
                    this.j = 0;
                    this.y = this.yi;
                    ++this.i;
                    this.x += this.stepx;
                }
            }
            if (SurfaceModelCanvas.this.autoScaleZ) {
                if ((double)this.min1 < 0.2 && (double)this.min1 > -0.2) {
                    DecimalFormat dfb = new DecimalFormat("#.#E00");
                    String s1 = dfb.format((double)this.min1 * 0.9);
                    if (this.min1 < 0.0f) {
                        s1 = dfb.format((double)this.min1 * 1.1);
                    }
                    this.min1 = (float)Double.valueOf(s1.trim()).doubleValue();
                } else {
                    if (this.min1 > 0.0f) {
                        this.min1 = (float)NumUtil.roundUp(this.min1);
                    }
                    if (this.min1 < 0.0f) {
                        this.min1 = -1.0f * (float)NumUtil.roundUp(-1.0 * (double)this.min1);
                    }
                }
                this.max1 = (float)NumUtil.roundUp((double)this.max1 * 1.2);
            }
            this.zfactor = 20.0f / (this.max1 - this.min1);
            SurfaceModelCanvas.this.setXMin(this.xi);
            SurfaceModelCanvas.this.setXMax(this.xx);
            SurfaceModelCanvas.this.setYMin(this.yi);
            SurfaceModelCanvas.this.setYMax(this.yx);
            SurfaceModelCanvas.this.setZMin(this.min1);
            SurfaceModelCanvas.this.setZMax(this.max1);
            SurfaceModelCanvas.this.setDataAvailable(true);
            SurfaceModelCanvas.this.autoScale();
            SurfaceModelCanvas.this.fireStateChanged();
        }

        @Override
        public void setP2D(ArrayList<P2D> p2d_hold) {
            if (p2d_hold == null) {
                return;
            }
            double maxZ = Double.NaN;
            double minZ = Double.NaN;
            double maxY = Double.NaN;
            double minY = Double.NaN;
            double maxX = Double.NaN;
            double minX = Double.NaN;
            SurfaceModelCanvas.this.setDataAvailable(false);
            SurfaceModelCanvas.this.m_isP2D = true;
            SurfaceModelCanvas.this.m_isP3D = false;
            int jpoint_size = 0;
            for (int ii = 0; ii < p2d_hold.size(); ++ii) {
                P2D p2d = p2d_hold.get(ii);
                for (int i = 0; i < p2d.size(); ++i) {
                    ++jpoint_size;
                }
            }
            int kk = 0;
            SurfaceModelCanvas.access$702(SurfaceModelCanvas.this, new JPoint[jpoint_size]);
            for (int ii = 0; ii < p2d_hold.size(); ++ii) {
                P2D p2d = p2d_hold.get(ii);
                for (int i = 0; i < p2d.size(); ++i) {
                    double v = p2d.getX(i);
                    if (Double.isNaN(maxX) || v > maxX) {
                        maxX = v;
                    } else if (Double.isNaN(minX) || v < minX) {
                        minX = v;
                    }
                    v = p2d.getY(i);
                    if (Double.isNaN(maxY) || v > maxY) {
                        maxY = v;
                    } else if (Double.isNaN(minY) || v < minY) {
                        minY = v;
                    }
                    v = p2d.getY(i);
                    if (Double.isNaN(maxZ) || v > maxZ) {
                        maxZ = v;
                    } else if (Double.isNaN(minZ) || v < minZ) {
                        minZ = v;
                    }
                    ((SurfaceModelCanvas)SurfaceModelCanvas.this).jpoint[kk] = new JPoint(p2d.getX(i), p2d.getY(i), p2d.getZ(i), 0.0, p2d.getSymbolColor(), p2d.getSymbolSize());
                    ++kk;
                }
            }
            float zi = 0.0f;
            float zx = 1.0f;
            float xi = 0.0f;
            float xx = 1.0f;
            float yi = 0.0f;
            float yx = 1.0f;
            try {
                xi = SurfaceModelCanvas.this.getXMin();
                yi = SurfaceModelCanvas.this.getYMin();
                xx = SurfaceModelCanvas.this.getXMax();
                yx = SurfaceModelCanvas.this.getYMax();
                zi = SurfaceModelCanvas.this.getZMin();
                zx = SurfaceModelCanvas.this.getZMax();
                if (xi >= xx || yi >= yx) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                SurfaceModelCanvas.this.setMessage("Error in ranges");
                return;
            }
            if (SurfaceModelCanvas.this.isAutoScaleZ()) {
                zi = (float)minZ;
                zx = (float)maxZ;
                if (zi > 0.0f) {
                    zi = 0.4f * zi;
                }
                if (zi < 0.0f) {
                    zi = 1.8f * zi;
                }
                if (zx > 0.0f) {
                    zx = 1.8f * zx;
                }
                if (zx < 0.0f) {
                    zx = 1.9f * zx;
                }
                zi = (float)NumUtil.roundUp(zi);
                zx = (float)NumUtil.roundUp(zx);
            }
            if (SurfaceModelCanvas.this.m_AutoXY) {
                xi = (float)minX;
                yi = (float)minY;
                xx = (float)maxX;
                yx = (float)maxY;
                if (xi > 0.0f) {
                    xi = 0.4f * xi;
                }
                if (yi > 0.0f) {
                    yi = 0.4f * yi;
                }
                if (xi < 0.0f) {
                    xi = 1.8f * xi;
                }
                if (yi < 0.0f) {
                    yi = 1.8f * yi;
                }
                if (xx > 0.0f) {
                    xx = 1.8f * xx;
                }
                if (yx > 0.0f) {
                    yx = 1.8f * yx;
                }
                if (xx < 0.0f) {
                    xx = 1.8f * xx;
                }
                if (yx < 0.0f) {
                    yx = 1.8f * yx;
                }
                xx = (float)NumUtil.roundUp(xx);
                yx = (float)NumUtil.roundUp(yx);
                xi = (float)NumUtil.roundUp(xi);
                yi = (float)NumUtil.roundUp(yi);
                if (xi >= xx || yi >= yx) {
                    throw new NumberFormatException();
                }
            }
            this.xfactor = 20.0f / (xx - xi);
            this.yfactor = 20.0f / (yx - yi);
            this.zfactor = 20.0f / (zx - zi);
            SurfaceModelCanvas.this.setXMin(xi);
            SurfaceModelCanvas.this.setXMax(xx);
            SurfaceModelCanvas.this.setYMin(yi);
            SurfaceModelCanvas.this.setYMax(yx);
            SurfaceModelCanvas.this.setZMin(zi);
            SurfaceModelCanvas.this.setZMax(zx);
            SurfaceModelCanvas.this.setDataAvailable(true);
            SurfaceModelCanvas.this.fireStateChanged();
        }

        @Override
        public void setP3D(ArrayList<P3D> p3d_hold) {
            float zx;
            float zi;
            float yx;
            float xx;
            float yi;
            float xi;
            SurfaceModelCanvas.this.m_isP3D = true;
            if (p3d_hold == null) {
                return;
            }
            SurfaceModelCanvas.this.setDataAvailable(false);
            SurfaceModelCanvas.this.m_isP2D = false;
            SurfaceModelCanvas.this.m_isP3D = true;
            int jpoint_size = 0;
            for (int ii = 0; ii < p3d_hold.size(); ++ii) {
                P3D p3d = p3d_hold.get(ii);
                for (int i = 0; i < p3d.size(); ++i) {
                    ++jpoint_size;
                }
            }
            int kk = 0;
            SurfaceModelCanvas.access$702(SurfaceModelCanvas.this, new JPoint[jpoint_size]);
            for (int ii = 0; ii < p3d_hold.size(); ++ii) {
                P3D p3d = p3d_hold.get(ii);
                for (int i = 0; i < p3d.size(); ++i) {
                    JPoint jpp = new JPoint(p3d.getX(i), p3d.getY(i), p3d.getZ(i), 0.0, p3d.getPenColor(), p3d.getPenWidth());
                    jpp.setExt(p3d.getDX(i), p3d.getDY(i), p3d.getDZ(i));
                    ((SurfaceModelCanvas)SurfaceModelCanvas.this).jpoint[kk] = jpp;
                    ++kk;
                }
            }
            P3D p3d = p3d_hold.get(p3d_hold.size() - 1);
            if (SurfaceModelCanvas.this.isAutoScaleZ()) {
                xi = (float)p3d.getMin(0);
                yi = (float)p3d.getMin(1);
                xx = (float)p3d.getMax(0);
                yx = (float)p3d.getMax(1);
                zi = (float)p3d.getMin(2);
                zx = (float)p3d.getMax(2);
                if (xi > 0.0f) {
                    xi = 0.4f * xi;
                }
                if (yi > 0.0f) {
                    yi = 0.4f * yi;
                }
                if (xi < 0.0f) {
                    xi = 1.8f * xi;
                }
                if (yi < 0.0f) {
                    yi = 1.8f * yi;
                }
                if (xx > 0.0f) {
                    xx = 1.8f * xx;
                }
                if (yx > 0.0f) {
                    yx = 1.8f * yx;
                }
                if (xx < 0.0f) {
                    xx = 1.8f * xx;
                }
                if (yx < 0.0f) {
                    yx = 1.8f * yx;
                }
                if (zi > 0.0f) {
                    zi = 0.4f * zi;
                }
                if (zi < 0.0f) {
                    zi = 1.8f * zi;
                }
                if (zx > 0.0f) {
                    zx = 1.8f * zx;
                }
                if (zx < 0.0f) {
                    zx = 1.9f * zx;
                }
                xx = (float)NumUtil.roundUp(xx);
                yx = (float)NumUtil.roundUp(yx);
                xi = (float)NumUtil.roundUp(xi);
                yi = (float)NumUtil.roundUp(yi);
                zi = (float)NumUtil.roundUp(zi);
                zx = (float)NumUtil.roundUp(zx);
                if (xi >= xx || yi >= yx || zi >= zx) {
                    throw new NumberFormatException();
                }
            } else {
                try {
                    xi = SurfaceModelCanvas.this.getXMin();
                    yi = SurfaceModelCanvas.this.getYMin();
                    xx = SurfaceModelCanvas.this.getXMax();
                    yx = SurfaceModelCanvas.this.getYMax();
                    zi = SurfaceModelCanvas.this.getZMin();
                    zx = SurfaceModelCanvas.this.getZMax();
                    if (xi >= xx || yi >= yx) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    SurfaceModelCanvas.this.setMessage("Error in ranges");
                    return;
                }
            }
            this.xfactor = 20.0f / (xx - xi);
            this.yfactor = 20.0f / (yx - yi);
            this.zfactor = 20.0f / (zx - zi);
            SurfaceModelCanvas.this.setXMin(xi);
            SurfaceModelCanvas.this.setXMax(xx);
            SurfaceModelCanvas.this.setYMin(yi);
            SurfaceModelCanvas.this.setYMax(yx);
            SurfaceModelCanvas.this.setZMin(zi);
            SurfaceModelCanvas.this.setZMax(zx);
            SurfaceModelCanvas.this.setDataAvailable(true);
            SurfaceModelCanvas.this.fireStateChanged();
        }
    }

    public static interface Plotter {
        public int getWidth();

        public int getHeight();

        public void setEmpty();

        public float[][] getPointsX();

        public float[][] getPointsY();

        public float[][] getPointsZ();

        public float getFactorX();

        public float getFactorY();

        public float getFactorZ();

        public float getStepX();

        public float getStepY();

        public void setP2D(ArrayList<P2D> var1);

        public void setH2D(ArrayList<H2D> var1);

        public void setF2D(ArrayList<F2D> var1);

        public void setP3D(ArrayList<P3D> var1);

        public void setH2DF2D(ArrayList<H2D> var1, ArrayList<F2D> var2);
    }
}

