/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import java.awt.Color;

public class ColorModel {
    public static final byte DUALSHADE = 0;
    public static final byte SPECTRUM = 1;
    public static final byte FOG = 2;
    public static final byte OPAQUE = 3;
    float hue;
    float sat;
    float bright;
    float min;
    float max;
    byte mode = 0;
    Color ocolor;

    public ColorModel(byte mode, float hue, float sat, float bright, float min, float max) {
        this.mode = mode;
        this.hue = hue;
        this.sat = sat;
        this.bright = bright;
        this.min = min;
        this.max = max;
    }

    public Color getPolygonColor(float z) {
        if (z < 0.0f || z > 1.0f) {
            return Color.WHITE;
        }
        switch (this.mode) {
            case 0: {
                return this.color(this.hue, this.sat, this.norm(z));
            }
            case 1: {
                return this.color(this.norm(1.0f - z), this.sat, this.bright);
            }
            case 2: {
                return this.color(this.hue, this.norm(z), this.bright);
            }
            case 3: {
                if (this.ocolor == null) {
                    this.ocolor = this.color(this.hue, this.sat, this.bright);
                }
                return this.ocolor;
            }
        }
        return Color.WHITE;
    }

    private Color color(float hue, float sat, float bright) {
        return Color.getHSBColor(hue, sat, bright);
    }

    private float norm(float z) {
        if (this.min == this.max) {
            return this.min;
        }
        return this.min + z * (this.max - this.min);
    }
}

