/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import graph.RTextLine;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.Enumeration;
import java.util.Vector;
import jplot.Axis;
import jplot.Contour;
import jplot.DataArray;
import jplot.GPoints;
import jplot.GraphGeneral;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.PlotPoint;
import jplot.Utils;
import org.freehep.graphics2d.VectorGraphics;

public class GraphXY
extends GraphGeneral {
    private static final long serialVersionUID = 1L;
    private double histoWidth = 1000000.0;
    private int[] xpolUP;
    private int[] ypolUP;
    private int[] xpolDW;
    private int[] ypolDW;
    private int[] xpolUPsys;
    private int[] ypolUPsys;
    private int[] xpolDWsys;
    private int[] ypolDWsys;
    private int NtotPoly = 0;
    private Contour contour;

    public GraphXY(JPlot jp, GraphSettings gs) {
        super(jp, gs);
    }

    public GraphXY(GraphSettings gs) {
        this(null, gs);
    }

    private double getLogBoundary(int axis, double v) {
        double k;
        double x = 10.0;
        if (v > 1.0) {
            for (k = 0.0; v >= 1.0 && k < 299.0; v /= 10.0, k += 1.0) {
            }
        } else {
            x = 0.1;
            while (v <= 0.1 && k < 299.0) {
                v *= 10.0;
                k += 1.0;
            }
        }
        return Math.pow(x, k);
    }

    @Override
    protected boolean setMinMax(int axis, Vector data) {
        double min = this.gs.getMinValue(axis);
        double max = this.gs.getMaxValue(axis);
        if (this.gs.autoRange(axis)) {
            Enumeration e = data.elements();
            DataArray da = (DataArray)e.nextElement();
            double minVal = this.gs.useLogScale(axis) ? da.getLowestNonZeroValue(axis) : da.getMinValue(axis);
            min = minVal;
            max = da.getMaxValue(axis);
            while (e.hasMoreElements()) {
                da = (DataArray)e.nextElement();
                minVal = this.gs.useLogScale(axis) ? da.getLowestNonZeroValue(axis) : da.getMinValue(axis);
                if (minVal < min) {
                    min = minVal;
                }
                if (!(da.getMaxValue(axis) > max)) continue;
                max = da.getMaxValue(axis);
            }
            double del = max - min;
            if ((min -= (del = 0.05 * del)) == (max += del)) {
                min -= 0.1;
                max += 0.1;
            }
            if (da.getGraphStyle() == 1 && axis == 1) {
                min = 0.0;
                if (this.gs.useLogScale(axis)) {
                    min = da.getLowestNonZeroValue(axis);
                }
            }
            if (this.gs.get2DType() == 1 && axis == 1) {
                min = 0.0;
                if (this.gs.useLogScale(axis)) {
                    min = da.getLowestNonZeroValue(axis);
                }
            }
            if (axis == 0 && this.gs.useLogScale(axis)) {
                min = da.getLowestNonZeroValue(axis);
            }
            if (this.gs.useLogScale(axis)) {
                min = this.getLogBoundary(axis, min) / 10.0;
                max = this.getLogBoundary(axis, max);
            }
        }
        if (this.gs.useLogScale(axis)) {
            max = GraphXY.log10(max);
            min = GraphXY.log10(min);
        }
        double tic = Axis.calculateTicSep(min, max, this.gs.getMaxNumberOfTics());
        if (this.gs.autoRange(axis)) {
            if (min < max) {
                min = tic * Math.floor(min / tic);
                max = tic * Math.ceil(max / tic);
            } else {
                min = tic * Math.ceil(min / tic);
                max = tic * Math.floor(max / tic);
            }
        }
        if (this.gs.useNumberOfTics(axis)) {
            this.numberOfTics[axis] = this.gs.getNumberOfTics(axis);
        } else if (!this.gs.useLogScale(axis)) {
            this.numberOfTics[axis] = Axis.calculateTicNumber(min, max, tic, this.gs.useLogScale(axis));
            this.gs.setNumberOfTics(axis, this.numberOfTics[axis]);
        }
        this.diff[axis] = Math.abs(min - max);
        if (this.gs.useLogScale(axis)) {
            min = Math.pow(10.0, min);
            max = Math.pow(10.0, max);
            if ((double)this.numberOfTics[axis] > this.diff[axis]) {
                this.numberOfTics[axis] = Axis.calculateTicNumber(min, max, tic, this.gs.useLogScale(axis));
                this.gs.setNumberOfTics(axis, this.numberOfTics[axis]);
            }
        }
        this.inv[axis] = min < max ? 1.0 : -1.0;
        this.gs.setMinValue(axis, min);
        this.gs.setMaxValue(axis, max);
        this.MinAxis[axis] = min;
        this.MaxAxis[axis] = max;
        this.AxisExponent[axis] = 0;
        this.AxisExponent[axis] = Math.abs(min) > Math.abs(max) ? (int)Math.floor(Math.log10(Math.abs(min)) / 3.0) * 3 : (int)Math.floor(Math.log10(Math.abs(max)) / 3.0) * 3;
        return true;
    }

    @Override
    protected void makeTicLabels() {
        int origExpX = this.AxisExponent[0];
        int origExpY = this.AxisExponent[1];
        if (Math.abs(this.AxisExponent[0]) <= 4) {
            this.AxisExponent[0] = 0;
        }
        if (Math.abs(this.AxisExponent[1]) <= 4) {
            this.AxisExponent[1] = 0;
        }
        int maxTics = this.gs.getMaxNumberOfTics();
        if (this.gs.useNumberOfTics(0)) {
            maxTics = this.gs.getNumberOfTics(0);
        }
        if (this.gs.useLogScale(0)) {
            maxTics = this.gs.getMaxNumberOfTics();
        }
        Vector<String> ticsX = new Vector();
        Vector<String> ticsXlabels = this.gs.getLabelTicks(0);
        ticsX = Axis.computeTicks(this.MinAxis[0], this.MaxAxis[0], maxTics, this.gs.useLogScale(0));
        if (this.gs.getAutomaticTicks(0)) {
            this.gs.setLabelTicks(0, ticsX);
        }
        this.numberOfTics[0] = ticsX.size();
        this.ticLabel[0] = new String[this.numberOfTics[0]];
        this.ticNumber[0] = new double[this.numberOfTics[0]];
        for (int i = 0; i < this.numberOfTics[0]; ++i) {
            double ticval;
            String ticstr = ticsX.elementAt(i);
            double NoExpon = ticval = Double.parseDouble(ticstr);
            if (!this.gs.useLogScale(0)) {
                NoExpon = ticval / Math.pow(10.0, this.AxisExponent[0]);
                ticstr = Utils.FormNum(NoExpon, this.MinAxis[0], this.MaxAxis[0]);
            } else {
                ticstr = Utils.FormLog(ticval);
            }
            this.ticNumber[0][i] = ticval;
            this.ticLabel[0][i] = !this.gs.getAutomaticTicks(0) ? ticsXlabels.elementAt(i) : ticstr;
        }
        if (this.gs.getAutomaticTicks(0)) {
            this.ticLabel[0] = Utils.skeepZero(this.ticLabel[0]);
        }
        maxTics = this.gs.getMaxNumberOfTics();
        if (this.gs.useNumberOfTics(1)) {
            maxTics = this.gs.getNumberOfTics(1);
        }
        if (this.gs.useLogScale(1)) {
            maxTics = this.gs.getMaxNumberOfTics();
        }
        Vector<String> ticsY = new Vector();
        Vector<String> ticsYlabels = this.gs.getLabelTicks(1);
        ticsY = Axis.computeTicks(this.MinAxis[1], this.MaxAxis[1], maxTics, this.gs.useLogScale(1));
        if (this.gs.getAutomaticTicks(1)) {
            this.gs.setLabelTicks(1, ticsY);
        }
        this.numberOfTics[1] = ticsY.size();
        this.ticLabel[1] = new String[this.numberOfTics[1]];
        this.ticNumber[1] = new double[this.numberOfTics[1]];
        for (int i = 0; i < this.numberOfTics[1]; ++i) {
            double ticval;
            String ticstr = ticsY.elementAt(i);
            double NoExpon = ticval = Double.parseDouble(ticstr);
            if (!this.gs.useLogScale(1)) {
                NoExpon = ticval / Math.pow(10.0, this.AxisExponent[1]);
                ticstr = Utils.FormNum(NoExpon, this.MinAxis[1], this.MaxAxis[1]);
            } else {
                ticstr = Utils.FormLog(ticval);
            }
            this.ticNumber[1][i] = ticval;
            this.ticLabel[1][i] = !this.gs.getAutomaticTicks(1) ? ticsYlabels.elementAt(i) : ticstr;
        }
        if (this.gs.getAutomaticTicks(1)) {
            this.ticLabel[1] = Utils.skeepZero(this.ticLabel[1]);
        }
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            DataArray da = (DataArray)e.nextElement();
            if (da.size() == 0 || da.getGraphStyle() != 2) continue;
            this.contour = new Contour(this.gs.getContour_bar(), this.gs.getContour_binsX(), this.gs.getContour_binsY(), this.gs.getContour_gray(), this.gs.getContour_levels());
            this.contour.createGrid(da.getData(), this.MinAxis[0], this.MaxAxis[0], this.MinAxis[1], this.MaxAxis[1]);
        }
    }

    private void drawGrid(VectorGraphics g2) {
        double d;
        int i;
        double x = this.leftMargin + this.axisLength[0];
        double y = this.topMargin + this.axisLength[1];
        g2.setStroke((Stroke)new BasicStroke());
        g2.setColor(this.gs.getGridColor());
        if (this.gs.drawGrid(0)) {
            for (i = 0; i < this.numberOfTics[0]; ++i) {
                d = this.toX(this.ticNumber[0][i]);
                if (!(d >= this.leftMargin) || !(d <= x)) continue;
                g2.drawLine(d, this.topMargin, d, y);
            }
        }
        if (this.gs.drawGrid(1)) {
            for (i = 0; i < this.numberOfTics[1]; ++i) {
                d = this.toY(this.ticNumber[1][i]);
                if (!(d >= this.topMargin) || !(d <= y)) continue;
                g2.drawLine(this.leftMargin, d, x, d);
            }
        }
    }

    private void drawMargins(VectorGraphics g2) {
        double x = this.leftMargin + this.axisLength[0];
        double y = this.topMargin + this.axisLength[1];
        g2.setColor(this.gs.getBackgroundColor());
        g2.fillRect(0.0, 0.0, this.leftMargin, (double)this.height);
        g2.fillRect(0.0, 0.0, (double)this.width, this.topMargin);
        g2.fillRect(x, 0.0, this.rightMargin, (double)this.height);
        g2.fillRect(0.0, y, (double)this.width, this.bottomMargin);
    }

    private void plotAxes(VectorGraphics g2) {
        double tt;
        double tdic;
        double sepa;
        int i;
        int[] yy;
        int[] xx;
        int le2;
        int le1;
        g2.setColor(this.gs.getAxesColor());
        if (this.gs.drawAxis(0) && this.gs.drawAxis(1)) {
            g2.drawRect(this.leftMargin, this.topMargin, this.axisLength[0], this.axisLength[1]);
        }
        double a = this.topMargin + this.axisLength[1];
        double x = this.leftMargin + this.axisLength[0];
        double y = this.topMargin + this.axisLength[1];
        if (this.gs.drawAxis(0) && !this.gs.drawAxis(1)) {
            if (this.gs.drawMirrorAxis(0)) {
                g2.drawLine(this.leftMargin, this.topMargin, x, this.topMargin);
            }
            g2.drawLine(this.leftMargin, y, x, y);
            if (this.gs.getAxesArrow() == 1) {
                le1 = 6 * (int)(this.gs.getPenWidthAxis() * this.scalingFrame);
                le2 = 2 * (int)(this.gs.getPenWidthAxis() * this.scalingFrame);
                xx = new int[]{(int)this.leftMargin, (int)x};
                yy = new int[]{(int)y, (int)y};
                this.drawPolylineArrow((Graphics)g2, xx, yy, le1, le2);
            }
            if (this.gs.getAxesArrow() == 2) {
                this.drawArrow2(g2, (int)this.leftMargin, (int)y, (int)x, (int)y);
            }
        }
        if (!this.gs.drawAxis(0) && this.gs.drawAxis(1)) {
            g2.drawLine(this.leftMargin, this.topMargin, this.leftMargin, a);
            if (this.gs.getAxesArrow() == 1) {
                le1 = 6 * (int)(this.gs.getPenWidthAxis() * this.scalingFrame);
                le2 = 2 * (int)(this.gs.getPenWidthAxis() * this.scalingFrame);
                xx = new int[]{(int)this.leftMargin, (int)this.leftMargin};
                yy = new int[]{(int)a, (int)this.topMargin};
                this.drawPolylineArrow((Graphics)g2, xx, yy, le1, le2);
            }
            if (this.gs.getAxesArrow() == 2) {
                this.drawArrow2(g2, (int)this.leftMargin, (int)a, (int)this.leftMargin, (int)this.topMargin);
            }
            if (this.gs.drawMirrorAxis(1)) {
                g2.drawLine(x, this.topMargin, x, a);
            }
        }
        FontMetrics fmX = this.getFontMetrics(this.gs.getTicFont(0));
        double xLabelHeight = (float)fmX.getHeight() * this.scalingFrame;
        FontMetrics fmY = this.getFontMetrics(this.gs.getTicFont(1));
        double yLabelHeight = (float)fmY.getHeight() * this.scalingFrame;
        int NticLog = this.gs.getMaxNumberOfTics() - 1;
        int xRot = 1;
        int yRot = 1;
        if (this.gs.rotateTics(0)) {
            xRot = -1;
        }
        if (this.gs.rotateTics(1)) {
            yRot = -1;
        }
        if (this.gs.drawTicLabels(0) && !this.gs.useLogScale(0) && this.AxisExponent[0] != 0) {
            String stext = "x10^" + Integer.toString(this.AxisExponent[0]);
            double ex1 = x - (double)(fmX.stringWidth(stext) / 4);
            double ey1 = a + 2.0 * xLabelHeight;
            RTextLine exponent = new RTextLine();
            exponent.setFont(this.scaleFont(this.gs.getTicFont(0)));
            exponent.setColor(this.gs.getTicColor(0));
            exponent.setText(stext);
            exponent.draw(g2, (int)ex1, (int)ey1);
        }
        g2.setStroke((Stroke)new BasicStroke(this.gs.getAxesPenTicWidth() * this.scalingFrame));
        double x_end = x;
        double y_end = this.topMargin;
        if (this.gs.getAxesArrow() != 0) {
            x_end = x - 1.0;
            y_end = this.topMargin + 1.0;
        }
        if (this.gs.drawTics(0)) {
            for (i = 0; i < this.numberOfTics[0]; ++i) {
                double t1;
                int j;
                int Ntics;
                double d = this.toX(this.ticNumber[0][i]);
                if (this.subticNumber[0] > 0 && i < this.numberOfTics[0] - 1) {
                    sepa = this.ticNumber[0][i + 1] - this.ticNumber[0][i];
                    Ntics = this.subticNumber[0];
                    tdic = this.ticNumber[0][i];
                    tt = sepa / (double)Ntics;
                    if (this.gs.useLogScale(0)) {
                        Ntics = NticLog;
                        tt = sepa / (double)Ntics;
                    }
                    for (j = 0; j < Ntics; ++j) {
                        t1 = this.toX(tdic += tt);
                        if (t1 >= this.leftMargin && t1 <= x_end) {
                            g2.drawLine(t1, y - (double)xRot * this.subticLength[0], t1, y);
                        }
                        if (this.gs.autoRange(0) || !this.gs.useLogScale(0) || !(t1 >= this.leftMargin) || !(t1 <= x_end) || j + 2 >= 10 || !(this.gs.getMinValue(0) > 0.2) || !(this.gs.getMaxValue(0) < 100.0)) continue;
                        double ifix = 0.0;
                        double ifih = 0.0;
                        double x1 = t1 - (ifix += 0.5 * (double)fmX.stringWidth(this.ticLabel[0][i]) * (double)this.scalingFrame);
                        double y1 = a + xLabelHeight + (ifih += 0.2 * xLabelHeight);
                        RTextLine text = new RTextLine();
                        text.setFont(this.scaleFont(this.gs.getTicFont(0)));
                        text.setColor(this.gs.getTicColor(0));
                        if (i == 1) {
                            text.setText(Integer.toString(j + 2));
                        }
                        if (i == 2) {
                            text.setText(Integer.toString((j + 2) * 10));
                        }
                        text.draw(g2, (int)x1, (int)y1);
                    }
                    if (!this.gs.useLogScale(0)) {
                        double t12 = this.toX(this.ticNumber[0][0] - tt);
                        if (t12 >= this.leftMargin && t12 <= x) {
                            g2.draw((Shape)new Line2D.Double(t12, y - (double)xRot * this.subticLength[0], t12, y));
                        }
                        if ((t12 = this.toX(this.ticNumber[0][this.numberOfTics[0] - 1] + tt)) >= this.leftMargin && t12 <= x_end) {
                            g2.drawLine(t12, y - (double)xRot * this.subticLength[0], t12, y);
                        }
                    }
                }
                if (d >= this.leftMargin && d <= x_end) {
                    g2.drawLine(d, y - (double)xRot * this.ticLength[0], d, y);
                }
                if (this.gs.drawMirrorTics(0)) {
                    if (this.subticNumber[0] > 0 && i < this.numberOfTics[0] - 1) {
                        sepa = this.ticNumber[0][i + 1] - this.ticNumber[0][i];
                        Ntics = this.subticNumber[0];
                        tdic = this.ticNumber[0][i];
                        tt = sepa / (double)Ntics;
                        if (this.gs.useLogScale(0)) {
                            Ntics = NticLog;
                            tt = sepa / (double)Ntics;
                        }
                        for (j = 0; j < Ntics; ++j) {
                            t1 = this.toX(tdic += tt);
                            if (!(t1 >= this.leftMargin) || !(t1 <= x)) continue;
                            g2.drawLine(t1, this.topMargin + (double)xRot * this.subticLength[0], t1, this.topMargin);
                        }
                        if (!this.gs.useLogScale(0)) {
                            double t13 = this.toX(this.ticNumber[0][0] - tt);
                            if (t13 >= this.leftMargin && t13 <= x) {
                                g2.drawLine(t13, this.topMargin + (double)xRot * this.subticLength[0], t13, this.topMargin);
                            }
                            if ((t13 = this.toX(this.ticNumber[0][this.numberOfTics[0] - 1] + tt)) >= this.leftMargin && t13 <= x) {
                                g2.drawLine(t13, this.topMargin + (double)xRot * this.subticLength[0], t13, this.topMargin);
                            }
                        }
                    }
                    if (d >= this.leftMargin && d <= x) {
                        g2.drawLine(d, this.topMargin + (double)xRot * this.ticLength[0], d, this.topMargin);
                    }
                }
                if (!this.gs.drawTicLabels(0) || this.ticLabel[0][i] == null) continue;
                double ifix = 0.0;
                double ifih = 0.0;
                if (this.ticLabel[0][i].indexOf("^") > -1) {
                    ifix = -0.35 * (double)fmX.stringWidth(this.ticLabel[0][i]) * (double)this.scalingFrame;
                    ifih = 0.2 * xLabelHeight;
                }
                if (this.gs.useLogScale(0) && (this.ticLabel[0][i].equals("1") || this.ticLabel[0][i].equals("10"))) {
                    ifih += 0.2 * xLabelHeight;
                }
                double x1 = d - (ifix += 0.5 * (double)fmX.stringWidth(this.ticLabel[0][i]) * (double)this.scalingFrame);
                double y1 = a + xLabelHeight + ifih;
                if (!(d >= this.leftMargin) || !(d <= x)) continue;
                RTextLine text = new RTextLine();
                text.setFont(this.scaleFont(this.gs.getTicFont(0)));
                text.setColor(this.gs.getTicColor(0));
                text.setText(this.ticLabel[0][i]);
                text.draw(g2, (int)x1, (int)y1);
            }
        }
        if (this.gs.drawTicLabels(1) && !this.gs.useLogScale(1) && this.AxisExponent[1] != 0) {
            String stext = "x10^" + Integer.toString(this.AxisExponent[1]);
            double ex1 = this.leftMargin;
            if (ex1 < 0.0) {
                ex1 = 0.0;
            }
            double ey1 = this.topMargin - 0.25 * yLabelHeight;
            RTextLine exponent = new RTextLine();
            exponent.setFont(this.scaleFont(this.gs.getTicFont(1)));
            exponent.setColor(this.gs.getTicColor(1));
            exponent.setText(stext);
            exponent.draw(g2, (int)ex1, (int)ey1);
        }
        if (this.gs.drawTics(1)) {
            for (i = 0; i < this.numberOfTics[1]; ++i) {
                double d = this.toY(this.ticNumber[1][i]);
                if (this.subticNumber[1] > 0 && i < this.numberOfTics[1] - 1) {
                    sepa = this.ticNumber[1][i + 1] - this.ticNumber[1][i];
                    int Ntics = this.subticNumber[1];
                    tdic = this.ticNumber[1][i];
                    tt = sepa / (double)Ntics;
                    if (this.gs.useLogScale(1)) {
                        Ntics = NticLog;
                        tt = sepa / (double)Ntics;
                    }
                    for (int j = 0; j < Ntics; ++j) {
                        double t1 = this.toY(tdic += tt);
                        if (t1 >= y_end && t1 <= y) {
                            g2.drawLine(this.leftMargin, t1, this.leftMargin + (double)yRot * this.subticLength[1], t1);
                        }
                        if (this.gs.autoRange(1) || !this.gs.useLogScale(1) || !(t1 >= y_end) || !(t1 <= y) || j + 2 >= 10 || !(this.gs.getMinValue(1) > 0.2) || !(this.gs.getMaxValue(1) < 100.0)) continue;
                        double ifih = 0.0;
                        if (this.ticLabel[1][i].equalsIgnoreCase("1")) {
                            ifih = -0.75 * (double)fmX.stringWidth(this.ticLabel[1][i]) * (double)this.scalingFrame;
                        } else if (this.ticLabel[1][i].equalsIgnoreCase("10")) {
                            ifih = -0.5 * (double)fmX.stringWidth(this.ticLabel[1][i]) * (double)this.scalingFrame;
                        }
                        double x2 = this.leftMargin - (double)((float)fmY.stringWidth(this.ticLabel[1][i]) * this.scalingFrame) - (double)this.xSep + ifih;
                        double y2 = t1 + 0.25 * yLabelHeight * (double)this.scalingFrame;
                        RTextLine text = new RTextLine();
                        text.setFont(this.scaleFont(this.gs.getTicFont(1)));
                        text.setColor(this.gs.getTicColor(1));
                        if (i == 1) {
                            text.setText(Integer.toString(j + 2));
                        }
                        if (i == 2) {
                            text.setText(Integer.toString((j + 2) * 10));
                        }
                        text.draw(g2, (int)x2, (int)y2);
                    }
                    if (!this.gs.useLogScale(1) && this.numberOfTics[1] > 0) {
                        double t1 = this.toY(this.ticNumber[1][this.numberOfTics[1] - 1] + tt);
                        if (t1 >= y_end && t1 <= y) {
                            g2.draw((Shape)new Line2D.Double(this.leftMargin, t1, this.leftMargin + (double)yRot * this.subticLength[1], t1));
                        }
                        if ((t1 = this.toY(this.ticNumber[1][0] - tt)) >= y_end && t1 <= y) {
                            g2.drawLine(this.leftMargin, t1, this.leftMargin + (double)yRot * this.subticLength[1], t1);
                        }
                    }
                }
                if (d >= y_end && d <= y) {
                    g2.drawLine(this.leftMargin, d, this.leftMargin + (double)yRot * this.ticLength[1], d);
                }
                if (this.gs.drawMirrorTics(1)) {
                    if (this.subticNumber[1] > 0 && i < this.numberOfTics[1] - 1) {
                        sepa = this.ticNumber[1][i + 1] - this.ticNumber[1][i];
                        int Ntics = this.subticNumber[1];
                        tdic = this.ticNumber[1][i];
                        tt = sepa / (double)Ntics;
                        if (this.gs.useLogScale(1)) {
                            Ntics = NticLog;
                            tt = sepa / (double)Ntics;
                        }
                        for (int j = 0; j < Ntics; ++j) {
                            double t1 = this.toY(tdic += tt);
                            if (!(t1 >= this.topMargin) || !(t1 <= y)) continue;
                            g2.drawLine(x - (double)yRot * this.subticLength[1], t1, x, t1);
                        }
                        if (!this.gs.useLogScale(1) && this.numberOfTics[1] > 0) {
                            double t1 = this.toY(this.ticNumber[1][this.numberOfTics[1] - 1] + tt);
                            if (t1 >= this.topMargin && t1 <= y) {
                                g2.drawLine(x - (double)yRot * this.subticLength[1], t1, x, t1);
                            }
                            if ((t1 = this.toY(this.ticNumber[1][0] - tt)) >= this.topMargin && t1 <= y) {
                                g2.drawLine(x - (double)yRot * this.subticLength[1], t1, x, t1);
                            }
                        }
                    }
                    if (d >= y_end && d <= y) {
                        g2.drawLine(x - (double)yRot * this.ticLength[1], d, x, d);
                    }
                }
                if (!this.gs.drawTicLabels(1) || this.ticLabel[1][i] == null) continue;
                double ifih = 0.0;
                if (this.gs.useLogScale(1)) {
                    if (this.ticLabel[1][i].indexOf("^") > -1) {
                        ifih = 0.5 * (double)fmX.stringWidth(this.ticLabel[1][i]) * (double)this.scalingFrame;
                    } else if (this.ticLabel[1][i].equalsIgnoreCase("1")) {
                        ifih = -0.75 * (double)fmX.stringWidth(this.ticLabel[1][i]) * (double)this.scalingFrame;
                    } else if (this.ticLabel[1][i].equalsIgnoreCase("10")) {
                        ifih = -0.5 * (double)fmX.stringWidth(this.ticLabel[1][i]) * (double)this.scalingFrame;
                    }
                } else {
                    ifih = 0.0;
                }
                double x2 = this.leftMargin - (double)((float)fmY.stringWidth(this.ticLabel[1][i]) * this.scalingFrame) - (double)this.xSep + ifih;
                double y2 = d + 0.25 * yLabelHeight * (double)this.scalingFrame;
                if (!(d >= this.topMargin) || !(d <= y)) continue;
                RTextLine text = new RTextLine();
                text.setFont(this.scaleFont(this.gs.getTicFont(1)));
                text.setColor(this.gs.getTicColor(1));
                text.setText(this.ticLabel[1][i]);
                text.draw(g2, (int)x2, (int)y2);
            }
        }
    }

    @Override
    public double toX(double x) {
        double d = this.gs.useLogScale(0) ? GraphXY.log10(x / this.gs.getMinValue(0)) : x - this.gs.getMinValue(0);
        return this.leftMargin + this.inv[0] * d * this.axisLength[0] / this.diff[0];
    }

    @Override
    public double toY(double y) {
        double d = this.gs.useLogScale(1) ? GraphXY.log10(y / this.gs.getMinValue(1)) : y - this.gs.getMinValue(1);
        return this.topMargin + this.axisLength[1] * (1.0 - this.inv[1] * d / this.diff[1]);
    }

    @Override
    public double toUserX(int Xpic) {
        double scale = this.axisLength[0] / this.diff[0];
        double d = ((double)Xpic - this.leftMargin) / (this.inv[0] * scale);
        double mPosX = this.gs.useLogScale(0) ? Math.pow(10.0, d) * this.gs.getMinValue(0) : d + this.gs.getMinValue(0);
        return mPosX;
    }

    @Override
    public double toUserY(int Ypic) {
        double scale = this.axisLength[1] / this.diff[1];
        double d = ((double)(-1 * Ypic) + this.topMargin + this.axisLength[1]) / (scale * this.inv[1]);
        double mPosY = this.gs.useLogScale(1) ? Math.pow(10.0, d) * this.gs.getMinValue(1) : d + this.gs.getMinValue(1);
        return mPosY;
    }

    @Override
    protected void fillGraphArea(VectorGraphics g2) {
        g2.setColor(this.gs.getGraphBackgroundColor());
        g2.fillRect(this.leftMargin, this.topMargin, this.axisLength[0], this.axisLength[1]);
    }

    public Vector getPoints(DataArray da) {
        Vector data = da.getData();
        double oldX = 0.0;
        Vector<PlotPoint> p = new Vector<PlotPoint>();
        int i = 0;
        double aXmin = this.leftMargin;
        double aXmax = this.leftMargin + this.axisLength[0];
        double aYmin = this.topMargin + this.axisLength[1];
        double aYmax = this.topMargin;
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            PlotPoint pp = (PlotPoint)e.nextElement();
            double x = this.toX(pp.getX());
            double y = this.toY(pp.getY());
            double left = this.toX(pp.getX() - pp.getXleft());
            double right = this.toX(pp.getX() + pp.getXright());
            double upper = this.toY(pp.getY() + pp.getYupper());
            double lower = this.toY(pp.getY() - pp.getYlower());
            double left_sys = this.toX(pp.getX() - pp.getXleft() - pp.getXleftSys());
            double right_sys = this.toX(pp.getX() + pp.getXright() + pp.getXrightSys());
            double upper_sys = this.toY(pp.getY() + pp.getYupper() + pp.getYupperSys());
            double lower_sys = this.toY(pp.getY() - pp.getYlower() - pp.getYlowerSys());
            if (da.getGraphStyle() != 1) {
                // empty if block
            }
            if (da.getGraphStyle() != 1 || !(right_sys < aXmin - 1.0) && !(left_sys > aXmax + 1.0)) {
                p.add(new PlotPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys));
            }
            ++i;
        }
        return p;
    }

    @Override
    protected void updateGraph() {
        VectorGraphics g2 = this.currentG;
        if (g2 == null) {
            return;
        }
        double a = this.topMargin + this.axisLength[1];
        double zeroX = this.toX(0.0);
        double zeroY = this.toY(0.0);
        double cXmin = this.leftMargin;
        double cXmax = this.leftMargin + this.axisLength[0];
        double cYmin = this.topMargin + this.axisLength[1];
        double cYmax = this.topMargin;
        double dashCounter1 = 0.0;
        double dashCounter2 = 0.0;
        if (!this.gs.gridToFront()) {
            this.drawGrid(g2);
        }
        if (!this.gs.primitivesToFront()) {
            this.plotPrimitives(g2);
        }
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            int m;
            int[] ypol;
            Color cold;
            DataArray da = (DataArray)e.nextElement();
            Vector points = this.getPoints(da);
            if (points.size() == 0) continue;
            if (da.getGraphStyle() == 2 && this.contour != null) {
                this.contour.drawColor((Graphics2D)g2, this.toX(this.MinAxis[0]), this.toX(this.MaxAxis[0]), this.toY(this.MinAxis[1]), this.toY(this.MaxAxis[1]));
                this.contour.drawColorBar((Graphics2D)g2, this.gs.getTicFont(1), (int)this.rightMargin);
                continue;
            }
            this.NtotPoly = points.size();
            if (da.getErrorsFill()) {
                this.xpolUP = new int[this.NtotPoly];
                this.ypolUP = new int[this.NtotPoly];
                this.xpolDW = new int[this.NtotPoly];
                this.ypolDW = new int[this.NtotPoly];
            }
            if (da.getErrorsFillSys()) {
                this.xpolUPsys = new int[this.NtotPoly];
                this.ypolUPsys = new int[this.NtotPoly];
                this.xpolDWsys = new int[this.NtotPoly];
                this.ypolDWsys = new int[this.NtotPoly];
            }
            BasicStroke lineSolidStroke = new BasicStroke(da.getPenWidth() * this.scalingFrame);
            BasicStroke lineStroke = new BasicStroke(da.getPenWidth() * this.scalingFrame);
            if (da.getDashLength() > 0.0f) {
                float[] dashPattern = new float[]{da.getDashLength(), 0.5f * da.getDashLength()};
                float dashPhase = 0.0f;
                lineStroke = new BasicStroke(da.getPenWidth() * this.scalingFrame, 0, 2, 2.0f, dashPattern, dashPhase);
            }
            g2.setColor(da.getColor());
            if (da.drawLine()) {
                g2.setStroke((Stroke)da.getStroke());
            }
            PlotPoint prev = new PlotPoint(0.0, 0.0);
            int i = 1;
            Enumeration e2 = points.elements();
            while (e2.hasMoreElements()) {
                block66: {
                    PlotPoint pp;
                    block62: {
                        block64: {
                            double minDist;
                            block65: {
                                block63: {
                                    double xup_prev;
                                    double xlow_prev;
                                    double dd;
                                    double XupS;
                                    double XlowS;
                                    double Xup;
                                    double Xlow;
                                    double YlowS;
                                    double Yup;
                                    double Ylow;
                                    double XupTic;
                                    double XlowTic;
                                    int sl;
                                    block61: {
                                        double YupS;
                                        pp = (PlotPoint)e2.nextElement();
                                        this.histoWidth = pp.getXright() - pp.getXleft();
                                        sl = (int)(da.getErrTicSize() * this.scalingFrame);
                                        if (this.histoWidth / 2.0 < (double)sl) {
                                            sl = 0;
                                        }
                                        float size = da.getSymbolSize() * this.scalingFrame;
                                        XlowTic = pp.getX() - (double)sl;
                                        if (XlowTic <= cXmin) {
                                            XlowTic = pp.getX();
                                        }
                                        if ((XupTic = pp.getX() + (double)sl) >= cXmax) {
                                            XupTic = pp.getX();
                                        }
                                        if ((Ylow = pp.getYlower()) > cYmin) {
                                            Ylow = cYmin - 1.0;
                                        }
                                        if (Ylow < cYmax) {
                                            Ylow = cYmax + 1.0;
                                        }
                                        if ((Yup = pp.getYupper()) < cYmax) {
                                            Yup = cYmax + 1.0;
                                        }
                                        if ((YlowS = pp.getYlowerSys()) > cYmin) {
                                            YlowS = cYmin - 1.0;
                                        }
                                        if ((YupS = pp.getYupperSys()) < cYmax) {
                                            YupS = cYmax + 1.0;
                                        }
                                        if ((Xlow = pp.getXleft()) < cXmin) {
                                            Xlow = cXmin + 1.0;
                                        }
                                        if ((Xup = pp.getXright()) > cXmax) {
                                            Xup = cXmax - 1.0;
                                        }
                                        if ((XlowS = pp.getXleftSys()) < cXmin) {
                                            XlowS = cXmin + 1.0;
                                        }
                                        if ((XupS = pp.getXrightSys()) > cXmax) {
                                            XupS = cXmax - 1.0;
                                        }
                                        if (da.drawSymbol() && i % da.getPointFrequency() == 0) {
                                            g2.setStroke((Stroke)lineSolidStroke);
                                            if (da.getErrorsY()) {
                                                g2.setPaint((Paint)da.getColorErrorsY());
                                                g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErr() * this.scalingFrame));
                                                g2.drawLine(pp.getX(), Ylow, pp.getX(), pp.getY() + 0.5 * (double)size);
                                                if (da.getErrorsFill()) {
                                                    this.xpolDW[i - 1] = (int)pp.getX();
                                                    this.ypolDW[i - 1] = (int)Ylow;
                                                }
                                                g2.drawLine(pp.getX(), pp.getY() - 0.5 * (double)size, pp.getX(), Yup);
                                                if (da.getErrorsFill()) {
                                                    this.xpolUP[i - 1] = (int)pp.getX();
                                                    this.ypolUP[i - 1] = (int)Yup;
                                                }
                                                g2.drawLine(XlowTic, Ylow, XupTic, Ylow);
                                                g2.drawLine(XlowTic, Yup, XupTic, Yup);
                                            }
                                            if (da.getErrorsSysY()) {
                                                g2.setPaint((Paint)da.getColorErrorsSysY());
                                                g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * this.scalingFrame));
                                                g2.drawLine(pp.getX(), YlowS, pp.getX(), Ylow);
                                                if (da.getErrorsFillSys()) {
                                                    this.xpolDWsys[i - 1] = (int)pp.getX();
                                                    this.ypolDWsys[i - 1] = (int)YlowS;
                                                }
                                                g2.drawLine(pp.getX(), Yup, pp.getX(), YupS);
                                                if (da.getErrorsFillSys()) {
                                                    this.xpolUPsys[i - 1] = (int)pp.getX();
                                                    this.ypolUPsys[i - 1] = (int)YupS;
                                                }
                                            }
                                            if (da.getErrorsX()) {
                                                g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErr() * this.scalingFrame));
                                                g2.setPaint((Paint)da.getColorErrorsX());
                                                g2.drawLine(Xlow, pp.getY(), pp.getX() - 0.5 * (double)size, pp.getY());
                                                g2.drawLine(pp.getX() + 0.5 * (double)size, pp.getY(), Xup, pp.getY());
                                                g2.drawLine(Xlow, pp.getY() - (double)sl, Xlow, pp.getY() + (double)sl);
                                                g2.drawLine(Xup, pp.getY() - (double)sl, Xup, pp.getY() + (double)sl);
                                            }
                                            if (da.getErrorsSysX()) {
                                                g2.setPaint((Paint)da.getColorErrorsSysX());
                                                g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * this.scalingFrame));
                                                g2.drawLine(XlowS, pp.getY(), Xlow, pp.getY());
                                                g2.drawLine(Xup, pp.getY(), XupS, pp.getY());
                                            }
                                            g2.setStroke((Stroke)new BasicStroke(da.getPenWidth() * this.scalingFrame));
                                            g2.setPaint((Paint)da.getColor());
                                            GPoints.drawPointType(da.getSymbol(), (Graphics2D)g2, pp.getX(), pp.getY(), size);
                                        }
                                        g2.setStroke((Stroke)lineSolidStroke);
                                        if (da.getGraphStyle() != 2) break block61;
                                        g2.drawLine(pp.getX(), pp.getY(), pp.getX(), zeroY);
                                        break block62;
                                    }
                                    if (da.getGraphStyle() != 1) break block63;
                                    double xlow = pp.getXleft();
                                    double xup = pp.getXright();
                                    double hW = this.histoWidth;
                                    if (xlow < cXmin) {
                                        dd = cXmin - xlow;
                                        xlow = cXmin;
                                        hW = this.histoWidth - dd;
                                    }
                                    if (xup > cXmax) {
                                        dd = xup - cXmax;
                                        xup = cXmax;
                                        hW = this.histoWidth - dd;
                                    }
                                    if ((xlow_prev = prev.getXleft()) < cXmin) {
                                        double dd2 = cXmin - xlow_prev;
                                        xlow_prev = cXmin;
                                        hW = this.histoWidth - dd2;
                                    }
                                    if ((xup_prev = prev.getXright()) > cXmax) {
                                        double dd3 = xup_prev - cXmax;
                                        xup_prev = cXmax;
                                        hW = this.histoWidth - dd3;
                                    }
                                    g2.setStroke((Stroke)lineSolidStroke);
                                    if (da.getDashLength() > 0.0f) {
                                        g2.setStroke((Stroke)lineStroke);
                                    }
                                    if (da.fill()) {
                                        g2.setPaint((Paint)da.getFillColor());
                                        AlphaComposite c = AlphaComposite.getInstance(3, da.getFillColorTransparency());
                                        g2.setComposite((Composite)c);
                                        g2.fillRect(xlow, pp.getY(), this.histoWidth, cYmin - pp.getY());
                                        AlphaComposite c1 = AlphaComposite.getInstance(3, 1.0f);
                                        g2.setComposite((Composite)c1);
                                    }
                                    if (da.isBarShown()) {
                                        this.rect.setRect(xlow, pp.getY(), this.histoWidth, cYmin - pp.getY());
                                        g2.setStroke((Stroke)lineSolidStroke);
                                        g2.setColor(da.getColor());
                                        g2.draw((Shape)this.rect);
                                    }
                                    g2.setPaint((Paint)da.getColor());
                                    g2.drawLine(xlow, pp.getY(), xup, pp.getY());
                                    if (i > 1) {
                                        g2.drawLine(xlow, prev.getY(), xlow, pp.getY());
                                        if (xlow - xup_prev > 0.05) {
                                            g2.drawLine(xup_prev, prev.getY(), xup_prev, cYmin);
                                            g2.drawLine(xlow, pp.getY(), xlow, cYmin);
                                        }
                                    }
                                    if (i == 1) {
                                        g2.drawLine(xlow, cYmin, xlow, pp.getY());
                                    }
                                    if (i == points.size()) {
                                        g2.drawLine(xup, cYmin, xup, pp.getY());
                                    }
                                    if (da.getErrorsY()) {
                                        g2.setPaint((Paint)da.getColorErrorsY());
                                        g2.drawLine(pp.getX(), Ylow, pp.getX(), Yup);
                                        if (da.getErrorsFill()) {
                                            this.xpolDW[i - 1] = (int)pp.getX();
                                            this.ypolDW[i - 1] = (int)Ylow;
                                            this.xpolUP[i - 1] = (int)pp.getX();
                                            this.ypolUP[i - 1] = (int)Yup;
                                        }
                                        g2.drawLine(XlowTic, Ylow, XupTic, Ylow);
                                        g2.drawLine(XlowTic, Yup, XupTic, Yup);
                                    }
                                    if (da.getErrorsSysY()) {
                                        g2.setPaint((Paint)da.getColorErrorsSysY());
                                        g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * this.scalingFrame));
                                        g2.drawLine(pp.getX(), YlowS, pp.getX(), Ylow);
                                        g2.drawLine(pp.getX(), Ylow, pp.getX(), YlowS);
                                    }
                                    if (da.getErrorsX()) {
                                        g2.setPaint((Paint)da.getColorErrorsX());
                                        g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErr() * this.scalingFrame));
                                        g2.drawLine(Xlow, pp.getY(), Xup, pp.getY());
                                        g2.drawLine(Xlow, pp.getY() - (double)sl, Xlow, pp.getY() + (double)sl);
                                        g2.drawLine(Xup, pp.getY() - (double)sl, Xup, pp.getY() + (double)sl);
                                    }
                                    if (da.getErrorsSysX()) {
                                        g2.setPaint((Paint)da.getColorErrorsSysX());
                                        g2.setStroke((Stroke)new BasicStroke(da.getPenWidthErrSys() * this.scalingFrame));
                                        g2.drawLine(XlowS, pp.getY(), Xlow, pp.getY());
                                        g2.drawLine(Xup, pp.getY(), XupS, pp.getY());
                                    }
                                    break block62;
                                }
                                if (i <= 1 || !da.drawLine() || prev.liftPen()) break block62;
                                g2.setStroke((Stroke)lineStroke);
                                if (!(da.getDashLength() > 0.0f) || da.getType() != 101 && da.getType() != 102) break block64;
                                minDist = Math.sqrt((pp.getX() - prev.getX()) * (pp.getX() - prev.getX()) + (pp.getY() - prev.getY()) * (pp.getY() - prev.getY()));
                                if (da.getType() != 101) break block65;
                                if (minDist < (double)(da.getDashLength() * 2.0f)) break block66;
                                g2.drawLine(prev.getX(), prev.getY(), pp.getX(), pp.getY());
                            }
                            if (da.getType() != 102 || !((dashCounter1 += minDist) > (double)(da.getDashLength() * 2.0f))) break block62;
                            g2.drawLine(prev.getX(), prev.getY(), pp.getX(), pp.getY());
                            dashCounter2 += minDist;
                            if (!(dashCounter2 > (double)(da.getDashLength() * 2.0f))) break block62;
                            dashCounter1 = 0.0;
                            dashCounter2 = 0.0;
                            break block66;
                        }
                        g2.drawLine(prev.getX(), prev.getY(), pp.getX(), pp.getY());
                    }
                    prev = pp;
                }
                ++i;
            }
            int NP = 2 * this.NtotPoly + 1;
            if (da.getErrorsFillSys()) {
                cold = g2.getColor();
                Composite com_old = g2.getComposite();
                g2.setColor(da.getColorErrorsFillSys());
                AlphaComposite c = AlphaComposite.getInstance(3, da.getErrorFillColorTranspSys());
                g2.setComposite((Composite)c);
                int[] xpol = new int[NP];
                ypol = new int[NP];
                for (int m2 = 0; m2 < this.NtotPoly; ++m2) {
                    xpol[m2] = this.xpolUPsys[m2];
                    ypol[m2] = this.ypolUPsys[m2];
                }
                int mm = this.NtotPoly;
                for (m = this.NtotPoly - 1; m >= 0; --m) {
                    xpol[mm] = this.xpolDWsys[m];
                    ypol[mm] = this.ypolDWsys[m];
                    ++mm;
                }
                xpol[this.NtotPoly * 2] = xpol[0];
                ypol[this.NtotPoly * 2] = ypol[0];
                for (m = 1; m < NP; ++m) {
                }
                g2.fillPolygon(xpol, ypol, NP);
                g2.setComposite(com_old);
                g2.setColor(cold);
            }
            if (!da.getErrorsFill()) continue;
            cold = g2.getColor();
            Composite com_old = g2.getComposite();
            g2.setColor(da.getColorErrorsFill());
            AlphaComposite c = AlphaComposite.getInstance(3, da.getErrorFillColorTransp());
            g2.setComposite((Composite)c);
            int[] xpol = new int[NP];
            ypol = new int[NP];
            for (int m3 = 0; m3 < this.NtotPoly; ++m3) {
                xpol[m3] = this.xpolUP[m3];
                ypol[m3] = this.ypolUP[m3];
            }
            int mm = this.NtotPoly;
            for (m = this.NtotPoly - 1; m >= 0; --m) {
                xpol[mm] = this.xpolDW[m];
                ypol[mm] = this.ypolDW[m];
                ++mm;
            }
            xpol[this.NtotPoly * 2] = xpol[0];
            ypol[this.NtotPoly * 2] = ypol[0];
            for (m = 1; m < NP; ++m) {
            }
            g2.fillPolygon(xpol, ypol, NP);
            g2.setComposite(com_old);
            g2.setColor(cold);
        }
        if (this.gs.gridToFront()) {
            this.drawGrid(g2);
        }
        g2.setStroke((Stroke)new BasicStroke(this.gs.getPenWidthAxis() * this.scalingFrame));
        this.drawMargins(g2);
        this.plotAxes(g2);
        if (this.gs.primitivesToFront()) {
            this.plotPrimitives(g2);
        }
        this.plotLabels(g2);
        if (this.gs.drawLegend()) {
            int k = 0;
            g2.setFont(this.scaleFont(this.gs.getLegendFont()));
            Enumeration e2 = this.data.elements();
            while (e2.hasMoreElements()) {
                DataArray da = (DataArray)e2.nextElement();
                if (!da.drawLegend()) {
                    --k;
                } else {
                    g2.setColor(da.getColor());
                    if (da.drawLine()) {
                        g2.setStroke((Stroke)da.getStroke());
                    }
                    this.drawLegend(g2, da, k);
                }
                ++k;
            }
        }
        g2.setStroke((Stroke)new BasicStroke());
    }

    private boolean inRange(double x, double y) {
        return !(x < this.leftMargin || x > this.leftMargin + this.axisLength[0] || y < this.topMargin) && !(y > this.topMargin + this.axisLength[1]);
    }
}

