/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BasicStroke;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import jplot.LinePars;
import jplot.PlotPoint;
import jplot.Utils;

public class DataArray
extends LinePars
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int file;
    protected int dimension;
    protected String title = " ";
    protected int col = 0;
    protected double mean = 0.0;
    protected int Ntot = 0;
    protected Vector<PlotPoint> points;
    protected double[] maxValue = new double[2];
    protected double[] minValue = new double[2];
    protected double[] lowestNonZeroValue = new double[2];

    public DataArray() {
        this(-1, -1);
    }

    public DataArray(int file, int col) {
        this(file, col, 0);
    }

    public DataArray(int file, int col, int n) {
        this.file = file;
        this.col = col;
        this.allocate(n);
    }

    public DataArray(int file, int col, int n, LinePars lp) {
        super(lp);
        this.file = file;
        this.col = col;
        this.allocate(n);
    }

    public DataArray(int file, LinePars lp) {
        super(lp);
        this.file = file;
        this.allocate(0);
    }

    public void allocate(int n) {
        if (n < 10) {
            n = 10;
        }
        this.points = new Vector(n, 10);
        for (int k = 0; k < 2; ++k) {
            this.maxValue[k] = -1.0E300;
            this.minValue[k] = 1.0E300;
            this.lowestNonZeroValue[k] = 1.0E300;
        }
    }

    public void updateMinMax(double x, double y) {
        if (x > this.maxValue[0]) {
            this.maxValue[0] = x;
        }
        if (x < this.minValue[0]) {
            this.minValue[0] = x;
        }
        if (x < this.lowestNonZeroValue[0] && x > 0.0) {
            this.lowestNonZeroValue[0] = x;
        }
        if (y > this.maxValue[1]) {
            this.maxValue[1] = y;
        }
        if (y < this.minValue[1]) {
            this.minValue[1] = y;
        }
        if (y < this.lowestNonZeroValue[1] && y > 0.0) {
            this.lowestNonZeroValue[1] = y;
        }
    }

    public void updateMinMax(double x, double y, double left, double right, double upper, double lower) {
        if (x + right > this.maxValue[0]) {
            this.maxValue[0] = x + right;
        }
        if (x - left < this.minValue[0]) {
            this.minValue[0] = x - left;
        }
        if (x - left < this.lowestNonZeroValue[0] && x - left > 0.0) {
            this.lowestNonZeroValue[0] = x - left;
        }
        if (y + upper > this.maxValue[1]) {
            this.maxValue[1] = y + upper;
        }
        if (y - lower < this.minValue[1]) {
            this.minValue[1] = y - lower;
        }
        if (y - lower < this.lowestNonZeroValue[1] && y - lower > 0.0) {
            this.lowestNonZeroValue[1] = y - lower;
        }
    }

    public void updateMinMax(double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        if (x + right + right_sys > this.maxValue[0]) {
            this.maxValue[0] = x + right + right_sys;
        }
        if (x - left - left_sys < this.minValue[0]) {
            this.minValue[0] = x - left - left_sys;
        }
        if (x - left - left_sys < this.lowestNonZeroValue[0] && x - left - left_sys > 0.0) {
            this.lowestNonZeroValue[0] = x - left - left_sys;
        }
        if (y + upper + upper_sys > this.maxValue[1]) {
            this.maxValue[1] = y + upper + upper_sys;
        }
        if (y - lower - lower_sys < this.minValue[1]) {
            this.minValue[1] = y - lower - lower_sys;
        }
        if (y - lower - lower_sys < this.lowestNonZeroValue[1] && y - lower - lower_sys > 0.0) {
            this.lowestNonZeroValue[1] = y - lower - lower_sys;
        }
    }

    public void updateMean(double x, double y) {
        this.mean += x;
        ++this.Ntot;
    }

    public double mean() {
        return this.mean / (double)this.Ntot;
    }

    public void addPoint(double x, double y) {
        y *= (double)this.multiplier;
        this.updateMinMax(x, y += (double)this.additioner);
        this.updateMean(x, y);
        this.points.add(new PlotPoint(x, y));
    }

    public void addPoint(double x, double y, double upper, double lower) {
        y *= (double)this.multiplier;
        upper *= (double)this.multiplier;
        lower *= (double)this.multiplier;
        this.updateMinMax(x, y += (double)this.additioner, 0.0, 0.0, upper += (double)this.additioner, lower += (double)this.additioner);
        this.updateMean(x, y);
        this.points.add(new PlotPoint(x, y, upper, lower));
    }

    public void addPoint(double x, double y, double left, double right, double upper, double lower) {
        y *= (double)this.multiplier;
        upper *= (double)this.multiplier;
        lower *= (double)this.multiplier;
        this.updateMinMax(x, y += (double)this.additioner, left, right, upper += (double)this.additioner, lower += (double)this.additioner);
        this.updateMean(x, y);
        this.points.add(new PlotPoint(x, y, left, right, upper, lower));
    }

    public void addPoint(double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        y *= (double)this.multiplier;
        y += (double)this.additioner;
        upper *= (double)this.multiplier;
        lower *= (double)this.multiplier;
        upper_sys *= (double)this.multiplier;
        lower_sys *= (double)this.multiplier;
        this.updateMinMax(x, y, left, right, upper += (double)this.additioner, lower += (double)this.additioner, left_sys, right_sys, upper_sys += (double)this.additioner, lower_sys += (double)this.additioner);
        this.updateMean(x, y);
        this.points.add(new PlotPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys));
    }

    public void addPoint(double x, double y, boolean liftPen) {
        y *= (double)this.multiplier;
        this.updateMinMax(x, y += (double)this.additioner);
        this.updateMean(x, y);
        this.points.add(new PlotPoint(x, y, liftPen));
    }

    public void setPoint(int i, double x, double y) {
        if (i >= 0 && i < this.points.size()) {
            this.updateMinMax(x, y);
            this.points.add(i, new PlotPoint(x, y));
        }
    }

    public void setPoint(int i, double x, double y, double upper, double lower) {
        if (i >= 0 && i < this.points.size()) {
            this.updateMinMax(x, y, 0.0, 0.0, upper, lower);
            this.points.add(i, new PlotPoint(x, y, upper, lower));
        }
    }

    public void setPoint(int i, double x, double y, double left, double right, double upper, double lower) {
        if (i >= 0 && i < this.points.size()) {
            this.updateMinMax(x, y, left, right, upper, lower);
            this.points.add(i, new PlotPoint(x, y, left, right, upper, lower));
        }
    }

    public void setPoint(int i, double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        if (i >= 0 && i < this.points.size()) {
            this.updateMinMax(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys);
            this.points.add(i, new PlotPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys));
        }
    }

    public void replacePoint(int i, double x, double y, double left, double right, double upper, double lower, double left_sys, double right_sys, double upper_sys, double lower_sys) {
        if (i >= 0 && i < this.points.size()) {
            this.points.set(i, new PlotPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys));
        }
    }

    public void allUpdate() {
        this.maxValue[0] = 0.0;
        this.minValue[0] = 0.0;
        this.lowestNonZeroValue[0] = 0.0;
        this.maxValue[1] = 0.0;
        this.minValue[1] = 0.0;
        this.lowestNonZeroValue[1] = 0.0;
        this.mean = 0.0;
        for (int i = 0; i < this.points.size(); ++i) {
            this.updateMinMax(this.getX(i), this.getY(i), this.getXleft(i), this.getXright(i), this.getYupper(i), this.getYlower(i), this.getXleftSys(i), this.getXrightSys(i), this.getYupperSys(i), this.getYlowerSys(i));
            this.updateMean(this.getX(i), this.getY(i));
        }
    }

    public PlotPoint getPoint(int i) {
        if (i >= 0 && i < this.points.size()) {
            return this.points.get(i);
        }
        return null;
    }

    public void setLiftPen(int i) {
        if (i >= 0 && i < this.points.size()) {
            this.points.get(i).setLiftPen(true);
        }
    }

    public boolean liftPen(int i) {
        return this.points.get(i).liftPen();
    }

    public int size() {
        return this.points.size();
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public Vector getData() {
        return this.points;
    }

    public double getX(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getX();
        }
        return 1.0E300;
    }

    public double getXleft(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getXleft();
        }
        return 1.0E300;
    }

    public double getXright(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getXright();
        }
        return 1.0E300;
    }

    public double getXleftSys(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getXleftSys();
        }
        return 1.0E300;
    }

    public double getXrightSys(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getXrightSys();
        }
        return 1.0E300;
    }

    public double getY(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getY();
        }
        return 1.0E300;
    }

    public double getYupper(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getYupper();
        }
        return 1.0E300;
    }

    public double getYlower(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getYlower();
        }
        return 1.0E300;
    }

    public double getYupperSys(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getYupperSys();
        }
        return 1.0E300;
    }

    public double getYlowerSys(int i) {
        if (i >= 0 && i < this.size()) {
            return this.points.get(i).getYlowerSys();
        }
        return 1.0E300;
    }

    public double getMaxValue(int axis) {
        return this.maxValue[axis];
    }

    public double getMinValue(int axis) {
        return this.minValue[axis];
    }

    public double getLowestNonZeroValue(int axis) {
        return this.lowestNonZeroValue[axis];
    }

    public BasicStroke getStroke() {
        float[] dash = new float[]{this.dashLength, this.dashLength};
        if (this.dashLength == 0.0f) {
            return new BasicStroke(this.penWidth);
        }
        return new BasicStroke(this.penWidth, 0, 2, 0.0f, dash, 0.0f);
    }

    public void setLinePars(LinePars l) {
        this.copy(l);
    }

    public LinePars getLinePars() {
        LinePars gg = new LinePars();
        return gg;
    }

    public int getFileIndex() {
        return this.file;
    }

    public int getColumnIndex() {
        return this.col;
    }

    public void clear() {
        if (this.points.size() > 0) {
            this.Ntot = 0;
            this.points.removeAllElements();
            for (int k = 0; k < 2; ++k) {
                this.maxValue[k] = -1.0E300;
                this.minValue[k] = 1.0E300;
                this.lowestNonZeroValue[k] = 1.0E300;
            }
        }
    }

    public void sort(boolean ascending) {
        if (ascending) {
            // empty if block
        }
    }

    public void toFile(String name, String title) {
        DecimalFormat dfb = new DecimalFormat("##.########E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        int dim = this.getDimension();
        this.title = title;
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# " + Integer.toString(dim));
            tx.println("# jhplot: output data from P1D:" + title);
            tx.println("# jhplot: created at " + today);
            tx.println("# x,y,x(left),x(right),y(upper),y(lower),x(leftSys),x(rightSys),y(upperSys),y(lowerSys)");
            tx.println("#");
            for (int i = 0; i < this.size(); ++i) {
                String x2;
                String x1;
                String y1;
                String y;
                String x;
                if (dim == 2) {
                    x = dfb.format(this.getX(i));
                    y = dfb.format(this.getY(i));
                    tx.println(x + "  " + y);
                    continue;
                }
                if (dim == 3) {
                    x = dfb.format(this.getX(i));
                    y = dfb.format(this.getY(i));
                    y1 = dfb.format(this.getYupper(i));
                    tx.println(x + " " + y + " " + y1);
                    continue;
                }
                if (dim == 4) {
                    x = dfb.format(this.getX(i));
                    y = dfb.format(this.getY(i));
                    y1 = dfb.format(this.getYupper(i));
                    String y2 = dfb.format(this.getYlower(i));
                    tx.println(x + " " + y + " " + y1 + " " + y2);
                    continue;
                }
                if (dim == 6) {
                    x = dfb.format(this.getX(i));
                    y = dfb.format(this.getY(i));
                    x1 = dfb.format(this.getXleft(i));
                    x2 = dfb.format(this.getXright(i));
                    String y12 = dfb.format(this.getYupper(i));
                    String y2 = dfb.format(this.getYlower(i));
                    tx.println(x + " " + y + " " + x1 + " " + x2 + " " + y12 + " " + y2);
                    continue;
                }
                x = dfb.format(this.getX(i));
                y = dfb.format(this.getY(i));
                x1 = dfb.format(this.getXleft(i));
                x2 = dfb.format(this.getXright(i));
                String x3 = dfb.format(this.getXleftSys(i));
                String x4 = dfb.format(this.getXrightSys(i));
                String y13 = dfb.format(this.getYupper(i));
                String y2 = dfb.format(this.getYlower(i));
                String y3 = dfb.format(this.getYupperSys(i));
                String y4 = dfb.format(this.getYlowerSys(i));
                tx.println(x + " " + y + " " + x1 + " " + x2 + " " + y13 + " " + y2 + " " + x3 + " " + x4 + " " + y3 + " " + y4);
            }
            f1.close();
        }
        catch (IOException e) {
            System.out.println("Error in the output file");
            e.printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean parse(File file) {
        boolean res = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            res = this.parse(in);
            if (!res) {
                return false;
            }
        }
        catch (IOException e) {
            Utils.oops(null, "Can't parse data file " + file.toString());
            return false;
        }
        return true;
    }

    public boolean parse(BufferedReader in) {
        this.clear();
        try {
            String s;
            while ((s = in.readLine()) != null) {
                int ncount;
                if ((s = s.trim()).length() < 1 || s.startsWith("#") || s.startsWith("*")) continue;
                StringTokenizer st = new StringTokenizer(s);
                this.dimension = ncount = st.countTokens();
                String[] sword = new String[ncount];
                double[] snum = new double[ncount];
                int mm = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(tmp.trim());
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error in reading the line " + Integer.toString(mm + 1));
                    }
                    snum[mm] = dd;
                    ++mm;
                }
                if (ncount == 2) {
                    this.addPoint(snum[0], snum[1]);
                    continue;
                }
                if (ncount == 3) {
                    this.addPoint(snum[0], snum[1], snum[2], snum[2]);
                    continue;
                }
                if (ncount == 4) {
                    this.addPoint(snum[0], snum[1], snum[2], snum[3]);
                    continue;
                }
                if (ncount == 6) {
                    this.addPoint(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5]);
                    continue;
                }
                this.addPoint(snum[0], snum[1], snum[2], snum[3], snum[4], snum[5], snum[6], snum[7], snum[8], snum[9]);
            }
        }
        catch (IOException e) {
            Utils.oops(null, "Can't parse data from BufferedReader");
            return false;
        }
        return true;
    }

    @Override
    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        String tmp = "#\n";
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        String br = "\n";
        tmp = tmp + "# jhplot: output data: " + this.title + br;
        tmp = tmp + "# jhplot: created at " + today + br;
        tmp = tmp + "# x,y,x(left),x(right),y(upper),y(lower),x(leftSys),x(rightSys),y(upperSys),y(lowerSys)" + br;
        tmp = tmp + "#" + br;
        for (int i = 0; i < this.size(); ++i) {
            String x = dfb.format(this.getX(i));
            String y = dfb.format(this.getY(i));
            String x1 = dfb.format(this.getXleft(i));
            String x2 = dfb.format(this.getXright(i));
            String x3 = dfb.format(this.getXleftSys(i));
            String x4 = dfb.format(this.getXrightSys(i));
            String y1 = dfb.format(this.getYupper(i));
            String y2 = dfb.format(this.getYlower(i));
            String y3 = dfb.format(this.getYupperSys(i));
            String y4 = dfb.format(this.getYlowerSys(i));
            tmp = tmp + x + "  " + y + "  " + x1 + "  " + x2 + "  " + y1 + "  " + y2 + "  " + x3 + "  " + x4 + "  " + y3 + "  " + y4 + br;
        }
        return tmp;
    }
}

