/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import jhplot.v3d.Vector3d;

class BoundingBox {
    Vector3d min;
    Vector3d max;

    BoundingBox(Vector3d[] vert, int nvert) {
        float zmin;
        float ymin;
        float xmin;
        if (nvert <= 0) {
            return;
        }
        Vector3d v = vert[0];
        float xmax = xmin = v.x;
        float ymax = ymin = v.y;
        float zmax = zmin = v.z;
        for (int i = 1; i < nvert; ++i) {
            float z;
            float y;
            v = vert[i];
            float x = v.x;
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if ((y = v.y) < ymin) {
                ymin = y;
            }
            if (y > ymax) {
                ymax = y;
            }
            if ((z = v.x) < zmin) {
                zmin = z;
            }
            if (!(z > zmax)) continue;
            zmax = z;
        }
        this.min = new Vector3d(xmin, ymin, zmin);
        this.max = new Vector3d(xmax, ymax, zmax);
    }

    void combine(BoundingBox bb) {
        Vector3d v = bb.min;
        if (v.x < this.min.x) {
            this.min.x = v.x;
        }
        if (v.y < this.min.y) {
            this.min.y = v.y;
        }
        if (v.z < this.min.z) {
            this.min.z = v.z;
        }
        v = bb.max;
        if (v.x > this.max.x) {
            this.max.x = v.x;
        }
        if (v.y > this.max.y) {
            this.max.y = v.y;
        }
        if (v.z > this.max.z) {
            this.max.z = v.z;
        }
    }

    Vector3d getCenter() {
        float xmid = (this.min.x + this.max.x) / 2.0f;
        float ymid = (this.min.y + this.max.y) / 2.0f;
        float zmid = (this.min.z + this.max.z) / 2.0f;
        return new Vector3d(xmid, ymid, zmid);
    }

    float getWidth() {
        return this.max.x - this.min.x;
    }

    float getHeight() {
        return this.max.y - this.min.y;
    }

    float getDepth() {
        return this.max.z - this.min.z;
    }
}

