/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.applet.Applet;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import jhplot.v3d.Model3d;

public abstract class Animation
extends Applet
implements Runnable {
    private static final long serialVersionUID = 1L;
    Thread thread = null;
    boolean threadSuspended = false;
    Model3d md = null;
    Image backBuffer = null;
    Graphics backGC = null;
    int delay = 0;
    static final boolean showFPS = true;
    static final boolean debug = false;
    boolean painted;

    @Override
    public void init() {
        try {
            this.delay = Integer.valueOf(this.getParameter("sleep"));
        }
        catch (Exception e) {
            this.delay = 0;
        }
    }

    @Override
    public void start() {
        if (this.thread == null) {
            this.threadSuspended = false;
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    @Override
    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
        this.md = null;
        this.backBuffer = null;
        this.backGC = null;
    }

    @Override
    public void update(Graphics g) {
        if (this.backBuffer == null) {
            g.clearRect(0, 0, this.size().width, this.size().height);
        }
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.md != null) {
            if (this.backBuffer != null) {
                this.backGC.setColor(this.getBackground());
                this.backGC.fillRect(0, 0, this.size().width, this.size().height);
                this.md.paint(this.backGC);
                g.drawImage(this.backBuffer, 0, 0, this);
            } else {
                this.md.paint(g);
            }
        }
        this.setPainted();
    }

    synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    synchronized void waitPainted() {
        while (!this.painted) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.painted = false;
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        if (this.thread != null) {
            if (this.threadSuspended) {
                this.thread.resume();
            } else {
                this.thread.suspend();
            }
            this.threadSuspended = !this.threadSuspended;
        }
        return true;
    }

    abstract Model3d createModel();

    @Override
    public void run() {
        this.md = this.createModel();
        this.backBuffer = this.createImage(this.size().width, this.size().height);
        this.backGC = this.backBuffer.getGraphics();
        long frame = 0L;
        long startTime = System.currentTimeMillis();
        while (this.thread != null) {
            this.repaint();
            this.waitPainted();
            if (++frame % 100L == 0L) {
                long currentTime = System.currentTimeMillis();
                long dt = currentTime - startTime;
                if (dt > 0L) {
                    int fps = (int)(100000L / dt);
                    this.showStatus("FPS " + fps);
                }
                startTime = currentTime;
            }
            if (this.delay <= 0) continue;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

