/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import jhplot.gui.HelpBrowser;

public class Statistics {
    protected static final double MACHEP = (double)1.110223E-16f;
    protected static final double MAXLOG = 709.782712893384;
    protected static final double MINLOG = -745.1332191019412;
    protected static final double MAXGAM = 171.6243769563027;
    protected static final double SQTPI = 2.5066282746310007;
    protected static final double SQRTH = 0.7071067811865476;
    protected static final double LOGPI = 1.1447298858494002;
    protected static final double big = 4.503599627370496E15;
    protected static final double biginv = 2.220446049250313E-16;

    public static double mean(double[] v) {
        double mean = 0.0;
        int m = v.length;
        for (int i = 0; i < m; ++i) {
            mean += v[i];
        }
        return mean /= (double)m;
    }

    public static double[] mean(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] mean = new double[n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                mean[n2] = mean[n2] + v[i][j];
            }
        }
        int j = 0;
        while (j < n) {
            int n3 = j++;
            mean[n3] = mean[n3] / (double)m;
        }
        return mean;
    }

    public static double stddeviation(double[] v) {
        return Math.sqrt(Statistics.variance(v));
    }

    public static double variance(double[] v) {
        int k;
        int degrees = v.length - 1;
        int m = v.length;
        double c = 0.0;
        double s = 0.0;
        for (k = 0; k < m; ++k) {
            s += v[k];
        }
        s /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (v[k] - s) * (v[k] - s);
        }
        double var = c / (double)degrees;
        return var;
    }

    public static double[] stddeviation(double[][] v) {
        double[] var = Statistics.variance(v);
        for (int i = 0; i < var.length; ++i) {
            var[i] = Math.sqrt(var[i]);
        }
        return var;
    }

    public static double[] variance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] var = new double[n];
        int degrees = m - 1;
        for (int j = 0; j < n; ++j) {
            int k;
            double c = 0.0;
            double s = 0.0;
            for (k = 0; k < m; ++k) {
                s += v[k][j];
            }
            s /= (double)m;
            for (k = 0; k < m; ++k) {
                c += (v[k][j] - s) * (v[k][j] - s);
            }
            var[j] = c / (double)degrees;
        }
        return var;
    }

    public static double covariance(double[] v1, double[] v2) {
        int k;
        int m = v1.length;
        int degrees = m - 1;
        double c = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        for (k = 0; k < m; ++k) {
            s1 += v1[k];
            s2 += v2[k];
        }
        s1 /= (double)m;
        s2 /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (v1[k] - s1) * (v2[k] - s2);
        }
        double X = c / (double)degrees;
        return X;
    }

    public static double[][] covariance(double[][] v1, double[][] v2) {
        int m = v1.length;
        int n1 = v1[0].length;
        int n2 = v2[0].length;
        double[][] X = new double[n1][n2];
        int degrees = m - 1;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v1[k][i];
                    s2 += v2[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v1[k][i] - s1) * (v2[k][j] - s2);
                }
                X[i][j] = c / (double)degrees;
            }
        }
        return X;
    }

    public static double[][] covariance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[][] X = new double[n][n];
        int degrees = m - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v[k][i];
                    s2 += v[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v[k][i] - s1) * (v[k][j] - s2);
                }
                X[i][j] = c / (double)degrees;
            }
        }
        return X;
    }

    public static double correlation(double[] v1, double[] v2) {
        return Statistics.covariance(v1, v2) / Math.sqrt(Statistics.variance(v1) * Statistics.variance(v2));
    }

    public static double[][] correlation(double[][] v1, double[][] v2) {
        double[] Varv1 = Statistics.variance(v1);
        double[] Varv2 = Statistics.variance(v2);
        double[][] cov = Statistics.covariance(v1, v2);
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov[i].length; ++j) {
                cov[i][j] = cov[i][j] / Math.sqrt(Varv1[i] * Varv2[j]);
            }
        }
        return cov;
    }

    public static double[][] correlation(double[][] v) {
        int j;
        int i;
        int m = v.length;
        int n = v[0].length;
        double[][] X = new double[n][n];
        double[][] V = new double[n][n];
        int degrees = m - 1;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v[k][i];
                    s2 += v[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v[k][i] - s1) * (v[k][j] - s2);
                }
                V[i][j] = c / (double)degrees;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                X[i][j] = V[i][j] / Math.sqrt(V[i][i] * V[j][j]);
            }
        }
        return X;
    }

    public static double FProbability(double F2, int df1, int df2) {
        return Statistics.incompleteBeta((double)df2 / 2.0, (double)df1 / 2.0, (double)df2 / ((double)df2 + (double)df1 * F2));
    }

    public static double incompleteBeta(double aa, double bb, double xx) {
        double x;
        double xc;
        double b;
        double a;
        if (aa <= 0.0 || bb <= 0.0) {
            System.err.println("ibeta: Domain error!");
            return 0.0;
        }
        if (xx <= 0.0 || xx >= 1.0) {
            if (xx == 0.0) {
                return 0.0;
            }
            if (xx == 1.0) {
                return 1.0;
            }
            System.err.println("ibeta: Domain error!");
        }
        boolean flag = false;
        if (bb * xx <= 1.0 && xx <= 0.95) {
            double t = Statistics.powerSeries(aa, bb, xx);
            return t;
        }
        double w = 1.0 - xx;
        if (xx > aa / (aa + bb)) {
            flag = true;
            a = bb;
            b = aa;
            xc = xx;
            x = w;
        } else {
            a = aa;
            b = bb;
            xc = w;
            x = xx;
        }
        if (flag && b * x <= 1.0 && x <= 0.95) {
            double t = Statistics.powerSeries(a, b, x);
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            return t;
        }
        double y = x * (a + b - 2.0) - (a - 1.0);
        w = y < 0.0 ? Statistics.incompleteBetaFraction1(a, b, x) : Statistics.incompleteBetaFraction2(a, b, x) / xc;
        y = a * Math.log(x);
        double t = b * Math.log(xc);
        if (a + b < 171.6243769563027 && Math.abs(y) < 709.782712893384 && Math.abs(t) < 709.782712893384) {
            t = Math.pow(xc, b);
            t *= Math.pow(x, a);
            t /= a;
            t *= w;
            t *= Statistics.gamma(a + b) / (Statistics.gamma(a) * Statistics.gamma(b));
            if (flag) {
                t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            }
            return t;
        }
        y += t + Statistics.lnGamma(a + b) - Statistics.lnGamma(a) - Statistics.lnGamma(b);
        t = (y += Math.log(w / a)) < -745.1332191019412 ? 0.0 : Math.exp(y);
        if (flag) {
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
        }
        return t;
    }

    public static double powerSeries(double a, double b, double x) {
        double v;
        double ai = 1.0 / a;
        double u = (1.0 - b) * x;
        double t1 = v = u / (a + 1.0);
        double t = u;
        double n = 2.0;
        double s = 0.0;
        double z = (double)1.110223E-16f * ai;
        while (Math.abs(v) > z) {
            u = (n - b) * x / n;
            v = (t *= u) / (a + n);
            s += v;
            n += 1.0;
        }
        s += t1;
        s += ai;
        u = a * Math.log(x);
        if (a + b < 171.6243769563027 && Math.abs(u) < 709.782712893384) {
            t = Statistics.gamma(a + b) / (Statistics.gamma(a) * Statistics.gamma(b));
            s = s * t * Math.pow(x, a);
        } else {
            t = Statistics.lnGamma(a + b) - Statistics.lnGamma(a) - Statistics.lnGamma(b) + u + Math.log(s);
            s = t < -745.1332191019412 ? 0.0 : Math.exp(t);
        }
        return s;
    }

    public static double lnGamma(double x) {
        double[] A = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] B = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] C = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double q = -x;
            double w = Statistics.lnGamma(q);
            double p = Math.floor(q);
            if (p == q) {
                throw new ArithmeticException("lnGamma: Overflow");
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                throw new ArithmeticException("lnGamma: Overflow");
            }
            z = 1.1447298858494002 - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    throw new ArithmeticException("lnGamma: Overflow");
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Statistics.polevl(x, B, 5) / Statistics.p1evl(x, C, 6);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            throw new ArithmeticException("lnGamma: Overflow");
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Statistics.polevl(p, A, 4) / x);
        return q;
    }

    public static double p1evl(double x, double[] coef, int N) {
        double ans = x + coef[0];
        for (int i = 1; i < N; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    public static double gamma(double x) {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int i = (int)p;
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * Statistics.stirlingFormula(q));
                return -z;
            }
            return Statistics.stirlingFormula(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = Statistics.polevl(x -= 2.0, P, 6);
        q = Statistics.polevl(x, Q, 7);
        return z * p / q;
    }

    public static double stirlingFormula(double x) {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double MAXSTIR = 143.01608;
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * Statistics.polevl(w, STIR, 4);
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }

    public static double polevl(double x, double[] coef, int N) {
        double ans = coef[0];
        for (int i = 1; i <= N; ++i) {
            ans = ans * x + coef[i];
        }
        return ans;
    }

    public static double incompleteBetaFraction1(double a, double b, double x) {
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = b - 1.0;
        double k7 = k4;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = x * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 += 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 -= 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    public static double incompleteBetaFraction2(double a, double b, double x) {
        double k1 = a;
        double k2 = b - 1.0;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = a + b;
        double k7 = a + 1.0;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double z = x / (1.0 - x);
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = z * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 -= 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 += 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

