/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import jhplot.P1D;
import jhplot.gui.HelpBrowser;

public class FactorialMoments {
    private int Bins = 0;
    private double Min = 0.0;
    private int[][] ICC;
    private int Nmax;
    private int[] IBI;
    private double[] BI;
    private int[][][] IH;
    private int[][][] CM;
    private int Nev = 0;
    private int[][] IL;
    private int[][] ILE;
    private int IMAX = 0;
    private double[][] FA;
    private double[][] FAA;
    private double[][] EA;
    private double[][] EAA;

    public FactorialMoments(int NmaxOrder, int Bins, int step, double Min, double Max) {
        int i;
        int n;
        int i2;
        this.Nmax = NmaxOrder;
        this.Bins = Bins;
        this.Min = Min;
        this.Nmax = 5;
        if (Bins < 2) {
            System.out.println("Number of bins should be larger than 2");
            return;
        }
        if (this.Nmax < 2) {
            System.out.println("Order if BP should be larger than 2");
            return;
        }
        if (this.Nmax > 10) {
            System.out.println("The factorial moment order cannot be larger than 10 (not implemented!)");
            return;
        }
        this.IBI = new int[Bins];
        for (i2 = 0; i2 < Bins; ++i2) {
            this.IBI[i2] = 1 + i2 * step;
        }
        this.IMAX = this.IBI[Bins - 1];
        this.BI = new double[Bins];
        for (i2 = 0; i2 < Bins; ++i2) {
            this.BI[i2] = (Max - Min) / (double)this.IBI[i2];
        }
        this.ICC = new int[Bins][this.IMAX];
        this.IH = new int[this.Nmax][Bins][this.IMAX];
        this.CM = new int[this.Nmax][Bins][this.IMAX];
        this.IL = new int[this.Nmax][Bins];
        this.ILE = new int[this.Nmax][Bins];
        this.Nev = 0;
        for (n = 0; n < this.Nmax; ++n) {
            for (i = 0; i < Bins; ++i) {
                for (int j = 0; j < this.IBI[i]; ++j) {
                    this.IH[n][i][j] = 0;
                }
            }
        }
        for (n = 0; n < this.Nmax; ++n) {
            for (i = 0; i < Bins; ++i) {
                this.IL[n][i] = 0;
                this.ILE[n][i] = 0;
            }
        }
    }

    public void run(double[] v) {
        int i;
        int n;
        int j;
        int i2;
        ++this.Nev;
        for (i2 = 0; i2 < this.Bins; ++i2) {
            for (j = 0; j < this.IBI[i2]; ++j) {
                this.ICC[i2][j] = 0;
            }
        }
        for (i2 = 0; i2 < this.Bins; ++i2) {
            for (j = 0; j < this.IBI[i2]; ++j) {
                double m1 = this.Min + this.BI[i2] * (double)j;
                double m2 = this.Min + this.BI[i2] * (double)(j + 1);
                for (int m = 0; m < v.length; ++m) {
                    if (!(v[m] > m1) || !(v[m] < m2)) continue;
                    int[] nArray = this.ICC[i2];
                    int n2 = j;
                    nArray[n2] = nArray[n2] + 1;
                }
            }
        }
        for (i2 = 0; i2 < this.Bins; ++i2) {
            for (j = 0; j < this.IBI[i2]; ++j) {
                this.IH[0][i2][j] = this.ICC[i2][j];
                this.IH[1][i2][j] = this.ICC[i2][j] * (this.ICC[i2][j] - 1);
                if (this.Nmax > 2) {
                    this.IH[2][i2][j] = this.IH[1][i2][j] * (this.ICC[i2][j] - 2);
                }
                if (this.Nmax > 3) {
                    this.IH[3][i2][j] = this.IH[2][i2][j] * (this.ICC[i2][j] - 3);
                }
                if (this.Nmax > 4) {
                    this.IH[4][i2][j] = this.IH[3][i2][j] * (this.ICC[i2][j] - 4);
                }
                if (this.Nmax > 5) {
                    this.IH[5][i2][j] = this.IH[4][i2][j] * (this.ICC[i2][j] - 5);
                }
                if (this.Nmax > 6) {
                    this.IH[6][i2][j] = this.IH[5][i2][j] * (this.ICC[i2][j] - 6);
                }
                if (this.Nmax > 7) {
                    this.IH[7][i2][j] = this.IH[6][i2][j] * (this.ICC[i2][j] - 7);
                }
                if (this.Nmax > 8) {
                    this.IH[8][i2][j] = this.IH[7][i2][j] * (this.ICC[i2][j] - 8);
                }
                if (this.Nmax <= 9) continue;
                this.IH[9][i2][j] = this.IH[8][i2][j] * (this.ICC[i2][j] - 9);
            }
        }
        for (n = 0; n < this.Nmax; ++n) {
            for (i = 0; i < this.Bins; ++i) {
                for (int j2 = 0; j2 < this.IBI[i]; ++j2) {
                    this.CM[n][i][j2] = this.IH[n][i][j2] * this.IH[n][i][j2];
                }
            }
        }
        for (n = 0; n < this.Nmax; ++n) {
            for (i = 0; i < this.Bins; ++i) {
                for (int j3 = 0; j3 < this.IBI[i]; ++j3) {
                    this.IL[n][i] = this.IL[n][i] + this.IH[n][i][j3];
                    this.ILE[n][i] = this.ILE[n][i] + this.CM[n][i][j3];
                }
            }
        }
    }

    public boolean eval() {
        int i;
        int n;
        boolean tmp = true;
        double AN = this.Nev;
        for (n = 0; n < this.Nmax; ++n) {
            for (i = 0; i < this.Bins; ++i) {
                for (int j = 0; j < this.IBI[i]; ++j) {
                    this.IL[n][i] = this.IL[n][i] + this.IH[n][i][j];
                    this.ILE[n][i] = this.ILE[n][i] + this.CM[n][i][j];
                }
                this.IL[n][i] = this.IL[n][i] / this.IBI[i];
                this.ILE[n][i] = this.ILE[n][i] / this.IBI[i];
            }
        }
        this.FA = new double[this.Nmax][this.Bins];
        this.FAA = new double[this.Nmax][this.Bins];
        this.EA = new double[this.Nmax][this.Bins];
        this.EAA = new double[this.Nmax][this.Bins];
        for (n = 0; n < this.Nmax; ++n) {
            for (i = 0; i < this.Bins; ++i) {
                this.FA[n][i] = (double)this.IL[n][i] / AN;
                this.EA[n][i] = (double)this.ILE[n][i] / AN;
            }
        }
        for (n = 1; n < this.Nmax; ++n) {
            for (i = 0; i < this.Bins; ++i) {
                this.FAA[n][i] = this.FA[n][i] / Math.pow(this.FA[0][i], n + 1);
            }
        }
        for (n = 1; n < this.Nmax; ++n) {
            int iipp = (n + 1) * 2;
            for (int i2 = 0; i2 < this.Bins; ++i2) {
                double DWA = this.EA[n][i2] - this.FA[n][i2] * this.FA[n][i2];
                double DWAA = Math.pow(this.FA[0][i2], iipp);
                if (DWA < 0.0) {
                    DWA = 0.1;
                    tmp = false;
                }
                double RED = DWAA * (AN - 1.0);
                this.EAA[n][i2] = Math.sqrt(DWA / RED);
            }
        }
        return tmp;
    }

    public P1D getNFM(int order) {
        if (order > this.Nmax) {
            System.out.println("NFM order is larger then allowed max 8");
            return null;
        }
        if (order < 2) {
            System.out.println("NFM order is too small");
            return null;
        }
        P1D pp = new P1D("NFM_{" + Integer.toString(order) + "}");
        for (int i = 1; i < this.Bins; ++i) {
            pp.add(this.IBI[i], this.FAA[order - 1][i], this.EAA[order - 1][i]);
        }
        return pp;
    }

    public P1D getFM(int order) {
        if (order > this.Nmax) {
            System.out.println("FM order is larger then allowed max 8");
            return null;
        }
        if (order < 2) {
            System.out.println("FM order is too small");
            return null;
        }
        P1D pp = new P1D("F_{" + Integer.toString(order) + "}");
        for (int i = 0; i < this.Bins; ++i) {
            pp.add(this.IBI[i], this.FA[order - 1][i], this.EA[order - 1][i]);
        }
        return pp;
    }

    public P1D getAv() {
        P1D pp = new P1D("average multiplicity");
        for (int i = 0; i < this.Bins; ++i) {
            pp.add(this.IBI[i], this.FA[0][i], this.EA[0][i]);
        }
        return pp;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

