/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Vector;
import jhplot.stat.Statistics;

public class Anova {
    protected double[][] data;
    protected double p;
    protected double f;
    protected int dof1;
    protected int dof2;

    public Anova(double[][] p_data) {
        int i;
        this.data = p_data;
        double s_between = 0.0;
        double s_residual = 0.0;
        double[] all_means = new double[p_data.length];
        double overall_mean = 0.0;
        int total_size = 0;
        int[] all_sizes = new int[p_data.length];
        Arrays.fill(all_means, 0.0);
        Arrays.fill(all_sizes, 0);
        for (i = 0; i < p_data.length; ++i) {
            int j;
            if (p_data == null) {
                System.out.println("pdata null");
            }
            if (p_data[i] == null) {
                System.out.println("pdata[" + i + "] null");
            }
            all_sizes[i] = p_data[i].length;
            total_size += all_sizes[i];
            for (j = 0; j < p_data[i].length; ++j) {
                if (!Double.isNaN(p_data[i][j])) {
                    int n = i;
                    all_means[n] = all_means[n] + p_data[i][j] / (double)all_sizes[i];
                }
                overall_mean += p_data[i][j];
            }
            for (j = 0; j < p_data[i].length; ++j) {
                if (Double.isNaN(p_data[i][j])) continue;
                s_residual += Math.pow(p_data[i][j] - all_means[i], 2.0);
            }
        }
        overall_mean /= (double)total_size;
        for (i = 0; i < p_data.length; ++i) {
            s_between += (double)all_sizes[i] * Math.pow(all_means[i] - overall_mean, 2.0);
        }
        this.dof1 = p_data.length - 1;
        this.dof2 = total_size - p_data.length;
        this.f = s_between / (double)this.dof1 / (s_residual / (double)this.dof2);
        this.p = Statistics.FProbability(this.f, this.dof1, this.dof2);
    }

    public void printData() {
        System.out.println("---------------------------------------");
        DecimalFormat df = new DecimalFormat("0.0000");
        Vector<Double> all_data = new Vector<Double>();
        for (int i = 0; i < this.data.length; ++i) {
            System.out.print(df.format(Statistics.mean(this.data[i])) + " " + df.format(Math.sqrt(Statistics.variance(this.data[i]))) + " |");
            for (int j = 0; j < this.data[i].length; ++j) {
                if (Double.isNaN(this.data[i][j])) continue;
                System.out.print(" " + df.format(this.data[i][j]));
                all_data.add(new Double(this.data[i][j]));
            }
            System.out.println();
        }
        System.out.println("  -------------------");
        double[] vall_data = new double[all_data.size()];
        for (int i = 0; i < all_data.size(); ++i) {
            vall_data[i] = (Double)all_data.elementAt(i);
        }
        System.out.println(df.format(Statistics.mean(vall_data)) + " " + df.format(Math.sqrt(Statistics.variance(vall_data))) + " |");
        System.out.println("-----------------------------------------");
    }

    public void printResults() {
        System.out.println("F=" + this.getF() + " DOF1=" + this.getDOF1() + " DOF2=" + this.getDOF2() + " P=" + this.getP());
    }

    public double getP() {
        return this.p;
    }

    public double getF() {
        return this.f;
    }

    public int getDOF1() {
        return this.dof1;
    }

    public int getDOF2() {
        return this.dof2;
    }

    public double[] getMeans() {
        double[] means = new double[this.data.length];
        for (int i = 0; i < means.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                if (Double.isNaN(this.data[i][j])) continue;
                int n = i;
                means[n] = means[n] + this.data[i][j];
            }
            int n = i;
            means[n] = means[n] / (double)this.data[i].length;
        }
        return means;
    }

    private static String makeMatlab(double[][] m) {
        StringBuffer mat = new StringBuffer("a = [");
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                mat.append(i + " " + m[i][j] + "; ");
            }
        }
        mat.append("];\n");
        mat.append("anova1(a(:,2)',a(:,1)')");
        return mat.toString();
    }

    private static void test() {
        double[][] i_data = new double[][]{{5.83E-4}, {1.17E-4, 0.001011, 1.9E-4, 0.003418, 4.45E-4, 4.72E-4, 7.942658E-5, 1.861884E-5, 7.19E-4, 3.86E-4, 3.4E-4, 9.94E-4, 0.001243, 4.81E-4, 0.001052}, {2.71E-4, 6.3E-4, 1.95E-4, 3.091709E-5, 0.001265, 0.001154, 0.001111, 0.001169, 9.82E-4, 0.009851, 2.14E-4, 3.18E-4, 5.65E-4, 0.004859, 0.006513, 0.007501, 0.010925, 6.53E-4, 6.87E-4, 1.808875E-5, 4.0E-4, 1.02E-4, 1.22E-4, 0.00731, 3.29E-4, 7.38E-4, 2.32E-4, 3.17E-4, 1.04E-4, 1.87E-4, 9.65759E-5, 8.779085E-5, 2.67E-4, 6.66E-4, 2.13E-4, 0.001207, 5.800928E-5, 1.46E-4, 2.1E-4, 0.0, 4.213974E-5, 2.96E-4, 7.076694E-5, 4.51E-4, 2.0E-4, 0.004935, 0.003804, 8.63E-4, 5.67E-4, 7.37E-4, 6.31E-4, 0.003083, 3.57E-4, 0.001986, 4.35E-4, 0.003722, 9.99448E-5, 4.48E-4, 0.001421, 0.024937, 4.04E-4, 1.92E-4, 4.56E-4, 5.722088E-5, 0.0025, 1.47E-4, 0.003904, 0.001772}, {0.001321, 1.56E-4, 2.353968E-5, 9.92E-4, 5.76E-4, 1.557194E-5, 0.002012, 5.01E-4, 5.27E-4}, {5.87E-4, 2.24E-4, 2.0E-4, 4.83E-4, 5.8E-4, 3.929909E-5, 0.002227, 5.43E-4, 3.626242E-5, 2.24E-4, 2.56E-4, 2.3E-4, 5.26E-4, 0.002585}};
        Anova an = new Anova(i_data);
        System.out.println(an.getP());
        an.printData();
        an.printResults();
        System.out.println(Anova.makeMatlab(i_data));
    }

    private static void hotDogTest() {
        double[][] i_data = new double[4][];
        double[] data1 = new double[]{186.0, 181.0, 176.0, 149.0, 184.0, 190.0, 158.0, 139.0, 175.0, 148.0, 152.0, 111.0, 141.0, 153.0, 190.0, 157.0, 131.0, 149.0, 135.0, 132.0};
        double[] data2 = new double[]{173.0, 191.0, 182.0, 190.0, 172.0, 147.0, 146.0, 139.0, 175.0, 136.0, 179.0, 153.0, 107.0, 195.0, 135.0, 140.0, 138.0};
        double[] data3 = new double[]{129.0, 132.0, 102.0, 106.0, 94.0, 102.0, 87.0, 99.0, 107.0, 113.0, 135.0, 142.0, 86.0, 143.0, 152.0, 146.0, 144.0};
        double[] data4 = new double[]{155.0, 170.0, 114.0, 191.0, 162.0, 146.0, 140.0, 187.0, 180.0};
        i_data[0] = data1;
        i_data[1] = data2;
        i_data[2] = data3;
        i_data[3] = data4;
        Anova an = new Anova(i_data);
        System.out.println(an.getP());
        an.printData();
        an.printResults();
        System.out.println(Anova.makeMatlab(i_data));
    }

    public static void main(String[] argv) {
        Anova.test();
    }
}

