/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca.covmatrixevd;

import Jama.Matrix;
import jhplot.math.pca.Assume;
import jhplot.math.pca.covmatrixevd.CovarianceMatrixEVDCalculator;
import jhplot.math.pca.covmatrixevd.EVD;
import jhplot.math.pca.covmatrixevd.EVDResult;

public class EVDBased
implements CovarianceMatrixEVDCalculator {
    @Override
    public EVDResult run(Matrix centeredData) {
        Matrix cov = EVDBased.calculateCovarianceMatrixOfCenteredData(centeredData);
        EVD evd = new EVD(cov);
        return new EVDResult(evd.d, evd.v);
    }

    public static Matrix calculateCovarianceMatrixOfCenteredData(Matrix data) {
        int c;
        int r;
        Assume.assume(data.getRowDimension() > 1, "Number of data samples is " + data.getRowDimension() + ", but it has to be >1 to compute covariances");
        int dimsNo = data.getColumnDimension();
        int samplesNo = data.getRowDimension();
        Matrix m = new Matrix(dimsNo, dimsNo);
        for (r = 0; r < dimsNo; ++r) {
            for (c = r; c < dimsNo; ++c) {
                double sum = 0.0;
                for (int i = 0; i < samplesNo; ++i) {
                    sum += data.get(i, r) * data.get(i, c);
                }
                m.set(r, c, sum / (double)(samplesNo - 1));
            }
        }
        for (r = 0; r < dimsNo; ++r) {
            for (c = 0; c < r; ++c) {
                m.set(r, c, m.get(c, r));
            }
        }
        return m;
    }
}

