/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.Constants;
import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;
import jhplot.math.num.special.Erf;

public class LogNormalRandomVariable
extends AbstractContinuousRandomVariable {
    private double mean;
    private double standardDeviation;

    public LogNormalRandomVariable() {
        this(0.0, 1.0);
    }

    public LogNormalRandomVariable(double m, double s) {
        this(m, s, new RandomRNG());
    }

    public LogNormalRandomVariable(double m, double s, RNG source) {
        super(source);
        this.setMean(m);
        this.setStandardDeviation(s);
    }

    public static double nextRandomVariable(double m, double s, RNG source) {
        double u = source.nextRandomNumber();
        return Math.exp(Constants.SQRT_2 * s * Erf.inverseErf(2.0 * u - 1.0) + m);
    }

    private double getMean() {
        return this.mean;
    }

    private double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double nextRandomVariable() {
        return LogNormalRandomVariable.nextRandomVariable(this.getMean(), this.getStandardDeviation(), this.getSource());
    }

    private void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("Mean must be a valid number.");
        }
        this.mean = m;
    }

    private void setStandardDeviation(double std) {
        if (std <= 0.0 || Double.isNaN(std)) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        this.standardDeviation = std;
    }
}

