/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.NumericException;
import jhplot.math.num.pdf.ContinuousDistribution;
import jhplot.math.num.pdf.Gamma;

public class ChiSquared
extends ContinuousDistribution {
    private Gamma gamma;

    public ChiSquared() {
        this(1.0);
    }

    public ChiSquared(double df) {
        this.setGamma(new Gamma(df / 2.0, 2.0));
    }

    @Override
    public double cumulativeProbability(double x) throws NumericException {
        return this.getGamma().cumulativeProbability(x);
    }

    public double getDegreesOfFreedom() {
        return this.getGamma().getAlpha() * 2.0;
    }

    private Gamma getGamma() {
        return this.gamma;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws NumericException {
        return this.getGamma().inverseCumulativeProbability(p);
    }

    public void setDegreesOfFreedom(double df) {
        this.getGamma().setAlpha(df / 2.0);
    }

    private void setGamma(Gamma g) {
        this.gamma = g;
    }
}

