/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.kalman;

import java.util.Random;
import jhplot.math.kalman.JKalman;
import jhplot.math.kalman.jama.Matrix;

public class KalmanTest {
    public static void main(String[] args) {
        try {
            JKalman kalman = new JKalman(4, 2);
            Random rand = new Random(System.currentTimeMillis() % 2011L);
            double x = 0.0;
            double y = 0.0;
            double dx = rand.nextDouble();
            double dy = rand.nextDouble();
            Matrix s = new Matrix(4, 1);
            Matrix c = new Matrix(4, 1);
            Matrix m = new Matrix(2, 1);
            m.set(0, 0, x);
            m.set(1, 0, y);
            double[][] tr = new double[][]{{1.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
            kalman.setTransition_matrix(new Matrix(tr));
            kalman.setError_cov_post(kalman.getError_cov_post().identity());
            System.out.println("first x:" + x + ", y:" + y + ", dx:" + dx + ", dy:" + dy);
            System.out.println("no; x; y; dx; dy; predictionX; predictionY; predictionDx; predictionDy; correctionX; correctionY; correctionDx; correctionDy;");
            for (int i = 0; i < 200; ++i) {
                s = kalman.Predict();
                x = rand.nextGaussian();
                y = rand.nextGaussian();
                m.set(0, 0, m.get(0, 0) + dx + rand.nextGaussian());
                m.set(1, 0, m.get(1, 0) + dy + rand.nextGaussian());
                if (rand.nextGaussian() < -0.8) {
                    System.out.println("" + i + ";;;;;" + s.get(0, 0) + ";" + s.get(1, 0) + ";" + s.get(2, 0) + ";" + s.get(3, 0) + ";");
                    continue;
                }
                c = kalman.Correct(m);
                System.out.println("" + i + ";" + m.get(0, 0) + ";" + m.get(1, 0) + ";" + x + ";" + y + ";" + s.get(0, 0) + ";" + s.get(1, 0) + ";" + s.get(2, 0) + ";" + s.get(3, 0) + ";" + c.get(0, 0) + ";" + c.get(1, 0) + ";" + c.get(2, 0) + ";" + c.get(3, 0) + ";");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

