/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jhplot.math.io.LEDataOutputStream;

public class BinaryOutputStream
extends OutputStream {
    private OutputStream stream;
    public static String LITTLE_ENDIAN = "LITTLE_ENDIAN";
    public static String BIG_ENDIAN = "BIG_ENDIAN";
    protected boolean bigEndian;

    public BinaryOutputStream(OutputStream out, String endian) {
        this.bigEndian = this.isBigEndian(endian);
        this.stream = out;
    }

    public BinaryOutputStream(OutputStream out, boolean endian) {
        this.bigEndian = endian;
        this.stream = out;
    }

    private boolean isBigEndian(String endian) {
        boolean be;
        if (endian.equals(LITTLE_ENDIAN)) {
            be = false;
        } else if (endian.equals(BIG_ENDIAN)) {
            be = true;
        } else {
            throw new IllegalArgumentException("The Endian type : " + endian + "is unknown. You must specify LITTLE_ENDIAN or BIG_ENDIAN.");
        }
        return be;
    }

    public static void writeDoubleArray(OutputStream out, double[] array, String endian) {
        BinaryOutputStream bs = new BinaryOutputStream(out, endian);
        bs.writeDoubleArray(array, false);
    }

    public static void appendDoubleArray(OutputStream out, double[] array, String endian) {
        BinaryOutputStream bs = new BinaryOutputStream(out, endian);
        bs.writeDoubleArray(array, true);
    }

    public static void writeFloatArray(OutputStream out, float[] array, String endian) {
        BinaryOutputStream bs = new BinaryOutputStream(out, endian);
        bs.writeFloatArray(array, false);
    }

    public static void appendFloatArray(OutputStream out, float[] array, String endian) {
        BinaryOutputStream bs = new BinaryOutputStream(out, endian);
        bs.writeFloatArray(array, true);
    }

    public static void writeIntArray(OutputStream out, int[] array, String endian) {
        BinaryOutputStream bs = new BinaryOutputStream(out, endian);
        bs.writeIntArray(array, false);
    }

    public static void appendIntArray(OutputStream out, int[] array, String endian) {
        BinaryOutputStream bs = new BinaryOutputStream(out, endian);
        bs.writeIntArray(array, true);
    }

    public void writeIntArray(int[] array, boolean append) {
        try {
            DataOutput dos = this.bigEndian ? new DataOutputStream(this.stream) : new LEDataOutputStream(this.stream);
            for (int i = 0; i < array.length; ++i) {
                dos.writeInt(array[i]);
            }
            this.stream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("InputStream is unwritable : " + e.toString());
        }
    }

    public void writeFloatArray(float[] array, boolean append) {
        try {
            DataOutput dos = this.bigEndian ? new DataOutputStream(this.stream) : new LEDataOutputStream(this.stream);
            for (int i = 0; i < array.length; ++i) {
                dos.writeFloat(array[i]);
            }
            this.stream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("InputStream is unwritable : " + e.toString());
        }
    }

    public void writeDoubleArray(double[] array, boolean append) {
        try {
            DataOutput dos = this.bigEndian ? new DataOutputStream(this.stream) : new LEDataOutputStream(this.stream);
            for (int i = 0; i < array.length; ++i) {
                dos.writeDouble(array[i]);
            }
            this.stream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("InputStream is unwritable : " + e.toString());
        }
    }

    public void writeByteArray(byte[] bytes, boolean append) {
        try {
            DataOutputStream dos = new DataOutputStream(this.stream);
            dos.write(bytes);
            this.stream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("InputStream is unwritable : " + e.toString());
        }
    }

    public void writeInt(int i, boolean append) {
        this.writeIntArray(new int[]{i}, append);
    }

    public void writeFloat(float f, boolean append) {
        this.writeFloatArray(new float[]{f}, append);
    }

    public void writeDouble(double d, boolean append) {
        this.writeDoubleArray(new double[]{d}, append);
    }

    public void writeByte(byte b, boolean append) {
        this.writeByteArray(new byte[]{b}, append);
    }

    @Override
    public void write(int i) {
        this.writeInt(i, false);
    }
}

