/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import java.io.Serializable;
import jhplot.HParam;

public class ValueErr
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double val = 0.0;
    private double err = 0.0;

    public ValueErr() {
        this.val = 0.0;
        this.err = 0.0;
    }

    public ValueErr(double value) {
        this.val = value;
        this.err = 0.0;
    }

    public ValueErr(double value, double error) {
        this.val = value;
        this.err = error;
    }

    public void setVal(double value) {
        this.val = value;
    }

    public void setErr(double error) {
        this.err = error;
    }

    public void reset(double value, double error) {
        this.val = value;
        this.err = error;
    }

    public double getVal() {
        return this.val;
    }

    public double getErr() {
        return this.err;
    }

    public String toString() {
        return this.val + " +- " + this.err;
    }

    public int hashCode() {
        long lvalue = Double.doubleToLongBits(this.val);
        long lerror = Double.doubleToLongBits(this.err);
        int hvalue = (int)(lvalue ^ lvalue >>> 32);
        int herror = (int)(lerror ^ lerror >>> 32);
        return 7 * (hvalue / 10) + 3 * (herror / 10);
    }

    public ValueErr[] oneDarray(int n) {
        ValueErr[] a = new ValueErr[n];
        for (int i = 0; i < n; ++i) {
            a[i] = this.zero();
        }
        return a;
    }

    public ValueErr[] oneDarray(int n, ValueErr constant) {
        ValueErr[] c = new ValueErr[n];
        for (int i = 0; i < n; ++i) {
            c[i] = ValueErr.copy(constant);
        }
        return c;
    }

    public ValueErr[][] twoDarray(int n, int m) {
        ValueErr[][] a = new ValueErr[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                a[i][j] = this.zero();
            }
        }
        return a;
    }

    public static ValueErr copy(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = a.val;
        b.err = a.err;
        return b;
    }

    public ValueErr copy() {
        ValueErr b = new ValueErr();
        b.val = this.val;
        b.err = this.err;
        return b;
    }

    public Object clone() {
        ValueErr b = new ValueErr();
        b.val = this.val;
        b.err = this.err;
        return b;
    }

    public ValueErr[] copy(ValueErr[] a) {
        int n = a.length;
        ValueErr[] b = this.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            b[i] = ValueErr.copy(a[i]);
        }
        return b;
    }

    public ValueErr[][] copy(ValueErr[][] a) {
        int n = a.length;
        int m = a[0].length;
        ValueErr[][] b = this.twoDarray(n, m);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                b[i][j] = ValueErr.copy(a[i][j]);
            }
        }
        return b;
    }

    public ValueErr minus(ValueErr a, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = this.val - a.val;
        c.err = this.hypWithCovariance(this.err, a.err, -corrCoeff);
        return c;
    }

    public ValueErr minus(ValueErr a, ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = a.val - b.val;
        c.err = this.hypWithCovariance(a.err, b.err, -corrCoeff);
        return c;
    }

    public ValueErr minus(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = this.val - a.val;
        b.err = this.hypWithCovariance(a.err, this.err, 0.0);
        return b;
    }

    public ValueErr minus(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a.val - b.val;
        c.err = this.hypWithCovariance(a.err, b.err, 0.0);
        return c;
    }

    public ValueErr minus(double a) {
        ValueErr b = new ValueErr();
        b.val = this.val - a;
        b.err = Math.abs(this.err);
        return b;
    }

    public ValueErr minus(double a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a - b.val;
        c.err = Math.abs(b.err);
        return c;
    }

    public ValueErr minus(double a, double b) {
        ValueErr c = new ValueErr();
        c.val = a - b;
        c.err = 0.0;
        return c;
    }

    public void minusEquals(ValueErr a, double corrCoeff) {
        this.val -= a.val;
        this.err = this.hypWithCovariance(a.err, this.err, -corrCoeff);
    }

    public void minusEquals(ValueErr a) {
        this.val -= a.val;
        this.err = this.hypWithCovariance(a.err, this.err, 0.0);
    }

    public void minusEquals(double a) {
        this.val -= a;
        this.err = Math.abs(this.err);
    }

    public ValueErr plus(ValueErr a, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = a.val + this.val;
        c.err = this.hypWithCovariance(a.err, this.err, corrCoeff);
        return c;
    }

    public ValueErr plus(ValueErr a, ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = a.val + b.val;
        c.err = this.hypWithCovariance(a.err, b.err, corrCoeff);
        return c;
    }

    public ValueErr plus(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = this.val + a.val;
        b.err = this.hypWithCovariance(a.err, this.err, 0.0);
        return b;
    }

    public ValueErr plus(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a.val + b.val;
        c.err = this.hypWithCovariance(a.err, b.err, 0.0);
        return c;
    }

    public ValueErr plus(double a) {
        ValueErr b = new ValueErr();
        b.val = this.val + a;
        b.err = Math.abs(this.err);
        return b;
    }

    public ValueErr plus(double a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a + b.val;
        c.err = Math.abs(b.err);
        return c;
    }

    public ValueErr plus(double a, double b) {
        ValueErr c = new ValueErr();
        c.val = a + b;
        c.err = 0.0;
        return c;
    }

    public void plusEquals(ValueErr a, double corrCoeff) {
        this.val += a.val;
        this.err = this.hypWithCovariance(a.err, this.err, corrCoeff);
    }

    public void plusEquals(ValueErr a) {
        this.val += a.val;
        this.err = Math.sqrt(a.err * a.err + this.err * this.err);
        this.err = this.hypWithCovariance(a.err, this.err, 0.0);
    }

    public void plusEquals(double a) {
        this.val += a;
        this.err = Math.abs(this.err);
    }

    public ValueErr times(ValueErr a, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = a.val * this.val;
        c.err = a.val == 0.0 ? a.err * this.val : (this.val == 0.0 ? this.err * a.val : Math.abs(c.val) * this.hypWithCovariance(a.err / a.val, this.err / this.val, corrCoeff));
        return c;
    }

    public ValueErr times(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = this.val * a.val;
        b.err = a.val == 0.0 ? a.err * this.val : (this.val == 0.0 ? this.err * a.val : Math.abs(b.val) * this.hypWithCovariance(a.err / a.val, this.err / this.val, 0.0));
        return b;
    }

    public ValueErr times(double a) {
        ValueErr b = new ValueErr();
        b.val = this.val * a;
        b.err = Math.abs(this.err * a);
        return b;
    }

    public ValueErr times(ValueErr a, ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = a.val * b.val;
        c.err = a.val == 0.0 ? a.err * b.val : (b.val == 0.0 ? b.err * a.val : Math.abs(c.val) * this.hypWithCovariance(a.err / a.val, b.err / b.val, corrCoeff));
        return c;
    }

    public ValueErr times(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a.val * b.val;
        c.err = a.val == 0.0 ? a.err * b.val : (b.val == 0.0 ? b.err * a.val : Math.abs(c.val) * this.hypWithCovariance(a.err / a.val, b.err / b.val, 0.0));
        return c;
    }

    public ValueErr times(double a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a * b.val;
        c.err = Math.abs(a * b.err);
        return c;
    }

    public ValueErr times(double a, double b) {
        ValueErr c = new ValueErr();
        c.val = a * b;
        c.err = 0.0;
        return c;
    }

    public void timesEquals(ValueErr a, double corrCoeff) {
        ValueErr b = new ValueErr();
        b.val = this.val * a.val;
        b.err = a.val == 0.0 ? a.err * this.val : (this.val == 0.0 ? this.err * a.val : Math.abs(b.val) * this.hypWithCovariance(a.err / a.val, this.err / this.val, corrCoeff));
        this.val = b.val;
        this.err = b.err;
    }

    public void timesEquals(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = this.val * a.val;
        b.err = a.val == 0.0 ? a.err * this.val : (this.val == 0.0 ? this.err * a.val : Math.abs(b.val) * this.hypWithCovariance(a.err / a.val, this.err / this.val, 0.0));
        this.val = b.val;
        this.err = b.err;
    }

    public void timesEquals(double a) {
        this.val *= a;
        this.err = Math.abs(this.err * a);
    }

    public ValueErr divide(ValueErr a, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = this.val / a.val;
        c.err = this.val == 0.0 ? this.err * a.val : Math.abs(c.val) * this.hypWithCovariance(this.err / this.val, a.err / a.val, -corrCoeff);
        return c;
    }

    public ValueErr divide(ValueErr a, ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = a.val / b.val;
        c.err = a.val == 0.0 ? a.err * b.val : Math.abs(c.val) * this.hypWithCovariance(a.err / a.val, b.err / b.val, -corrCoeff);
        return c;
    }

    public ValueErr divide(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = this.val / a.val;
        b.err = Math.abs(b.val) * this.hypWithCovariance(a.err / a.val, this.err / this.val, 0.0);
        b.err = this.val == 0.0 ? this.err * b.val : Math.abs(b.val) * this.hypWithCovariance(a.err / a.val, this.err / this.val, 0.0);
        return b;
    }

    public ValueErr divide(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a.val / b.val;
        c.err = a.val == 0.0 ? a.err * b.val : Math.abs(c.val) * this.hypWithCovariance(a.err / a.val, b.err / b.val, 0.0);
        return c;
    }

    public ValueErr divide(double a) {
        ValueErr b = new ValueErr();
        b.val = this.val / a;
        b.err = Math.abs(this.err / a);
        return b;
    }

    public ValueErr divide(double a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = a / b.val;
        c.err = Math.abs(a * b.err / (b.val * b.val));
        return c;
    }

    public ValueErr divide(double a, double b) {
        ValueErr c = new ValueErr();
        c.val = a / b;
        c.err = 0.0;
        return c;
    }

    public void divideEqual(ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = this.val / b.val;
        c.err = this.val == 0.0 ? this.err * b.val : Math.abs(c.val) * this.hypWithCovariance(this.err / this.val, b.err / b.val, 0.0);
        this.val = c.val;
        this.err = c.err;
    }

    public void divideEqual(ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = this.val / b.val;
        c.err = this.val == 0.0 ? this.err * b.val : Math.abs(c.val) * this.hypWithCovariance(this.err / this.val, b.err / b.val, -corrCoeff);
        this.val = c.val;
        this.err = c.err;
    }

    public void divideEqual(double a) {
        this.val /= a;
        this.err = Math.abs(this.err / a);
    }

    public ValueErr inverse() {
        ValueErr b = this.divide(1.0, this);
        return b;
    }

    public ValueErr inverse(ValueErr a) {
        ValueErr b = this.divide(1.0, a);
        return b;
    }

    public ValueErr hypotenuse(ValueErr a, ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = this.hypotenuse(a.val, b.val);
        c.err = Math.abs(this.hypWithCovariance(a.err * a.val, b.err * b.val, corrCoeff) / c.val);
        return c;
    }

    public double hypotenuse(double aa, double bb) {
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }

    public ValueErr hypot(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = this.hypotenuse(a.val, b.val);
        c.err = Math.abs(this.hypWithCovariance(a.err * a.val, b.err * b.val, 0.0) / c.val);
        return c;
    }

    public ValueErr exp(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = Math.exp(a.val);
        b.err = Math.abs(b.val * a.err);
        return b;
    }

    public ValueErr log(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.log(a.val) : Math.log(a.val);
        b.err = Math.abs(a.err / a.val);
        return b;
    }

    public ValueErr log10(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.log10(a.val) : this.log10(a.val);
        b.err = Math.abs(a.err / (a.val * Math.log(10.0)));
        return b;
    }

    public double log10(double a) {
        return Math.log(a) / Math.log(10.0);
    }

    public ValueErr sqrt(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.sqrt(a.val) : Math.sqrt(a.val);
        b.err = Math.abs(a.err / (2.0 * a.val));
        return b;
    }

    public ValueErr nRoot(ValueErr a, int n) {
        if (n == 0) {
            throw new ArithmeticException("Division by zero (n = 0 - infinite root)");
        }
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.pow(a.val, 1 / n) : Math.pow(a.val, 1 / n);
        b.err = Math.abs(a.err * Math.pow(a.val, 1 / n - 1) / (double)n);
        return b;
    }

    public ValueErr square() {
        ValueErr a = new ValueErr(this.val, this.err);
        return a.times(a, 1.0);
    }

    public ValueErr square(ValueErr a) {
        return a.times(a, 1.0);
    }

    public ValueErr pow(ValueErr a, double b) {
        ValueErr c = new ValueErr();
        c.val = HParam.isMath() ? Math.pow(a.val, b) : Math.pow(a.val, b);
        c.err = Math.abs(b * Math.pow(a.val, b - 1.0));
        return c;
    }

    public ValueErr pow(double a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = HParam.isMath() ? Math.pow(a, b.val) : Math.pow(a, b.val);
        c.err = Math.abs(c.val * Math.log(a) * b.err);
        return c;
    }

    public ValueErr pow(ValueErr a, ValueErr b, double corrCoeff) {
        ValueErr c = new ValueErr();
        c.val = HParam.isMath() ? Math.pow(a.val, b.val) : Math.pow(a.val, b.val);
        c.err = this.hypWithCovariance(a.err * b.val * Math.pow(a.val, b.val - 1.0), b.err * Math.log(a.val) * Math.pow(a.val, b.val), corrCoeff);
        return c;
    }

    public ValueErr pow(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        c.val = HParam.isMath() ? Math.pow(a.val, b.val) : Math.pow(a.val, b.val);
        c.err = this.hypWithCovariance(a.err * b.val * Math.pow(a.val, b.val - 1.0), b.err * Math.log(a.val) * Math.pow(a.val, b.val), 0.0);
        return c;
    }

    public ValueErr sin(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.sin(a.val) : Math.sin(a.val);
        b.err = Math.abs(a.err * Math.cos(a.val));
        return b;
    }

    public ValueErr cos(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.cos(a.val) : Math.cos(a.val);
        b.err = Math.abs(a.err * Math.sin(a.val));
        return b;
    }

    public ValueErr tan(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.tan(a.val) : Math.tan(a.val);
        b.err = Math.abs(a.err * this.square(this.sec(a.val)));
        return b;
    }

    public double sec(double a) {
        return 1.0 / Math.cos(a);
    }

    public double square(double a) {
        return a * a;
    }

    public ValueErr sinh(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.sinh(a.val) : Math.sinh(a.val);
        b.err = Math.abs(a.err * Math.cosh(a.val));
        return b;
    }

    public ValueErr cosh(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.cosh(a.val) : Math.cosh(a.val);
        b.err = Math.abs(a.err * Math.sinh(a.val));
        return b;
    }

    public ValueErr tanh(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.tanh(a.val) : Math.tanh(a.val);
        b.err = Math.abs(a.err * this.square(this.sech(a.val)));
        return b;
    }

    public double sech(double a) {
        return 1.0 / Math.cosh(a);
    }

    public ValueErr asin(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.asin(a.val) : Math.asin(a.val);
        b.err = Math.abs(a.err / Math.sqrt(1.0 - a.val * a.val));
        return b;
    }

    public ValueErr acos(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.acos(a.val) : Math.acos(a.val);
        b.err = Math.abs(a.err / Math.sqrt(1.0 - a.val * a.val));
        return b;
    }

    public ValueErr atan(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = HParam.isMath() ? Math.atan(a.val) : Math.atan(a.val);
        b.err = Math.abs(a.err / (1.0 + a.val * a.val));
        return b;
    }

    public ValueErr atan2(ValueErr a, ValueErr b) {
        ValueErr c = new ValueErr();
        ValueErr d = a.divide(b);
        c.val = Math.atan2(a.val, b.val);
        c.err = Math.abs(d.err / (1.0 + d.val * d.val));
        return c;
    }

    public ValueErr atan2(ValueErr a, ValueErr b, double rho) {
        ValueErr c = new ValueErr();
        ValueErr d = a.divide(b, rho);
        c.val = HParam.isMath() ? Math.atan2(a.val, b.val) : Math.atan2(a.val, b.val);
        c.err = Math.abs(d.err / (1.0 + d.val * d.val));
        return c;
    }

    public ValueErr asinh(ValueErr a) {
        ValueErr b = new ValueErr();
        b.val = this.asinh(a.val);
        b.err = Math.abs(a.err / Math.sqrt(a.val * a.val + 1.0));
        return b;
    }

    public double asinh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return sgn * Math.log(a + Math.sqrt(a * a + 1.0));
    }

    public ValueErr zero() {
        ValueErr c = new ValueErr();
        c.val = 0.0;
        c.err = 0.0;
        return c;
    }

    public double sign(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public double hypWithCovariance(double a, double b, double r) {
        double pre = 0.0;
        double ratio = 0.0;
        double sgn = 0.0;
        if (a == 0.0 && b == 0.0) {
            return 0.0;
        }
        if (Math.abs(a) > Math.abs(b)) {
            pre = Math.abs(a);
            ratio = b / a;
            sgn = this.sign(a);
        } else {
            pre = Math.abs(b);
            ratio = a / b;
            sgn = this.sign(b);
        }
        return pre * Math.sqrt(1.0 + ratio * (ratio + 2.0 * r * sgn));
    }
}

