/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import java.util.Random;

public class Poisson {
    private double elambda;
    private Random rand;

    public Poisson(Random rand, double lambda) {
        this.elambda = Math.exp(-lambda);
        this.rand = rand;
    }

    public Poisson(double lambda) {
        this.elambda = Math.exp(-lambda);
        this.rand = new Random();
    }

    public Poisson(long seed, double lambda) {
        this.elambda = Math.exp(-lambda);
        this.rand = new Random(seed);
    }

    public int next() {
        int count = 0;
        int result = 0;
        for (double product = 1.0; product >= this.elambda; product *= this.rand.nextDouble()) {
            result = count++;
        }
        return result;
    }

    public int next(double lambda) {
        int count = 0;
        int result = 0;
        this.elambda = Math.exp(-lambda);
        for (double product = 1.0; product >= this.elambda; product *= this.rand.nextDouble()) {
            result = count++;
        }
        return result;
    }

    public static final void main(String[] args) {
        int size = 10;
        Poisson test = new Poisson(2.5);
        int total = 0;
        for (int line = 0; line < size; ++line) {
            for (int col = 0; col < size; ++col) {
                int next = test.next();
                total += next;
                System.out.printf("%d ", next);
            }
            System.out.println();
        }
        System.out.printf("%nThe actual mean arrival time is %.4f%n", (double)total / (double)(size * size));
    }
}

