/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

public final class ArrayMath {
    private ArrayMath() {
    }

    public static int[] copy(int[] array) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static long[] copy(long[] array) {
        long[] result = new long[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static float[] copy(float[] array) {
        float[] result = new float[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static double[] copy(double[] array) {
        double[] result = new double[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static float[] toFloat(double[] v) {
        float[] ans = new float[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (float)v[k];
        }
        return ans;
    }

    public static float[] toFloat(long[] v) {
        float[] ans = new float[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = v[k];
        }
        return ans;
    }

    public static float[] toFloat(int[] v) {
        float[] ans = new float[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = v[k];
        }
        return ans;
    }

    public static boolean isSquare(double[][] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == a.length) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(float[][] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == a.length) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(long[][] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == a.length) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(int[][] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == a.length) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(Object[][] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == a.length) continue;
            return false;
        }
        return true;
    }

    public static float[][] toFloat(double[][] v) {
        float[][] ans = new float[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toFloat(v[k]);
        }
        return ans;
    }

    public static float[][] toFloat(long[][] v) {
        float[][] ans = new float[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toFloat(v[k]);
        }
        return ans;
    }

    public static float[][] toFloat(int[][] v) {
        float[][] ans = new float[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toFloat(v[k]);
        }
        return ans;
    }

    public static double[] toDouble(float[] v) {
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = v[k];
        }
        return ans;
    }

    public static double[] toDouble(long[] v) {
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = v[k];
        }
        return ans;
    }

    public static double[] toDouble(int[] v) {
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = v[k];
        }
        return ans;
    }

    public static double[][] toDouble(float[][] v) {
        double[][] ans = new double[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toDouble(v[k]);
        }
        return ans;
    }

    public static double[][] toDouble(long[][] v) {
        double[][] ans = new double[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toDouble(v[k]);
        }
        return ans;
    }

    public static double[][] toDouble(int[][] v) {
        double[][] ans = new double[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toDouble(v[k]);
        }
        return ans;
    }

    public static long[] toLong(double[] v) {
        long[] ans = new long[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (long)v[k];
        }
        return ans;
    }

    public static long[] toLong(float[] v) {
        long[] ans = new long[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (long)v[k];
        }
        return ans;
    }

    public static long[] toLong(int[] v) {
        long[] ans = new long[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = v[k];
        }
        return ans;
    }

    public static long[][] toLong(float[][] v) {
        long[][] ans = new long[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toLong(v[k]);
        }
        return ans;
    }

    public static long[][] toLong(double[][] v) {
        long[][] ans = new long[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toLong(v[k]);
        }
        return ans;
    }

    public static long[][] toLong(int[][] v) {
        long[][] ans = new long[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toLong(v[k]);
        }
        return ans;
    }

    public static int[] toInt(double[] v) {
        int[] ans = new int[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (int)v[k];
        }
        return ans;
    }

    public static int[] toInt(float[] v) {
        int[] ans = new int[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (int)v[k];
        }
        return ans;
    }

    public static int[] toInt(long[] v) {
        int[] ans = new int[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (int)v[k];
        }
        return ans;
    }

    public static int[][] toInt(float[][] v) {
        int[][] ans = new int[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toInt(v[k]);
        }
        return ans;
    }

    public static int[][] toInt(double[][] v) {
        int[][] ans = new int[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toInt(v[k]);
        }
        return ans;
    }

    public static int[][] toInt(long[][] v) {
        int[][] ans = new int[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.toInt(v[k]);
        }
        return ans;
    }

    public static double[] normalize(double[] v) {
        return ArrayMath.scalarMultiply(1.0 / ArrayMath.norm(v), v);
    }

    public static double[] setLengthFromEnd(double[] data, int length) {
        double[] ans = new double[length];
        int debut = length - data.length < 0 ? data.length - length : 0;
        System.arraycopy(data, debut, ans, -data.length + length + debut, data.length - debut);
        return ans;
    }

    public static double[] setLengthFromBeginning(double[] data, int length) {
        double[] ans = new double[length];
        int debut = length - data.length < 0 ? data.length - length : 0;
        System.arraycopy(data, 0, ans, 0, data.length - debut);
        return ans;
    }

    public static double[][] copy(double[][] v) {
        double[][] ans = new double[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.copy(v[k]);
        }
        return ans;
    }

    public static double variance(double[] v) {
        if (v.length > 1) {
            double m = ArrayMath.mean(v);
            double ans = 0.0;
            for (int i = 0; i < v.length; ++i) {
                ans += (v[i] - m) * (v[i] - m);
            }
            return ans / (double)(v.length - 1);
        }
        throw new IllegalArgumentException("Array length must be of 2 or greater.");
    }

    public static double covariance(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + v1.length + ", " + v2.length);
        }
        double m1 = ArrayMath.mean(v1);
        double m2 = ArrayMath.mean(v2);
        double ans = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            ans += (v1[i] - m1) * (v2[i] - m2);
        }
        return ans / (double)(v1.length - 1);
    }

    public static double correlation(double[] v1, double[] v2) {
        double denom = Math.sqrt(ArrayMath.variance(v1) * ArrayMath.variance(v2));
        if (denom != 0.0) {
            return ArrayMath.covariance(v1, v2) / denom;
        }
        if (ArrayMath.variance(v1) == 0.0 && ArrayMath.variance(v2) == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double mean(double[] v) {
        if (v.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! The array must have at least one element.");
        }
        return ArrayMath.mass(v) / (double)v.length;
    }

    public static double standardDeviation(double[] v) {
        return Math.sqrt(ArrayMath.variance(v));
    }

    public static double[] sortMinToMax(double[] v) {
        double[] ans = ArrayMath.copy(v);
        ArrayMath.quickSortMinToMax(ans, 0, ans.length - 1);
        return ans;
    }

    public static double[] sortMaxToMin(double[] v) {
        double[] ans = ArrayMath.copy(v);
        ArrayMath.quickSortMaxToMin(ans, 0, ans.length - 1);
        return ans;
    }

    public static double percentile(double[] v, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1 : " + p);
        }
        double[] ans = ArrayMath.sortMinToMax(v);
        int pos = (int)Math.floor(p * (double)(ans.length - 1));
        double dif = p * (double)(ans.length - 1) - Math.floor(p * (double)(ans.length - 1));
        if (pos == ans.length - 1) {
            return ans[ans.length - 1];
        }
        return ans[pos] * (1.0 - dif) + ans[pos + 1] * dif;
    }

    public static double median(double[] v) {
        if (v.length == 3) {
            return ArrayMath.median3(ArrayMath.copy(v));
        }
        if (v.length == 5) {
            return ArrayMath.median5(ArrayMath.copy(v));
        }
        if (v.length == 7) {
            return ArrayMath.median7(ArrayMath.copy(v));
        }
        if (v.length % 2 == 1) {
            return ArrayMath.quickSelect(ArrayMath.copy(v), false);
        }
        double[] tmp = ArrayMath.copy(v);
        double lowerMedian = ArrayMath.quickSelect(tmp, false);
        double upperMedian = ArrayMath.quickSelect(tmp, true);
        return (lowerMedian + upperMedian) / 2.0;
    }

    private static void sortInPlace(double[] v, int i, int j) {
        if (v[i] > v[j]) {
            double tmp = v[i];
            v[i] = v[j];
            v[j] = tmp;
        }
    }

    private static double median3(double[] v) {
        ArrayMath.sortInPlace(v, 0, 1);
        ArrayMath.sortInPlace(v, 1, 2);
        ArrayMath.sortInPlace(v, 0, 1);
        return v[1];
    }

    private static double median5(double[] v) {
        ArrayMath.sortInPlace(v, 0, 1);
        ArrayMath.sortInPlace(v, 3, 4);
        ArrayMath.sortInPlace(v, 0, 3);
        ArrayMath.sortInPlace(v, 1, 4);
        ArrayMath.sortInPlace(v, 1, 2);
        ArrayMath.sortInPlace(v, 2, 3);
        ArrayMath.sortInPlace(v, 1, 2);
        return v[2];
    }

    private static double median7(double[] v) {
        ArrayMath.sortInPlace(v, 0, 5);
        ArrayMath.sortInPlace(v, 0, 3);
        ArrayMath.sortInPlace(v, 1, 6);
        ArrayMath.sortInPlace(v, 2, 4);
        ArrayMath.sortInPlace(v, 0, 1);
        ArrayMath.sortInPlace(v, 3, 5);
        ArrayMath.sortInPlace(v, 2, 6);
        ArrayMath.sortInPlace(v, 2, 3);
        ArrayMath.sortInPlace(v, 3, 6);
        ArrayMath.sortInPlace(v, 4, 5);
        ArrayMath.sortInPlace(v, 1, 4);
        ArrayMath.sortInPlace(v, 1, 3);
        ArrayMath.sortInPlace(v, 3, 4);
        return v[3];
    }

    private static double quickSelect(double[] v, boolean upperMedian) {
        int median;
        int low = 0;
        int high = v.length - 1;
        int n = median = upperMedian ? high / 2 + 1 : high / 2;
        while (high > low) {
            if (high == low + 1) {
                if (v[low] > v[high]) {
                    ArrayMath.swap(v, low, high);
                }
                return v[median];
            }
            int middle = (low + high) / 2;
            if (v[middle] > v[high]) {
                ArrayMath.swap(v, middle, high);
            }
            if (v[low] > v[high]) {
                ArrayMath.swap(v, low, high);
            }
            if (v[middle] > v[low]) {
                ArrayMath.swap(v, middle, low);
            }
            ArrayMath.swap(v, middle, low + 1);
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (v[low] > v[++ll]) {
                    continue;
                }
                while (v[--hh] > v[low]) {
                }
                if (hh < ll) break;
                ArrayMath.swap(v, ll, hh);
            }
            ArrayMath.swap(v, low, hh);
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return v[median];
    }

    public static double[] abs(double[] v) {
        double[] ans = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            ans[i] = Math.abs(v[i]);
        }
        return ans;
    }

    public static double[][] abs(double[][] v) {
        double[][] ans = new double[v.length][];
        for (int i = 0; i < v.length; ++i) {
            ans[i] = ArrayMath.abs(v[i]);
        }
        return ans;
    }

    public static double max(double[] v) {
        double max = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (!(max < v[i])) continue;
            max = v[i];
        }
        return max;
    }

    public static double max(double[][] v) {
        double max = ArrayMath.max(v[0]);
        for (int i = 1; i < v.length; ++i) {
            if (!(max < ArrayMath.max(v[i]))) continue;
            max = ArrayMath.max(v[i]);
        }
        return max;
    }

    public static double maxIndex(double[] value) {
        double result = Double.NEGATIVE_INFINITY;
        int index = 0;
        int i = 0;
        while (i < value.length) {
            if (value[i] > result) {
                result = value[i];
            }
            index = i++;
        }
        return index;
    }

    public static double min(double[] v) {
        double min = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (!(min > v[i])) continue;
            min = v[i];
        }
        return min;
    }

    public static double min(double[][] v) {
        double min = ArrayMath.min(v[0]);
        for (int i = 1; i < v.length; ++i) {
            if (!(min > ArrayMath.min(v[i]))) continue;
            min = ArrayMath.min(v[i]);
        }
        return min;
    }

    public static double minIndex(double[] value) {
        double result = Double.POSITIVE_INFINITY;
        int index = 0;
        int i = 0;
        while (i < value.length) {
            if (value[i] < result) {
                result = value[i];
            }
            index = i++;
        }
        return index;
    }

    public static double norm(double[] data) {
        return Math.sqrt(ArrayMath.sumSquares(data));
    }

    public static double sumSquares(double[] data) {
        double ans = 0.0;
        for (int k = 0; k < data.length; ++k) {
            ans += data[k] * data[k];
        }
        return ans;
    }

    public static double sumSquares(double[][] data) {
        double ans = 0.0;
        for (int k = 0; k < data.length; ++k) {
            for (int l = 0; l < data[k].length; ++l) {
                ans += data[k][l] * data[k][l];
            }
        }
        return ans;
    }

    public static double getPowerN(double[] data, int n) {
        double ans = 0.0;
        for (int k = 0; k < data.length; ++k) {
            ans += data[k];
        }
        return Math.pow(ans, n);
    }

    public static double scalarProduct(double[] w0, double[] w1) {
        if (w0.length != w1.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + w0.length + ", " + w1.length);
        }
        if (w0.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double sortie = 0.0;
        for (int k = 0; k < w0.length; ++k) {
            sortie += w0[k] * w1[k];
        }
        return sortie;
    }

    public static double scalarProduct(double[][] w0, double[][] w1) {
        if (w0.length != w1.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + w0.length + ", " + w1.length);
        }
        if (w0.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double sortie = 0.0;
        for (int k = 0; k < w0.length; ++k) {
            sortie += ArrayMath.scalarProduct(w0[k], w1[k]);
        }
        return sortie;
    }

    public static double[] extract(int k0, int k1, double[] invect) {
        if (k0 < 0 || k1 < 0 || k0 > invect.length - 1 || k1 > invect.length - 1) {
            throw new IllegalArgumentException("The parameters are incorrect : " + k0 + ", " + k1 + ", " + invect.length);
        }
        if (k1 > k0) {
            double[] ans = new double[k1 - k0 + 1];
            System.arraycopy(invect, k0, ans, 0, k1 - k0 + 1);
            return ans;
        }
        double[] ans = new double[-k1 + k0 + 1];
        for (int k = k1; k <= k0; ++k) {
            ans[k0 - k] = invect[k];
        }
        return ans;
    }

    public static double[] invert(double[] v) {
        double[] w = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            w[v.length - 1 - k] = v[k];
        }
        return w;
    }

    public static double[] padding(int n0, int pos, double[] v) {
        if (v.length + pos > n0 || pos < 0) {
            throw new IllegalArgumentException("Array is to long for this : " + n0 + ", " + pos + ", " + v.length);
        }
        double[] w = new double[n0];
        System.arraycopy(v, 0, w, pos, v.length);
        return w;
    }

    public static double[] add(double[] w, double a, double[] v, int p) {
        if (v.length > w.length) {
            throw new IllegalArgumentException("Second array must be shorter or equal to the first one : " + w.length + ", " + v.length);
        }
        double[] ans = ArrayMath.copy(w);
        for (int k = p; k < p + v.length; ++k) {
            int n = k;
            ans[n] = ans[n] + a * v[k - p];
        }
        return ans;
    }

    public static double[] add(double[] w, double a) {
        double[] ans = ArrayMath.copy(w);
        int k = 0;
        while (k < ans.length) {
            int n = k++;
            ans[n] = ans[n] + a;
        }
        return ans;
    }

    public static double[][] transpose(double[][] M) {
        double[][] Mt = new double[M[0].length][M.length];
        for (int i = 0; i < M.length; ++i) {
            if (M[i].length != M[0].length) {
                throw new IllegalArgumentException("The array is not a matrix.");
            }
            for (int j = 0; j < M[0].length; ++j) {
                Mt[j][i] = M[i][j];
            }
        }
        return Mt;
    }

    public static double[] range(double a, double b, double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("The argument step should be positive: " + step + " < 0");
        }
        if (a == b) {
            double[] ans = new double[]{a};
            return ans;
        }
        int sizeOfArray = new Double(Math.abs(a - b) / step).intValue() + 1;
        double[] ans = new double[sizeOfArray];
        ans[0] = a;
        if (a > b) {
            step = -step;
        }
        for (int k = 1; k < sizeOfArray; ++k) {
            ans[k] = ans[k - 1] + step;
        }
        return ans;
    }

    public static double[] range(double a, double b) {
        return ArrayMath.range(a, b, 1.0);
    }

    public static double range(double[] population) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < population.length; ++i) {
            if (population[i] < min) {
                min = population[i];
            }
            if (!(population[i] > max)) continue;
            max = population[i];
        }
        return max - min;
    }

    public static double softmax(int index, double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.exp(x[i]);
        }
        return Math.exp(x[index]) / sum;
    }

    public static double[] range(double b) {
        return ArrayMath.range(0.0, b);
    }

    public static double[] add(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + a.length + ", " + b.length);
        }
        double[] ans = ArrayMath.copy(a);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            ans[n] = ans[n] + b[i];
        }
        return ans;
    }

    public static double[] subtract(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + a.length + ", " + b.length);
        }
        double[] ans = ArrayMath.copy(a);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            ans[n] = ans[n] - b[i];
        }
        return ans;
    }

    public static double[] scalarMultiply(double a, double[] v) {
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = a * v[k];
        }
        return ans;
    }

    public static String toString(double[] array) {
        int i;
        StringBuffer buf = new StringBuffer(array.length);
        for (i = 0; i < array.length - 1; ++i) {
            buf.append(array[i]);
            buf.append(',');
        }
        buf.append(array[i]);
        return buf.toString();
    }

    public static String toString(double[][] array) {
        StringBuffer buf = new StringBuffer();
        for (int k = 0; k < array.length; ++k) {
            buf.append(ArrayMath.toString(array[k]));
            buf.append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    public static double mass(double[] v) {
        double somme = 0.0;
        for (int k = 0; k < v.length; ++k) {
            somme += v[k];
        }
        return somme;
    }

    public static double[] scalarMultiplyFast(double a, double[] v) {
        if (a == 0.0) {
            return new double[v.length];
        }
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = a != 0.0 && v[k] != 0.0 ? v[k] * a : 0.0;
        }
        return ans;
    }

    public static void print(double[] v) {
        for (int k = 0; k < v.length; ++k) {
            System.out.println("array [" + k + "] = " + v[k]);
        }
    }

    public static void print(double[][] v) {
        for (int k = 0; k < v.length; ++k) {
            for (int l = 0; l < v[k].length; ++l) {
                System.out.println("array [" + k + "][" + l + "] = " + v[k][l]);
            }
        }
    }

    public static int[] setLengthFromEnd(int[] data, int length) {
        int[] ans = new int[length];
        int debut = length - data.length < 0 ? data.length - length : 0;
        System.arraycopy(data, debut, ans, -data.length + length + debut, data.length - debut);
        return ans;
    }

    public static int[] setLengthFromBeginning(int[] data, int length) {
        int[] ans = new int[length];
        int debut = length - data.length < 0 ? data.length - length : 0;
        System.arraycopy(data, 0, ans, 0, data.length - debut);
        return ans;
    }

    public static int[][] copy(int[][] v) {
        int[][] ans = new int[v.length][];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = ArrayMath.copy(v[k]);
        }
        return ans;
    }

    public static double variance(int[] v) {
        if (v.length > 1) {
            double m = ArrayMath.mean(v);
            double ans = 0.0;
            for (int i = 0; i < v.length; ++i) {
                ans += ((double)v[i] - m) * ((double)v[i] - m);
            }
            return ans / (double)(v.length - 1);
        }
        throw new IllegalArgumentException("Array length must be of 2 or greater.");
    }

    public static double covariance(int[] v1, int[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + v1.length + ", " + v2.length);
        }
        double m1 = ArrayMath.mean(v1);
        double m2 = ArrayMath.mean(v2);
        double ans = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            ans += ((double)v1[i] - m1) * ((double)v2[i] - m2);
        }
        return ans / (double)(v1.length - 1);
    }

    public static double correlation(int[] v1, int[] v2) {
        double denom = Math.sqrt(ArrayMath.variance(v1) * ArrayMath.variance(v2));
        if (denom != 0.0) {
            return ArrayMath.covariance(v1, v2) / denom;
        }
        if (ArrayMath.variance(v1) == 0.0 && ArrayMath.variance(v2) == 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double mean(int[] v) {
        if (v.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! The array must have at least one element.");
        }
        return (double)ArrayMath.mass(v) / (double)v.length;
    }

    public static double standardDeviation(int[] v) {
        return Math.sqrt(ArrayMath.variance(v));
    }

    public static int[] sortMinToMax(int[] v) {
        int[] ans = ArrayMath.copy(v);
        ArrayMath.quickSortMinToMax(ans, 0, ans.length - 1);
        return ans;
    }

    public static int[] sortMaxToMin(int[] v) {
        int[] ans = ArrayMath.copy(v);
        ArrayMath.quickSortMaxToMin(ans, 0, ans.length - 1);
        return ans;
    }

    public static String toString(int[] array) {
        int i;
        StringBuffer buf = new StringBuffer(array.length);
        for (i = 0; i < array.length - 1; ++i) {
            buf.append(array[i]);
            buf.append(',');
        }
        buf.append(array[i]);
        return buf.toString();
    }

    public static String toString(int[][] array) {
        StringBuffer buf = new StringBuffer();
        for (int k = 0; k < array.length; ++k) {
            buf.append(ArrayMath.toString(array[k]));
            buf.append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    public static double percentile(int[] v, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0 and 1 : " + p);
        }
        int[] ans = ArrayMath.sortMinToMax(v);
        int pos = (int)Math.floor(p * (double)(ans.length - 1));
        double dif = p * (double)(ans.length - 1) - Math.floor(p * (double)(ans.length - 1));
        if (pos == ans.length - 1) {
            return ans[ans.length - 1];
        }
        return (double)ans[pos] * (1.0 - dif) + (double)ans[pos + 1] * dif;
    }

    public static int median(int[] v) {
        if (v.length == 3) {
            return ArrayMath.median3(ArrayMath.copy(v));
        }
        if (v.length == 5) {
            return ArrayMath.median5(ArrayMath.copy(v));
        }
        if (v.length == 7) {
            return ArrayMath.median7(ArrayMath.copy(v));
        }
        return ArrayMath.quickSelect(ArrayMath.copy(v));
    }

    private static void sortInPlace(int[] v, int i, int j) {
        if (v[i] > v[j]) {
            int tmp = v[i];
            v[i] = v[j];
            v[j] = tmp;
        }
    }

    private static int median3(int[] v) {
        ArrayMath.sortInPlace(v, 0, 1);
        ArrayMath.sortInPlace(v, 1, 2);
        ArrayMath.sortInPlace(v, 0, 1);
        return v[1];
    }

    private static int median5(int[] v) {
        ArrayMath.sortInPlace(v, 0, 1);
        ArrayMath.sortInPlace(v, 3, 4);
        ArrayMath.sortInPlace(v, 0, 3);
        ArrayMath.sortInPlace(v, 1, 4);
        ArrayMath.sortInPlace(v, 1, 2);
        ArrayMath.sortInPlace(v, 2, 3);
        ArrayMath.sortInPlace(v, 1, 2);
        return v[2];
    }

    private static int median7(int[] v) {
        ArrayMath.sortInPlace(v, 0, 5);
        ArrayMath.sortInPlace(v, 0, 3);
        ArrayMath.sortInPlace(v, 1, 6);
        ArrayMath.sortInPlace(v, 2, 4);
        ArrayMath.sortInPlace(v, 0, 1);
        ArrayMath.sortInPlace(v, 3, 5);
        ArrayMath.sortInPlace(v, 2, 6);
        ArrayMath.sortInPlace(v, 2, 3);
        ArrayMath.sortInPlace(v, 3, 6);
        ArrayMath.sortInPlace(v, 4, 5);
        ArrayMath.sortInPlace(v, 1, 4);
        ArrayMath.sortInPlace(v, 1, 3);
        ArrayMath.sortInPlace(v, 3, 4);
        return v[3];
    }

    private static int quickSelect(int[] v) {
        int low = 0;
        int high = v.length - 1;
        int median = high / 2;
        while (high > low) {
            if (high == low + 1) {
                if (v[low] > v[high]) {
                    ArrayMath.swap(v, low, high);
                }
                return v[median];
            }
            int middle = (low + high) / 2;
            if (v[middle] > v[high]) {
                ArrayMath.swap(v, middle, high);
            }
            if (v[low] > v[high]) {
                ArrayMath.swap(v, low, high);
            }
            if (v[middle] > v[low]) {
                ArrayMath.swap(v, middle, low);
            }
            ArrayMath.swap(v, middle, low + 1);
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (v[low] > v[++ll]) {
                    continue;
                }
                while (v[--hh] > v[low]) {
                }
                if (hh < ll) break;
                ArrayMath.swap(v, ll, hh);
            }
            ArrayMath.swap(v, low, hh);
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return v[median];
    }

    public static boolean equals(int[] a, int[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] abs(int[] v) {
        int[] ans = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            ans[i] = Math.abs(v[i]);
        }
        return ans;
    }

    public static int[][] abs(int[][] v) {
        int[][] ans = new int[v.length][];
        for (int i = 0; i < v.length; ++i) {
            ans[i] = ArrayMath.abs(v[i]);
        }
        return ans;
    }

    public static int max(int[] v) {
        int max = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (max >= v[i]) continue;
            max = v[i];
        }
        return max;
    }

    public static int max(int[][] v) {
        int max = ArrayMath.max(v[0]);
        for (int i = 1; i < v.length; ++i) {
            if (max >= ArrayMath.max(v[i])) continue;
            max = ArrayMath.max(v[i]);
        }
        return max;
    }

    public static int min(int[] v) {
        int min = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (min <= v[i]) continue;
            min = v[i];
        }
        return min;
    }

    public static int min(int[][] v) {
        int min = ArrayMath.min(v[0]);
        for (int i = 1; i < v.length; ++i) {
            if (min <= ArrayMath.min(v[i])) continue;
            min = ArrayMath.min(v[i]);
        }
        return min;
    }

    public static double norm(int[] data) {
        return Math.sqrt(ArrayMath.sumSquares(data));
    }

    public static int sumSquares(int[] data) {
        int ans = 0;
        for (int k = 0; k < data.length; ++k) {
            ans += data[k] * data[k];
        }
        return ans;
    }

    public static int sumSquares(int[][] data) {
        int ans = 0;
        for (int k = 0; k < data.length; ++k) {
            for (int l = 0; l < data[k].length; ++l) {
                ans += data[k][l] * data[k][l];
            }
        }
        return ans;
    }

    public static int scalarProduct(int[] w0, int[] w1) {
        if (w0.length != w1.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + w0.length + ", " + w1.length);
        }
        if (w0.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        int sortie = 0;
        for (int k = 0; k < w0.length; ++k) {
            sortie += w0[k] * w1[k];
        }
        return sortie;
    }

    public static double scalarProduct(int[][] w0, int[][] w1) {
        if (w0.length != w1.length) {
            throw new IllegalArgumentException("Arrays must have the same length : " + w0.length + ", " + w1.length);
        }
        if (w0.length == 0) {
            throw new IllegalArgumentException("Nothing to compute! Arrays must have at least one element.");
        }
        double sortie = 0.0;
        for (int k = 0; k < w0.length; ++k) {
            sortie += (double)ArrayMath.scalarProduct(w0[k], w1[k]);
        }
        return sortie;
    }

    public static int[] extract(int k0, int k1, int[] invect) {
        if (k0 < 0 || k1 < 0 || k0 > invect.length - 1 || k1 > invect.length - 1) {
            throw new IllegalArgumentException("The parameters are incorrect : " + k0 + ", " + k1 + ", " + invect.length);
        }
        if (k1 > k0) {
            int[] ans = new int[k1 - k0 + 1];
            System.arraycopy(invect, k0, ans, 0, k1 - k0 + 1);
            return ans;
        }
        int[] ans = new int[-k1 + k0 + 1];
        for (int k = k1; k <= k0; ++k) {
            ans[k0 - k] = invect[k];
        }
        return ans;
    }

    public static int[] invert(int[] v) {
        int[] w = new int[v.length];
        for (int k = 0; k < v.length; ++k) {
            w[v.length - 1 - k] = v[k];
        }
        return w;
    }

    public static int[] padding(int n0, int pos, int[] v) {
        if (v.length + pos > n0 || pos < 0) {
            throw new IllegalArgumentException("The array is too long for this : " + n0 + ", " + pos + ", " + v.length);
        }
        int[] w = new int[n0];
        System.arraycopy(v, 0, w, pos, v.length);
        return w;
    }

    public static int[] add(int[] w, double a, int[] v, int p) {
        if (v.length > w.length) {
            throw new IllegalArgumentException("Second array must be shorter or equal to the first one : " + w.length + ", " + v.length);
        }
        int[] ans = ArrayMath.copy(w);
        for (int k = p; k < p + v.length; ++k) {
            int n = k;
            ans[n] = (int)((double)ans[n] + a * (double)v[k - p]);
        }
        return ans;
    }

    public static int[] add(int[] w, int a) {
        int[] ans = ArrayMath.copy(w);
        int k = 0;
        while (k < ans.length) {
            int n = k++;
            ans[n] = ans[n] + a;
        }
        return ans;
    }

    public static int[] range(int a, int b) {
        return ArrayMath.range(a, b, 1);
    }

    public static int[] range(int b) {
        return ArrayMath.range(0, b);
    }

    public static int[] range(int a, int b, int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("The argument step should be positive: " + step + " < 0");
        }
        if (a == b) {
            int[] ans = new int[]{a};
            return ans;
        }
        int sizeOfArray = new Double(Math.abs(a - b) / step).intValue();
        int[] ans = new int[sizeOfArray];
        ans[0] = a;
        if (a > b) {
            step = -step;
        }
        for (int k = 1; k < sizeOfArray; ++k) {
            ans[k] = ans[k - 1] + step;
        }
        return ans;
    }

    public static int[][] transpose(int[][] M) {
        int[][] Mt = new int[M[0].length][M.length];
        for (int i = 0; i < M.length; ++i) {
            if (M[i].length != M[0].length) {
                throw new IllegalArgumentException("The array is not a matrix.");
            }
            for (int j = 0; j < M[0].length; ++j) {
                Mt[j][i] = M[i][j];
            }
        }
        return Mt;
    }

    public static int[] add(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + a.length + ", " + b.length);
        }
        int[] ans = ArrayMath.copy(a);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            ans[n] = ans[n] + b[i];
        }
        return ans;
    }

    public static int[] subtract(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("To add two arrays, they must have the same length : " + a.length + ", " + b.length);
        }
        int[] ans = ArrayMath.copy(a);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            ans[n] = ans[n] - b[i];
        }
        return ans;
    }

    public static int mass(int[] v) {
        int somme = 0;
        for (int k = 0; k < v.length; ++k) {
            somme += v[k];
        }
        return somme;
    }

    public static double[] scalarMultiply(double a, int[] v) {
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = (double)v[k] * a;
        }
        return ans;
    }

    public static double[] scalarMultiplyFast(double a, int[] v) {
        if (a == 0.0) {
            return new double[v.length];
        }
        double[] ans = new double[v.length];
        for (int k = 0; k < v.length; ++k) {
            ans[k] = a != 0.0 && v[k] != 0 ? (double)v[k] * a : 0.0;
        }
        return ans;
    }

    public static void print(int[] v) {
        for (int k = 0; k < v.length; ++k) {
            System.out.println("array [" + k + "] = " + v[k]);
        }
    }

    public static void print(int[][] v) {
        for (int k = 0; k < v.length; ++k) {
            for (int l = 0; l < v[k].length; ++l) {
                System.out.println("array [" + k + "][" + l + "] = " + v[k][l]);
            }
        }
    }

    private static void quickSortMinToMax(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(int)Math.round((double)(lo0 + hi0) / 2.0)];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                ArrayMath.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                ArrayMath.quickSortMinToMax(a, lo0, hi);
            }
            if (lo < hi0) {
                ArrayMath.quickSortMinToMax(a, lo, hi0);
            }
        }
    }

    private static void quickSortMaxToMin(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(int)Math.round((double)(lo0 + hi0) / 2.0)];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] > mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] < mid) {
                    --hi;
                }
                if (lo > hi) continue;
                ArrayMath.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                ArrayMath.quickSortMaxToMin(a, lo0, hi);
            }
            if (lo < hi0) {
                ArrayMath.quickSortMaxToMin(a, lo, hi0);
            }
        }
    }

    private static void quickSortMinToMax(double[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = a[(int)Math.round((double)(lo0 + hi0) / 2.0)];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                ArrayMath.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                ArrayMath.quickSortMinToMax(a, lo0, hi);
            }
            if (lo < hi0) {
                ArrayMath.quickSortMinToMax(a, lo, hi0);
            }
        }
    }

    private static void quickSortMaxToMin(double[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = a[(int)Math.round((double)(lo0 + hi0) / 2.0)];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] > mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] < mid) {
                    --hi;
                }
                if (lo > hi) continue;
                ArrayMath.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                ArrayMath.quickSortMaxToMin(a, lo0, hi);
            }
            if (lo < hi0) {
                ArrayMath.quickSortMaxToMin(a, lo, hi0);
            }
        }
    }

    private static void swap(int[] a, int i, int j) {
        int T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private static void swap(double[] a, int i, int j) {
        double T = a[i];
        a[i] = a[j];
        a[j] = T;
    }
}

