/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.csv.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jhplot.io.csv.CSVReader;
import jhplot.io.csv.bean.MappingStrategy;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Class<T> type;

    public void captureHeader(CSVReader reader) throws IOException {
        this.header = reader.readNext();
    }

    @Override
    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return null != columnName && columnName.trim().length() > 0 ? this.findDescriptor(columnName) : null;
    }

    protected String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap(this.getType());
        }
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    protected boolean matches(String name, PropertyDescriptor desc) {
        return desc.getName().equals(name.trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap(Class<T> cls) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors = this.loadDescriptors(this.getType())) {
            map.put(descriptor.getName().toUpperCase().trim(), descriptor);
        }
        return map;
    }

    private PropertyDescriptor[] loadDescriptors(Class<T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    @Override
    public void captureHeader(au.com.bytecode.opencsv.CSVReader reader) throws IOException {
    }
}

