/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import promc.io.PEventFile;

public class EFile {
    private FileOutputStream oof = null;
    private FileInputStream iif = null;
    private int nev = 0;
    private static final int FILE_VERSION = 1;
    private ZipOutputStream zout;
    static final int BUFFER = 2048;
    private byte[] data;
    private ZipInputStream zin;
    private ZipFile zipFile;

    public EFile(String file, String option) {
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.oof = new FileOutputStream(file);
                this.zout = new ZipOutputStream(new BufferedOutputStream(this.oof));
                this.data = new byte[2048];
                this.zipFile = null;
                ZipEntry entry = new ZipEntry("info");
                this.zout.putNextEntry(entry);
                String a = new String(Integer.toString(1));
                byte[] theByteArray = a.getBytes();
                entry.setSize(theByteArray.length);
                this.zout.write(theByteArray);
                this.zout.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("r")) {
            try {
                this.zipFile = new ZipFile(file);
                this.iif = new FileInputStream(file);
                this.zin = new ZipInputStream(this.iif);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.ErrorMessage("Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    public int getVersion() {
        String tmp = "0";
        if (this.zipFile == null) {
            return 0;
        }
        ZipEntry ze = this.zipFile.getEntry("info");
        long size = ze.getSize();
        if (size > 0L) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.zipFile.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    tmp = line;
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Integer.parseInt(tmp);
    }

    public EFile(String file) {
        this(file, "r");
    }

    public boolean write(PEventFile.HEvent.Builder ev) {
        boolean success = true;
        ++this.nev;
        String firec = Integer.toString(this.nev);
        try {
            this.data = ev.build().toByteArray();
            ZipEntry entry = new ZipEntry(firec);
            this.zout.putNextEntry(entry);
            entry.setSize(this.data.length);
            this.zout.write(this.data);
            this.zout.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
            success = false;
            return success;
        }
        return success;
    }

    public int size() {
        if (this.zipFile == null) {
            return this.nev;
        }
        return this.zipFile.size() - 1;
    }

    public int getNEntries() {
        return this.size();
    }

    public String entriesToString() {
        String tmp = "";
        if (this.iif == null) {
            return tmp;
        }
        try {
            ZipEntry ze;
            while ((ze = this.zin.getNextEntry()) != null) {
                String a = ze.getName();
                if (!a.equals("info")) {
                    tmp = tmp + a + "\n";
                }
                this.zin.closeEntry();
            }
            this.zin.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public PEventFile.HEvent read() {
        ++this.nev;
        return this.read(this.nev);
    }

    public PEventFile.HEvent read(int index) {
        PEventFile.HEvent ob = null;
        if (this.zipFile == null) {
            return ob;
        }
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        if (entry == null) {
            return ob;
        }
        InputStream zz = null;
        PEventFile.HEvent record = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = PEventFile.HEvent.parseFrom((InputStream)zz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ob;
        }
        if (record == null) {
            return ob;
        }
        return record;
    }

    public boolean close() {
        boolean success = true;
        try {
            if (this.iif != null) {
                this.iif.close();
                this.zin.close();
                this.zipFile.close();
                this.iif = null;
                this.zin = null;
                this.zipFile = null;
            }
            if (this.oof != null) {
                this.zout.finish();
                this.zout.close();
                this.oof.flush();
                this.oof.close();
                this.oof = null;
            }
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

