/*
 * Decompiled with CFR 0.152.
 */
package jhplot.gui;

import graph.RTextLine;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jhplot.JHPlot;
import jhplot.gui.GHPanel;
import jhplot.utils.GHFontChooser;
import jplot.Translate;
import org.freehep.graphics2d.VectorGraphics;

public class GHMargin
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Rectangle selection;
    protected String sname = " ";
    private static boolean insideBox = false;
    private Font f;
    private Color c;
    private FontMetrics fm;
    private int textWidth = 0;
    private int textHeight = 0;
    private Color recColor;
    private Color recColor1;
    private Color bakColor;
    private final Color borderColor = new Color(151, 201, 201);
    private final GHPanel win;
    private int rotation;
    private String sinfo = "";
    private int dXsize;
    private int dYsize;
    private JPopupMenu menu;
    private SelectionChangeMouseListener scml;
    JMenuItem iedit;
    JMenuItem icolor;
    JMenuItem imargin1;
    JMenuItem imargin2;
    JMenuItem imargin3;
    JMenuItem idefault;

    public GHMargin(GHPanel w, final String wname) {
        this.win = w;
        this.sinfo = wname + " margin";
        this.sname = " ";
        this.f = new Font("Lucida Sans", 1, 20);
        this.c = Color.BLACK;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.scml = new SelectionChangeMouseListener();
        this.addMouseListener(this.scml);
        this.addMouseMotionListener(this.scml);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.menu = new JPopupMenu();
        JMenuItem info = new JMenuItem(this.sinfo);
        info.setEnabled(false);
        info.setForeground(this.borderColor);
        JMenuItem iedit = new JMenuItem("Edit title");
        JMenuItem imargin1 = new JMenuItem("Divider +");
        JMenuItem imargin2 = new JMenuItem("Divider -");
        JMenuItem imargin3 = new JMenuItem("Remove borders");
        JMenuItem idefault = new JMenuItem("Default location");
        this.menu.add(info);
        this.menu.addSeparator();
        this.menu.add(iedit);
        this.menu.add(imargin1);
        this.menu.add(imargin2);
        this.menu.add(imargin3);
        this.menu.add(idefault);
        this.recColor = Color.white;
        this.recColor1 = Color.white;
        this.bakColor = Color.white;
        this.rotation = 0;
        imargin3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GHMargin.this.showBorder(false);
            }
        });
        imargin1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GHMargin.this.dXsize = GHMargin.this.getSizeX();
                GHMargin.this.dYsize = GHMargin.this.getSizeY();
                if (wname.equalsIgnoreCase("Left") || wname.equalsIgnoreCase("Right")) {
                    GHMargin.this.dXsize = GHMargin.this.dXsize + 5;
                    GHMargin.this.setSizeMargin(GHMargin.this.dXsize, GHMargin.this.dYsize);
                }
                if (wname.equalsIgnoreCase("Top") || wname.equalsIgnoreCase("Bottom")) {
                    GHMargin.this.dYsize = GHMargin.this.dYsize + 5;
                    GHMargin.this.setSizeMargin(GHMargin.this.dXsize, GHMargin.this.dYsize);
                }
                GHMargin.this.showBorder(true);
            }
        });
        imargin2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GHMargin.this.dXsize = GHMargin.this.getSizeX();
                GHMargin.this.dYsize = GHMargin.this.getSizeY();
                if (wname.equalsIgnoreCase("Left") || wname.equalsIgnoreCase("Right")) {
                    GHMargin.this.dXsize = GHMargin.this.dXsize - 5;
                    if (GHMargin.this.dXsize > 2) {
                        GHMargin.this.setSizeMargin(GHMargin.this.dXsize, GHMargin.this.dYsize);
                    }
                }
                if (wname.equalsIgnoreCase("Top") || wname.equalsIgnoreCase("Bottom")) {
                    GHMargin.this.dYsize = GHMargin.this.dYsize - 5;
                    if (GHMargin.this.dYsize > 2) {
                        GHMargin.this.setSizeMargin(GHMargin.this.dXsize, GHMargin.this.dYsize);
                    }
                }
                GHMargin.this.showBorder(true);
            }
        });
        iedit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHPlot.showStatusBarText("Start margin editor..");
                if (GHMargin.this.sname == null) {
                    GHMargin.this.sname = " ";
                }
                JPanel jj = GHMargin.this.win.getCanvasPanel();
                GHFontChooser dlg = new GHFontChooser(jj, GHMargin.this.sname);
                SimpleAttributeSet a = new SimpleAttributeSet();
                StyleConstants.setFontFamily(a, GHMargin.this.f.getName());
                StyleConstants.setFontSize(a, GHMargin.this.f.getSize());
                int style = GHMargin.this.f.getStyle();
                StyleConstants.setItalic(a, false);
                StyleConstants.setBold(a, false);
                if (style == 1) {
                    StyleConstants.setBold(a, true);
                }
                if (style == 2) {
                    StyleConstants.setItalic(a, true);
                }
                StyleConstants.setBackground(a, GHMargin.this.bakColor);
                StyleConstants.setForeground(a, GHMargin.this.getGColor());
                dlg.setAttributes(a);
                dlg.setVisible(true);
                a = (SimpleAttributeSet)dlg.getAttributes();
                String newName = StyleConstants.getFontFamily(a);
                int newSize = StyleConstants.getFontSize(a);
                style = 0;
                if (StyleConstants.isBold(a)) {
                    style = 1;
                }
                if (StyleConstants.isItalic(a)) {
                    style = 2;
                }
                Color newc = StyleConstants.getForeground(a);
                Color newcb = StyleConstants.getBackground(a);
                Font ff = new Font(newName, style, newSize);
                String ss = dlg.getInputText();
                if (ff != null && ss != null && newc != null && newcb != null) {
                    GHMargin.this.setGRecBackground(newcb);
                    GHMargin.this.setGBackground(newcb);
                    if (wname.equalsIgnoreCase("Left") || wname.equalsIgnoreCase("Right")) {
                        GHMargin.this.setRotation(-90);
                    }
                    GHMargin.this.setString(ss, ff, newc, GHMargin.this.getSize());
                    GHMargin.this.refreshText();
                }
            }
        });
        idefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GHMargin.this.setDefault();
            }
        });
    }

    public void setDefault() {
        this.setString(this.sname, this.f, this.c, this.getSize());
        this.showBorder(false);
    }

    public void setDefault(Object com) {
        Dimension d = ((JPanel)com).getSize();
        this.setString(this.sname, this.f, this.c, d);
        this.showBorder(false);
    }

    public void disposeMe() {
        this.c = null;
        this.f = null;
        this.iedit = null;
        this.icolor = null;
        this.scml = null;
        this.imargin1 = null;
        this.imargin2 = null;
        this.imargin3 = null;
        this.idefault = null;
        this.bakColor = null;
        this.recColor = null;
        this.fm = null;
        this.selection = null;
        this.menu = null;
        System.gc();
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setString(String sname, Font f, Color c, Dimension dd) {
        this.sname = sname;
        this.f = f;
        this.c = c;
        this.fm = this.getFontMetrics(f);
        String tmp = Translate.shrink(sname);
        this.textWidth = this.fm.stringWidth(tmp);
        this.textHeight = this.fm.getHeight();
        this.dYsize = (int)dd.getHeight();
        this.dXsize = (int)dd.getWidth();
        int xx = (int)(0.5 * (double)this.dXsize) - (int)(0.5 * (double)this.textWidth);
        int yy = (int)(0.5 * (double)this.dYsize) - (int)(0.5 * (double)this.dYsize) + 3;
        if (this.rotation == 90 || this.rotation == -90) {
            xx = (int)(0.5 * (double)this.dXsize) - (int)(0.5 * (double)this.textWidth) - this.textHeight;
            yy = (int)(0.5 * (double)this.dYsize) - (int)(0.5 * (double)this.dYsize) + 3;
            this.selection = new Rectangle(xx, yy, Math.min(this.textWidth, 5), Math.min(this.textHeight, 5));
        } else {
            this.selection = new Rectangle(xx, yy, Math.min(this.textWidth, 5), Math.min(this.textHeight, 5));
        }
        this.repaint();
    }

    protected void refreshText() {
        this.repaint();
    }

    public void setGFont(Font f) {
        this.f = f;
        this.repaint();
    }

    public void setGColor(Color c) {
        this.c = c;
        this.repaint();
    }

    public Color getGColor() {
        return this.c;
    }

    public Font getGFont() {
        return this.f;
    }

    public Color getGBackground() {
        return this.bakColor;
    }

    public String getString() {
        return this.sname;
    }

    public void showBorder(boolean show) {
        if (show) {
            this.setBorder(BorderFactory.createLineBorder(this.borderColor, 1));
            this.recColor1 = this.borderColor;
            this.recColor = this.borderColor;
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.recColor = this.recColor1 = this.getGBackground();
        }
        this.updateUI();
    }

    public boolean isBorder() {
        return this.recColor == this.borderColor;
    }

    public void showBorderNoUpdate(boolean show) {
        if (show) {
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 1));
            this.recColor1 = Color.blue;
            this.recColor = Color.blue;
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.recColor = this.recColor1 = this.getGBackground();
        }
    }

    public void setString(String sname) {
        this.sname = sname;
        this.f = new Font("Lucida Sans", 1, 20);
        this.setString(sname, this.f, Color.black, this.getSize());
    }

    public void setString(String sname, Font f, Color c) {
        this.setString(sname, f, c, this.getSize());
    }

    public Font getMFont() {
        return this.f;
    }

    public Color getMColor() {
        return this.c;
    }

    private void setSelectionBounds(Rectangle rect) {
        this.selection = rect;
        this.repaint();
    }

    public void setGBackground(Color c) {
        this.bakColor = c;
        this.repaint();
    }

    public void setGRecBackground(Color c) {
        this.recColor1 = c;
        this.recColor = c;
        this.repaint();
    }

    public JPanel getJPanel() {
        return this;
    }

    public void setSizeMargin(int x, int y) {
        this.dXsize = x;
        this.dYsize = y;
        this.setPreferredSize(new Dimension(x, y));
        this.setMinimumSize(new Dimension(5, 5));
    }

    public int getSizeX() {
        return this.dXsize;
    }

    public int getSizeY() {
        return this.dYsize;
    }

    public double getStringPositionX() {
        return (double)this.selection.x / (double)this.getSizeX();
    }

    public double getStringPositionY() {
        return (double)this.selection.y / (double)this.getSizeY();
    }

    public void setStringPositionX(double x) {
        this.selection.x = (int)(x * (double)this.getSizeX());
        this.repaint();
    }

    public void setStringPositionY(double y) {
        this.selection.y = (int)(y * (double)this.getSizeY());
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics gr) {
        Dimension size = this.getSize();
        if (gr == null) {
            return;
        }
        VectorGraphics g2d = VectorGraphics.create((Graphics)gr);
        g2d.setColor(this.bakColor);
        g2d.fillRect(0, 0, size.width, size.height);
        if (this.f != null && this.sname != null && this.selection != null) {
            g2d.setFont(this.f);
            this.fm = this.getFontMetrics(this.f);
            String tmp = Translate.shrink(this.sname);
            this.textWidth = this.fm.stringWidth(tmp);
            this.textHeight = this.fm.getHeight();
            if (this.selection.width < this.textWidth) {
                this.selection.width = this.textWidth;
            }
            if (this.selection.height < this.textHeight) {
                this.selection.height = this.textHeight;
            }
            g2d.setColor(this.recColor);
            double rota = (double)this.rotation * Math.PI / 180.0;
            int irot = 0;
            if (this.rotation == 0) {
                g2d.drawRect(this.selection.x, this.selection.y, this.selection.width, this.selection.height);
            }
            if (this.rotation == 90 || this.rotation == -90) {
                irot = (int)(0.7 * (double)this.selection.width);
                g2d.drawRect(this.selection.x + irot, this.selection.y, this.selection.height, this.selection.width);
            }
            g2d.setColor(Color.black);
            String stext = Translate.decode(this.sname);
            RTextLine text = new RTextLine();
            text.setColor(this.c);
            text.setText(stext);
            text.setFont(this.f);
            g2d.rotate(rota, (double)(this.selection.x + irot), (double)this.selection.y);
            if (this.rotation == 0) {
                text.draw(g2d, this.selection.x + 2, this.selection.y + this.textHeight - 2);
            } else if (this.rotation == 90) {
                text.draw(g2d, this.selection.x + irot, this.selection.y - (int)(0.4 * (double)this.textHeight));
            } else if (this.rotation == -90) {
                text.draw(g2d, this.selection.x + irot - this.textWidth, this.selection.y + this.textHeight);
            } else {
                text.draw(g2d, this.selection.x - this.selection.height, this.selection.y);
            }
            g2d.rotate(-1.0 * rota, (double)(this.selection.x + irot), (double)this.selection.y);
        }
    }

    private class SelectionChangeMouseListener
    implements MouseMotionListener,
    MouseListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected int frameWidth = 5;
        protected int minSize = 5;
        protected int startDragX;
        protected int startDragY;
        protected Rectangle startDragRect;
        protected boolean resizeLeft;
        protected boolean resizeTop;
        protected boolean resizeRight;
        protected boolean resizeBottom;
        protected boolean move;

        private SelectionChangeMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startDragRect != null) {
                int x = e.getX();
                int y = e.getY();
                int diffX = this.startDragX - x;
                int diffY = this.startDragY - y;
                int newX = this.startDragRect.x;
                int newY = this.startDragRect.y;
                int newW = this.startDragRect.width;
                int newH = this.startDragRect.height;
                if (this.move) {
                    newX -= diffX;
                    newY -= diffY;
                }
                if (newW > this.minSize && newH > this.minSize) {
                    GHMargin.this.setSelectionBounds(new Rectangle(newX, newY, newW, newH));
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            insideBox = false;
            if (GHMargin.this.selection != null) {
                int x = e.getX();
                int y = e.getY();
                int selX = GHMargin.this.selection.x;
                int selY = GHMargin.this.selection.y;
                int selW = GHMargin.this.selection.width;
                int selH = GHMargin.this.selection.height;
                if (GHMargin.this.rotation == 90 || GHMargin.this.rotation == -90) {
                    int irot = (int)(0.7 * (double)GHMargin.this.selection.width);
                    selX = GHMargin.this.selection.x + irot;
                    selW = GHMargin.this.selection.height;
                    selH = GHMargin.this.selection.width;
                }
                Rectangle inside = new Rectangle(selX, selY, selW, selH);
                Rectangle leftFrame = new Rectangle(selX, selY, this.frameWidth, selH);
                Rectangle topFrame = new Rectangle(selX, selY, selW, this.frameWidth);
                Rectangle rightFrame = new Rectangle(selX + selW - this.frameWidth, selY, this.frameWidth, selH);
                Rectangle bottomFrame = new Rectangle(selX, selY + selH - this.frameWidth, selW, this.frameWidth);
                boolean isInside = inside.contains(x, y);
                boolean isLeft = leftFrame.contains(x, y);
                boolean isTop = topFrame.contains(x, y);
                boolean isRight = rightFrame.contains(x, y);
                boolean isBottom = bottomFrame.contains(x, y);
                if (isLeft && isTop) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(6));
                } else if (isTop && isRight) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(7));
                } else if (isRight && isBottom) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(5));
                } else if (isBottom && isLeft) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(4));
                } else if (isLeft) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (isTop) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(8));
                } else if (isRight) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(11));
                } else if (isBottom) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(9));
                } else if (isInside) {
                    insideBox = true;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    insideBox = false;
                    GHMargin.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            } else {
                insideBox = false;
                GHMargin.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (GHMargin.this.selection != null) {
                int x = e.getX();
                int y = e.getY();
                insideBox = true;
                int selX = GHMargin.this.selection.x;
                int selY = GHMargin.this.selection.y;
                int selW = GHMargin.this.selection.width;
                int selH = GHMargin.this.selection.height;
                if (GHMargin.this.rotation == 90 || GHMargin.this.rotation == -90) {
                    int irot = (int)(0.7 * (double)GHMargin.this.selection.width);
                    selX = GHMargin.this.selection.x + irot;
                    selW = GHMargin.this.selection.height;
                    selH = GHMargin.this.selection.width;
                }
                if (e.getClickCount() != 2 || x <= selX || x >= selX + selW || y <= selY || y < selY + selH) {
                    // empty if block
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!insideBox && (e.getModifiers() & 4) != 0 && e.getClickCount() == 1) {
                GHMargin.this.menu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            if (GHMargin.this.selection != null) {
                int x = e.getX();
                int y = e.getY();
                int selX = GHMargin.this.selection.x;
                int selY = GHMargin.this.selection.y;
                int selW = GHMargin.this.selection.width;
                int selH = GHMargin.this.selection.height;
                if (GHMargin.this.rotation == 90 || GHMargin.this.rotation == -90) {
                    int irot = (int)(0.7 * (double)GHMargin.this.selection.width);
                    selX = GHMargin.this.selection.x + irot;
                    selW = GHMargin.this.selection.height;
                    selH = GHMargin.this.selection.width;
                }
                Rectangle inside = new Rectangle(selX, selY, selW, selH);
                Rectangle leftFrame = new Rectangle(selX, selY, this.frameWidth, selH);
                Rectangle topFrame = new Rectangle(selX, selY, selW, this.frameWidth);
                Rectangle rightFrame = new Rectangle(selX + selW - this.frameWidth, selY, this.frameWidth, selH);
                Rectangle bottomFrame = new Rectangle(selX, selY + selH - this.frameWidth, selW, this.frameWidth);
                boolean isInside = inside.contains(x, y);
                boolean isLeft = leftFrame.contains(x, y);
                boolean isTop = topFrame.contains(x, y);
                boolean isRight = rightFrame.contains(x, y);
                boolean isBottom = bottomFrame.contains(x, y);
                if (isLeft && isTop) {
                    this.resizeLeft = true;
                    this.resizeTop = true;
                    this.resizeRight = false;
                    this.resizeBottom = false;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isTop && isRight) {
                    this.resizeLeft = false;
                    this.resizeTop = true;
                    this.resizeRight = true;
                    this.resizeBottom = false;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isRight && isBottom) {
                    this.resizeLeft = false;
                    this.resizeTop = false;
                    this.resizeRight = true;
                    this.resizeBottom = true;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isBottom && isLeft) {
                    this.resizeLeft = true;
                    this.resizeTop = false;
                    this.resizeRight = false;
                    this.resizeBottom = true;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isLeft) {
                    this.resizeLeft = true;
                    this.resizeTop = false;
                    this.resizeRight = false;
                    this.resizeBottom = false;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isTop) {
                    this.resizeLeft = false;
                    this.resizeTop = true;
                    this.resizeRight = false;
                    this.resizeBottom = false;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isRight) {
                    this.resizeLeft = false;
                    this.resizeTop = false;
                    this.resizeRight = true;
                    this.resizeBottom = false;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isBottom) {
                    this.resizeLeft = false;
                    this.resizeTop = false;
                    this.resizeRight = false;
                    this.resizeBottom = true;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                } else if (isInside) {
                    this.resizeLeft = false;
                    this.resizeTop = false;
                    this.resizeRight = false;
                    this.resizeBottom = false;
                    this.move = true;
                } else {
                    this.resizeLeft = false;
                    this.resizeTop = false;
                    this.resizeRight = false;
                    this.resizeBottom = false;
                    this.move = false;
                    GHMargin.this.recColor = GHMargin.this.recColor1;
                }
                if (this.move) {
                    GHMargin.this.recColor = GHMargin.this.borderColor;
                }
                this.startDragX = x;
                this.startDragY = y;
                this.startDragRect = (Rectangle)GHMargin.this.selection.clone();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            GHMargin.this.recColor = GHMargin.this.recColor1;
            GHMargin.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JHPlot.showMessage(GHMargin.this.sinfo);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GHMargin.this.recColor = GHMargin.this.recColor1;
            JHPlot.showMessage(" ");
        }
    }
}

