/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import jhplot.bsom.Data;
import jhplot.bsom.Matrix;
import jhplot.bsom.Visible2DPointArray;

class Weight
extends Visible2DPointArray {
    Matrix Ds;
    Matrix P;
    double initial_level;
    int seed = 1;

    public Weight(int r, double scale, int radius, int x, int y, double initial_level) {
        super(r, scale, radius, x, y);
        this.initial_level = initial_level;
        this.init();
    }

    public synchronized void init() {
        Matrix noise = Matrix.random(this.row, this.col, this.seed);
        this.updateLinearConv(0.0, this.initial_level, noise);
        ++this.seed;
    }

    public synchronized void update(Data X, Matrix M, double alpha, double beta, int grabed_unit) {
        double c = 1.0;
        this.Ds = this.crossSqDistance(X);
        this.P = this.Ds.multipliedBy(-beta / 2.0);
        this.P.updateExp();
        Matrix Z = this.P.verticalSum();
        this.dealZeroZ(Z, this.P, this.Ds);
        this.P.updateDivideByRowVector(Z);
        Matrix N = this.P.horizontalSum();
        N = N.diagonal();
        Matrix Ki = M.linearConv(alpha / beta, 1.0, N);
        Matrix Xm = this.P.multipliedBy(X);
        Matrix Wn = Ki.dividedBy(Xm, 5);
        if (grabed_unit >= 0) {
            Wn.value[grabed_unit][0] = this.value[grabed_unit][0];
            Wn.value[grabed_unit][1] = this.value[grabed_unit][1];
        }
        this.updateLinearConv(1.0 - c, c, Wn);
    }

    void dealZeroZ(Matrix z, Matrix P, Matrix D) {
        for (int j = 0; j < P.col; ++j) {
            if (!(z.value[0][j] <= 0.0)) continue;
            P.value[0][j] = 1.0;
            int imin = 0;
            for (int i = 1; i < P.row; ++i) {
                if (D.value[i][j] < D.value[imin][j]) {
                    P.value[imin][j] = 0.0;
                    P.value[i][j] = 1.0;
                    imin = i;
                    continue;
                }
                P.value[i][j] = 0.0;
            }
            z.value[0][j] = 1.0;
        }
    }

    public double ngp(int n, double alpha, double beta, Matrix lmd) {
        double gamma = 0.0;
        double betad = beta * (double)n / (double)this.row;
        for (int i = 0; i < this.row; ++i) {
            gamma += betad / (betad + alpha * lmd.value[0][i]);
        }
        return gamma -= 2.0;
    }

    public double updateAlpha(Matrix D, double gamma) {
        Matrix R = D.multipliedBy(this);
        double alpha = gamma * (double)this.col / R.sumSqrEntries();
        return alpha;
    }

    public double updateBeta(int n, double gamma) {
        Matrix PD = this.P.mulipliedEntriesWith(this.Ds);
        double beta = ((double)n - gamma - 2.0) * (double)this.col / PD.sumEntries();
        return beta;
    }

    public Matrix makeDensity(Matrix pos, double beta) {
        Matrix Ds = this.crossSqDistance(pos);
        Matrix P = Ds.multipliedBy(-beta / 2.0);
        P.updateExp();
        Matrix Z = P.verticalSum();
        double zmax = 0.0;
        for (int k = 0; k < Z.col; ++k) {
            if (!(Z.value[0][k] > zmax)) continue;
            zmax = Z.value[0][k];
        }
        Matrix density = Z.multipliedBy(1.0 / zmax);
        return density;
    }
}

