/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.P1D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.VHolder;
import jhplot.gui.HelpBrowser;
import jhplot.io.csv.CSVReader;
import jminhep.cluster.DataHolder;
import sharptools.Config;
import sharptools.Debug;
import sharptools.Formula;
import sharptools.SharpTableModel;
import sharptools.SharpTools;

public class SPsheet {
    private SharpTools Sharp;
    private Config config;
    private SharpTableModel model;

    public SPsheet() {
        this.showSPsheet();
    }

    public SPsheet(double[] a) {
        this.showSPsheet();
        VHolder vh = new VHolder();
        vh.setData(a);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(double[][] a) {
        this.showSPsheet();
        VHolder vh = new VHolder();
        vh.setData(a);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(P1D p1d) {
        this.showSPsheet();
        VHolder vh = new VHolder(p1d);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(PND pnd) {
        this.showSPsheet();
        VHolder vh = new VHolder(pnd);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(PNI pnd) {
        this.showSPsheet();
        VHolder vh = new VHolder(pnd);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(CSVReader reader) throws IOException {
        String[] nextLine;
        this.showSPsheet();
        int aRow = this.model.getRowCount();
        int i = 0;
        while ((nextLine = reader.readNext()) != null) {
            for (int j = 0; j < nextLine.length; ++j) {
                try {
                    double f = Double.valueOf(nextLine[j].trim());
                    this.model.doSetValueAt(new Double(f), i, j + 1);
                    continue;
                }
                catch (Exception e) {
                    this.model.doSetValueAt(nextLine[j], i, j + 1);
                }
            }
            this.model.addRow();
            ++i;
        }
    }

    public void addRow() {
        this.model.addRow();
    }

    public SPsheet(H1D h1d) {
        this.showSPsheet();
        VHolder vh = new VHolder(h1d);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(F1D f1d) {
        this.showSPsheet();
        VHolder vh = new VHolder(f1d);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public SPsheet(DataHolder dh) {
        this.showSPsheet();
        VHolder vh = new VHolder(dh);
        this.fillWithVectors(vh.getTitle(), vh.getNames(), vh.getData());
    }

    private void showSPsheet() {
        String OS = System.getProperty("os.name").toLowerCase();
        String INIDIR = System.getProperty("user.home") + File.separator + ".jehep";
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            INIDIR = System.getProperty("user.home") + File.separator + "jehep";
        }
        String INIFILE = INIDIR + File.separator + "sharptools.ini";
        this.config = new Config(INIFILE);
        this.config.setInt("ROWS", 20);
        this.config.setInt("COLUMNS", 10);
        this.config.setInt("HISTOGRAMWIDTH", 600);
        this.config.setInt("HISTOGRAMHEIGHT", 400);
        this.config.load();
        if (this.config.get("DEBUG") != null) {
            Debug.setDebug(this.config.getBoolean("DEBUG"));
        }
        Formula.registerFunctions();
        this.Sharp = new SharpTools(this.config);
        this.model = this.Sharp.getTableModel();
        this.Sharp.setVisible(true);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.model.doSetValueAt(aValue, aRow, aColumn);
    }

    public void setCellAt(Object input, int aRow, int aColumn) {
        this.model.setCellAt(input, aRow, aColumn);
    }

    public void fillWithVectors(String title, String[] names, Double[][] arrayList) {
        int i;
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            this.model.setValueAt(name, 0, i + 1);
        }
        for (i = 0; i < arrayList.length; ++i) {
            for (int j = 0; j < arrayList[0].length; ++j) {
                String a = Double.toString(arrayList[i][j]);
                try {
                    double f = Double.valueOf(a);
                    this.model.doSetValueAt(new Double(f), i, j + 1);
                }
                catch (Exception e) {
                    this.model.doSetValueAt(a, i, j + 1);
                }
                this.model.addRow();
            }
        }
    }

    public Object getValueAt(int aRow, int aColumn) {
        return this.model.getValueAt(aRow, aColumn);
    }

    public void setValueAt(double value, int aRow, int aColumn) {
        this.model.setValueAt(new Double(value), aRow, aColumn);
    }

    public void setStringAt(String value, int aRow, int aColumn) {
        this.model.setValueAt(new String(value), aRow, aColumn);
    }

    public SharpTableModel getTableModel() {
        return this.model;
    }

    public void addRow(double[] a) {
        List list = Arrays.asList(new double[][]{a});
        Vector vector = new Vector(list);
        this.model.addRow(vector);
    }

    public void insertRow(double[] a, int row) {
        List list = Arrays.asList(new double[][]{a});
        Vector vector = new Vector(list);
        this.model.insertRow(row, vector);
    }

    public void addColumn(double[] a) {
        List list = Arrays.asList(new double[][]{a});
        Vector vector = new Vector(list);
        this.model.addColumn(vector);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

