/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import jhplot.F1D;
import jhplot.P1D;
import jyplot.GraphicsUtil;
import jyplot.Jyplot;
import jyplot.JyplotVanilla;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.LengthAdjustmentType;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.python.core.ArgParser;
import org.python.core.PyArray;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;

public class Plot
extends JyplotVanilla
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Plot() {
    }

    public Plot(boolean enableJFrame) {
        super(enableJFrame);
    }

    public void export(String file) {
        this.savefig(file);
    }

    public void axhline(float y, float xmin, float xmax, float linewidth, Color color) {
        ValueMarker start = new ValueMarker(y);
        start.setStroke(new BasicStroke(linewidth));
        start.setLabelOffsetType(LengthAdjustmentType.EXPAND);
        start.setPaint(color);
        this.getChart().getXYPlot().addRangeMarker(start, Layer.BACKGROUND);
    }

    public Dataset errorbar(double[] x, double[] y, double[] xerr, double[] yerr, String label, Color color, Color cerr, int capsize, boolean barsabove) {
        Color c = color;
        Color ec = cerr;
        return this.errorbar(x, y, xerr, yerr, ec, true);
    }

    public void figure(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("figure", args, kws, new String[]{"num", "figsize", "dpi", "facecolor", "edgecolor", "frameon"});
        PyTuple figsizetuple = null;
        int dpi = ap.getInt(2, 150);
        try {
            figsizetuple = (PyTuple)ap.getPyObject(1, (PyObject)new PyTuple(new PyObject[]{new PyFloat(8.0f), new PyFloat(6.0f)}));
            this.dpi = dpi;
        }
        catch (Exception e) {
            System.out.println("Problem with figsize arguments.  They should be in the form: (8,6)");
        }
    }

    private String[] getStringArrayFromPyList(PyObject list) {
        try {
            PyList plist = (PyList)list;
            String[] result = new String[plist.__len__()];
            for (int i = 0; i < plist.__len__(); ++i) {
                result[i] = plist.__getitem__(i).__str__().toString();
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void xticksa(PyObject[] args, String[] kws) {
        int i;
        ArgParser ap = new ArgParser("xticks", args, kws, "locs", "labels");
        double[] locs = this.getDoubleArrayFromPyList(ap.getPyObject(0));
        String[] labels = this.getStringArrayFromPyList(ap.getPyObject(1, null));
        double max = locs[0];
        double min = locs[0];
        for (int i2 = 0; i2 < locs.length; ++i2) {
            max = Math.max(max, locs[i2]);
            min = Math.min(min, locs[i2]);
        }
        int maxi = (int)max;
        int mini = (int)min;
        int sizeOfArray = maxi - mini;
        boolean generateLabelsFromLocations = false;
        if (labels == null) {
            labels = new String[sizeOfArray];
            generateLabelsFromLocations = true;
        }
        for (i = 0; i < labels.length; ++i) {
            labels[i] = new String("");
        }
        for (i = 0; i < locs.length; ++i) {
        }
        i = 0;
        int j = mini;
        while (i < locs.length) {
            if (generateLabelsFromLocations) {
                // empty if block
            }
            ++i;
            ++j;
        }
        if (this.chart != null) {
            NumberAxis numberAxis = (NumberAxis)this.chart.getXYPlot().getDomainAxis();
        } else {
            System.out.println("xticks(): No chart created");
        }
    }

    public void setp(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("xticks", args, kws, "locs", "labels");
        double[] locs = this.getDoubleArrayFromPyList(ap.getPyObject(0));
        String[] labels = this.getStringArrayFromPyList(ap.getPyObject(1, null));
    }

    double[] getDoubleArrayFromPyList(PyObject list) {
        if (list == null) {
            return null;
        }
        try {
            if (list instanceof PyList) {
                PyList plist = (PyList)list;
                double[] result = new double[plist.__len__()];
                for (int i = 0; i < plist.__len__(); ++i) {
                    result[i] = plist.__getitem__(i).__float__().getValue();
                }
                return result;
            }
            if (list instanceof PyArray) {
                PyArray parray = (PyArray)list;
                double[] result = new double[parray.__len__()];
                for (int i = 0; i < parray.__len__(); ++i) {
                    result[i] = parray.__getitem__(i).__float__().getValue();
                }
                return result;
            }
            if (list instanceof PyFloat) {
                PyFloat fl = (PyFloat)list;
                double[] result = new double[]{fl.getValue()};
                return result;
            }
            if (list instanceof PyInteger) {
                PyInteger fl = (PyInteger)list;
                double[] result = new double[]{fl.getValue()};
                return result;
            }
            System.err.println("Failed to convert " + list.getClass().getName() + " into double[]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void legendtest(PyObject[] args, String[] kws) {
        System.out.println("legend(PyObject[] args, String[] kw) currently does not work");
    }

    @Override
    public void savefig(String filename) {
        int calculatedWidth = (int)this.figureWidth * this.dpi;
        int calculatedHeight = (int)this.figureHeight * this.dpi;
        if (calculatedWidth <= 0) {
            calculatedWidth = 300;
        }
        if (calculatedHeight <= 0) {
            calculatedHeight = 200;
        }
        this.savefig(filename, calculatedWidth, calculatedHeight);
    }

    @Override
    public void savefig(String filename, int width, int height) {
        block16: {
            try {
                String fname = filename;
                String filetype = fname.substring(fname.length() - 3);
                if (filetype.equalsIgnoreCase("png")) {
                    BufferedImage b = new BufferedImage(width, height, 1);
                    Graphics2D g = b.createGraphics();
                    this.drawToGraphics2D(g, width, height);
                    g.dispose();
                    ImageIO.write((RenderedImage)b, "png", new File(fname));
                    break block16;
                }
                if (filetype.equalsIgnoreCase("jpg") || filetype.equalsIgnoreCase("jpeg")) {
                    BufferedImage b = new BufferedImage(width, height, 1);
                    Graphics2D g = b.createGraphics();
                    this.drawToGraphics2D(g, width, height);
                    g.dispose();
                    ImageIO.write((RenderedImage)b, "jpg", new File(fname));
                    break block16;
                }
                if (filetype.equalsIgnoreCase("eps")) {
                    try {
                        FileOutputStream outputStream = new FileOutputStream(fname);
                        EpsGraphics2D g = new EpsGraphics2D("Example", outputStream, 0, 0, width, height);
                        this.drawToGraphics2D(g, width, height);
                        g.flush();
                        g.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Problem writing eps");
                        System.err.println("Epsgraphics2D.jar present in classpath?");
                    }
                    break block16;
                }
                if (filetype.equalsIgnoreCase("pdf")) {
                    try {
                        FileOutputStream outputStream = new FileOutputStream(fname);
                        DefaultFontMapper mapper = new DefaultFontMapper();
                        Rectangle pagesize = new Rectangle((float)width, (float)height);
                        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
                        try {
                            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
                            document.open();
                            PdfContentByte cb = writer.getDirectContent();
                            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                            Graphics2D g = tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
                            this.drawToGraphics2D(g, width, height);
                            g.dispose();
                            cb.addTemplate(tp, 0.0f, 0.0f);
                        }
                        catch (DocumentException de) {
                            System.err.println(de.getMessage());
                        }
                        document.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Cannot find itext library, cannot create pdf.");
                    }
                    break block16;
                }
                if (filetype.equalsIgnoreCase("svg")) {
                    try {
                        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                        org.w3c.dom.Document document = domImpl.createDocument(null, "svg", null);
                        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
                        svgGenerator.getGeneratorContext().setPrecision(6);
                        this.drawToGraphics2D((Graphics2D)svgGenerator, width, height);
                        boolean useCSS = true;
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filename)), "UTF-8");
                        svgGenerator.stream((Writer)out, useCSS);
                        ((Writer)out).close();
                    }
                    catch (DOMException e) {
                        System.err.println("Problem writing to SVG");
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Missing Batik libraries?");
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Dataset plot(PyObject[] args, String[] kws) {
        boolean separateYAxis;
        ArgParser ap = new ArgParser("plot", args, kws, new String[]{"x", "y", "shape", "color", "label", "separateYAxis"});
        double[] x = this.getDoubleArrayFromPyList(ap.getPyObject(0, null));
        double[] y = this.getDoubleArrayFromPyList(ap.getPyObject(1, null));
        if (x == null) {
            System.err.println("x is null");
            return null;
        }
        if (y == null) {
            y = x;
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        }
        String label = ap.getString(4, "");
        XYSeries series = new XYSeries((Comparable)((Object)label));
        boolean xlogarithmic = this.isDomainLogarithmic();
        boolean ylogarithmic = this.isRangeLogarithmic();
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i]) || Double.isInfinite(x[i]) || Double.isInfinite(y[i]) || xlogarithmic && x[i] <= 0.0 || ylogarithmic && y[i] <= 0.0) continue;
            series.add(x[i], y[i]);
        }
        if (label != null) {
            series.setKey((Comparable)((Object)label));
        }
        if (this.chart == null) {
            this.createXYChart();
        }
        this.chart.setBorderPaint(DEFAULT_BG_COLOR);
        this.chart.setBackgroundPaint(DEFAULT_BG_COLOR);
        this.chart.setBorderVisible(false);
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint(DEFAULT_BG_COLOR);
        int currentDatasetIndex = plot.getDatasetCount();
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        plot.setDataset(currentDatasetIndex, dataset);
        XYLineAndShapeRenderer renderer = null;
        renderer = new XYLineAndShapeRenderer();
        plot.setRenderer(currentDatasetIndex, renderer);
        String shapeString = ap.getString(2, "");
        this.setShapesVisible(shapeString.length() > 0);
        Color color = this.getColorFromPyObject(ap.getPyObject(3, null));
        boolean bl = separateYAxis = ap.getInt(5, 0) != 0;
        if (separateYAxis) {
            this.setSeperateYAxis("", color, true);
        }
        this.setSeriesColor(color);
        if (label == null || label.equalsIgnoreCase("")) {
            renderer.setSeriesVisibleInLegend(false);
        }
        this.chart.getXYPlot().configureDomainAxes();
        this.chart.getXYPlot().configureRangeAxes();
        this.grid(false);
        return dataset;
    }

    public Dataset bar(PyObject[] args, String[] kws) {
        double[] bottom;
        double[] width;
        ArgParser ap = new ArgParser("bar", args, kws, new String[]{"left", "height", "width", "bottom", "color", "edgecolor", "linewidth", "yerr", "xerr", "ecolor", "capsize", "align", "orientation", "log"});
        double[] left = this.getDoubleArrayFromPyList(ap.getPyObject(0, null));
        double[] height = this.getDoubleArrayFromPyList(ap.getPyObject(1, null));
        if (left == null) {
            System.err.println("left is null");
            return null;
        }
        if (height == null) {
            height = left;
            left = new double[height.length];
            for (int i = 0; i < height.length; ++i) {
                left[i] = (double)i - 0.5;
            }
        }
        if ((width = this.getDoubleArrayFromPyList(ap.getPyObject(2, null))) == null) {
            width = new double[height.length];
            for (int i = 0; i < height.length; ++i) {
                width[i] = 1.0;
            }
        }
        if ((bottom = this.getDoubleArrayFromPyList(ap.getPyObject(3, null))) == null) {
            bottom = new double[height.length];
            for (int i = 0; i < height.length; ++i) {
                bottom[i] = 0.0;
            }
        }
        Color color = null;
        PyObject colorObject = ap.getPyObject(4, null);
        if (colorObject != null) {
            try {
                color = (Color)colorObject.__tojava__(Color.class);
            }
            catch (RuntimeException e) {
                color = GraphicsUtil.getColorFromString(colorObject.toString());
            }
        }
        return this.bar(left, height, width, bottom, color);
    }

    private Color getColorFromPyObject(PyObject pyobject) {
        Color c = null;
        if (pyobject == null) {
            return null;
        }
        try {
            if (pyobject instanceof PyList) {
                PyList parray = (PyList)pyobject;
                int[] result = new int[parray.__len__()];
                for (int i = 0; i < parray.__len__(); ++i) {
                    result[i] = (int)parray.__getitem__(i).__float__().getValue();
                }
                if (result.length == 1) {
                    return new Color(result[0]);
                }
                if (result.length == 3) {
                    return new Color(result[0], result[1], result[2]);
                }
                if (result.length == 4) {
                    return new Color(result[0], result[1], result[2], result[3]);
                }
            } else if (pyobject instanceof PyArray) {
                PyArray parray = (PyArray)pyobject;
                int[] result = new int[parray.__len__()];
                for (int i = 0; i < parray.__len__(); ++i) {
                    result[i] = (int)parray.__getitem__(i).__float__().getValue();
                }
                if (result.length == 1) {
                    return new Color(result[0]);
                }
                if (result.length == 3) {
                    return new Color(result[0], result[1], result[2]);
                }
                if (result.length == 4) {
                    return new Color(result[0], result[1], result[2], result[3]);
                }
            } else {
                if (pyobject instanceof PyString) {
                    return this.getColor(pyobject.toString());
                }
                if (Class.forName("java.awt.Color").isInstance(pyobject)) {
                    return (Color)pyobject.__tojava__(Color.class);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public Dataset semilogx(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("semilogx", args, kws, new String[]{"basex", "subsx"});
        Dataset dataset = this.plot(args, kws);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        String xlabel = plot.getDomainAxis().getLabel();
        plot.setDomainAxis(new LogarithmicAxis(xlabel));
        return dataset;
    }

    public Dataset semilogy(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("semilogy", args, kws, new String[]{"basex", "subsx"});
        Dataset dataset = this.plot(args, kws);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        String ylabel = plot.getRangeAxis().getLabel();
        plot.setRangeAxis(new LogarithmicAxis(ylabel));
        return dataset;
    }

    public Dataset loglog(PyObject[] args, String[] kws) {
        Dataset dataset = this.plot(args, kws);
        ArrayList<Number> xValuesToRemove = new ArrayList<Number>();
        for (int i = 0; i < ((XYSeriesCollection)dataset).getSeriesCount(); ++i) {
            XYSeries series = ((XYSeriesCollection)dataset).getSeries(i);
            xValuesToRemove.clear();
            for (int j = 0; j < series.getItemCount(); ++j) {
                if (!(series.getX(j).doubleValue() <= 0.0) && !(series.getY(j).doubleValue() <= 0.0)) continue;
                xValuesToRemove.add(series.getX(j));
            }
            for (Number number : xValuesToRemove) {
                series.remove(number);
            }
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        String ylabel = plot.getRangeAxis().getLabel();
        plot.setRangeAxis(new LogarithmicAxis(ylabel));
        String xlabel = plot.getDomainAxis().getLabel();
        plot.setDomainAxis(new LogarithmicAxis(xlabel));
        return dataset;
    }

    public static void main(String[] args) {
        PythonInterpreter python = new PythonInterpreter();
        Jyplot p = new Jyplot();
        PyObject[] x = new PyObject[]{new PyFloat(0.1), new PyFloat(1.0f), new PyFloat(10.0f), new PyFloat(100.0f), new PyFloat(1000.0f)};
        PyObject[] y = new PyObject[]{new PyFloat(10.0f), new PyFloat(6.0f), new PyFloat(260.0f), new PyFloat(140.0f), new PyFloat(15000.0f)};
        PyList xx = new PyList(x);
        PyList yy = new PyList(y);
        p.loglog(new PyObject[]{xx, yy}, null);
        p.show();
        p.savefig("a.pdf", 300, 200);
    }

    public void draw(double[] x, double[] y) {
        this.plot(x, y);
    }

    public void draw(P1D p) {
        this.plot(p.getArrayX(), p.getArrayY());
    }

    public void draw(F1D f1, double min, double max) {
        f1.eval(min, max, f1.getPoints());
        this.plot(f1.getArrayX(), f1.getArrayY());
    }

    private boolean isDomainLogarithmic() {
        if (this.chart == null) {
            return false;
        }
        return this.chart.getXYPlot().getDomainAxis().getClass().getName().contains("Logarithmic");
    }

    private boolean isRangeLogarithmic() {
        if (this.chart == null) {
            return false;
        }
        return this.chart.getXYPlot().getRangeAxis().getClass().getName().contains("Logarithmic");
    }
}

