/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jhplot.F2D;
import jhplot.H2D;
import jhplot.P2D;
import jhplot.P3D;
import jhplot.gui.CommonGUI;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.io.BrowserData;
import jhplot.utils.HelpDialog;
import jplot3d.JSurfacePanel;
import jplot3d.SurfaceModel;
import jplot3d.SurfaceModelCanvas;

public class HPlot3D
extends GHFrame {
    private static final long serialVersionUID = 1L;
    public boolean set = true;
    private JSurfacePanel[][] jpp = new JSurfacePanel[this.N1final][this.N2final];
    private SurfaceModelCanvas[][] sp = new SurfaceModelCanvas[this.N1final][this.N2final];
    protected static int Nframe = 0;
    private Thread1 m_Close;
    protected static int isOpen = 0;
    private boolean changeStyleCalled = false;
    private final String help_file = "hplot3d";

    public HPlot3D(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set, 1);
        Nframe = 0;
        this.changeStyleCalled = false;
        int Ntot = this.N1final * this.N2final;
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.jpp[i1][i2] = new JSurfacePanel();
                this.sp[i1][i2] = this.jpp[i1][i2].createDefaultSurfaceModel();
                this.jpp[i1][i2].setSurface(this.sp[i1][i2]);
                if (set) {
                    this.mainPanel.add(this.jpp[i1][i2]);
                }
                float r = this.sp[i1][i2].get2DScaling();
                if (Ntot > 1 && Ntot < 3) {
                    r *= 0.9f;
                }
                if (Ntot > 2 && Ntot < 5) {
                    r *= 0.8f;
                }
                if (Ntot > 4 && Ntot < 9) {
                    r *= 0.6f;
                }
                if (Ntot > 8) {
                    r *= 0.5f;
                }
                this.sp[i1][i2].set2DScaling(r);
                this.sp[i1][i2].getColorModel().setBoxColor(Color.white);
                ++Nframe;
            }
        }
    }

    public void resizePad(double widthScale, double heightScale) {
        Dimension dim = this.jpp[N1][N2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.jpp[N1][N2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.jpp[N1][N2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.jpp[N1][N2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public void resizePad(int n1, int n2, double widthScale, double heightScale) {
        Dimension dim = this.jpp[n1][n2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.jpp[n1][n2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.jpp[n1][n2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.jpp[n1][n2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public HPlot3D(String title, int xsize, int ysize, int n1, int n2) {
        this(title, xsize, ysize, n1, n2, true);
    }

    @Override
    protected void clearFrame() {
    }

    @Override
    protected void refreshFrame() {
    }

    public void setDistance(double distance) {
        this.sp[N1][N2].getProjector().setDistance((float)distance);
    }

    public double getDistance() {
        return this.sp[N1][N2].getProjector().getDistance();
    }

    public void setScaling(double scale) {
        this.sp[N1][N2].getProjector().set2DScaling((float)scale);
    }

    public double getScaling() {
        return this.sp[N1][N2].getProjector().get2DScaling();
    }

    public void setRotationAngle(double angle) {
        this.sp[N1][N2].getProjector().setRotationAngle((float)angle);
    }

    public double getRotationAngle() {
        return this.sp[N1][N2].getProjector().getRotationAngle();
    }

    public void setElevationAngle(double angle) {
        this.sp[N1][N2].getProjector().setElevationAngle((float)angle);
    }

    public double getElevationAngle() {
        return this.sp[N1][N2].getProjector().getElevationAngle();
    }

    public void setLabelFontColor(Color fontColorLabel) {
        this.sp[N1][N2].setFontColorLabel(fontColorLabel);
    }

    @Override
    protected void openWriteDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HPlot3D");
    }

    @Override
    protected void openReadDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HPlot3D");
    }

    private void showIt() {
        this.updateAll();
        this.mainFrame.setVisible(true);
    }

    public void update(int n1, int n2) {
        this.jpp[n1][n2].evaluate();
    }

    public void updateData(int n1, int n2) {
        this.jpp[n1][n2].evaluate();
    }

    public void updateData() {
        this.updateData(N1, N2);
    }

    public double getLabelOffset(int axes) {
        double tmp = 1.0;
        if (axes == 0) {
            return this.sp[N1][N2].getLabelOffsetX();
        }
        if (axes == 1) {
            return this.sp[N1][N2].getLabelOffsetY();
        }
        if (axes == 2) {
            return this.sp[N1][N2].getLabelOffsetZ();
        }
        return tmp;
    }

    public void updateAll() {
        if (this.N1final == 0 && this.N2final == 0) {
            return;
        }
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.update(i1, i2);
            }
        }
    }

    public HPlot3D(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public HPlot3D(String title) {
        this(title, 600, 600, 1, 1, true);
    }

    public HPlot3D() {
        this("Default", 600, 600, 1, 1, true);
    }

    public void clear() {
        this.drawBox();
    }

    public void clear(int i1, int i2) {
        this.drawBox();
        System.gc();
    }

    public void setPenWidthAxes(double w) {
        this.sp[N1][N2].setPenWidth((float)w);
    }

    public float getPenWidthAxes() {
        return this.sp[N1][N2].getPenWidth();
    }

    public void drawBox() {
        this.jpp[N1][N2].setEmpty();
        this.update();
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAll();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.jpp[i1][i2] = null;
                this.sp[i1][i2] = null;
            }
        }
        this.jpp = null;
        this.sp = null;
        this.removeFrame();
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.mainFrame.setVisible(false);
            this.mainFrame.validate();
        }
        if (vs) {
            this.showIt();
        }
    }

    public void visible(int posX, int posY) {
        this.updateAll();
        this.mainFrame.setLocation(posX, posY);
        this.mainFrame.setVisible(true);
    }

    public void visible() {
        this.visible(true);
    }

    public boolean isSurface() {
        boolean tmp = false;
        if (this.sp[N1][N2].getPlotType() == SurfaceModel.PlotType.SURFACE) {
            tmp = true;
        }
        return tmp;
    }

    public void setNameX(String a) {
        this.sp[N1][N2].setXlabel(a);
    }

    public void setNameY(String a) {
        this.sp[N1][N2].setYlabel(a);
    }

    public void setNameZ(String a) {
        this.sp[N1][N2].setZlabel(a);
    }

    public void setLabelFont(Font a) {
        this.sp[N1][N2].setLabelFont(a);
    }

    public void setAxisFont(Font fontAxis) {
        this.sp[N1][N2].setAxisFont(fontAxis);
    }

    public Font getAxisFont() {
        return this.sp[N1][N2].getAxisFont();
    }

    public void setLabelColor(Color a) {
        this.sp[N1][N2].setLabelColor(a);
    }

    public void setColorLines(Color a) {
        this.sp[N1][N2].getColorModel().setLineBoxColor(a);
    }

    public void setColorFill(Color a) {
        this.sp[N1][N2].getColorModel().setFillColor(a);
    }

    public void setFill(boolean fill) {
    }

    public void setTicFont(Font a) {
        this.sp[N1][N2].setTicFont(a);
    }

    public void setDisplayXY(boolean a) {
        this.sp[N1][N2].setDisplayXY(a);
    }

    public void setDivisions(int v) {
        this.sp[N1][N2].setCalcDivisions(v);
    }

    public void setContourLines(int v) {
        this.sp[N1][N2].setContourLines(v);
    }

    public void setDisplayGrids(boolean a) {
        this.sp[N1][N2].setDisplayGrids(a);
    }

    public void setDisplayZ(boolean a) {
        this.sp[N1][N2].setDisplayZ(a);
    }

    public void setContour() {
        this.setContour(true);
    }

    public void setContour(boolean a) {
        this.changeStyleCalled = true;
        this.sp[N1][N2].setBarsType(false);
        this.sp[N1][N2].setContourType(a);
    }

    public void setDensity() {
        this.setDensity(true);
    }

    public void setDensity(boolean a) {
        this.changeStyleCalled = true;
        this.sp[N1][N2].setBarsType(false);
        this.sp[N1][N2].setDensityType(a);
    }

    public void setSurface() {
        this.setSurface(true);
    }

    public void setSurface(boolean a) {
        this.changeStyleCalled = true;
        this.sp[N1][N2].setSurfaceType(a);
    }

    public void setBars() {
        this.setBars(true);
    }

    public void setBars(boolean a) {
        this.changeStyleCalled = true;
        this.sp[N1][N2].setBarsType(a);
    }

    public void setBoxColor(Color a) {
        this.sp[N1][N2].getColorModel().setBoxColor(a);
    }

    public void setFrameColor(Color a) {
        this.sp[N1][N2].getColorModel().setBackgroundColor(a);
    }

    public void setBoxed(boolean boxed) {
        this.sp[N1][N2].setBoxed(boxed);
    }

    public Color getAxesFontColor() {
        return this.sp[N1][N2].getAxesFontColor();
    }

    public void setAxesFontColor(Color fontColorAxes) {
        this.sp[N1][N2].setAxesFontColor(fontColorAxes);
    }

    public Color getFrameColor() {
        return this.sp[N1][N2].getColorModel().getBackgroundColor();
    }

    public void setColorMode(int a) {
        if (a == 0) {
            this.sp[N1][N2].setWireframeType(true);
        }
        if (a == 1) {
            this.sp[N1][N2].setHiddenMode(true);
        }
        if (a == 2) {
            this.sp[N1][N2].setSpectrumMode(true);
        }
        if (a == 3) {
            this.sp[N1][N2].setGrayScaleMode(true);
        }
        if (a == 4) {
            this.sp[N1][N2].setDualShadeMode(true);
        }
        if (a == 5) {
            this.sp[N1][N2].setFogMode(true);
        }
        if (a == 6) {
            this.sp[N1][N2].setMesh(true);
        }
    }

    public SurfaceModelCanvas getSurfaceModel() {
        return this.sp[N1][N2];
    }

    public int getColorMode() {
        int tmp = -1;
        SurfaceModel.PlotType i = this.sp[N1][N2].getPlotType();
        if (i == SurfaceModel.PlotType.WIREFRAME) {
            tmp = 0;
        }
        if (this.sp[N1][N2].isHiddenMode()) {
            tmp = 1;
        }
        if (this.sp[N1][N2].isSpectrumMode()) {
            tmp = 2;
        }
        if (this.sp[N1][N2].isGrayScaleMode()) {
            tmp = 3;
        }
        if (this.sp[N1][N2].isDualShadeMode()) {
            tmp = 4;
        }
        if (this.sp[N1][N2].isFogMode()) {
            tmp = 5;
        }
        if (this.sp[N1][N2].isMesh()) {
            tmp = 6;
        }
        return tmp;
    }

    public Color getLabelColor() {
        return this.sp[N1][N2].getLabelColor();
    }

    public void update() {
        this.jpp[N1][N2].evaluate();
    }

    public void setTicOffset(double a) {
        this.sp[N1][N2].setTicOffset((float)a);
    }

    public void setLabelOffsetX(double a) {
        this.sp[N1][N2].setLabelOffsetX((float)a);
    }

    public void setLabelOffsetY(double a) {
        this.sp[N1][N2].setLabelOffsetY((float)a);
    }

    public void setLabelOffsetZ(double a) {
        this.sp[N1][N2].setLabelOffsetZ((float)a);
    }

    public void setRange(double Xmin, double Xmax, double Ymin, double Ymax) {
        this.sp[N1][N2].setXMin((float)Xmin);
        this.sp[N1][N2].setXMax((float)Xmax);
        this.sp[N1][N2].setYMin((float)Ymin);
        this.sp[N1][N2].setYMax((float)Ymax);
        this.sp[N1][N2].setAutoScaleXY(false);
    }

    public void setRange(double Xmin, double Xmax, double Ymin, double Ymax, double Zmin, double Zmax) {
        this.sp[N1][N2].setXMin((float)Xmin);
        this.sp[N1][N2].setXMax((float)Xmax);
        this.sp[N1][N2].setYMin((float)Ymin);
        this.sp[N1][N2].setYMax((float)Ymax);
        this.sp[N1][N2].setZMin((float)Zmin);
        this.sp[N1][N2].setZMax((float)Zmax);
        this.setAutoRange(false);
    }

    public void setRangeZ(double Zmin, double Zmax) {
        this.sp[N1][N2].setZMin((float)Zmin);
        this.sp[N1][N2].setZMax((float)Zmax);
        this.sp[N1][N2].setAutoScaleZ(false);
    }

    public void draw(H2D f1) {
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        if (f1.getLabelZ() != null && f1.getLabelZ().length() > 0) {
            this.setNameZ(f1.getLabelZ());
        }
        if (!this.changeStyleCalled) {
            this.setBars(true);
        }
        this.jpp[N1][N2].setH2D(f1);
        this.update();
    }

    public void draw(H2D[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.draw(d[i]);
        }
    }

    public void draw(P2D h1) {
        if (h1.getLabelX() != null && h1.getLabelX().length() > 0) {
            this.setNameX(h1.getLabelX());
        }
        if (h1.getLabelY() != null && h1.getLabelY().length() > 0) {
            this.setNameY(h1.getLabelY());
        }
        if (h1.getLabelZ() != null && h1.getLabelZ().length() > 0) {
            this.setNameZ(h1.getLabelZ());
        }
        this.jpp[N1][N2].setP2D(h1);
        this.update();
    }

    public void draw(P2D[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.draw(d[i]);
        }
    }

    public void setAutoRange(boolean b) {
        this.sp[N1][N2].setAutoScaleZ(b);
        this.sp[N1][N2].setAutoScaleXY(b);
    }

    public void setAutoRangeAll(boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.sp[i1][i2].setAutoScaleZ(b);
                this.sp[i1][i2].setAutoScaleXY(b);
            }
        }
    }

    public void setAutoRange() {
        this.setAutoRange(true);
    }

    public void setAutoRangeXY() {
        this.sp[N1][N2].setAutoScaleXY(true);
    }

    public void draw(P3D h) {
        this.jpp[N1][N2].setP3D(h);
        this.update();
    }

    public void draw(P3D[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.draw(d[i]);
        }
    }

    public void draw(H2D h1, H2D h2) {
        this.jpp[N1][N2].setH2D(h1);
        this.jpp[N1][N2].setH2D(h2);
        this.update();
    }

    public void draw(F2D f1) {
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        if (f1.getLabelZ() != null && f1.getLabelZ().length() > 0) {
            this.setNameZ(f1.getLabelZ());
        }
        this.jpp[N1][N2].setF2D(f1);
        this.update();
    }

    public void draw(F2D f1, F2D f2) {
        this.jpp[N1][N2].setF2D(f1);
        this.jpp[N1][N2].setF2D(f2);
        this.update();
    }

    public void draw(H2D h1, F2D h2) {
        if (h1.getLabelX() != null && h1.getLabelX().length() > 0) {
            this.setNameX(h1.getLabelX());
        }
        if (h1.getLabelY() != null && h1.getLabelY().length() > 0) {
            this.setNameY(h1.getLabelY());
        }
        if (h1.getLabelZ() != null && h1.getLabelZ().length() > 0) {
            this.setNameZ(h1.getLabelZ());
        }
        this.jpp[N1][N2].setH2D(h1);
        this.jpp[N1][N2].setF2D(h2);
        this.update();
    }

    public void draw(F2D h2, H2D h1) {
        this.jpp[N1][N2].setH2D(h1);
        this.jpp[N1][N2].setF2D(h2);
        this.update();
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    @Override
    protected void showHelp() {
        new HelpDialog((Component)this.getFrame(), "hplot3d.html");
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    protected void openReadDataDialog() {
        JFileChooser fileChooser = CommonGUI.openDataFileChooser(this.getFrame());
        int ret = fileChooser.showDialog(this.getFrame(), "Open Data file");
        if (ret == 0) {
            new BrowserData(fileChooser.getSelectedFile().getAbsolutePath(), this);
        }
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HPlot3D.this.quit();
        }
    }
}

