/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import cern.jet.random.AbstractDistribution;
import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.VariableAxis;
import hep.io.root.interfaces.TH2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import jhplot.DrawOptions;
import jhplot.F2D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import root.Converter;

public class H2D
extends DrawOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Histogram2D h1;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int binsX;
    private int binsY;
    private IAxis xAx;
    private IAxis yAy;

    public H2D(String title, int binsX, double minX, double maxX, int binsY, double minY, double maxY) {
        this.is3D = true;
        this.title = title;
        this.binsX = binsX;
        this.minX = minX;
        this.maxX = maxX;
        this.binsY = binsY;
        this.minY = minY;
        this.maxY = maxY;
        this.xAx = new FixedAxis(this.binsX, this.minX, this.maxX);
        this.yAy = new FixedAxis(this.binsY, this.minY, this.maxY);
        this.h1 = new Histogram2D(this.title, this.title, this.xAx, this.yAy);
    }

    public H2D(IHistogram2D h1) {
        this.setStyle("h");
        this.is3D = true;
        this.h1 = (Histogram2D)h1;
        this.setTitle(h1.title());
        this.xAx = h1.xAxis();
        this.yAy = h1.yAxis();
        this.minX = this.xAx.lowerEdge();
        this.maxX = this.xAx.upperEdge();
        this.minY = this.yAy.lowerEdge();
        this.maxY = this.yAy.upperEdge();
        this.binsX = this.xAx.bins();
        this.binsY = this.yAy.bins();
    }

    public H2D(Cloud2D c2d, int binX, int binY) {
        this.setStyle("h");
        this.is3D = true;
        this.title = c2d.title();
        this.setTitle(c2d.title());
        this.minX = c2d.lowerEdgeX();
        this.maxX = c2d.upperEdgeX();
        this.minY = c2d.lowerEdgeY();
        this.maxY = c2d.upperEdgeY();
        this.binsX = binX;
        this.binsY = binY;
        this.xAx = new FixedAxis(this.binsX, this.minX, this.maxX);
        this.yAy = new FixedAxis(this.binsY, this.minY, this.maxY);
        this.h1 = new Histogram2D(this.title, this.title, this.xAx, this.yAy);
        this.fill(c2d);
    }

    public H2D(String title, double[] edgesX, double[] edgesY) {
        this.is3D = true;
        this.title = title;
        this.binsX = edgesX.length - 1;
        this.binsY = edgesY.length - 1;
        this.minX = edgesX[0];
        this.maxX = edgesX[edgesX.length - 1];
        this.minY = edgesY[0];
        this.maxY = edgesY[edgesY.length - 1];
        this.xAx = new VariableAxis(edgesX);
        this.yAy = new VariableAxis(edgesY);
        this.h1 = new Histogram2D(this.title, this.title, this.xAx, this.yAy);
    }

    public H2D(String title, IAxis xAx, IAxis yAy) {
        this.is3D = true;
        this.title = title;
        this.binsX = xAx.bins();
        this.minX = xAx.lowerEdge();
        this.maxX = xAx.upperEdge();
        this.binsY = yAy.bins();
        this.minY = yAy.lowerEdge();
        this.maxY = yAy.upperEdge();
        this.h1 = new Histogram2D(this.title, this.title, xAx, yAy);
    }

    public H2D(Histogram2D h1) {
        this.is3D = true;
        this.h1 = h1;
        this.setTitle(h1.title());
        this.xAx = h1.xAxis();
        this.yAy = h1.yAxis();
        this.minX = this.xAx.lowerEdge();
        this.maxX = this.xAx.upperEdge();
        this.minY = this.yAy.lowerEdge();
        this.maxY = this.yAy.upperEdge();
        this.binsX = this.xAx.bins();
        this.binsY = this.yAy.bins();
    }

    public Histogram2D get() {
        return this.h1;
    }

    public H2D(TH2 h2t) {
        this.h1 = Converter.convert(h2t, h2t.getTitle());
    }

    public void setRmsY(double rmsY) {
        this.h1.setRmsY(rmsY);
    }

    public void setMeanY(double mean) {
        this.h1.setMeanY(mean);
    }

    public double getRmsY() {
        return this.h1.rmsY();
    }

    public double getMeanY() {
        return this.h1.meanY();
    }

    public double getMeanX() {
        return this.h1.meanX();
    }

    public double getRmsX() {
        return this.h1.rmsX();
    }

    public void setNEntries(int entries) {
        this.h1.setNEntries(entries);
    }

    public void setValidEntries(int entries) {
        this.h1.setValidEntries(entries);
    }

    public void setRmsX(double rmsX) {
        this.h1.setRmsX(rmsX);
    }

    public void setMeanX(double mean) {
        this.h1.setMeanX(mean);
    }

    public void setContents(double[][] heights, double[][] errors) {
        this.h1.setContents(heights, errors, null, null, null, null, null);
    }

    public void setContents(double[][] heights, double[][] errors, int[][] entries, double[][] meanXs, double[][] rmsXs, double[][] meanYs, double[][] rmsYs) {
        this.h1.setContents(heights, errors, entries, meanXs, rmsXs, meanYs, rmsYs);
    }

    public void fill(double value1, double value2) {
        this.h1.fill(value1, value2);
    }

    public void fillGauss(int TotNumber, double meanX, double sdX, double meanY, double sdY) {
        Random random = new Random();
        for (int i = 0; i < TotNumber; ++i) {
            this.h1.fill(sdX * random.nextGaussian() + meanX, sdY * random.nextGaussian() + meanY);
        }
    }

    public void fillRnd(int TotNumber, double meanX, double widthX, double meanY, double widthY) {
        Random random = new Random();
        for (int i = 0; i < TotNumber; ++i) {
            this.h1.fill(widthX * random.nextDouble() + meanX, widthY * random.nextDouble() + meanY);
        }
    }

    public void fill(int TotNumber, AbstractDistribution random1, AbstractDistribution random2) {
        for (int i = 0; i < TotNumber; ++i) {
            this.h1.fill(random1.nextDouble(), random2.nextDouble());
        }
    }

    public void setBinError(int indexX, int indexY, double error) {
        this.h1.setBinError(indexX, indexY, error);
    }

    public double binHeight(int indexX, int indexY) {
        return this.h1.binHeight(indexX, indexY);
    }

    public int extraEntries() {
        return this.h1.extraEntries();
    }

    public double sumExtraBinHeights() {
        return this.h1.sumExtraBinHeights();
    }

    public double sumAllBinHeights() {
        return this.h1.sumAllBinHeights();
    }

    public int getBinsX() {
        return this.h1.xAxis().bins();
    }

    public int getBinsY() {
        return this.h1.yAxis().bins();
    }

    public double getMinX() {
        return this.h1.xAxis().lowerEdge();
    }

    public double getMaxX() {
        return this.h1.xAxis().upperEdge();
    }

    public double getMaxY() {
        return this.h1.yAxis().upperEdge();
    }

    public double getMinY() {
        return this.h1.yAxis().lowerEdge();
    }

    public int getUnderflowEntriesY() {
        return this.h1.binEntriesY(-2);
    }

    public double getUnderflowHeightY() {
        return this.h1.binHeightY(-2);
    }

    public double getUnderflowHeightX() {
        return this.h1.binHeightX(-2);
    }

    public int getUnderflowEntriesX() {
        return this.h1.binEntriesY(-2);
    }

    public int getOverflowEntriesY() {
        return this.h1.binEntriesY(-1);
    }

    public double getOverflowHeightY() {
        return this.h1.binHeightY(-1);
    }

    public int getOverflowEntriesX() {
        return this.h1.binEntriesX(-1);
    }

    public double getOverflowHeightX() {
        return this.h1.binHeightX(-1);
    }

    public double getLowerEdgeX(int index) {
        return this.h1.xAxis().binLowerEdge(index);
    }

    public H2D oper(H2D a, String title, String what) {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(af.createTreeFactory().create());
        if (what.equals("+")) {
            IHistogram2D hnew = hf.add(title, (IHistogram2D)this.get(), (IHistogram2D)a.get());
            return new H2D(hnew);
        }
        if (what.equals("-")) {
            IHistogram2D hnew = hf.subtract(title, (IHistogram2D)this.get(), (IHistogram2D)a.get());
            return new H2D(hnew);
        }
        if (what.equals("*")) {
            IHistogram2D hnew = hf.multiply(title, (IHistogram2D)this.get(), (IHistogram2D)a.get());
            return new H2D(hnew);
        }
        if (what.equals("/")) {
            IHistogram2D hnew = hf.divide(title, (IHistogram2D)this.get(), (IHistogram2D)a.get());
            return new H2D(hnew);
        }
        this.ErrorMessage("Operation \"" + what + "\" is not implemented");
        return this;
    }

    public void scale(String title, double scaleFactor) {
        this.title = title;
        this.h1.scale(scaleFactor);
    }

    public H2D operScale(String title, double scaleFactor) {
        this.scale(title, scaleFactor);
        return this;
    }

    public double getUpperEdgeX(int index) {
        return this.h1.xAxis().binUpperEdge(index);
    }

    public double getUpperEdgeY(int index) {
        return this.h1.yAxis().binUpperEdge(index);
    }

    public double getLowerEdgeY(int index) {
        return this.h1.yAxis().binLowerEdge(index);
    }

    public Map<String, Double> getStat() {
        Histogram2D h = this.get();
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        tmp.put("meanX", h.meanX());
        tmp.put("meanY", h.meanY());
        tmp.put("rmsX", h.rmsX());
        tmp.put("rmsY", h.rmsX());
        tmp.put("entries", Double.valueOf(h.allEntries()));
        return tmp;
    }

    public int allEntries() {
        return this.h1.allEntries();
    }

    public int entries() {
        return this.h1.entries();
    }

    public IAxis getAxisX() {
        return this.h1.xAxis();
    }

    public IAxis getAxisY() {
        return this.h1.yAxis();
    }

    public void clear() {
        this.h1.reset();
    }

    public double[][] binHeights() {
        this.binsX = this.h1.xAxis().bins();
        this.binsY = this.h1.yAxis().bins();
        int ibinsX = this.binsX + 2;
        int ibinsY = this.binsY + 2;
        double[][] newHeights = new double[ibinsX][ibinsY];
        newHeights[0][0] = this.getUnderflowHeightX();
        newHeights[ibinsX - 1][ibinsY - 1] = this.getOverflowHeightY();
        for (int i = 0; i < ibinsX - 1; ++i) {
            for (int j = 0; j < ibinsY - 1; ++j) {
                newHeights[i + 1][j + 1] = this.h1.binHeight(i, j);
            }
        }
        return newHeights;
    }

    public double[][] binErrors() {
        this.binsX = this.h1.xAxis().bins();
        this.binsY = this.h1.yAxis().bins();
        int ibinsX = this.binsX + 2;
        int ibinsY = this.binsY + 2;
        double[][] newErr = new double[ibinsX][ibinsY];
        newErr[0][0] = this.getUnderflowHeightX();
        newErr[ibinsX - 1][ibinsY - 1] = this.getOverflowHeightY();
        for (int i = 0; i < ibinsX - 1; ++i) {
            for (int j = 0; j < ibinsY - 1; ++j) {
                newErr[i + 1][j + 1] = this.h1.binError(i, j);
            }
        }
        return newErr;
    }

    public double[][] binMeansX() {
        this.binsX = this.h1.xAxis().bins();
        this.binsY = this.h1.yAxis().bins();
        double[][] xx = new double[this.binsX + 2][this.binsY + 2];
        for (int i = 0; i < this.binsX + 1; ++i) {
            for (int j = 0; j < this.binsY + 1; ++j) {
                xx[i + 1][j + 1] = this.h1.binMeanX(i, j);
            }
        }
        return xx;
    }

    public double[] getLowerEdgesX() {
        this.binsX = this.h1.xAxis().bins();
        double[] xx = new double[this.binsX];
        for (int i = 0; i < this.binsX; ++i) {
            xx[i] = this.h1.xAxis().binLowerEdge(i);
        }
        return xx;
    }

    public double[] getLowerEdgesY() {
        this.binsY = this.h1.yAxis().bins();
        double[] xx = new double[this.binsY];
        for (int i = 0; i < this.binsY; ++i) {
            xx[i] = this.h1.yAxis().binLowerEdge(i);
        }
        return xx;
    }

    public double[][] binMeansY() {
        this.binsX = this.h1.xAxis().bins();
        this.binsY = this.h1.yAxis().bins();
        double[][] xx = new double[this.binsX + 2][this.binsY + 2];
        for (int i = 0; i < this.binsX + 1; ++i) {
            for (int j = 0; j < this.binsY + 1; ++j) {
                xx[i + 1][j + 1] = this.h1.binMeanY(i, j);
            }
        }
        return xx;
    }

    public double[] binMeans(int i, int j) {
        double[] center = new double[]{this.h1.binMeanX(i, j), this.h1.binMeanY(i, j)};
        return center;
    }

    public H2D copy(String newtitle) {
        this.xAx = this.h1.xAxis();
        this.yAy = this.h1.yAxis();
        this.binsX = this.xAx.bins();
        this.binsY = this.yAy.bins();
        int ibinsX = this.binsX + 2;
        int ibinsY = this.binsY + 2;
        double[][] newHeights = new double[ibinsX][ibinsY];
        double[][] newErrors = new double[ibinsX][ibinsY];
        double[][] newMeansX = new double[ibinsX][ibinsY];
        double[][] newRmssX = new double[ibinsX][ibinsY];
        double[][] newMeansY = new double[ibinsX][ibinsY];
        double[][] newRmssY = new double[ibinsX][ibinsY];
        int[][] newEntries = new int[ibinsX][ibinsY];
        newHeights[0][0] = this.getUnderflowHeightX();
        newHeights[ibinsX - 1][ibinsY - 1] = this.getOverflowHeightY();
        for (int i = 0; i < ibinsX - 1; ++i) {
            for (int j = 0; j < ibinsY - 1; ++j) {
                newHeights[i + 1][j + 1] = this.h1.binHeight(i, j);
                newErrors[i + 1][j + 1] = this.h1.binError(i, j);
                newEntries[i + 1][j + 1] = this.h1.binEntries(i, j);
                newMeansX[i + 1][j + 1] = this.h1.binMeanX(i, j);
                newRmssX[i + 1][j + 1] = this.h1.binRmsX(i, j);
                newMeansY[i + 1][j + 1] = this.h1.binMeanY(i, j);
                newRmssY[i + 1][j + 1] = this.h1.binRmsY(i, j);
            }
        }
        H2D hnew = new H2D(newtitle, this.xAx, this.yAy);
        hnew.setContents(newHeights, newErrors, newEntries, newMeansX, newMeansY, newRmssX, newRmssY);
        hnew.setMeanX(this.h1.meanX());
        hnew.setMeanY(this.h1.meanX());
        hnew.setRmsX(this.h1.rmsX());
        hnew.setRmsY(this.h1.rmsY());
        hnew.setNEntries(this.entries());
        return hnew;
    }

    public H2D getDensity() {
        int ibinsX = this.binsX + 2;
        int ibinsY = this.binsY + 2;
        double[][] newHeights = new double[ibinsX][ibinsY];
        double[][] newErrors = new double[ibinsX][ibinsY];
        double[][] newMeansX = new double[ibinsX][ibinsY];
        double[][] newRmssX = new double[ibinsX][ibinsY];
        double[][] newMeansY = new double[ibinsX][ibinsY];
        double[][] newRmssY = new double[ibinsX][ibinsY];
        int[][] newEntries = new int[ibinsX][ibinsY];
        newHeights[0][0] = this.getUnderflowHeightX();
        newHeights[ibinsX - 1][ibinsY - 1] = this.getOverflowHeightY();
        double sum = this.sumAllBinHeights();
        for (int i = 0; i < ibinsX - 1; ++i) {
            double w1 = sum * (this.xAx.binUpperEdge(i) - this.xAx.binLowerEdge(i));
            for (int j = 0; j < ibinsY - 1; ++j) {
                double ww = w1 * (this.yAy.binUpperEdge(j) - this.yAy.binLowerEdge(j));
                newHeights[i + 1][j + 1] = this.h1.binHeight(i, j) / ww;
                newErrors[i + 1][j + 1] = this.h1.binError(i, j) / ww;
                newEntries[i + 1][j + 1] = this.h1.binEntries(i, j);
                newMeansX[i + 1][j + 1] = this.h1.binMeanX(i, j);
                newRmssX[i + 1][j + 1] = this.h1.binRmsX(i, j);
                newMeansY[i + 1][j + 1] = this.h1.binMeanY(i, j);
                newRmssY[i + 1][j + 1] = this.h1.binRmsY(i, j);
            }
        }
        H2D hnew = new H2D(this.getTitle(), this.xAx, this.yAy);
        hnew.setContents(newHeights, newErrors, newEntries, newMeansX, newMeansY, newRmssX, newRmssY);
        hnew.setMeanX(this.h1.meanX());
        hnew.setMeanY(this.h1.meanY());
        hnew.setRmsX(this.h1.rmsX());
        hnew.setRmsY(this.h1.rmsY());
        hnew.setNEntries(this.entries());
        return hnew;
    }

    public int binEntries(int indexX, int indexY) {
        return this.h1.binEntries(indexX, indexY);
    }

    public double binError(int indexX, int indexY) {
        return this.h1.binError(indexX, indexY);
    }

    public void fill(double value1, double value2, double weight) {
        this.h1.fill(value1, value2, weight);
    }

    public void fill(double[] value1, double[] value2) {
        if (value1.length != value2.length) {
            this.ErrorMessage("Different size of input arrays");
            return;
        }
        for (int i = 0; i < value1.length; ++i) {
            this.h1.fill(value1[i], value2[i]);
        }
    }

    public void fill(Cloud2D c2d) {
        for (int i = 0; i < c2d.entries(); ++i) {
            this.h1.fill(c2d.valueX(i), c2d.valueY(i), c2d.weight(i));
        }
    }

    public void fill(P0D value1, P0D value2) {
        if (value1.size() != value2.size()) {
            this.ErrorMessage("Different size of input arrays");
            return;
        }
        for (int i = 0; i < value1.size(); ++i) {
            this.h1.fill(value1.getQuick(i), value2.getQuick(i));
        }
    }

    public void fill(P0I value1, P0I value2) {
        if (value1.size() != value2.size()) {
            this.ErrorMessage("Different size of input arrays");
            return;
        }
        for (int i = 0; i < value1.size(); ++i) {
            this.h1.fill((double)value1.getQuick(i), (double)value2.getQuick(i));
        }
    }

    public void fill(double[] value1, double[] value2, double[] weights) {
        if (value1.length != value2.length) {
            this.ErrorMessage("Different size of input arrays");
            return;
        }
        if (value1.length != weights.length) {
            this.ErrorMessage("Different size of input weight");
            return;
        }
        for (int i = 0; i < value1.length; ++i) {
            this.h1.fill(value1[i], value2[i], weights[i]);
        }
    }

    public int findBinX(double x) {
        return this.xAx.coordToIndex(x);
    }

    public int findBinY(double y) {
        return this.yAy.coordToIndex(y);
    }

    public double integralRange(double xMin, double xMax, double yMin, double yMax, boolean timesBinWidth) {
        int i1 = this.findBinX(xMin);
        int i2 = this.findBinX(xMax);
        int i3 = this.findBinY(yMin);
        int i4 = this.findBinY(yMax);
        return this.integral(i1, i2, i3, i4, false);
    }

    public H2D getProbability() {
        H2D h2d = this.copy(this.getTitle());
        h2d.scale(1.0 / h2d.sumAllBinHeights());
        return h2d;
    }

    public H2D copy() {
        return this.copy(this.getTitle());
    }

    public void scale(double scaleFactor) {
        this.h1.scale(scaleFactor);
    }

    public double integral(int BinMinX, int BinMaxX, int BinMinY, int BinMaxY) {
        return this.integral(BinMinX, BinMaxX, BinMinY, BinMaxY, false);
    }

    public double integral(int BinMinX, int BinMaxX, int BinMinY, int BinMaxY, boolean timesBinWidth) {
        if (BinMinX > BinMaxX) {
            this.ErrorMessage("Wrong bin number for X!");
            return -1.0;
        }
        if (BinMinY > BinMaxY) {
            this.ErrorMessage("Wrong bin number for Y!");
            return -1.0;
        }
        int bX = this.xAx.bins();
        int bY = this.yAy.bins();
        if (BinMinX < 1 || BinMaxX > bX) {
            this.ErrorMessage("Wrong bin number for X!");
            return -1.0;
        }
        if (BinMinY < 1 || BinMaxY > bY) {
            this.ErrorMessage("Wrong bin number for Y!");
            return -1.0;
        }
        double sum = 0.0;
        if (!timesBinWidth) {
            for (int i = BinMinX - 1; i < BinMaxX; ++i) {
                for (int j = BinMinY - 1; j < BinMaxY; ++j) {
                    sum += this.h1.binHeight(i, j);
                }
            }
        } else {
            for (int i = BinMinX - 1; i < BinMaxX; ++i) {
                double w1 = this.xAx.binUpperEdge(i) - this.xAx.binLowerEdge(i);
                for (int j = BinMinY - 1; j < BinMaxY; ++j) {
                    double w2 = this.yAy.binUpperEdge(j) - this.yAy.binLowerEdge(j);
                    sum += this.h1.binHeight(i, j) * w1 * w2;
                }
            }
        }
        return sum;
    }

    public Map<String, Double> compareChi2(F2D f1) {
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        int bins1x = this.get().xAxis().bins();
        int bins1y = this.get().yAxis().bins();
        double sum1 = 0.0;
        double nDf = 0.0;
        for (int i = 0; i < bins1x; ++i) {
            double xx1 = this.get().xAxis().binLowerEdge(i);
            double xx2 = this.get().xAxis().binUpperEdge(i);
            double d1 = xx2 - xx1;
            double xx = xx1 + 0.5 * d1;
            for (int j = 0; j < bins1y; ++j) {
                double y1 = this.get().yAxis().binLowerEdge(j);
                double y2 = this.get().yAxis().binUpperEdge(j);
                double d2 = y1 - y2;
                double yy = y1 + 0.5 * d2;
                double bin1 = this.binHeight(i, j);
                double e1 = this.binError(i, j);
                double ff = f1.eval(xx, yy);
                if (e1 == 0.0) continue;
                sum1 += (ff - bin1) * (ff - bin1) / (e1 * e1);
                nDf += 1.0;
            }
        }
        double chi2 = sum1;
        tmp.put("chi2", chi2);
        tmp.put("ndf", nDf);
        ChiSquaredDistribution chi2Distribution = new ChiSquaredDistribution(nDf);
        double prob = chi2Distribution.cumulativeProbability(chi2);
        tmp.put("p-value", 1.0 - prob);
        return tmp;
    }

    public Map<String, Double> compareChi2(H2D h2) {
        double e2;
        double e1;
        double bin2;
        double bin1;
        int j;
        int i;
        int bins2y;
        int bins2x;
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        int bins1x = this.get().xAxis().bins();
        if (bins1x != (bins2x = h2.get().xAxis().bins())) {
            System.out.println("Different histograms! Please use histograms with the same bin numbers in X");
            return tmp;
        }
        int bins1y = this.get().yAxis().bins();
        if (bins1y != (bins2y = h2.get().yAxis().bins())) {
            System.out.println("Different histograms! Please use histograms with the same bin numbers in Y");
            return tmp;
        }
        double chi2 = 0.0;
        int nDf = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sumw1 = 0.0;
        double sumw2 = 0.0;
        for (i = 0; i < bins1x; ++i) {
            for (j = 0; j < bins1y; ++j) {
                bin1 = this.binHeight(i, j);
                bin2 = h2.binHeight(i, j);
                e1 = this.binError(i, j);
                e2 = h2.binError(i, j);
                bin1 = e1 > 0.0 ? (bin1 *= bin1 / (e1 * e1)) : 0.0;
                bin2 = e2 > 0.0 ? (bin2 *= bin2 / (e2 * e2)) : 0.0;
                sum1 += bin1;
                sum2 += bin2;
                sumw1 += e1 * e1;
                sumw2 += e2 * e2;
            }
        }
        if (sumw1 <= 0.0 || sumw2 <= 0.0) {
            System.out.println("Cannot compare histograms with all zero errors");
            return tmp;
        }
        if (sum1 == 0.0 || sum2 == 0.0) {
            System.out.println("One histogram is empty!");
            return tmp;
        }
        for (i = 0; i < bins1x; ++i) {
            for (j = 0; j < bins1y; ++j) {
                bin1 = this.binHeight(i, j);
                bin2 = h2.binHeight(i, j);
                e1 = this.binError(i, j);
                e2 = h2.binError(i, j);
                bin1 = e1 > 0.0 ? (bin1 *= bin1 / (e1 * e1)) : 0.0;
                bin2 = e2 > 0.0 ? (bin2 *= bin2 / (e2 * e2)) : 0.0;
                double binsum = bin1 + bin2;
                double delta = sum2 * bin1 - sum1 * bin2;
                if (!(binsum > 0.0)) continue;
                System.out.println(chi2 += delta * delta / binsum);
                ++nDf;
            }
        }
        tmp.put("chi2", chi2 /= sum1 * sum2);
        tmp.put("ndf", Double.valueOf(nDf));
        ChiSquaredDistribution chi2Distribution = new ChiSquaredDistribution((double)nDf);
        double prob = chi2Distribution.cumulativeProbability(chi2);
        tmp.put("p-value", 1.0 - prob);
        return tmp;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage(a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

