/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Cell;
import java.util.Vector;

public class IsoCurve {
    static final int TERMINAL = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int TOP = 3;
    static final int BOTTOM = 4;
    static final int ARRAYSIZE = 100;
    static final int MAXARRAYSIZE = 2000;
    protected Vector cells = null;
    protected double[] grid = null;
    protected int nx = 0;
    protected int ny = 0;
    protected double[] curve = null;
    protected int size = 0;
    protected double value = 0.0;

    public IsoCurve() {
    }

    public IsoCurve(double[] grid, int nx, int ny) {
        this();
        this.setGrid(grid, nx, ny);
    }

    public void setGrid(double[] grid, int nx, int ny) {
        this.grid = grid;
        this.nx = nx;
        this.ny = ny;
    }

    public void setValue(double value) {
        this.value = value;
        if (this.grid == null) {
            return;
        }
        this.createCells();
    }

    public double[] getCurve() {
        this.size = 0;
        this.getcurve();
        if (this.size == 0 || this.curve == null) {
            return null;
        }
        double[] tmp = new double[this.size];
        System.arraycopy(this.curve, 0, tmp, 0, this.size);
        return tmp;
    }

    protected void createCells() {
        if (this.cells == null) {
            this.cells = new Vector();
        } else {
            this.cells.removeAllElements();
        }
        for (int j = 0; j < this.ny - 1; ++j) {
            int jcell = j * this.nx;
            for (int i = 0; i < this.nx - 1; ++i) {
                Cell cell;
                int icell = i + jcell;
                double bl = this.grid[icell];
                double br = this.grid[icell + 1];
                double tl = this.grid[icell + this.nx];
                double tr = this.grid[icell + this.nx + 1];
                boolean bottom = false;
                boolean top = false;
                boolean left = false;
                boolean right = false;
                if ((bl - this.value) * (br - this.value) <= 0.0) {
                    bottom = true;
                }
                if ((br - this.value) * (tr - this.value) <= 0.0) {
                    right = true;
                }
                if ((tr - this.value) * (tl - this.value) <= 0.0) {
                    top = true;
                }
                if ((tl - this.value) * (bl - this.value) <= 0.0) {
                    left = true;
                }
                if (top && bottom && left && right) {
                    if (tr >= tl && bl >= br) {
                        cell = new Cell();
                        cell.i = i;
                        cell.j = j;
                        cell.face[0] = 3;
                        cell.face[1] = 1;
                        this.cells.addElement(cell);
                        cell = new Cell();
                        cell.i = i;
                        cell.j = j;
                        cell.face[0] = 4;
                        cell.face[1] = 2;
                        this.cells.addElement(cell);
                        continue;
                    }
                    if (!(tl >= tr) || !(br >= bl)) continue;
                    cell = new Cell();
                    cell.i = i;
                    cell.j = j;
                    cell.face[0] = 3;
                    cell.face[1] = 1;
                    this.cells.addElement(cell);
                    cell = new Cell();
                    cell.i = i;
                    cell.j = j;
                    cell.face[0] = 4;
                    cell.face[1] = 2;
                    continue;
                }
                if (!top && !bottom && !left && !right) continue;
                cell = new Cell();
                this.cells.addElement(cell);
                cell.i = i;
                cell.j = j;
                if (bl == this.value && br == this.value) {
                    bottom = false;
                }
                if (bl == this.value && tl == this.value) {
                    left = false;
                }
                if (tr == this.value && tl == this.value) {
                    top = false;
                }
                if (tr == this.value && br == this.value) {
                    right = false;
                }
                int count = 0;
                if (bottom) {
                    ++count;
                }
                if (top) {
                    ++count;
                }
                if (left) {
                    ++count;
                }
                if (right) {
                    ++count;
                }
                if (count > 2) {
                    System.out.println("IsoCurve: Pathological Cell");
                    System.out.println("          value=" + this.value);
                    System.out.println("          i=" + i + ", j=" + j);
                    System.out.println("          tl=" + tl + ", tr=" + tr);
                    System.out.println("          bl=" + bl + ", br=" + br);
                    continue;
                }
                count = 0;
                if (bottom) {
                    cell.face[count] = 4;
                    ++count;
                }
                if (top) {
                    cell.face[count] = 3;
                    ++count;
                }
                if (left) {
                    cell.face[count] = 1;
                    ++count;
                }
                if (!right) continue;
                cell.face[count] = 2;
                ++count;
            }
        }
    }

    protected void getcurve() {
        int face = 0;
        int ifcell = -1;
        int jfcell = -1;
        double[] d = new double[2];
        this.size = 0;
        if (this.cells == null || this.cells.isEmpty()) {
            return;
        }
        Cell current = (Cell)this.cells.firstElement();
        if (current.face[0] == 0 && current.face[1] == 0) {
            this.cells.removeElement(current);
            System.out.println("getcurve: Terminal cell removed!");
            return;
        }
        int icell = current.i;
        int jcell = current.j;
        ifcell = -1;
        jfcell = -1;
        if (this.search(icell - 1, jcell) == null && (current.face[0] == 1 || current.face[1] == 1)) {
            this.addDataPoint(1, icell, jcell);
            face = 1;
        } else if (this.search(icell + 1, jcell) == null && (current.face[0] == 2 || current.face[1] == 2)) {
            this.addDataPoint(2, icell, jcell);
            face = 2;
        } else if (this.search(icell, jcell - this.nx) == null && (current.face[0] == 4 || current.face[1] == 4)) {
            this.addDataPoint(4, icell, jcell);
            face = 4;
        } else if (this.search(icell, jcell + this.nx) == null && (current.face[0] == 3 || current.face[1] == 3)) {
            this.addDataPoint(3, icell, jcell);
            face = 3;
        } else {
            int index = 0;
            if (current.face[0] == 0) {
                index = 1;
            }
            this.addDataPoint(current.face[index], icell, jcell);
            face = current.face[index];
            if (face == 3) {
                ifcell = current.i;
                jfcell = current.j + 1;
            } else if (face == 4) {
                ifcell = current.i;
                jfcell = current.j - 1;
            } else if (face == 1) {
                ifcell = current.i - 1;
                jfcell = current.j;
            } else if (face == 2) {
                ifcell = current.i + 1;
                jfcell = current.j;
            }
        }
        while (current != null) {
            icell = current.i;
            jcell = current.j;
            if ((face = current.face[0] == face ? current.face[1] : current.face[0]) != 0) {
                this.addDataPoint(face, icell, jcell);
            }
            if (face == 3) {
                ++jcell;
                face = 4;
            } else if (face == 4) {
                --jcell;
                face = 3;
            } else if (face == 1) {
                --icell;
                face = 2;
            } else if (face == 2) {
                ++icell;
                face = 1;
            }
            this.cells.removeElement(current);
            if (icell == ifcell && jcell == jfcell) {
                this.addDataPoint(this.curve[0], this.curve[1]);
                current = null;
                continue;
            }
            current = this.search(icell, jcell);
        }
    }

    protected double[] getPoint(int wall, int icell, int jcell) {
        double[] d = new double[2];
        int index = icell + jcell * this.nx;
        if (wall == 3) {
            double tl = this.grid[index + this.nx];
            double tr = this.grid[index + this.nx + 1];
            d[1] = jcell + 1;
            d[0] = (double)icell + (this.value - tl) / (tr - tl);
        } else if (wall == 4) {
            double bl = this.grid[index];
            double br = this.grid[index + 1];
            d[1] = jcell;
            d[0] = (double)icell + (this.value - bl) / (br - bl);
        } else if (wall == 1) {
            double bl = this.grid[index];
            double tl = this.grid[index + this.nx];
            d[1] = (double)jcell + (this.value - bl) / (tl - bl);
            d[0] = icell;
        } else if (wall == 2) {
            double br = this.grid[index + 1];
            double tr = this.grid[index + 1 + this.nx];
            d[1] = (double)jcell + (this.value - br) / (tr - br);
            d[0] = icell + 1;
        }
        return d;
    }

    protected void addDataPoint(int wall, int icell, int jcell) {
        double[] d = this.getPoint(wall, icell, jcell);
        this.addDataPoint(d[0], d[1]);
    }

    protected void addDataPoint(double x, double y) {
        if (this.size >= 1998) {
            return;
        }
        if (this.curve == null) {
            this.curve = new double[100];
        } else if (this.size == this.curve.length - 2) {
            double[] tmp = new double[2 * this.size];
            System.arraycopy(this.curve, 0, tmp, 0, this.size);
            this.curve = tmp;
        }
        this.curve[this.size] = x;
        ++this.size;
        this.curve[this.size] = y;
        ++this.size;
    }

    protected Cell search(int icell, int jcell) {
        Cell current = null;
        if (this.cells.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.cells.size(); ++i) {
            current = (Cell)this.cells.elementAt(i);
            if (current.i != icell || current.j != jcell) continue;
            return current;
        }
        return null;
    }
}

