/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Axis;
import graph.Contour;
import graph.DataSet;
import graph.G2Dint;
import graph.Graph2D;
import graph.LoadData;
import graph.Markers;
import graph.NamedObject;
import graph.ParseFunction;
import graph.RTextLine;
import graph.ScanWord;
import graph.TextLine;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public class BuildGraph
extends ScanWord {
    static final int BEGIN = 256;
    static final int GRAPH2D = 257;
    static final int MARKER = 258;
    static final int AXIS = 259;
    static final int URL = 260;
    static final int DATA = 261;
    static final int SIZE = 262;
    static final int COLOR = 263;
    static final int NAME = 264;
    static final int TITLE = 265;
    static final int LABEL = 266;
    static final int FONT = 267;
    static final int STYLE = 268;
    static final int BOTTOM = 269;
    static final int TOP = 270;
    static final int LEFT = 271;
    static final int RIGHT = 272;
    static final int END = 273;
    static final int G2DINT = 274;
    static final int OFF = 275;
    static final int ON = 276;
    static final int ATTACH = 277;
    static final int PLAIN = 278;
    static final int BOLD = 279;
    static final int ITALIC = 280;
    static final int DEBUG = 281;
    static final int GRID = 282;
    static final int ZERO = 283;
    static final int CONTOUR = 284;
    static final int LLEVELS = 285;
    static final int NUMBER = 286;
    static final int CDATA = 287;
    static final int FUNCTION = 288;
    static final int XRANGE = 289;
    static final int YRANGE = 290;
    static final int BACKGROUND = 291;
    static final int LOGCONTOURS = 292;
    static final int CLABELS = 293;
    static final int SQUARE = 294;
    static final int MARKER_STYLE = 512;
    static final int MARKER_COLOR = 513;
    static final int MARKER_SIZE = 514;
    static final int LABEL_COLOR = 515;
    static final int LABEL_FONT = 517;
    static final int GRID_COLOR = 520;
    static final int GRID_OFF = 521;
    static final int ZERO_COLOR = 522;
    static final int ZERO_OFF = 523;
    static final int MARKER_URL = 524;
    static final int GRID_ON = 525;
    static final int ZERO_ON = 526;
    static final int XMIN = 527;
    static final int XMAX = 528;
    static final int YMIN = 529;
    static final int YMAX = 530;
    static final int XNUMBER = 531;
    static final int YNUMBER = 532;
    static final int LABEL_OFF = 533;
    protected Stack build = new Stack();
    protected Stack object = new Stack();
    protected Vector built = new Vector();
    protected Object graph = null;
    protected TextLine graphtitle = null;
    protected Applet applet;
    protected boolean debug = false;
    private Vector datasets = new Vector();
    public int lineno = 1;
    public int level = 0;

    public BuildGraph(InputStream in, Applet ap) {
        super(in);
        this.applet = ap;
        this.addKeyWord("{", 256);
        this.addKeyWord("}", 273);
        this.addKeyWord("graph2d", 257);
        this.addKeyWord("g2dint", 274);
        this.addKeyWord("marker", 258);
        this.addKeyWord("axis", 259);
        this.addKeyWord("url", 260);
        this.addKeyWord("data", 261);
        this.addKeyWord("size", 262);
        this.addKeyWord("color", 263);
        this.addKeyWord("name", 264);
        this.addKeyWord("title", 265);
        this.addKeyWord("label", 266);
        this.addKeyWord("font", 267);
        this.addKeyWord("style", 268);
        this.addKeyWord("bottom", 269);
        this.addKeyWord("top", 270);
        this.addKeyWord("left", 271);
        this.addKeyWord("right", 272);
        this.addKeyWord("on", 276);
        this.addKeyWord("off", 275);
        this.addKeyWord("attach", 277);
        this.addKeyWord("plain", 278);
        this.addKeyWord("bold", 279);
        this.addKeyWord("italic", 280);
        this.addKeyWord("debug", 281);
        this.addKeyWord("grid", 282);
        this.addKeyWord("zero", 283);
        this.addKeyWord("contour", 284);
        this.addKeyWord("number", 286);
        this.addKeyWord("cdata", 287);
        this.addKeyWord("function", 288);
        this.addKeyWord("xrange", 289);
        this.addKeyWord("yrange", 290);
        this.addKeyWord("background", 291);
        this.addKeyWord("llevels", 285);
        this.addKeyWord("square", 294);
        this.addKeyWord("log", 292);
    }

    public Object getGraph() {
        return this.graph;
    }

    public TextLine getGraphTitle() {
        return this.graphtitle;
    }

    public Vector getBuilt() {
        return this.built;
    }

    public void parse() {
        boolean cont = true;
        block24: while (cont) {
            int token = this.nextWord();
            this.debugMessage("Main", token);
            switch (token) {
                case 281: {
                    this.debug = !this.debug;
                    continue block24;
                }
                case 284: {
                    if (this.graph != null) {
                        this.errorAtLine("Graph already defined.");
                        return;
                    }
                    this.graph = new Contour();
                    NamedObject nobj = new NamedObject(this.graph, 284);
                    this.object.push(nobj);
                    continue block24;
                }
                case 274: {
                    if (this.graph != null) {
                        this.errorAtLine("Graph already defined.");
                        return;
                    }
                    this.graph = new G2Dint();
                    NamedObject nobj = new NamedObject(this.graph, 274);
                    this.object.push(nobj);
                    continue block24;
                }
                case 257: {
                    if (this.graph != null) {
                        this.errorAtLine("Graph already defined.");
                        return;
                    }
                    this.graph = new Graph2D();
                    NamedObject nobj = new NamedObject(this.graph, 257);
                    this.object.push(nobj);
                    continue block24;
                }
                case -1: {
                    cont = false;
                    continue block24;
                }
                case 10: {
                    ++this.lineno;
                    if (this.lineno != this.lineno / 10 * 10) continue block24;
                    this.applet.showStatus("Reading input: Line " + this.lineno);
                    continue block24;
                }
                case 269: 
                case 270: 
                case 271: 
                case 272: {
                    NamedObject nobj;
                    if (this.isContext(259)) {
                        nobj = new NamedObject(token);
                    } else {
                        int toke = this.nextWord();
                        if (toke == -2) {
                            nobj = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), token);
                        } else {
                            this.errorAtLine("In this context LEFT, RIGHT, TOP or BOTTOM should be followed an integer");
                            return;
                        }
                    }
                    this.object.push(nobj);
                    continue block24;
                }
                case 260: {
                    NamedObject nobj;
                    token = this.nextWord();
                    if (token == -258) {
                        try {
                            URL url = new URL(this.applet.getDocumentBase(), this.sval);
                            nobj = new NamedObject((Object)url, 260);
                        }
                        catch (Exception e) {
                            this.errorAtLine("Failed to build URL!");
                            return;
                        }
                    } else {
                        this.errorAtLine("URL should be followed by a string");
                        return;
                    }
                    this.object.push(nobj);
                    continue block24;
                }
                case 277: {
                    if (!this.isContext(259)) {
                        this.errorAtLine("ATTACH should only appear in AXIS context");
                        return;
                    }
                    token = this.nextWord();
                    if (token != -258) {
                        this.errorAtLine("ATTACH should be followed by a string");
                        return;
                    }
                    NamedObject nobj = new NamedObject((Object)this.sval, 277);
                    this.object.push(nobj);
                    continue block24;
                }
                case 268: {
                    NamedObject nobj;
                    if (!this.isContext(258) && !this.isContext(267)) {
                        this.errorAtLine("STYLE should only appear in MARKER or FONT context");
                        return;
                    }
                    token = this.nextWord();
                    if (token == 278) {
                        nobj = new NamedObject(278);
                    } else if (token == 279) {
                        nobj = new NamedObject(279);
                    } else if (token == 280) {
                        nobj = new NamedObject(278);
                    } else if (token == -2) {
                        nobj = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 268);
                    } else {
                        this.errorAtLine("STYLE should be followed an integer or Keyword");
                        return;
                    }
                    this.object.push(nobj);
                    continue block24;
                }
                case 262: {
                    if (!this.isContext(258) && !this.isContext(267)) {
                        this.errorAtLine("SIZE should only appear in MARKER or FONT context");
                        return;
                    }
                    token = this.nextWord();
                    if (token != -2) {
                        this.errorAtLine("SIZE should be followed by an integer");
                        return;
                    }
                    NamedObject nobj = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 262);
                    this.object.push(nobj);
                    continue block24;
                }
                case 285: {
                    if (!this.isContext(284)) {
                        this.errorAtLine("LLEVELS should only appear in CONTOUR context");
                        return;
                    }
                    token = this.nextWord();
                    if (token != -2) {
                        this.errorAtLine("LLEVELS should be followed by an integer");
                        return;
                    }
                    NamedObject nobj = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 285);
                    this.object.push(nobj);
                    continue block24;
                }
                case 263: 
                case 291: {
                    NamedObject nobj;
                    int[] rgb = new int[]{-1, -1, -1};
                    for (int i = 0; i < 3; ++i) {
                        int t = this.nextWord();
                        if (t != -2 || this.nval < 0.0 || this.nval > 255.0) {
                            this.errorAtLine("Incorrect Color definition");
                            return;
                        }
                        rgb[i] = (int)(this.nval + 0.001);
                    }
                    if (token == 263) {
                        nobj = new NamedObject((Object)new Color(rgb[0], rgb[1], rgb[2]), 263);
                        this.object.push(nobj);
                        continue block24;
                    }
                    if (this.isContext(261) || this.isContext(287)) {
                        ((Graph2D)this.graph).setDataBackground(new Color(rgb[0], rgb[1], rgb[2]));
                        continue block24;
                    }
                    ((Graph2D)this.graph).setGraphBackground(new Color(rgb[0], rgb[1], rgb[2]));
                    continue block24;
                }
                case 264: {
                    token = this.nextWord();
                    if (token != -258) {
                        this.errorAtLine("NAME should be followed by a string");
                        return;
                    }
                    NamedObject nobj = new NamedObject((Object)this.sval, 264);
                    this.object.push(nobj);
                    continue block24;
                }
                case 288: {
                    token = this.nextWord();
                    if (token != -258) {
                        this.errorAtLine("FUNCTION should be followed by a string");
                        return;
                    }
                    NamedObject nobj = new NamedObject((Object)this.sval, 288);
                    this.object.push(nobj);
                    continue block24;
                }
                case 286: {
                    token = this.nextWord();
                    if (token != -2) {
                        this.errorAtLine("NUMBER should be followed by an integer");
                        return;
                    }
                    NamedObject nobj = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 286);
                    this.object.push(nobj);
                    continue block24;
                }
                case 289: 
                case 290: {
                    NamedObject nobj;
                    boolean error = false;
                    double min = 0.0;
                    double max = 0.0;
                    int num = 0;
                    int t = this.nextWord();
                    if (t == -2) {
                        num = (int)(this.nval + 0.001);
                        t = this.nextWord();
                        if (t == -2) {
                            min = this.nval;
                            t = this.nextWord();
                            if (t == -2) {
                                max = this.nval;
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    } else {
                        error = true;
                    }
                    if (error) {
                        this.errorAtLine("Range limits must be followed by 3 numbers");
                        return;
                    }
                    if (min == max) {
                        this.errorAtLine("Range limits must not be the same");
                        return;
                    }
                    if (num <= 1) {
                        this.errorAtLine("Number of points must be greater than 1");
                        return;
                    }
                    if (min > max) {
                        double tmp = max;
                        max = min;
                        min = tmp;
                    }
                    if (token == 289) {
                        nobj = new NamedObject((Object)new Integer(num), 531);
                        this.object.push(nobj);
                        nobj = new NamedObject((Object)new Double(min), 527);
                        this.object.push(nobj);
                        nobj = new NamedObject((Object)new Double(max), 528);
                        this.object.push(nobj);
                        continue block24;
                    }
                    nobj = new NamedObject((Object)new Integer(num), 532);
                    this.object.push(nobj);
                    nobj = new NamedObject((Object)new Double(min), 529);
                    this.object.push(nobj);
                    nobj = new NamedObject((Object)new Double(max), 530);
                    this.object.push(nobj);
                    continue block24;
                }
                case -256: {
                    this.errorAtLine("Unknown keyword!!");
                    continue block24;
                }
                case 256: {
                    ++this.level;
                    this.build.push(this.object.pop());
                    this.object.push(new NamedObject(256));
                    continue block24;
                }
                case 273: {
                    --this.level;
                    this.build((NamedObject)this.build.pop());
                    continue block24;
                }
            }
            this.object.push(new NamedObject(token));
        }
        this.closeStream();
        if (this.graph == null) {
            System.out.println("Graph never defined! Cannot build graph!");
            return;
        }
        if (this.level != 0) {
            System.out.println("Mismatched Braces!! Will try and build graph.");
        }
        if (this.graph instanceof Graph2D) {
            ((Graph2D)this.graph).repaint();
        } else if (this.graph instanceof G2Dint) {
            ((G2Dint)this.graph).repaint();
        } else if (this.graph instanceof Contour) {
            ((Contour)this.graph).repaint();
        } else {
            System.out.println("Unknown graph type - totally confused!");
        }
    }

    protected boolean isContext(int token) {
        for (int i = 0; i < this.build.size(); ++i) {
            if (((NamedObject)this.build.elementAt((int)i)).id != token) continue;
            return true;
        }
        return false;
    }

    protected boolean build(NamedObject nobj) {
        switch (nobj.id) {
            case 267: {
                return this.buildFont();
            }
            case 258: {
                return this.buildMarker();
            }
            case 265: {
                return this.buildTitle();
            }
            case 266: {
                return this.buildLabel();
            }
            case 261: 
            case 287: {
                return this.buildData(nobj.id);
            }
            case 259: {
                return this.buildAxis();
            }
            case 282: {
                return this.buildGrid();
            }
            case 283: {
                return this.buildZero();
            }
            case 257: 
            case 274: 
            case 284: {
                return this.buildGraph(nobj.id);
            }
        }
        this.errorAtLine("Incorrect keyword followed by braces");
        return false;
    }

    protected boolean buildGraph(int type) {
        NamedObject nobj;
        String dname = type == 284 ? "Contour" : (type == 274 ? "G2Dint" : "Graph");
        block19: while (true) {
            nobj = (NamedObject)this.object.pop();
            this.debugMessage(dname, nobj.id);
            switch (nobj.id) {
                case 259: {
                    Axis axis = (Axis)nobj.getObject();
                    if (type == 257) {
                        ((Graph2D)this.graph).attachAxis(axis);
                        continue block19;
                    }
                    ((G2Dint)this.graph).attachAxis(axis);
                    continue block19;
                }
                case 261: {
                    ((Graph2D)this.graph).attachDataSet((DataSet)nobj.getObject());
                    continue block19;
                }
                case 277: {
                    Axis axis = (Axis)nobj.getObject();
                    String name = nobj.getName();
                    boolean attach = false;
                    for (int i = 0; i < this.datasets.size(); ++i) {
                        nobj = (NamedObject)this.datasets.elementAt(i);
                        if (!name.equals(nobj.getName())) continue;
                        axis.attachDataSet((DataSet)nobj.getObject());
                        attach = true;
                        break;
                    }
                    if (attach) continue block19;
                    this.errorAtLine("Data name not found for Attach keyword");
                    continue block19;
                }
                case 520: {
                    ((Graph2D)this.graph).gridcolor = (Color)nobj.getObject();
                    continue block19;
                }
                case 521: {
                    ((Graph2D)this.graph).drawgrid = false;
                    continue block19;
                }
                case 525: {
                    ((Graph2D)this.graph).drawgrid = true;
                    continue block19;
                }
                case 522: {
                    ((Graph2D)this.graph).zerocolor = (Color)nobj.getObject();
                    continue block19;
                }
                case 523: {
                    ((Graph2D)this.graph).drawzero = false;
                    continue block19;
                }
                case 526: {
                    ((Graph2D)this.graph).drawzero = true;
                    continue block19;
                }
                case 258: {
                    ((Graph2D)this.graph).setMarkers((Markers)nobj.getObject());
                    continue block19;
                }
                case 265: {
                    this.graphtitle = (TextLine)nobj.getObject();
                    this.built.addElement(this.graphtitle);
                    continue block19;
                }
                case 271: {
                    ((Graph2D)this.graph).borderLeft = (Integer)nobj.getObject();
                    continue block19;
                }
                case 272: {
                    ((Graph2D)this.graph).borderRight = (Integer)nobj.getObject();
                    continue block19;
                }
                case 270: {
                    ((Graph2D)this.graph).borderTop = (Integer)nobj.getObject();
                    continue block19;
                }
                case 269: {
                    ((Graph2D)this.graph).borderBottom = (Integer)nobj.getObject();
                    continue block19;
                }
                case 294: {
                    ((Graph2D)this.graph).square = true;
                    continue block19;
                }
                case 256: {
                    this.built.addElement(this.graph);
                    this.applet.showStatus("BuildGraph: Built Graph!!!");
                    return true;
                }
            }
            break;
        }
        if (type == 284) {
            if (!this.buildContour(nobj)) {
                this.errorAtLine("Incorrect keyword in Contour specification");
                return false;
            }
            return true;
        }
        this.errorAtLine("Incorrect keyword in Graph specification");
        return false;
    }

    protected boolean buildContour(NamedObject nobj) {
        switch (nobj.id) {
            case 286: {
                ((Contour)this.graph).setNLevels((Integer)nobj.getObject());
                break;
            }
            case 285: {
                ((Contour)this.graph).setLabelLevels((Integer)nobj.getObject());
                break;
            }
            case 263: {
                ((Contour)this.graph).setContourColor((Color)nobj.getObject());
                break;
            }
            case 292: {
                ((Contour)this.graph).logLevels = true;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean buildFont() {
        String name = "TimesRoman";
        int style = 0;
        int size = 20;
        block10: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Font", nobj.id);
            switch (nobj.id) {
                case 264: {
                    name = (String)nobj.getObject();
                    continue block10;
                }
                case 262: {
                    size = (Integer)nobj.getObject();
                    continue block10;
                }
                case 278: {
                    style += 0;
                    continue block10;
                }
                case 279: {
                    ++style;
                    continue block10;
                }
                case 280: {
                    style += 2;
                    continue block10;
                }
                case 256: {
                    try {
                        Font f = new Font(name, style, size);
                        nobj = new NamedObject((Object)f, 267);
                        this.object.push(nobj);
                        this.applet.showStatus("BuildGraph: Built Font!");
                        return true;
                    }
                    catch (Exception e) {
                        this.errorAtLine("Ill formed font specification");
                        return false;
                    }
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Font specification");
        return false;
    }

    protected boolean buildTitle() {
        RTextLine title = new RTextLine();
        block6: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Title", nobj.id);
            switch (nobj.id) {
                case 264: {
                    title.setText((String)nobj.getObject());
                    continue block6;
                }
                case 267: {
                    title.setFont((Font)nobj.getObject());
                    continue block6;
                }
                case 263: {
                    title.setColor((Color)nobj.getObject());
                    continue block6;
                }
                case 256: {
                    nobj = new NamedObject((Object)title, 265);
                    this.object.push(nobj);
                    this.applet.showStatus("BuildGraph: Built Title!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Title specification");
        return false;
    }

    protected boolean buildLabel() {
        NamedObject color = null;
        NamedObject font = null;
        block5: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Label", nobj.id);
            switch (nobj.id) {
                case 267: {
                    font = nobj;
                    font.setId(517);
                    continue block5;
                }
                case 263: {
                    color = nobj;
                    color.setId(515);
                    continue block5;
                }
                case 256: {
                    if (color != null) {
                        this.object.push(color);
                    }
                    if (font != null) {
                        this.object.push(font);
                    }
                    this.applet.showStatus("BuildGraph: Built Axis Label!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Label specification");
        return false;
    }

    protected boolean buildMarker() {
        Markers m = null;
        NamedObject size = null;
        NamedObject color = null;
        NamedObject style = null;
        block9: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Marker", nobj.id);
            switch (nobj.id) {
                case 262: {
                    size = nobj;
                    size.setId(514);
                    continue block9;
                }
                case 263: {
                    color = nobj;
                    color.setId(513);
                    continue block9;
                }
                case 268: {
                    style = nobj;
                    if (style.getObject() instanceof Integer) {
                        style.setId(512);
                        continue block9;
                    }
                    this.errorAtLine("Style should be an Integer in MARKER");
                    return false;
                }
                case 260: {
                    try {
                        m = new Markers((URL)nobj.getObject());
                    }
                    catch (Exception e) {
                        this.errorAtLine("Failed to load markers: " + e.getMessage());
                    }
                    continue block9;
                }
                case 256: {
                    if (m != null) {
                        nobj = new NamedObject(m, 258);
                        this.object.push(nobj);
                        this.built.addElement(m);
                        this.applet.showStatus("BuildGraph: Loaded Marker file!");
                        return true;
                    }
                    if (color != null) {
                        this.object.push(color);
                    }
                    if (size != null) {
                        this.object.push(size);
                    }
                    if (style != null) {
                        this.object.push(style);
                    }
                    this.applet.showStatus("BuildGraph: Built Marker!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in MARKER specification");
        return false;
    }

    protected boolean buildData(int type) {
        DataSet data = new DataSet();
        NamedObject ndata = new NamedObject((Object)data, 261);
        ParseFunction parsef = null;
        LoadData load = null;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        int nx = 0;
        int ny = 0;
        if (type == 287 && !(this.graph instanceof Contour)) {
            this.errorAtLine("CDATA can only be used in CONTOUR!");
        }
        block20: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Data", nobj.id);
            switch (nobj.id) {
                case 264: {
                    ndata.setName((String)nobj.getObject());
                    continue block20;
                }
                case 512: {
                    data.marker = (Integer)nobj.getObject();
                    continue block20;
                }
                case 514: {
                    data.markerscale = ((Integer)nobj.getObject()).intValue();
                    continue block20;
                }
                case 513: {
                    data.markercolor = (Color)nobj.getObject();
                    continue block20;
                }
                case 275: {
                    data.linestyle = 0;
                    continue block20;
                }
                case 276: {
                    data.linestyle = 1;
                    continue block20;
                }
                case 263: {
                    if (type == 287) {
                        ((Contour)this.graph).setContourColor((Color)nobj.getObject());
                        continue block20;
                    }
                    data.linecolor = (Color)nobj.getObject();
                    continue block20;
                }
                case 260: {
                    load = new LoadData(data);
                    load.loadDataSet((URL)nobj.getObject(), this.graph);
                    continue block20;
                }
                case 288: {
                    parsef = new ParseFunction((String)nobj.getObject());
                    if (parsef.parse()) continue block20;
                    this.errorAtLine("Error in function definition!");
                    return false;
                }
                case 531: {
                    nx = (Integer)nobj.getObject();
                    continue block20;
                }
                case 527: {
                    xmin = (Double)nobj.getObject();
                    continue block20;
                }
                case 528: {
                    xmax = (Double)nobj.getObject();
                    continue block20;
                }
                case 532: {
                    ny = (Integer)nobj.getObject();
                    continue block20;
                }
                case 529: {
                    ymin = (Double)nobj.getObject();
                    continue block20;
                }
                case 530: {
                    ymax = (Double)nobj.getObject();
                    continue block20;
                }
                case 256: {
                    if (parsef != null && type == 287) {
                        if (!(this.graph instanceof Contour)) {
                            this.errorAtLine("CDATA should only be used for Contours!");
                            return false;
                        }
                        double[] array = this.arrayFromFunction(parsef, nx, xmin, xmax, ny, ymin, ymax);
                        if (array == null) {
                            this.errorAtLine("Unable to build Data from Function");
                            return false;
                        }
                        ((Contour)this.graph).setRange(xmin, xmax, ymin, ymax);
                        ((Contour)this.graph).setGrid(array, nx, ny);
                        return true;
                    }
                    if (parsef != null) {
                        double[] array = this.arrayFromFunction(parsef, nx, xmin, xmax);
                        if (array == null) {
                            this.errorAtLine("Unable to build Data from Function");
                            return false;
                        }
                        try {
                            data.append(array, nx);
                            this.object.push(ndata);
                            this.datasets.addElement(ndata);
                            this.built.addElement(data);
                            return true;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    if (load == null) {
                        this.errorAtLine("No URL has been defined for Data!");
                        return false;
                    }
                    this.object.push(ndata);
                    this.built.addElement(data);
                    this.built.addElement(load);
                    this.datasets.addElement(ndata);
                    this.applet.showStatus("BuildGraph: Loading Data!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Data specification");
        return false;
    }

    protected double[] arrayFromFunction(ParseFunction f, int nx, double xmin, double xmax) {
        double[] array = new double[2 * nx];
        double xinc = (xmax - xmin) / (double)(nx - 1);
        int count = 0;
        for (int i = 0; i < nx; ++i) {
            double x = xmin + (double)i * xinc;
            try {
                double y = f.getResult(x);
                array[count++] = x;
                array[count++] = y;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (count == 0) {
            return null;
        }
        return array;
    }

    protected double[] arrayFromFunction(ParseFunction f, int nx, double xmin, double xmax, int ny, double ymin, double ymax) {
        double[] array = new double[ny * nx];
        double xinc = (xmax - xmin) / (double)(nx - 1);
        double yinc = (ymax - ymin) / (double)(ny - 1);
        int count = 0;
        for (int j = 0; j < ny; ++j) {
            double y = ymin + (double)j * yinc;
            for (int i = 0; i < nx; ++i) {
                double x = xmin + (double)i * xinc;
                try {
                    array[count++] = f.getResult(x, y);
                    continue;
                }
                catch (Exception e) {
                    array[count++] = 0.0;
                }
            }
        }
        if (count == 0) {
            return null;
        }
        return array;
    }

    protected boolean buildAxis() {
        Stack<NamedObject> attach = new Stack<NamedObject>();
        Axis axis = new Axis();
        NamedObject naxis = new NamedObject((Object)axis, 259);
        int angle = 0;
        block12: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Axis", nobj.id);
            switch (nobj.id) {
                case 264: {
                    naxis.setName((String)nobj.getObject());
                    continue block12;
                }
                case 265: {
                    axis.title = (RTextLine)nobj.getObject();
                    continue block12;
                }
                case 517: {
                    axis.label.setFont((Font)nobj.getObject());
                    continue block12;
                }
                case 515: {
                    axis.label.setColor((Color)nobj.getObject());
                    continue block12;
                }
                case 269: {
                    axis.setPosition(5);
                    continue block12;
                }
                case 270: {
                    axis.setPosition(4);
                    continue block12;
                }
                case 271: {
                    axis.setPosition(2);
                    angle = 90;
                    continue block12;
                }
                case 272: {
                    axis.setPosition(3);
                    angle = -90;
                    continue block12;
                }
                case 277: {
                    attach.push(new NamedObject(axis, (String)nobj.getObject(), 277));
                    continue block12;
                }
                case 256: {
                    axis.g2d = (Graph2D)this.graph;
                    axis.setTitleRotation(angle);
                    this.object.push(naxis);
                    while (attach.size() > 0) {
                        this.object.push(attach.pop());
                    }
                    this.built.addElement(axis);
                    this.applet.showStatus("BuildGraph: Built Axis!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Data specification");
        return false;
    }

    protected boolean buildGrid() {
        NamedObject color = null;
        NamedObject grid = null;
        block6: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Grid", nobj.id);
            switch (nobj.id) {
                case 275: {
                    grid = nobj;
                    grid.setId(521);
                    continue block6;
                }
                case 276: {
                    grid = nobj;
                    grid.setId(525);
                    continue block6;
                }
                case 263: {
                    color = nobj;
                    color.setId(520);
                    continue block6;
                }
                case 256: {
                    if (grid != null) {
                        this.object.push(grid);
                    }
                    if (color != null) {
                        this.object.push(color);
                    }
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Grid specification");
        return false;
    }

    protected boolean buildZero() {
        NamedObject color = null;
        NamedObject zero = null;
        block6: while (true) {
            NamedObject nobj = (NamedObject)this.object.pop();
            this.debugMessage("Zero", nobj.id);
            switch (nobj.id) {
                case 275: {
                    zero = nobj;
                    zero.setId(523);
                    continue block6;
                }
                case 276: {
                    zero = nobj;
                    zero.setId(526);
                    continue block6;
                }
                case 263: {
                    color = nobj;
                    color.setId(522);
                    continue block6;
                }
                case 256: {
                    if (zero != null) {
                        this.object.push(zero);
                    }
                    if (color != null) {
                        this.object.push(color);
                    }
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Zero specification");
        return false;
    }

    private void errorAtLine(String s) {
        System.out.println("Error at line " + this.lineno + ": " + s);
        this.applet.showStatus("Error at line " + this.lineno + ": " + s);
    }

    private void debugMessage(String s, int token) {
        String st = null;
        if (!this.debug) {
            return;
        }
        switch (token) {
            case 281: {
                st = null;
                break;
            }
            case 274: {
                st = "G2DINT";
                break;
            }
            case 257: {
                st = "GRAPH2D";
                break;
            }
            case 284: {
                st = "CONTOUR";
                break;
            }
            case -1: {
                st = null;
                break;
            }
            case 10: {
                st = null;
                break;
            }
            case 260: {
                st = "URL";
                break;
            }
            case 277: {
                st = "ATTACH";
                break;
            }
            case 268: {
                st = "STYLE";
                break;
            }
            case 262: {
                st = "SIZE";
                break;
            }
            case 263: {
                st = "COLOR";
                break;
            }
            case 264: {
                st = "NAME";
                break;
            }
            case 256: {
                st = "BEGIN";
                break;
            }
            case 273: {
                st = "END";
                break;
            }
            case 258: {
                st = "MARKER";
                break;
            }
            case 259: {
                st = "AXIS";
                break;
            }
            case 265: {
                st = "TITLE";
                break;
            }
            case 261: {
                st = "DATA";
                break;
            }
            case 266: {
                st = "LABEL";
                break;
            }
            case 267: {
                st = "FONT";
                break;
            }
            case 269: {
                st = "BOTTOM";
                break;
            }
            case 270: {
                st = "TOP";
                break;
            }
            case 271: {
                st = "LEFT";
                break;
            }
            case 272: {
                st = "RIGHT";
                break;
            }
            case 276: {
                st = "ON";
                break;
            }
            case 275: {
                st = "OFF";
                break;
            }
            case 278: {
                st = "PLAIN";
                break;
            }
            case 279: {
                st = "BOLD";
                break;
            }
            case 280: {
                st = "ITALIC";
                break;
            }
            case 512: {
                st = "MARKER_STYLE";
                break;
            }
            case 513: {
                st = "MARKER_COLOR";
                break;
            }
            case 514: {
                st = "MARKER_SIZE";
                break;
            }
            case 515: {
                st = "LABEL_COLOR";
                break;
            }
            case 517: {
                st = "LABEL_FONT";
                break;
            }
            case 520: {
                st = "GRID_COLOR";
                break;
            }
            case 282: {
                st = "GRID";
                break;
            }
            case 521: {
                st = "GRID_OFF";
                break;
            }
            case 525: {
                st = "GRID_ON";
                break;
            }
            case 522: {
                st = "ZERO_COLOR";
                break;
            }
            case 283: {
                st = "ZERO";
                break;
            }
            case 523: {
                st = "ZERO_OFF";
                break;
            }
            case 526: {
                st = "ZERO_ON";
                break;
            }
            case 524: {
                st = "MARKER_URL";
                break;
            }
            case 288: {
                st = "FUNCTION";
                break;
            }
            case 289: {
                st = "XRANGE";
                break;
            }
            case 290: {
                st = "YRANGE";
                break;
            }
            case 286: {
                st = "NUMBER";
                break;
            }
            case 294: {
                st = "SQUARE";
                break;
            }
            case 291: {
                st = "BACKGROUND";
                break;
            }
            default: {
                st = "UNKNOWN";
            }
        }
        if (st != null) {
            System.out.println("(" + this.lineno + ") " + s + ": " + st);
        }
    }
}

