/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.hipo.data.HipoEvent;
import org.jlab.hipo.io.HipoFileHeader;
import org.jlab.hipo.io.HipoRecord;
import org.jlab.hipo.schema.Schema;
import org.jlab.hipo.schema.SchemaFactory;
import org.jlab.hipo.utils.HipoLogo;

public class HipoWriter {
    public static int DICTIONARY = 1;
    public static int CUSTOMHEADER = 2;
    private int writerDictionaryMode = DICTIONARY;
    FileOutputStream outStream = null;
    HipoRecord outputRecord = null;
    HipoRecord headerRecord = null;
    int MAX_RECORD_SIZE = 0x800000;
    int MAX_RECORD_COUNT = 5000;
    private long totalByteWritten = 0L;
    private long totalBytesInRecords = 0L;
    private long numberOfRecords = 0L;
    private long timeSpendOnWriting = 0L;
    private long timeSpendOnCompression = 0L;
    private int compressionAlgorithm = 0;
    private boolean streamCompression = false;
    private final SchemaFactory schemaFactory = new SchemaFactory();

    public HipoWriter() {
        this.outputRecord = new HipoRecord();
        this.headerRecord = new HipoRecord();
        if (System.getenv("CLAS12DIR") != null) {
            this.schemaFactory.initFromDirectory("CLAS12DIR", "etc/bankdefs/hipo");
        }
    }

    public HipoWriter(String file) {
        this.outputRecord = new HipoRecord();
        if (System.getenv("CLAS12DIR") != null) {
            this.schemaFactory.initFromDirectory("CLAS12DIR", "etc/bankdefs/hipo");
        }
        this.open(file);
    }

    public final void open(String name) {
        if (this.writerDictionaryMode == DICTIONARY) {
            System.out.println("[HipoWriter] --->  initialize with dictionary. Schema count # ");
            HipoEvent schema = this.schemaFactory.getSchemaEvent();
            this.headerRecord.addEvent(schema.getDataBuffer());
            this.open(name, this.headerRecord.build().array());
        } else if (this.headerRecord.getEventCount() == 0) {
            this.addHeader("{undefined-header}");
            this.open(name, this.headerRecord.build().array());
        } else {
            this.open(name, this.headerRecord.build().array());
        }
    }

    public final void open(String name, byte[] array) {
        HipoLogo.showLogo();
        try {
            this.outStream = new FileOutputStream(new File(name));
            HipoFileHeader fileHeader = new HipoFileHeader();
            int headerRecordSize = array.length;
            fileHeader.setHeaderSize(headerRecordSize);
            this.outStream.write(fileHeader.build().array());
            this.outStream.write(array);
            this.outputRecord.reset();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(HipoWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HipoWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addHeader(String config) {
        byte[] buffer = config.getBytes();
        this.headerRecord.addEvent(buffer);
    }

    public void write() {
        if (this.outputRecord.getEventCount() != 0) {
            try {
                long stime_compress = System.currentTimeMillis();
                this.outputRecord.setCompressionType(this.compressionAlgorithm);
                byte[] array = this.outputRecord.build().array();
                long etime_compress = System.currentTimeMillis();
                this.timeSpendOnCompression += etime_compress - stime_compress;
                long stime_write = System.currentTimeMillis();
                this.outStream.write(array);
                long etime_write = System.currentTimeMillis();
                this.timeSpendOnWriting += etime_write - stime_write;
                ++this.numberOfRecords;
                this.totalByteWritten += (long)array.length;
                System.out.println("[hipo-writter] --> writing record with # events " + this.outputRecord.getEventCount());
                this.outputRecord.reset();
            }
            catch (IOException ex) {
                Logger.getLogger(HipoWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void writeEvent(byte[] event) {
        this.outputRecord.addEvent(event);
        int size = this.outputRecord.getBytesWritten();
        if (size > this.MAX_RECORD_SIZE) {
            this.write();
            this.outputRecord.reset();
        }
    }

    public void writeEvent(HipoEvent event) {
        this.writeEvent(event.getDataBuffer());
    }

    public void close() {
        if (this.outputRecord.getEventCount() > 0) {
            this.write();
        }
        try {
            this.outStream.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HipoWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(this.getStatusString());
    }

    public String getStatusString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("NRECORDS = %12d, ", this.numberOfRecords));
        double mb = (double)this.totalByteWritten / 1024.0 / 1024.0;
        str.append(String.format("BYTES = %8.2f Mb, ", mb));
        double wtime = (double)this.timeSpendOnWriting / 1000.0;
        double ctime = (double)this.timeSpendOnCompression / 1000.0;
        str.append(String.format("WTIME = %7.3f sec, ", wtime));
        str.append(String.format("CTIME = %7.3f sec, ", ctime));
        return str.toString();
    }

    public void setCompression(boolean flag) {
        this.streamCompression = flag;
    }

    public void setMaxRecordCount(int maxCount) {
        this.MAX_RECORD_COUNT = maxCount;
    }

    public void setCompressionType(int type) {
        this.compressionAlgorithm = 0;
        if (type > 0 && type < 4) {
            this.compressionAlgorithm = type;
        }
    }

    public void setMaxRecordSize(int maxSize) {
        this.MAX_RECORD_SIZE = maxSize;
    }

    public void defineSchema(String name, int group, String format) {
        this.schemaFactory.addSchema(new Schema(name, group, format));
    }

    public void defineSchema(Schema schema) {
        this.schemaFactory.addSchema(schema);
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public HipoEvent createEvent() {
        HipoEvent event = new HipoEvent(this.schemaFactory);
        return event;
    }

    public static void main(String[] args) {
        HipoWriter writer = new HipoWriter();
        writer.setCompressionType(2);
        writer.defineSchema(new Schema("{20,GenPart::true}[1,pid,INT][2,px,FLOAT][3,py,FLOAT][4,pz,FLOAT][5,vx,FLOAT][6,vy,FLOAT][7,vz,FLOAT]"));
        writer.open("testfile.hipo");
        HipoEvent event = writer.createEvent();
        writer.writeEvent(event);
        writer.close();
    }
}

