/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.hipo.io.HipoByteUtils;

public class HipoRecordHeader {
    public static final int RECORD_HEADER_SIZE = 40;
    public static final byte[] RECORD_IDENTIFIER_STRING = new byte[]{72, 82, 69, 67};
    public static final int RECORD_IDENTIFIER_INTEGER = 1128616520;
    public static final int OFFSET_RECORD_LENGTH_WORD = 4;
    public static final int OFFSET_DATA_LENGTH_WORD_UNCOMPRESSED = 8;
    public static final int OFFSET_DATA_LENGTH_WORD_COMPRESSED = 12;
    public static final int OFFSET_NUMBER_OF_EVENTS = 16;
    public static final int OFFSET_HEADER_LENGTH_WORD = 20;
    public static final int OFFSET_INDEX_LENGTH_WORD = 24;
    ByteBuffer recordHeaderBuffer = null;
    private long positionInFile = 0L;

    public HipoRecordHeader() {
        byte[] headerBytes = new byte[40];
        this.recordHeaderBuffer = ByteBuffer.wrap(headerBytes);
        this.recordHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 4; ++i) {
            this.recordHeaderBuffer.put(i, RECORD_IDENTIFIER_STRING[i]);
        }
        this.reset();
    }

    public HipoRecordHeader(byte[] array) {
        this.initBinary(array);
    }

    public final void initBinary(byte[] array) {
        this.recordHeaderBuffer = ByteBuffer.wrap(array);
        this.recordHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public final boolean isValid() {
        int magicWord = this.recordHeaderBuffer.getInt(0);
        return (magicWord & 0x4FFFFFFF) == 1128616520;
    }

    public int getDataSize() {
        return this.recordHeaderBuffer.getInt(8);
    }

    public int getDataSizeCompressed() {
        int result = this.recordHeaderBuffer.getInt(12);
        int size = HipoByteUtils.getInteger(result, 0, 23);
        return size;
    }

    public int getRecordHeaderLength() {
        return 40;
    }

    public int getNumberOfEvents() {
        return this.recordHeaderBuffer.getInt(16);
    }

    public int getRecordSize() {
        return this.recordHeaderBuffer.getInt(4);
    }

    public int getHeaderSize() {
        return this.recordHeaderBuffer.getInt(20);
    }

    public final int getIndexArraySize() {
        int result = this.recordHeaderBuffer.getInt(24);
        int size = HipoByteUtils.getInteger(result, 0, 23);
        return size;
    }

    public int getCompressionType() {
        int result = this.recordHeaderBuffer.getInt(12);
        int type = HipoByteUtils.getInteger(result, 24, 30);
        return type;
    }

    public byte[] getRecordHeaderData() {
        return this.recordHeaderBuffer.array();
    }

    public long getPositionInFile() {
        return this.positionInFile;
    }

    public void setPositionInFile(long pos) {
        this.positionInFile = pos;
    }

    public final void setDataSize(int size) {
        int result = this.recordHeaderBuffer.getInt(8);
        result = HipoByteUtils.write(result, size, 0, 23);
        this.recordHeaderBuffer.putInt(8, result);
    }

    public final void setDataSizeCompressed(int size) {
        int result = this.recordHeaderBuffer.getInt(12);
        result = HipoByteUtils.write(result, size, 0, 23);
        this.recordHeaderBuffer.putInt(12, result);
    }

    public final void setIndexArraySize(int size) {
        int result = this.recordHeaderBuffer.getInt(24);
        result = HipoByteUtils.write(result, size, 0, 23);
        this.recordHeaderBuffer.putInt(24, result);
    }

    public final void setRecordHeaderLength(int length) {
        this.recordHeaderBuffer.putInt(4, length);
    }

    public final void setNumberOfEvents(int nevents) {
        this.recordHeaderBuffer.putInt(16, nevents);
    }

    public final void setHeaderSize(int size) {
        this.recordHeaderBuffer.putInt(20, size);
    }

    public void setCompressionType(int type) {
        int result = this.recordHeaderBuffer.getInt(12);
        result = HipoByteUtils.write(result, type, 24, 30);
        this.recordHeaderBuffer.putInt(12, result);
    }

    public void setRecordSize(int size) {
        this.recordHeaderBuffer.putInt(4, size);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("RECORD : ");
        str.append(String.format("SIZE = %8d, # EVENTS = %9d, DATA SIZE (COMP) = (%8d , %8d), HEADER %8d, TYPE = %2d, INDEX SIZE %8d,  POS = %12d", this.getRecordSize(), this.getNumberOfEvents(), this.getDataSize(), this.getDataSizeCompressed(), this.getHeaderSize(), this.getCompressionType(), this.getIndexArraySize(), this.getPositionInFile()));
        return str.toString();
    }

    public final void reset() {
        this.setDataSize(0);
        this.setDataSizeCompressed(0);
        this.setHeaderSize(0);
        this.setNumberOfEvents(0);
        this.setIndexArraySize(0);
        this.setRecordHeaderLength(0);
    }

    public static void main(String[] args) {
        HipoRecordHeader header = new HipoRecordHeader();
        header.setRecordHeaderLength(819);
        header.setDataSize(40);
        header.setHeaderSize(120);
        System.out.println(header);
        System.out.println("Magic = " + header.isValid());
    }
}

