/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.data;

public enum HipoNodeType {
    UNDEFINED(0, 0, "UNDEFINED"),
    BYTE(1, 1, "BYTE"),
    SHORT(2, 2, "SHORT"),
    INT(3, 4, "INT"),
    FLOAT(4, 4, "FLOAT"),
    DOUBLE(5, 8, "DOUBLE"),
    STRING(6, 1, "STRING"),
    GROUP(7, 0, "GROUP"),
    LONG(8, 8, "LONG"),
    VECTOR3F(9, 12, "VECTOR3F");

    private final int typeid;
    private final int sizeOf;
    private final String typename;

    private HipoNodeType() {
        this.typeid = 0;
        this.sizeOf = 0;
        this.typename = "UNDEFINED";
    }

    private HipoNodeType(int id, int s, String name) {
        this.typeid = id;
        this.sizeOf = s;
        this.typename = name;
    }

    public String getName() {
        return this.typename;
    }

    public int getType() {
        return this.typeid;
    }

    public int getSize() {
        return this.sizeOf;
    }

    public static HipoNodeType getType(String name) {
        name = name.trim();
        for (HipoNodeType id : HipoNodeType.values()) {
            if (!id.getName().equalsIgnoreCase(name)) continue;
            return id;
        }
        return UNDEFINED;
    }

    public static HipoNodeType getType(int tid) {
        for (HipoNodeType id : HipoNodeType.values()) {
            if (id.typeid != tid) continue;
            return id;
        }
        return UNDEFINED;
    }
}

